/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.id.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.IDGenerator;
import org.dcm4chee.arc.id.IDService;
import org.dcm4chee.arc.id.impl.IDServiceEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IDServiceImpl
implements IDService {
    private static final Logger LOG = LoggerFactory.getLogger(IDServiceImpl.class);
    @Inject
    private Device device;
    @Inject
    private IDServiceEJB ejb;

    @Override
    public String createID(String name) {
        IDGenerator generator = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getIDGenerator(name);
        return String.format(generator.getFormat(), this.nextValue(generator.getName(), generator.getInitialValue()));
    }

    @Override
    public void newPatientID(Attributes attrs) {
        attrs.setString(0x100020, VR.LO, this.createID("PatientID"));
        Issuer issuer = this.device.getIssuerOfPatientID();
        if (issuer != null) {
            issuer.toIssuerOfPatientID(attrs);
        }
    }

    @Override
    public void newAccessionNumber(Attributes attrs) {
        attrs.setString(524368, VR.SH, this.createID("AccessionNumber"));
        Issuer issuer = this.device.getIssuerOfAccessionNumber();
        if (issuer != null) {
            attrs.newSequence(524369, 1).add(issuer.toItem());
        }
    }

    @Override
    public void newAccessionNumber(String idGenerator, Attributes attrs) {
        attrs.setString(524368, VR.SH, this.createID(idGenerator));
        Issuer issuer = this.device.getIssuerOfAccessionNumber();
        if (issuer != null) {
            attrs.newSequence(524369, 1).add(issuer.toItem());
        }
    }

    @Override
    public void newRequestedProcedureID(Attributes attrs) {
        attrs.setString(0x401001, VR.SH, this.createID("RequestedProcedureID"));
    }

    @Override
    public void newRequestedProcedureID(String idGenerator, Attributes attrs) {
        attrs.setString(0x401001, VR.SH, this.createID(idGenerator));
    }

    @Override
    public void newScheduledProcedureStepID(Attributes attrs) {
        attrs.setString(0x400009, VR.SH, this.createID("ScheduledProcedureStepID"));
    }

    @Override
    public void newScheduledProcedureStepID(String idGenerator, Attributes attrs) {
        attrs.setString(0x400009, VR.SH, this.createID(idGenerator));
    }

    @Override
    public int newLocationMultiReference() {
        return this.nextValue("LocationMultiReference", 0);
    }

    private int nextValue(String name, int initalValue) {
        try {
            return this.ejb.nextValue(name, initalValue);
        }
        catch (RuntimeException e) {
            LOG.info("Failed to create {} - retry\n", (Object)name, (Object)e);
            return this.ejb.nextValue(name, initalValue);
        }
    }
}

