/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.hl7.HL7Charset;
import org.dcm4che3.hl7.HL7ContentHandler;
import org.dcm4che3.hl7.HL7Parser;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.SAXWriter;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SAXTransformer {
    private static SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();

    private SAXTransformer() {
    }

    public static Attributes transform(UnparsedHL7Message msg, ArchiveHL7ApplicationExtension arcHL7App, String uri, SAXTransformer.SetupTransformer setup) throws TransformerConfigurationException, IOException, SAXException {
        String dicomCharset;
        Templates tpl = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)uri));
        Attributes attrs = new Attributes();
        String hl7charset = msg.msh().getField(17, arcHL7App.getHL7Application().getHL7DefaultCharacterSet());
        String string = dicomCharset = arcHL7App.hl7DicomCharacterSet() != null ? arcHL7App.hl7DicomCharacterSet() : HL7Charset.toDicomCharacterSetCode((String)hl7charset);
        if (dicomCharset != null) {
            attrs.setString(524293, VR.CS, dicomCharset);
        }
        TransformerHandler th = factory.newTransformerHandler(tpl);
        th.setResult(new SAXResult((ContentHandler)new ContentHandlerAdapter(attrs)));
        if (setup != null) {
            setup.setup(th.getTransformer());
        }
        new HL7Parser((ContentHandler)th).parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(msg.unescapeXdddd()), HL7Charset.toCharsetName((String)hl7charset)));
        return attrs;
    }

    public static byte[] transform(Attributes attrs, String hl7charset, String uri, SAXTransformer.SetupTransformer setup) throws TransformerConfigurationException, SAXException, UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Templates tpl = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)uri));
        TransformerHandler th = factory.newTransformerHandler(tpl);
        th.setResult(new SAXResult((ContentHandler)new HL7ContentHandler((Writer)new OutputStreamWriter((OutputStream)out, HL7Charset.toCharsetName((String)hl7charset)))));
        if (setup != null) {
            setup.setup(th.getTransformer());
        }
        SAXWriter saxWriter = new SAXWriter((ContentHandler)th);
        saxWriter.setIncludeKeyword(true);
        saxWriter.setIncludeNamespaceDeclaration(false);
        saxWriter.write(attrs);
        return out.toByteArray();
    }
}

