/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.dcm2ups;

import java.io.OutputStream;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.ws.rs.MediaTypes;

enum EntityType {
    DICOM_JSON(MediaTypes.APPLICATION_DICOM_JSON_TYPE){

        @Override
        Entity<StreamingOutput> entity(Attributes upsAttrs) {
            return Entity.entity(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                new JSONWriter(gen).write(upsAttrs);
                gen.flush();
            }, (MediaType)MediaTypes.APPLICATION_DICOM_JSON_TYPE);
        }
    }
    ,
    DICOM_XML(MediaTypes.APPLICATION_DICOM_XML_TYPE){

        @Override
        Entity<StreamingOutput> entity(Attributes upsAttrs) {
            return Entity.entity(out -> {
                try {
                    SAXTransformer.getSAXWriter((Result)new StreamResult(out)).write(upsAttrs);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }, (MediaType)MediaTypes.APPLICATION_DICOM_XML_TYPE);
        }
    };

    final MediaType type;

    private EntityType(MediaType type) {
        this.type = type;
    }

    static EntityType valueOf(MediaType type) {
        return MediaTypes.APPLICATION_DICOM_XML_TYPE.isCompatible(type) ? DICOM_XML : DICOM_JSON;
    }

    abstract Entity<StreamingOutput> entity(Attributes var1);
}

