/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.ValueSelector;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.PersonName;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.StudyQueryAttributes;

@NamedQueries(value={@NamedQuery(name="Study.findByPatient", query="select st from Study st where st.patient = ?1"), @NamedQuery(name="Study.findByStudyIUID", query="select st from Study st where st.studyInstanceUID = ?1"), @NamedQuery(name="Study.findByStudyIUIDEager", query="select st from Study st join fetch st.patient p left join fetch p.patientName left join fetch st.referringPhysicianName join fetch st.attributesBlob join fetch p.attributesBlob where st.studyInstanceUID = ?1"), @NamedQuery(name="Study.UpdateAccessTime", query="update Study st set st.accessTime = CURRENT_TIMESTAMP where st.pk = ?1"), @NamedQuery(name="Study.setStudySize", query="update Study st set st.size = ?2 where st.pk = ?1"), @NamedQuery(name="Study.setCompleteness", query="update Study st set st.completeness = ?2 where st.studyInstanceUID = ?1"), @NamedQuery(name="Study.incrementFailedRetrieves", query="update Study st set st.failedRetrieves = st.failedRetrieves + 1, st.completeness = ?2 where st.studyInstanceUID = ?1"), @NamedQuery(name="Study.countStudiesOfPatient", query="select count(st) from Study st where st.patient = ?1"), @NamedQuery(name="Study.getExpiredStudies", query="select st from Study st where st.expirationDate <= ?1 and st.expirationState in ?2"), @NamedQuery(name="Study.claimExpiredStudy", query="update Study st set st.expirationState = ?3 where st.pk = ?1 and st.expirationState = ?2"), @NamedQuery(name="Study.studyIUIDsByAccessionNumber", query="select st.studyInstanceUID from Study st where st.accessionNumber = ?1"), @NamedQuery(name="Study.studyIUIDsByPatient", query="select st.studyInstanceUID from Study st where st.patient = ?1"), @NamedQuery(name="Study.findPkByStudyUID", query="select st.pk from Study st where st.studyInstanceUID = ?1"), @NamedQuery(name="Study.storageIDsByStudyUID", query="select st.pk, st.storageIDs from Study st where st.studyInstanceUID in ?1"), @NamedQuery(name="Study.setStorageIDs", query="update Study st set st.storageIDs = ?2 where st.pk = ?1"), @NamedQuery(name="Study.updateAccessControlID", query="update Study st set st.accessControlID = ?2 where st.studyInstanceUID = ?1"), @NamedQuery(name="Study.findPkStudyUIDPIDByUpdateTimeAndUnknownSize", query="select st.pk, st.studyInstanceUID, p.patientID from Study st join st.patient p where st.size = -1 and st.updatedTime < ?1"), @NamedQuery(name="Study.claimUnknownSizeStudy", query="update Study st set st.size = -2 where st.size = -1 and st.pk = ?1"), @NamedQuery(name="Study.setStudySizeIfClaimed", query="update Study st set st.size = ?2 where st.size = -2 and st.pk = ?1")})
@Entity
@Table(name="study", uniqueConstraints={@UniqueConstraint(columnNames={"study_iuid"})}, indexes={@Index(columnList="access_time"), @Index(columnList="created_time"), @Index(columnList="access_control_id"), @Index(columnList="rejection_state"), @Index(columnList="storage_ids"), @Index(columnList="study_date"), @Index(columnList="study_time"), @Index(columnList="accession_no"), @Index(columnList="admission_id"), @Index(columnList="study_desc"), @Index(columnList="study_custom1"), @Index(columnList="study_custom2"), @Index(columnList="study_custom3"), @Index(columnList="expiration_state"), @Index(columnList="expiration_date"), @Index(columnList="failed_retrieves"), @Index(columnList="completeness"), @Index(columnList="ext_retrieve_aet"), @Index(columnList="study_size")})
public class Study {
    public static final String FIND_BY_PATIENT = "Study.findByPatient";
    public static final String FIND_BY_STUDY_IUID = "Study.findByStudyIUID";
    public static final String FIND_BY_STUDY_IUID_EAGER = "Study.findByStudyIUIDEager";
    public static final String UPDATE_ACCESS_TIME = "Study.UpdateAccessTime";
    public static final String SET_STUDY_SIZE = "Study.setStudySize";
    public static final String SET_COMPLETENESS = "Study.setCompleteness";
    public static final String INCREMENT_FAILED_RETRIEVES = "Study.incrementFailedRetrieves";
    public static final String COUNT_STUDIES_OF_PATIENT = "Study.countStudiesOfPatient";
    public static final String GET_EXPIRED_STUDIES = "Study.getExpiredStudies";
    public static final String CLAIM_EXPIRED_STUDY = "Study.claimExpiredStudy";
    public static final String STUDY_IUIDS_BY_ACCESSION_NUMBER = "Study.studyIUIDsByAccessionNumber";
    public static final String STUDY_IUIDS_BY_PATIENT = "Study.studyIUIDsByPatient";
    public static final String FIND_PK_BY_STUDY_UID = "Study.findPkByStudyUID";
    public static final String STORAGE_IDS_BY_STUDY_UID = "Study.storageIDsByStudyUID";
    public static final String SET_STORAGE_IDS = "Study.setStorageIDs";
    public static final String UPDATE_ACCESS_CONTROL_ID = "Study.updateAccessControlID";
    public static final String FIND_PK_STUDY_UID_PID_BY_UPDATE_TIME_AND_UNKNOWN_SIZE = "Study.findPkStudyUIDPIDByUpdateTimeAndUnknownSize";
    public static final String CLAIM_UNKNOWN_SIZE_STUDY = "Study.claimUnknownSizeStudy";
    public static final String SET_STUDY_SIZE_IF_CLAIMED = "Study.setStudySizeIfClaimed";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="modified_time")
    private Date modifiedTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="access_time")
    private Date accessTime;
    @Basic
    @Column(name="storage_ids")
    private String storageIDs;
    @Basic(optional=false)
    @Column(name="completeness")
    private Completeness completeness;
    @Basic(optional=false)
    @Column(name="failed_retrieves")
    private int failedRetrieves;
    @Basic(optional=false)
    @Column(name="study_iuid", updatable=false)
    private String studyInstanceUID;
    @Basic(optional=false)
    @Column(name="study_id")
    private String studyID;
    @Basic(optional=false)
    @Column(name="study_date")
    private String studyDate;
    @Basic(optional=false)
    @Column(name="study_time")
    private String studyTime;
    @Basic(optional=false)
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="accno_entity_id")
    private String accessionNumberLocalNamespaceEntityID;
    @Column(name="accno_entity_uid")
    private String accessionNumberUniversalEntityID;
    @Column(name="accno_entity_uid_type")
    private String accessionNumberUniversalEntityIDType;
    @Basic(optional=false)
    @Column(name="admission_id")
    private String admissionID;
    @Column(name="admid_entity_id")
    private String admissionIDLocalNamespaceEntityID;
    @Column(name="admid_entity_uid")
    private String admissionIDUniversalEntityID;
    @Column(name="admid_entity_uid_type")
    private String admissionIDUniversalEntityIDType;
    @Basic(optional=false)
    @Column(name="study_desc")
    private String studyDescription;
    @Basic(optional=false)
    @Column(name="study_custom1")
    private String studyCustomAttribute1;
    @Basic(optional=false)
    @Column(name="study_custom2")
    private String studyCustomAttribute2;
    @Basic(optional=false)
    @Column(name="study_custom3")
    private String studyCustomAttribute3;
    @Basic(optional=false)
    @Column(name="access_control_id")
    private String accessControlID = "*";
    @Basic(optional=false)
    @Column(name="rejection_state")
    private RejectionState rejectionState;
    @Basic(optional=false)
    @Column(name="expiration_state")
    private ExpirationState expirationState;
    @Basic
    @Column(name="expiration_date")
    private String expirationDate;
    @Basic
    @Column(name="expiration_exporter_id")
    private String expirationExporterID;
    @Basic(optional=false)
    @Column(name="ext_retrieve_aet")
    private String externalRetrieveAET;
    @Basic(optional=false)
    @Column(name="study_size")
    private long size = -1L;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, optional=false)
    @JoinColumn(name="dicomattrs_fk")
    private AttributesBlob attributesBlob;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="ref_phys_name_fk")
    private PersonName referringPhysicianName;
    @ManyToMany
    @JoinTable(name="rel_study_pcode", joinColumns={@JoinColumn(name="study_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="pcode_fk", referencedColumnName="pk")})
    private Collection<CodeEntity> procedureCodes;
    @OneToMany(mappedBy="study", cascade={CascadeType.ALL})
    private Collection<StudyQueryAttributes> queryAttributes;
    @ManyToOne(optional=false)
    @JoinColumn(name="patient_fk")
    private Patient patient;

    public Study() {
    }

    public Study(long pk, String studyInstanceUID) {
        this.pk = pk;
        this.studyInstanceUID = studyInstanceUID;
    }

    public String toString() {
        return "Study[pk=" + this.pk + ", uid=" + this.studyInstanceUID + ", id=" + this.studyID + "]";
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
        this.accessTime = now;
        this.modifiedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        Date now;
        this.updatedTime = now = new Date();
        this.accessTime = now;
    }

    public long getPk() {
        return this.pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public Date getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
    }

    public boolean updateAccessTime(Duration maxAccessTimeStaleness) {
        if (maxAccessTimeStaleness == null) {
            return false;
        }
        Date now = new Date();
        if (this.accessTime.getTime() + maxAccessTimeStaleness.getSeconds() * 1000L < now.getTime()) {
            this.accessTime = now;
            return true;
        }
        return false;
    }

    public String getEncodedStorageIDs() {
        return this.storageIDs;
    }

    public String[] getStorageIDs() {
        return StringUtils.split((String)this.storageIDs, (char)'\\');
    }

    public void setStorageIDs(String ... storageIDs) {
        Arrays.sort(storageIDs);
        this.storageIDs = StringUtils.concat((String[])storageIDs, (char)'\\');
    }

    public boolean addStorageID(String storageID) {
        String newStorageIDs = Study.addStorageID(this.storageIDs, storageID);
        if (newStorageIDs.equals(this.storageIDs)) {
            return false;
        }
        this.storageIDs = newStorageIDs;
        return true;
    }

    public static String addStorageID(String storageIDs, String storageID) {
        if (storageID.equals(storageIDs) || storageIDs == null) {
            return storageID;
        }
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(StringUtils.split((String)storageIDs, (char)'\\')));
        if (!set.add(storageID)) {
            return storageIDs;
        }
        return StringUtils.concat((String[])set.toArray(StringUtils.EMPTY_STRING), (char)'\\');
    }

    public boolean removeStorageID(String storageID) {
        if (this.storageIDs == null) {
            return false;
        }
        if (storageID.equals(this.storageIDs)) {
            this.storageIDs = null;
            return true;
        }
        TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.getStorageIDs()));
        if (!set.remove(storageID)) {
            return false;
        }
        this.storageIDs = StringUtils.concat((String[])set.toArray(StringUtils.EMPTY_STRING), (char)'\\');
        return true;
    }

    public void clearStorageIDs() {
        this.storageIDs = null;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getStudyID() {
        return this.studyID;
    }

    public String getStudyDate() {
        return this.studyDate;
    }

    public String getStudyTime() {
        return this.studyTime;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String getAdmissionID() {
        return this.admissionID;
    }

    public PersonName getReferringPhysicianName() {
        return this.referringPhysicianName;
    }

    public AttributesBlob getAttributesBlob() {
        return this.attributesBlob;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getAttributes();
    }

    public String getStudyDescription() {
        return this.studyDescription;
    }

    public String getStudyCustomAttribute1() {
        return this.studyCustomAttribute1;
    }

    public String getStudyCustomAttribute2() {
        return this.studyCustomAttribute2;
    }

    public String getStudyCustomAttribute3() {
        return this.studyCustomAttribute3;
    }

    public String getAccessControlID() {
        return (String)StringUtils.nullify((Object)this.accessControlID, (Object)"*");
    }

    public void setAccessControlID(String accessControlID) {
        this.accessControlID = (String)StringUtils.maskNull((Object)accessControlID, (Object)"*");
    }

    public RejectionState getRejectionState() {
        return this.rejectionState;
    }

    public void setRejectionState(RejectionState rejectionState) {
        this.rejectionState = rejectionState;
    }

    public ExpirationState getExpirationState() {
        return this.expirationState;
    }

    public void setExpirationState(ExpirationState expirationState) {
        this.expirationState = expirationState;
    }

    public LocalDate getExpirationDate() {
        return this.expirationDate != null ? LocalDate.parse(this.expirationDate, DateTimeFormatter.BASIC_ISO_DATE) : null;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        if (expirationDate != null) {
            try {
                this.expirationDate = DateTimeFormatter.BASIC_ISO_DATE.format(expirationDate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.expirationDate = null;
        }
    }

    public String getExpirationExporterID() {
        return this.expirationExporterID;
    }

    public void setExpirationExporterID(String expirationExporterID) {
        this.expirationExporterID = expirationExporterID;
    }

    public Completeness getCompleteness() {
        return this.completeness;
    }

    public void setCompleteness(Completeness completeness) {
        this.completeness = completeness;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public void resetSize() {
        this.size = -1L;
    }

    public Collection<CodeEntity> getProcedureCodes() {
        if (this.procedureCodes == null) {
            this.procedureCodes = new ArrayList<CodeEntity>();
        }
        return this.procedureCodes;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public void setAttributes(Attributes attrs, AttributeFilter filter, boolean withOriginalAttributesSequence, FuzzyStr fuzzyStr) {
        this.studyInstanceUID = attrs.getString(0x20000D);
        this.studyID = attrs.getString(0x200010, "*");
        this.studyDescription = attrs.getString(528432, "*");
        Date dt = attrs.getDate(2251937253163056L);
        if (dt != null) {
            this.studyDate = DateUtils.formatDA(null, (Date)dt);
            this.studyTime = attrs.containsValue(524336) ? DateUtils.formatTM(null, (Date)dt) : "*";
        } else {
            this.studyDate = "*";
            this.studyTime = "*";
        }
        this.accessionNumber = attrs.getString(524368, "*");
        Issuer accessionNumberIssuer = Issuer.valueOf((Attributes)attrs.getNestedDataset(524369));
        if (accessionNumberIssuer != null) {
            this.accessionNumberLocalNamespaceEntityID = accessionNumberIssuer.getLocalNamespaceEntityID();
            this.accessionNumberUniversalEntityID = accessionNumberIssuer.getUniversalEntityID();
            this.accessionNumberUniversalEntityIDType = accessionNumberIssuer.getUniversalEntityIDType();
        } else {
            this.accessionNumberLocalNamespaceEntityID = null;
            this.accessionNumberUniversalEntityID = null;
            this.accessionNumberUniversalEntityIDType = null;
        }
        this.admissionID = attrs.getString(3670032, "*");
        Issuer admissionIDIssuer = Issuer.valueOf((Attributes)attrs.getNestedDataset(3670036));
        if (admissionIDIssuer != null) {
            this.admissionIDLocalNamespaceEntityID = admissionIDIssuer.getLocalNamespaceEntityID();
            this.admissionIDUniversalEntityID = admissionIDIssuer.getUniversalEntityID();
            this.admissionIDUniversalEntityIDType = admissionIDIssuer.getUniversalEntityIDType();
        } else {
            this.admissionIDLocalNamespaceEntityID = null;
            this.admissionIDUniversalEntityID = null;
            this.admissionIDUniversalEntityIDType = null;
        }
        this.referringPhysicianName = PersonName.valueOf(attrs.getString(524432), fuzzyStr, this.referringPhysicianName);
        this.studyCustomAttribute1 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute1(), (String)"*");
        this.studyCustomAttribute2 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute2(), (String)"*");
        this.studyCustomAttribute3 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute3(), (String)"*");
        Attributes blobAttrs = new Attributes(attrs, filter.getSelection(withOriginalAttributesSequence));
        if (this.attributesBlob == null) {
            this.attributesBlob = new AttributesBlob(blobAttrs);
        } else {
            this.attributesBlob.setAttributes(blobAttrs);
        }
        this.modifiedTime = new Date();
        if (this.externalRetrieveAET == null) {
            this.externalRetrieveAET = "*";
        }
    }

    public static class PKUID {
        public final Long pk;
        public final String uid;

        public PKUID(Long pk, String uid) {
            this.pk = pk;
            this.uid = uid;
        }

        public String toString() {
            return "Study[pk=" + this.pk + ", uid=" + this.uid + "]";
        }
    }
}

