/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Issuer;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Patient;

@NamedQueries(value={@NamedQuery(name="MPPS.findByPatient", query="select mpps from MPPS mpps where mpps.patient = ?1"), @NamedQuery(name="MPPS.deleteByPatient", query="delete from MPPS mpps where mpps.patient = ?1"), @NamedQuery(name="MPPS.findBySOPInstanceUID", query="select mpps from MPPS mpps where mpps.sopInstanceUID = ?1"), @NamedQuery(name="MPPS.findBySOPInstanceUID", query="select mpps from MPPS mpps join fetch mpps.patient p left join fetch p.patientName join fetch mpps.attributesBlob join fetch p.attributesBlob where mpps.sopInstanceUID = ?1")})
@Entity
@Table(name="mpps", uniqueConstraints={@UniqueConstraint(columnNames={"sop_iuid"})})
public class MPPS {
    public static final String FIND_BY_PATIENT = "MPPS.findByPatient";
    public static final String DELETE_BY_PATIENT = "MPPS.deleteByPatient";
    public static final String FIND_BY_SOP_INSTANCE_UID = "MPPS.findBySOPInstanceUID";
    public static final String FIND_BY_SOP_INSTANCE_UID_EAGER = "MPPS.findBySOPInstanceUID";
    public static final String IN_PROGRESS = "IN PROGRESS";
    public static final String COMPLETED = "COMPLETED";
    public static final String DISCONTINUED = "DISCONTINUED";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Column(name="sop_iuid", updatable=false)
    private String sopInstanceUID;
    @Basic(optional=false)
    @Column(name="pps_start_date")
    private String performedProcedureStepStartDate;
    @Basic(optional=false)
    @Column(name="pps_start_time")
    private String performedProcedureStepStartTime;
    @Basic(optional=false)
    @Column(name="study_iuid", updatable=false)
    private String studyInstanceUID;
    @Basic(optional=false)
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="accno_entity_id")
    private String accessionNumberLocalNamespaceEntityID;
    @Column(name="accno_entity_uid")
    private String accessionNumberUniversalEntityID;
    @Column(name="accno_entity_uid_type")
    private String accessionNumberUniversalEntityIDType;
    @Basic(optional=false)
    @Column(name="pps_status")
    private Status status;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, optional=false)
    @JoinColumn(name="dicomattrs_fk")
    private AttributesBlob attributesBlob;
    @ManyToOne
    @JoinColumn(name="discreason_code_fk")
    private CodeEntity discontinuationReasonCode;
    @ManyToOne(optional=false)
    @JoinColumn(name="patient_fk")
    private Patient patient;

    public String toString() {
        return "MPPS[pk=" + this.pk + ", uid=" + this.sopInstanceUID + ", studyInstanceUID=" + this.studyInstanceUID + ", status=" + this.status + "]";
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getPerformedProcedureStepStartDate() {
        return this.performedProcedureStepStartDate;
    }

    public String getPerformedProcedureStepStartTime() {
        return this.performedProcedureStepStartTime;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setSopInstanceUID(String sopInstanceUID) {
        this.sopInstanceUID = sopInstanceUID;
    }

    public CodeEntity getDiscontinuationReasonCode() {
        return this.discontinuationReasonCode;
    }

    public void setDiscontinuationReasonCode(CodeEntity discontinuationReasonCode) {
        this.discontinuationReasonCode = discontinuationReasonCode;
    }

    public AttributesBlob getAttributesBlob() {
        return this.attributesBlob;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getAttributes();
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public void setAttributes(Attributes attrs, AttributeFilter filter) {
        Attributes ssa = attrs.getNestedDataset(4194928);
        String cs = attrs.getString(4194898);
        this.status = IN_PROGRESS.equals(cs) ? Status.IN_PROGRESS : Status.valueOf(cs);
        this.performedProcedureStepStartDate = attrs.getString(0x400244);
        this.performedProcedureStepStartTime = attrs.getString(4194885);
        this.studyInstanceUID = ssa.getString(0x20000D);
        this.accessionNumber = ssa.getString(524368, "*");
        Issuer issuer = Issuer.valueOf((Attributes)ssa.getNestedDataset(524369));
        if (issuer != null) {
            this.accessionNumberLocalNamespaceEntityID = issuer.getLocalNamespaceEntityID();
            this.accessionNumberUniversalEntityID = issuer.getUniversalEntityID();
            this.accessionNumberUniversalEntityIDType = issuer.getUniversalEntityIDType();
        } else {
            this.accessionNumberLocalNamespaceEntityID = null;
            this.accessionNumberUniversalEntityID = null;
            this.accessionNumberUniversalEntityIDType = null;
        }
        if (this.attributesBlob == null) {
            this.attributesBlob = new AttributesBlob(new Attributes(attrs, filter.getSelection()));
        } else {
            this.attributesBlob.setAttributes(new Attributes(attrs, filter.getSelection()));
        }
    }

    public static enum Status {
        IN_PROGRESS,
        COMPLETED,
        DISCONTINUED;


        public static Status fromString(String s) {
            return Status.valueOf(s.replace(' ', '_'));
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

