/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.delete.RejectionService;
import org.dcm4chee.arc.delete.impl.DeletionServiceEJB;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RejectExpiredStudiesScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(RejectExpiredStudiesScheduler.class);
    @Inject
    private DeletionServiceEJB ejb;
    @Inject
    private RejectionService rejectionService;
    @Inject
    private ExportManager exportManager;

    protected RejectExpiredStudiesScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev != null ? arcDev.getRejectExpiredStudiesPollingInterval() : null;
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (!ScheduleExpression.emptyOrAnyContainsNow((ScheduleExpression[])arcDev.getRejectExpiredStudiesSchedules())) {
            return;
        }
        ApplicationEntity ae = this.getApplicationEntity(arcDev.getRejectExpiredStudiesAETitle());
        if (ae == null || !ae.isInstalled()) {
            LOG.warn("No such Application Entity: {}", (Object)arcDev.getRejectExpiredStudiesAETitle());
            return;
        }
        RejectionNote rn = arcDev.getRejectionNote(RejectionNote.Type.DATA_RETENTION_POLICY_EXPIRED);
        if (rn == null) {
            LOG.warn("Data Retention Policy Expired Rejection Note not configured.");
            return;
        }
        this.process(arcDev, ae, arcDev.getRejectExpiredStudiesAETitle(), rn);
    }

    private void process(ArchiveDeviceExtension arcDev, ApplicationEntity ae, String aet, RejectionNote rjNote) {
        int studyFetchSize = arcDev.getRejectExpiredStudiesFetchSize();
        if (studyFetchSize == 0) {
            LOG.warn("RejectExpiredStudies operation ABORT : Study fetch size is 0");
            return;
        }
        this.processExpiredStudies(ae, aet, rjNote, studyFetchSize);
        int seriesFetchSize = arcDev.getRejectExpiredSeriesFetchSize();
        if (seriesFetchSize == 0) {
            LOG.warn("RejectExpiredSeries operation ABORT : Series fetch size is 0");
            return;
        }
        this.processExpiredSeries(ae, aet, rjNote, seriesFetchSize);
    }

    private void processExpiredSeries(ApplicationEntity ae, String aet, RejectionNote rn, int seriesFetchSize) {
        List<Series> seriesList;
        do {
            seriesList = this.ejb.findExpiredSeries(seriesFetchSize);
            for (Series series : seriesList) {
                if (this.getPollingInterval() == null) {
                    return;
                }
                if (series.getExpirationExporterID() == null) {
                    this.rejectExpiredSeries(series, ae, aet, rn);
                    continue;
                }
                this.exportExpiredSeries(series);
            }
        } while (seriesFetchSize == seriesList.size());
    }

    private void rejectExpiredSeries(Series series, ApplicationEntity ae, String aet, RejectionNote rn) {
        try {
            if (this.ejb.claimExpiredSeriesFor(series, ExpirationState.REJECTED)) {
                this.rejectionService.reject(ae, aet, series.getStudy().getStudyInstanceUID(), series.getSeriesInstanceUID(), null, rn, null);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to reject Expired Series[UID={}] of Study[UID={}].\n", new Object[]{series.getSeriesInstanceUID(), series.getStudy().getStudyInstanceUID(), e});
            this.ejb.claimExpiredSeriesFor(series, ExpirationState.FAILED_TO_REJECT);
        }
    }

    private void exportExpiredSeries(Series series) {
        String expirationExporterID = series.getExpirationExporterID();
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        ExporterDescriptor exporter = arcDev.getExporterDescriptor(expirationExporterID);
        if (exporter == null) {
            LOG.warn("No configuration found for [ExpirationExporterID={}] of Series[UID={}]", (Object)expirationExporterID, (Object)series.getSeriesInstanceUID());
            this.ejb.claimExpiredSeriesFor(series, ExpirationState.FAILED_TO_EXPORT);
            return;
        }
        if (this.ejb.claimExpiredSeriesFor(series, ExpirationState.EXPORT_SCHEDULED)) {
            this.exportManager.createExportTask(this.device.getDeviceName(), exporter, series.getStudy().getStudyInstanceUID(), series.getSeriesInstanceUID(), "*", null, new Date(), null);
        }
    }

    private void processExpiredStudies(ApplicationEntity ae, String aet, RejectionNote rn, int studyFetchSize) {
        List<Study> studies;
        do {
            studies = this.ejb.findExpiredStudies(studyFetchSize);
            for (Study study : studies) {
                if (this.getPollingInterval() == null) {
                    return;
                }
                if (study.getExpirationExporterID() == null) {
                    this.rejectExpiredStudy(study, ae, aet, rn);
                    continue;
                }
                this.exportExpiredStudy(study);
            }
        } while (studyFetchSize == studies.size());
    }

    private void rejectExpiredStudy(Study study, ApplicationEntity ae, String aet, RejectionNote rn) {
        try {
            if (this.ejb.claimExpiredStudyFor(study, ExpirationState.REJECTED)) {
                this.rejectionService.reject(ae, aet, study.getStudyInstanceUID(), null, null, rn, null);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to reject Expired Study[UID={}].\n", (Object)study.getStudyInstanceUID(), (Object)e);
            this.ejb.claimExpiredStudyFor(study, ExpirationState.FAILED_TO_REJECT);
        }
    }

    private void exportExpiredStudy(Study study) {
        String expirationExporterID = study.getExpirationExporterID();
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        ExporterDescriptor exporter = arcDev.getExporterDescriptor(expirationExporterID);
        if (exporter == null) {
            LOG.warn("No configuration found for [ExpirationExporterID={}] of Study[UID={}]", (Object)expirationExporterID, (Object)study.getStudyInstanceUID());
            this.ejb.claimExpiredStudyFor(study, ExpirationState.FAILED_TO_EXPORT);
            return;
        }
        if (this.ejb.claimExpiredStudyFor(study, ExpirationState.EXPORT_SCHEDULED)) {
            this.exportManager.createExportTask(this.device.getDeviceName(), exporter, study.getStudyInstanceUID(), "*", "*", null, new Date(), null);
        }
    }

    private ApplicationEntity getApplicationEntity(String aet) {
        return this.device.getApplicationEntity(aet, true);
    }
}

