/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.json;

import javax.json.stream.JsonParser;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.json.ConfigurationDelegate;
import org.dcm4che3.conf.json.JsonReader;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.conf.json.hl7.JsonHL7ConfigurationExtension;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7ApplicationExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7ImportReportAdjustIUID;
import org.dcm4chee.arc.conf.HL7ImportReportMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7ImportReportMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ORUAction;
import org.dcm4chee.arc.conf.HL7OrderMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderMissingStudyIUIDPolicy;
import org.dcm4chee.arc.conf.HL7ReferredMergedPatientPolicy;
import org.dcm4chee.arc.conf.ScheduledProtocolCodeInOrder;
import org.dcm4chee.arc.conf.ScheduledStationAETInOrder;
import org.dcm4chee.arc.conf.json.JsonArchiveConfiguration;

public class JsonArchiveHL7Configuration
implements JsonHL7ConfigurationExtension {
    public void storeTo(HL7Application hl7App, Device device, JsonWriter writer) {
        ArchiveHL7ApplicationExtension ext = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (ext == null) {
            return;
        }
        writer.writeStartObject("dcmArchiveHL7Application");
        writer.writeNotNullOrDef("hl7PatientUpdateTemplateURI", (Object)ext.getPatientUpdateTemplateURI(), null);
        writer.writeNotNullOrDef("hl7ImportReportTemplateURI", (Object)ext.getImportReportTemplateURI(), null);
        writer.writeNotEmpty("hl7ImportReportTemplateParam", ext.getImportReportTemplateParams());
        writer.writeNotNullOrDef("hl7ScheduleProcedureTemplateURI", (Object)ext.getScheduleProcedureTemplateURI(), null);
        writer.writeNotNullOrDef("hl7LogFilePattern", (Object)ext.getHL7LogFilePattern(), null);
        writer.writeNotNullOrDef("hl7ErrorLogFilePattern", (Object)ext.getHL7ErrorLogFilePattern(), null);
        writer.writeNotNullOrDef("dicomAETitle", (Object)ext.getAETitle(), null);
        writer.writeNotNull("dcmRecordAttributeModification", ext.getRecordAttributeModification());
        writer.writeNotNullOrDef("hl7ScheduledProtocolCodeInOrder", (Object)ext.getHL7ScheduledProtocolCodeInOrder(), null);
        writer.writeNotNullOrDef("hl7ScheduledStationAETInOrder", (Object)ext.getHL7ScheduledStationAETInOrder(), null);
        writer.writeNotEmpty("hl7NoPatientCreateMessageType", (Object[])ext.getHL7NoPatientCreateMessageTypes(), (Object[])new String[0]);
        writer.writeNotNull("hl7UseNullValue", ext.getHL7UseNullValue());
        writer.writeNotNullOrDef("hl7OrderMissingStudyIUIDPolicy", (Object)ext.getHL7OrderMissingStudyIUIDPolicy(), null);
        writer.writeNotNullOrDef("hl7OrderMissingAdmissionIDPolicy", (Object)ext.getHl7OrderMissingAdmissionIDPolicy(), null);
        writer.writeNotNullOrDef("hl7ImportReportMissingStudyIUIDPolicy", (Object)ext.getHl7ImportReportMissingStudyIUIDPolicy(), null);
        writer.writeNotNullOrDef("hl7ImportReportMissingAdmissionIDPolicy", (Object)ext.getHl7ImportReportMissingAdmissionIDPolicy(), null);
        writer.writeNotNullOrDef("hl7ImportReportMissingStudyIUIDCFindSCP", (Object)ext.getHl7ImportReportMissingStudyIUIDCFindSCP(), null);
        writer.writeNotNullOrDef("hl7ImportReportAdjustIUID", (Object)ext.getHl7ImportReportAdjustIUID(), null);
        writer.writeNotNullOrDef("hl7DicomCharacterSet", (Object)ext.getHl7DicomCharacterSet(), null);
        writer.writeNotNullOrDef("hl7VeterinaryUsePatientName", (Object)ext.getHl7VeterinaryUsePatientName(), null);
        writer.writeNotEmpty("hl7ORUAction", (Object[])ext.getHl7ORUAction(), (Object[])new HL7ORUAction[0]);
        writer.writeNotNullOrDef("dcmMWLWorklistLabel", (Object)ext.getMWLWorklistLabel(), null);
        writer.writeNotNullOrDef("dcmMWLAccessionNumberGenerator", (Object)ext.getMWLAccessionNumberGenerator(), null);
        writer.writeNotNullOrDef("dcmMWLRequestedProcedureIDGenerator", (Object)ext.getMWLRequestedProcedureIDGenerator(), null);
        writer.writeNotNullOrDef("dcmMWLScheduledProcedureStepIDGenerator", (Object)ext.getMWLScheduledProcedureStepIDGenerator(), null);
        writer.writeNotNull("dcmAuditHL7MsgLimit", ext.getAuditHL7MsgLimit());
        writer.writeNotNullOrDef("hl7ReferredMergedPatientPolicy", (Object)ext.getHl7ReferredMergedPatientPolicy(), null);
        writer.writeNotNullOrDef("hl7PatientArrivalMessageType", (Object)ext.getHL7PatientArrivalMessageType(), null);
        JsonArchiveConfiguration.writeHL7ForwardRules(writer, ext.getHL7ForwardRules());
        JsonArchiveConfiguration.writeHL7ExportRules(writer, ext.getHL7ExportRules());
        JsonArchiveConfiguration.writeHL7PrefetchRules(writer, ext.getHL7PrefetchRules());
        JsonArchiveConfiguration.writeHL7StudyRetentionPolicies(writer, ext.getHL7StudyRetentionPolicies());
        JsonArchiveConfiguration.writeScheduledStations(writer, ext.getHL7OrderScheduledStations());
        JsonArchiveConfiguration.writeHL7OrderSPSStatus(writer, ext.getHL7OrderSPSStatuses());
        JsonArchiveConfiguration.writeUPSOnHL7List(writer, ext.listUPSOnHL7());
        writer.writeEnd();
    }

    public boolean loadHL7ApplicationExtension(Device device, HL7Application hl7App, JsonReader reader, ConfigurationDelegate config) throws ConfigurationException {
        if (!reader.getString().equals("dcmArchiveHL7Application")) {
            return false;
        }
        reader.next();
        reader.expect(JsonParser.Event.START_OBJECT);
        ArchiveHL7ApplicationExtension ext = new ArchiveHL7ApplicationExtension();
        this.loadFrom(ext, reader, config);
        hl7App.addHL7ApplicationExtension((HL7ApplicationExtension)ext);
        reader.expect(JsonParser.Event.END_OBJECT);
        return true;
    }

    private void loadFrom(ArchiveHL7ApplicationExtension ext, JsonReader reader, ConfigurationDelegate config) throws ConfigurationException {
        block74: while (reader.next() == JsonParser.Event.KEY_NAME) {
            switch (reader.getString()) {
                case "hl7PatientUpdateTemplateURI": {
                    ext.setPatientUpdateTemplateURI(reader.stringValue());
                    continue block74;
                }
                case "hl7ImportReportTemplateURI": {
                    ext.setImportReportTemplateURI(reader.stringValue());
                    continue block74;
                }
                case "hl7ImportReportTemplateParam": {
                    ext.setImportReportTemplateParams(reader.stringArray());
                    continue block74;
                }
                case "hl7ScheduleProcedureTemplateURI": {
                    ext.setScheduleProcedureTemplateURI(reader.stringValue());
                    continue block74;
                }
                case "hl7LogFilePattern": {
                    ext.setHL7LogFilePattern(reader.stringValue());
                    continue block74;
                }
                case "hl7ErrorLogFilePattern": {
                    ext.setHL7ErrorLogFilePattern(reader.stringValue());
                    continue block74;
                }
                case "dicomAETitle": {
                    ext.setAETitle(reader.stringValue());
                    continue block74;
                }
                case "dcmRecordAttributeModification": {
                    ext.setRecordAttributeModification(Boolean.valueOf(reader.booleanValue()));
                    continue block74;
                }
                case "hl7ScheduledProtocolCodeInOrder": {
                    ext.setHL7ScheduledProtocolCodeInOrder(ScheduledProtocolCodeInOrder.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7ScheduledStationAETInOrder": {
                    ext.setHL7ScheduledStationAETInOrder(ScheduledStationAETInOrder.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7NoPatientCreateMessageType": {
                    ext.setHL7NoPatientCreateMessageTypes(reader.stringArray());
                    continue block74;
                }
                case "hl7UseNullValue": {
                    ext.setHL7UseNullValue(Boolean.valueOf(reader.booleanValue()));
                    continue block74;
                }
                case "hl7OrderMissingStudyIUIDPolicy": {
                    ext.setHL7OrderMissingStudyIUIDPolicy(HL7OrderMissingStudyIUIDPolicy.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7OrderMissingAdmissionIDPolicy": {
                    ext.setHl7OrderMissingAdmissionIDPolicy(HL7OrderMissingAdmissionIDPolicy.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7ImportReportMissingStudyIUIDPolicy": {
                    ext.setHl7ImportReportMissingStudyIUIDPolicy(HL7ImportReportMissingStudyIUIDPolicy.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7ImportReportMissingAdmissionIDPolicy": {
                    ext.setHl7ImportReportMissingAdmissionIDPolicy(HL7ImportReportMissingAdmissionIDPolicy.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7ImportReportMissingStudyIUIDCFindSCP": {
                    ext.setHl7ImportReportMissingStudyIUIDCFindSCP(reader.stringValue());
                    continue block74;
                }
                case "hl7ImportReportAdjustIUID": {
                    ext.setHl7ImportReportAdjustIUID(HL7ImportReportAdjustIUID.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7DicomCharacterSet": {
                    ext.setHl7DicomCharacterSet(reader.stringValue());
                    continue block74;
                }
                case "hl7VeterinaryUsePatientName": {
                    ext.setHl7VeterinaryUsePatientName(Boolean.valueOf(reader.booleanValue()));
                    continue block74;
                }
                case "hl7ORUAction": {
                    ext.setHl7ORUAction((HL7ORUAction[])reader.enumArray(HL7ORUAction.class));
                    continue block74;
                }
                case "dcmMWLWorklistLabel": {
                    ext.setMWLWorklistLabel(reader.stringValue());
                    continue block74;
                }
                case "dcmMWLAccessionNumberGenerator": {
                    ext.setMWLAccessionNumberGenerator(reader.stringValue());
                    continue block74;
                }
                case "dcmMWLRequestedProcedureIDGenerator": {
                    ext.setMWLRequestedProcedureIDGenerator(reader.stringValue());
                    continue block74;
                }
                case "dcmMWLScheduledProcedureStepIDGenerator": {
                    ext.setMWLScheduledProcedureStepIDGenerator(reader.stringValue());
                    continue block74;
                }
                case "hl7ReferredMergedPatientPolicy": {
                    ext.setHl7ReferredMergedPatientPolicy(HL7ReferredMergedPatientPolicy.valueOf((String)reader.stringValue()));
                    continue block74;
                }
                case "hl7PatientArrivalMessageType": {
                    ext.setHL7PatientArrivalMessageType(reader.stringValue());
                    continue block74;
                }
                case "dcmAuditHL7MsgLimit": {
                    ext.setAuditHL7MsgLimit(Integer.valueOf(reader.intValue()));
                    continue block74;
                }
                case "hl7ForwardRule": {
                    JsonArchiveConfiguration.loadHL7ForwardRules(ext.getHL7ForwardRules(), reader);
                    continue block74;
                }
                case "hl7ExportRule": {
                    JsonArchiveConfiguration.loadHL7ExportRules(ext.getHL7ExportRules(), reader);
                    continue block74;
                }
                case "hl7PrefetchRule": {
                    JsonArchiveConfiguration.loadHL7PrefetchRules(ext.getHL7PrefetchRules(), reader);
                    continue block74;
                }
                case "hl7StudyRetentionPolicy": {
                    JsonArchiveConfiguration.loadHL7StudyRetentionPolicy(ext.getHL7StudyRetentionPolicies(), reader);
                    continue block74;
                }
                case "hl7OrderScheduledStation": {
                    JsonArchiveConfiguration.loadScheduledStations(ext.getHL7OrderScheduledStations(), reader, config);
                    continue block74;
                }
                case "hl7OrderSPSStatus": {
                    JsonArchiveConfiguration.loadHL7OrderSPSStatus(ext.getHL7OrderSPSStatuses(), reader);
                    continue block74;
                }
                case "hl7UPSOnHL7": {
                    JsonArchiveConfiguration.loadUPSOnHL7List(ext.listUPSOnHL7(), reader);
                    continue block74;
                }
            }
            reader.skipUnknownProperty();
        }
    }
}

