/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.conf.Conditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudyRetentionPolicy {
    public static final StudyRetentionPolicy[] EMPTY = new StudyRetentionPolicy[0];
    private static final Logger LOG = LoggerFactory.getLogger(StudyRetentionPolicy.class);
    private String commonName;
    private int priority;
    private Conditions conditions = new Conditions(new String[0]);
    private Period retentionPeriod;
    private boolean expireSeriesIndividually;
    private boolean startRetentionPeriodOnStudyDate;
    private String exporterID;
    private boolean freezeExpirationDate;
    private boolean revokeExpiration;

    public StudyRetentionPolicy() {
    }

    public StudyRetentionPolicy(String commonName) {
        this.setCommonName(commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public Period getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Period retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public boolean isExpireSeriesIndividually() {
        return this.expireSeriesIndividually;
    }

    public void setExpireSeriesIndividually(boolean expireSeriesIndividually) {
        this.expireSeriesIndividually = expireSeriesIndividually;
    }

    public boolean isStartRetentionPeriodOnStudyDate() {
        return this.startRetentionPeriodOnStudyDate;
    }

    public void setStartRetentionPeriodOnStudyDate(boolean startRetentionPeriodOnStudyDate) {
        this.startRetentionPeriodOnStudyDate = startRetentionPeriodOnStudyDate;
    }

    public String getExporterID() {
        return this.exporterID;
    }

    public void setExporterID(String exporterID) {
        this.exporterID = exporterID;
    }

    public boolean isFreezeExpirationDate() {
        return this.freezeExpirationDate;
    }

    public void setFreezeExpirationDate(boolean freezeExpirationDate) {
        this.freezeExpirationDate = freezeExpirationDate;
    }

    public boolean isRevokeExpiration() {
        return this.revokeExpiration;
    }

    public void setRevokeExpiration(boolean revokeExpiration) {
        this.revokeExpiration = revokeExpiration;
    }

    public LocalDate expirationDate(Attributes attrs) {
        String s;
        LocalDate date = LocalDate.now();
        if (this.startRetentionPeriodOnStudyDate && (s = attrs.getString(524320)) != null) {
            try {
                date = LocalDate.parse(s, DateTimeFormatter.BASIC_ISO_DATE);
            }
            catch (Exception e) {
                LOG.warn("Failed parsing study date to get retention start date." + e.getMessage());
            }
        }
        return date.plus(this.retentionPeriod);
    }

    public boolean protectStudy() {
        return this.revokeExpiration && this.freezeExpirationDate;
    }

    public boolean match(String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        return this.conditions.match(sendingHost, sendingAET, receivingHost, receivingAET, attrs);
    }

    public String toString() {
        return "StudyRetentionPolicy{cn=" + this.commonName + ", priority=" + this.priority + ", conditions=" + this.conditions + ", retentionPeriod=" + this.retentionPeriod + ", expireSeriesIndividually=" + this.expireSeriesIndividually + ", startRetentionPeriodOnStudyDate=" + this.startRetentionPeriodOnStudyDate + ", exporterID=" + this.exporterID + ", freezeExpirationDate=" + this.freezeExpirationDate + ", revokeExpiration=" + this.revokeExpiration + "}";
    }
}

