/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.deident.DeIdentifier;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.MergeAttribute;
import org.dcm4chee.arc.conf.MergeMWLMatchingKey;
import org.dcm4chee.arc.conf.NullifyIssuer;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.UseCallingAETitleAsCoercion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveAttributeCoercion {
    static final Logger LOG = LoggerFactory.getLogger(ArchiveAttributeCoercion.class);
    public static final ArchiveAttributeCoercion[] EMPTY = new ArchiveAttributeCoercion[0];
    private String commonName;
    private int priority;
    private Dimse dimse;
    private TransferCapability.Role role;
    private String[] sopClasses = new String[0];
    private Conditions conditions = new Conditions(new String[0]);
    private boolean retrieveAsReceived;
    private DeIdentifier.Option[] deIdentification = new DeIdentifier.Option[0];
    private String xsltStylesheetURI;
    private boolean noKeywords;
    private String leadingCFindSCP;
    private MergeMWLMatchingKey mergeMWLMatchingKey;
    private String mergeMWLTemplateURI;
    private String mergeMWLSCP;
    private String[] mergeLocalMWLWorklistLabels = new String[0];
    private SPSStatus[] mergeLocalMWLWithStatus = new SPSStatus[0];
    private boolean filterBySCU;
    private Attributes.UpdatePolicy attributeUpdatePolicy = Attributes.UpdatePolicy.MERGE;
    private boolean trimISO2022CharacterSet;
    private UseCallingAETitleAsCoercion.Type useCallingAETitleAs;
    private int[] nullifyTags = new int[0];
    private boolean nullifyPixelData;
    private NullifyIssuer nullifyIssuerOfPatientID;
    private MergeAttribute[] mergeAttributes = new MergeAttribute[0];
    private Issuer[] issuerOfPatientIDs = new Issuer[0];
    private Device supplementFromDevice;
    private String issuerOfPatientIDFormat;

    public ArchiveAttributeCoercion() {
    }

    public ArchiveAttributeCoercion(String commonName) {
        this.setCommonName(commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public ArchiveAttributeCoercion setCommonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ArchiveAttributeCoercion setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public Dimse getDIMSE() {
        return this.dimse;
    }

    public ArchiveAttributeCoercion setDIMSE(Dimse dimse) {
        this.dimse = dimse;
        return this;
    }

    public TransferCapability.Role getRole() {
        return this.role;
    }

    public ArchiveAttributeCoercion setRole(TransferCapability.Role role) {
        this.role = role;
        return this;
    }

    public String[] getSOPClasses() {
        return this.sopClasses;
    }

    public ArchiveAttributeCoercion setSOPClasses(String ... sopClasses) {
        this.sopClasses = sopClasses;
        return this;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public ArchiveAttributeCoercion setSendingHostname(String hostname) {
        this.conditions.setSendingHostname(hostname);
        return this;
    }

    public ArchiveAttributeCoercion setSendingAETitle(String aet) {
        this.conditions.setSendingAETitle(aet);
        return this;
    }

    public ArchiveAttributeCoercion setReceivingHostname(String hostname) {
        this.conditions.setReceivingHostname(hostname);
        return this;
    }

    public ArchiveAttributeCoercion setReceivingAETitle(String aet) {
        this.conditions.setReceivingAETitle(aet);
        return this;
    }

    public boolean isRetrieveAsReceived() {
        return this.retrieveAsReceived;
    }

    public ArchiveAttributeCoercion setRetrieveAsReceived(boolean retrieveAsReceived) {
        this.retrieveAsReceived = retrieveAsReceived;
        return this;
    }

    public DeIdentifier.Option[] getDeIdentification() {
        return this.deIdentification;
    }

    public void setDeIdentification(DeIdentifier.Option[] deIdentification) {
        this.deIdentification = deIdentification;
    }

    public String getXSLTStylesheetURI() {
        return this.xsltStylesheetURI;
    }

    public ArchiveAttributeCoercion setXSLTStylesheetURI(String xsltStylesheetURI) {
        this.xsltStylesheetURI = xsltStylesheetURI;
        return this;
    }

    public boolean isNoKeywords() {
        return this.noKeywords;
    }

    public ArchiveAttributeCoercion setNoKeywords(boolean noKeywords) {
        this.noKeywords = noKeywords;
        return this;
    }

    public String getLeadingCFindSCP() {
        return this.leadingCFindSCP;
    }

    public ArchiveAttributeCoercion setLeadingCFindSCP(String leadingCFindSCP) {
        this.leadingCFindSCP = leadingCFindSCP;
        return this;
    }

    public MergeMWLMatchingKey getMergeMWLMatchingKey() {
        return this.mergeMWLMatchingKey;
    }

    public ArchiveAttributeCoercion setMergeMWLMatchingKey(MergeMWLMatchingKey mergeMWLMatchingKey) {
        this.mergeMWLMatchingKey = mergeMWLMatchingKey;
        return this;
    }

    public String getMergeMWLTemplateURI() {
        return this.mergeMWLTemplateURI;
    }

    public ArchiveAttributeCoercion setMergeMWLTemplateURI(String mergeMWLTemplateURI) {
        this.mergeMWLTemplateURI = mergeMWLTemplateURI;
        return this;
    }

    public String getMergeMWLSCP() {
        return this.mergeMWLSCP;
    }

    public ArchiveAttributeCoercion setMergeMWLSCP(String mergeMWLSCP) {
        this.mergeMWLSCP = mergeMWLSCP;
        return this;
    }

    public String[] getMergeLocalMWLWorklistLabels() {
        return this.mergeLocalMWLWorklistLabels;
    }

    public void setMergeLocalMWLWorklistLabels(String ... mergeLocalMWLWorklistLabels) {
        this.mergeLocalMWLWorklistLabels = mergeLocalMWLWorklistLabels;
    }

    public SPSStatus[] getMergeLocalMWLWithStatus() {
        return this.mergeLocalMWLWithStatus;
    }

    public void setMergeLocalMWLWithStatus(SPSStatus ... mergeLocalMWLWithStatus) {
        this.mergeLocalMWLWithStatus = mergeLocalMWLWithStatus;
    }

    public boolean isFilterBySCU() {
        return this.filterBySCU;
    }

    public void setFilterBySCU(boolean filterBySCU) {
        this.filterBySCU = filterBySCU;
    }

    public Attributes.UpdatePolicy getAttributeUpdatePolicy() {
        return this.attributeUpdatePolicy;
    }

    public ArchiveAttributeCoercion setAttributeUpdatePolicy(Attributes.UpdatePolicy attributeUpdatePolicy) {
        this.attributeUpdatePolicy = attributeUpdatePolicy;
        return this;
    }

    public boolean isTrimISO2022CharacterSet() {
        return this.trimISO2022CharacterSet;
    }

    public void setTrimISO2022CharacterSet(boolean trimISO2022CharacterSet) {
        this.trimISO2022CharacterSet = trimISO2022CharacterSet;
    }

    public UseCallingAETitleAsCoercion.Type getUseCallingAETitleAs() {
        return this.useCallingAETitleAs;
    }

    public void setUseCallingAETitleAs(UseCallingAETitleAsCoercion.Type useCallingAETitleAs) {
        this.useCallingAETitleAs = useCallingAETitleAs;
    }

    public int[] getNullifyTags() {
        return this.nullifyTags;
    }

    public void setNullifyTags(int[] nullifyTags) {
        this.nullifyTags = nullifyTags;
        this.nullifyPixelData = nullifyTags != null && IntStream.of(nullifyTags).anyMatch(tag -> tag == 2145386512);
    }

    public boolean isNullifyPixelData() {
        return this.nullifyPixelData;
    }

    public NullifyIssuer getNullifyIssuerOfPatientID() {
        return this.nullifyIssuerOfPatientID;
    }

    public void setNullifyIssuerOfPatientID(NullifyIssuer nullifyIssuerOfPatientID) {
        this.nullifyIssuerOfPatientID = nullifyIssuerOfPatientID;
    }

    public MergeAttribute[] getMergeAttributes() {
        return this.mergeAttributes;
    }

    public void setMergeAttributes(String ... mergeAttributes) {
        this.mergeAttributes = MergeAttribute.of(mergeAttributes);
    }

    public Issuer[] getIssuerOfPatientIDs() {
        return this.issuerOfPatientIDs;
    }

    public void setIssuerOfPatientIDs(Issuer ... issuerOfPatientIDs) {
        this.issuerOfPatientIDs = issuerOfPatientIDs;
    }

    public final Device getSupplementFromDevice() {
        return this.supplementFromDevice;
    }

    public String getSupplementFromDeviceName() {
        if (this.supplementFromDevice == null) {
            throw new IllegalStateException("SupplementFromDevice not initialized");
        }
        return this.supplementFromDevice.getDeviceName();
    }

    public ArchiveAttributeCoercion setSupplementFromDevice(Device supplementFromDevice) {
        this.supplementFromDevice = supplementFromDevice;
        return this;
    }

    public String getIssuerOfPatientIDFormat() {
        return this.issuerOfPatientIDFormat;
    }

    public void setIssuerOfPatientIDFormat(String issuerOfPatientIDFormat) {
        this.issuerOfPatientIDFormat = issuerOfPatientIDFormat;
    }

    public boolean matchSOPClass(String sopClass) {
        if (this.sopClasses.length == 0) {
            return true;
        }
        if (sopClass != null) {
            for (String o1 : this.sopClasses) {
                if (!o1.equals(sopClass)) continue;
                return true;
            }
        }
        return false;
    }

    public AttributesCoercion nullifyIssuerOfPatientID(Attributes attrs, final AttributesCoercion next) {
        if (!this.nullifyIssuerOfPatientID(attrs)) {
            return next;
        }
        return new AttributesCoercion(){

            public void coerce(Attributes attrs, Attributes modified) throws Exception {
                Attributes item;
                LOG.info("Nullify Issuer of Patient ID using coercion [cn={}, nullifyIssuerOfPatientID={}]", (Object)ArchiveAttributeCoercion.this.commonName, (Object)ArchiveAttributeCoercion.this.nullifyIssuerOfPatientID);
                String issuerOfPatientID = attrs.getString(0x100021);
                if (issuerOfPatientID != null && !issuerOfPatientID.isEmpty()) {
                    attrs.setNull(0x100021, VR.LO);
                    if (modified != null) {
                        modified.setString(0x100021, VR.LO, issuerOfPatientID);
                    }
                }
                if ((item = attrs.getNestedDataset(1048612)) != null) {
                    attrs.setNull(1048612, VR.SQ);
                    if (modified != null) {
                        modified.newSequence(1048612, 1).add(new Attributes(item));
                    }
                }
                if (next != null) {
                    next.coerce(attrs, modified);
                }
            }

            public String remapUID(String uid) {
                return next != null ? next.remapUID(uid) : uid;
            }
        };
    }

    private boolean nullifyIssuerOfPatientID(Attributes attrs) {
        return this.nullifyIssuerOfPatientID != null && this.nullifyIssuerOfPatientID.test(Issuer.fromIssuerOfPatientID((Attributes)attrs), this.issuerOfPatientIDs);
    }

    public boolean match(TransferCapability.Role role, Dimse dimse, String sopClass, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        return this.role == role && this.dimse == dimse && this.matchSOPClass(sopClass) && this.conditions.match(sendingHost, sendingAET, receivingHost, receivingAET, attrs);
    }

    public AttributesCoercion mergeAttributes(final AttributesCoercion next) {
        if (this.mergeAttributes == null) {
            return next;
        }
        return new AttributesCoercion(){

            public void coerce(Attributes attrs, Attributes modified) throws Exception {
                LOG.info("Merge attributes using coercion [cn={}]", (Object)ArchiveAttributeCoercion.this.commonName);
                for (MergeAttribute mergeAttribute : ArchiveAttributeCoercion.this.mergeAttributes) {
                    mergeAttribute.merge(attrs, modified);
                }
                if (next != null) {
                    next.coerce(attrs, modified);
                }
            }

            public String remapUID(String uid) {
                return next != null ? next.remapUID(uid) : uid;
            }
        };
    }

    public AttributesCoercion supplementIssuerOfPatientID(final AttributesCoercion next) {
        if (this.issuerOfPatientIDFormat == null) {
            return next;
        }
        return new AttributesCoercion(){

            public void coerce(Attributes attrs, Attributes modified) throws Exception {
                LOG.info("Supplement Issuer of Patient ID using coercion [cn={}, issuerOfPatientIDFormat={}]", (Object)ArchiveAttributeCoercion.this.commonName, (Object)ArchiveAttributeCoercion.this.issuerOfPatientIDFormat);
                String issuerOfPatientID = attrs.getString(0x100021);
                String supplementIssuerOfPatientID = new AttributesFormat(ArchiveAttributeCoercion.this.issuerOfPatientIDFormat).format((Object)attrs);
                attrs.setString(0x100021, VR.LO, (String)(issuerOfPatientID != null && !issuerOfPatientID.isEmpty() ? issuerOfPatientID + "-" + supplementIssuerOfPatientID : supplementIssuerOfPatientID));
                if (modified != null) {
                    modified.setString(0x100021, VR.LO, issuerOfPatientID);
                }
                if (next != null) {
                    next.coerce(attrs, modified);
                }
            }

            public String remapUID(String uid) {
                return next != null ? next.remapUID(uid) : uid;
            }
        };
    }

    public String toString() {
        return "ArchiveAttributeCoercion[cn=" + this.commonName + ", priority=" + this.priority + ", DIMSE=" + this.dimse + ", role=" + this.role + ", cuids=" + Arrays.toString(this.sopClasses) + ", conditions=" + this.conditions.toString() + ", retrieveAsReceived=" + this.retrieveAsReceived + ", deIdentification=" + Arrays.toString(this.deIdentification) + ", xslturi=" + this.xsltStylesheetURI + ", noKeywords=" + this.noKeywords + ", leadingCFindSCP=" + this.leadingCFindSCP + ", mergeMWLMatchingKey=" + this.mergeMWLMatchingKey + ", mergeMWLTemplateURI=" + this.mergeMWLTemplateURI + ", mergeMWLSCP=" + this.mergeMWLSCP + ", mergeLocalMWLSCPs=" + Arrays.toString(this.mergeLocalMWLWorklistLabels) + ", mergeLocalMWLStatus=" + Arrays.toString((Object[])this.mergeLocalMWLWithStatus) + ", mwlImportFilterBySCU=" + this.filterBySCU + ", attributeUpdatePolicy=" + this.attributeUpdatePolicy + ", trimISO2022CharacterSet=" + this.trimISO2022CharacterSet + ", useCallingAETitleAs=" + this.useCallingAETitleAs + ", nullifyTags=" + Arrays.toString(this.nullifyTags) + ", mergeAttributes=" + Arrays.toString(this.mergeAttributes) + ", nullifyIssuerOfPatientID=" + this.nullifyIssuerOfPatientID + ", issuerOfPatientIDs=" + Arrays.toString(this.issuerOfPatientIDs) + ", issuerOfPatientIDFormat=" + this.issuerOfPatientIDFormat + ", supplementFromDeviceName=" + (this.supplementFromDevice != null ? this.supplementFromDevice.getDeviceName() : null) + "]";
    }
}

