/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.coerce.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.SpecificCharacterSet;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.coerce.CoercionProcessor;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="trim-ISO2022")
public class TrimISO2022CharacterSetCoercionProcessor
implements CoercionProcessor {
    static final Logger LOG = LoggerFactory.getLogger(TrimISO2022CharacterSetCoercionProcessor.class);

    public boolean coerce(ArchiveAttributeCoercion2 coercion, String sopClassUID, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs, Attributes modified) throws Exception {
        String[] codes = attrs.getStrings(524293);
        if (!SpecificCharacterSet.trimISO2022((String[])codes)) {
            return false;
        }
        LOG.info("ISO 2022 Character Set trimmed by {}", (Object)coercion);
        if (modified != null) {
            modified.setValue(524293, VR.CS, attrs.setString(524293, VR.CS, codes));
        }
        return true;
    }
}

