/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.HL7Separator;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4chee.arc.ConnectionEvent;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ShowPatientInfo;
import org.dcm4chee.arc.entity.Patient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditInfoBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AuditInfoBuilder.class);
    final String callingHost;
    final String callingUserID;
    final String calledUserID;
    final String calledHost;
    final String studyUID;
    final String accNum;
    final String pID;
    final String pName;
    final String outcome;
    final String studyDate;
    final String sopCUID;
    final String sopIUID;
    final String mppsUID;
    final String queryPOID;
    final String queryString;
    final String destUserID;
    final String destNapID;
    final String moveUserID;
    final String findSCP;
    final String warning;
    final boolean failedIUIDShow;
    final String submissionSetUID;
    final boolean isExport;
    final boolean isOutgoingHL7;
    final String outgoingHL7Sender;
    final String outgoingHL7Receiver;
    final String filters;
    final int count;
    final String queueMsg;
    final String taskPOID;
    final String errorCode;
    final String patMismatchCode;
    final ConnectionEvent.Type connType;
    final Patient.VerificationStatus patVerificationStatus;
    final String pdqServiceURI;
    final String impaxEndpoint;
    final int failed;
    final String expirationDate;
    final String queueName;
    final String status;
    final String fhirWebAppName;

    private AuditInfoBuilder(Builder builder) {
        this.callingHost = builder.callingHost;
        this.callingUserID = builder.callingUserID;
        this.calledUserID = builder.calledUserID;
        this.calledHost = builder.calledHost;
        this.studyUID = builder.studyUID;
        this.accNum = builder.accNum;
        this.pID = builder.pID;
        this.pName = builder.pName;
        this.outcome = builder.outcome;
        this.studyDate = builder.studyDate;
        this.sopCUID = builder.sopCUID;
        this.sopIUID = builder.sopIUID;
        this.mppsUID = builder.mppsUID;
        this.queryPOID = builder.queryPOID;
        this.queryString = builder.queryString;
        this.destUserID = builder.destUserID;
        this.destNapID = builder.destNapID;
        this.moveUserID = builder.moveUserID;
        this.findSCP = builder.findSCP;
        this.warning = builder.warning;
        this.failedIUIDShow = builder.failedIUIDShow;
        this.submissionSetUID = builder.submissionSetUID;
        this.isExport = builder.isExport;
        this.isOutgoingHL7 = builder.isOutgoingHL7;
        this.outgoingHL7Sender = builder.outgoingHL7Sender;
        this.outgoingHL7Receiver = builder.outgoingHL7Receiver;
        this.filters = builder.filters;
        this.count = builder.count;
        this.queueMsg = builder.queueMsg;
        this.taskPOID = builder.taskPOID;
        this.errorCode = builder.errorCode;
        this.patMismatchCode = builder.patMismatchCode;
        this.connType = builder.connType;
        this.patVerificationStatus = builder.patVerificationStatus;
        this.pdqServiceURI = builder.pdqServiceURI;
        this.impaxEndpoint = builder.impaxEndpoint;
        this.failed = builder.failed;
        this.expirationDate = builder.expirationDate;
        this.queueName = builder.queueName;
        this.status = builder.status;
        this.fhirWebAppName = builder.fhirWebAppName;
    }

    private static IDWithIssuer idWithIssuer(ArchiveDeviceExtension arcDev, String cx) {
        Issuer auditAssigningAuthorityOfPatientID = arcDev.getAuditAssigningAuthorityOfPatientID();
        if (auditAssigningAuthorityOfPatientID != null) {
            for (String cx1 : cx.split("~")) {
                IDWithIssuer idWithIssuer = new IDWithIssuer(cx1);
                if (!auditAssigningAuthorityOfPatientID.equals((Object)idWithIssuer.getIssuer())) continue;
                return idWithIssuer;
            }
            LOG.info("None of the qualified patient identifier pairs in PID-3 {} match with configured Assigning Authority of Patient ID for audit {}", (Object)cx, (Object)auditAssigningAuthorityOfPatientID);
        }
        return new IDWithIssuer(cx);
    }

    private static String toPID(IDWithIssuer pidWithIssuer, ArchiveDeviceExtension arcDev) {
        return arcDev.showPatientInfoInAuditLog() == ShowPatientInfo.HASH_NAME_AND_ID ? String.valueOf(pidWithIssuer.hashCode()) : HL7Separator.unescapeAll((String)pidWithIssuer.toString());
    }

    private static String toPatName(String pName, ArchiveDeviceExtension arcDev) {
        return pName != null ? (arcDev.showPatientInfoInAuditLog() != ShowPatientInfo.PLAIN_TEXT ? String.valueOf(pName.hashCode()) : HL7Separator.unescapeAll((String)pName)) : null;
    }

    private static String errorCodeAsString(int errorCode) {
        String errorCodeAsString = Integer.toHexString(errorCode).toUpperCase();
        return errorCodeAsString.length() == 3 ? "x0" + errorCodeAsString : errorCodeAsString;
    }

    static class Builder {
        private String callingHost;
        private String callingUserID;
        private String calledUserID;
        private String calledHost;
        private String studyUID;
        private String accNum;
        private String pID;
        private String pName;
        private String outcome;
        private String studyDate;
        private String sopCUID;
        private String sopIUID;
        private String mppsUID;
        private String queryPOID;
        private String queryString;
        private String destUserID;
        private String destNapID;
        private String moveUserID;
        private String findSCP;
        private String warning;
        private boolean failedIUIDShow;
        private String submissionSetUID;
        private boolean isExport;
        private boolean isOutgoingHL7;
        private String outgoingHL7Sender;
        private String outgoingHL7Receiver;
        private String filters;
        private int count;
        private String queueMsg;
        private String taskPOID;
        private String errorCode;
        private String patMismatchCode;
        private ConnectionEvent.Type connType;
        private Patient.VerificationStatus patVerificationStatus;
        private String pdqServiceURI;
        private String impaxEndpoint;
        private int failed;
        private String expirationDate;
        private String queueName;
        private String status;
        private String fhirWebAppName;

        Builder() {
        }

        Builder callingHost(String val) {
            this.callingHost = val;
            return this;
        }

        Builder callingUserID(String val) {
            this.callingUserID = val;
            return this;
        }

        Builder calledUserID(String val) {
            this.calledUserID = val;
            return this;
        }

        Builder calledHost(String val) {
            this.calledHost = val;
            return this;
        }

        Builder pIDAndName(Attributes attr, ArchiveDeviceExtension arcDev) {
            this.pID = arcDev.auditUnknownPatientID();
            if (attr != null) {
                this.pName = AuditInfoBuilder.toPatName(attr.getString(0x100010), arcDev);
                IDWithIssuer pidWithIssuer = IDWithIssuer.pidOf((Attributes)attr);
                if (pidWithIssuer != null) {
                    this.pID = AuditInfoBuilder.toPID(pidWithIssuer, arcDev);
                }
            }
            return this;
        }

        Builder patID(String pid, ArchiveDeviceExtension arcDev) {
            this.pID = pid == null ? arcDev.auditUnknownPatientID() : AuditInfoBuilder.toPID(AuditInfoBuilder.idWithIssuer(arcDev, pid), arcDev);
            return this;
        }

        Builder patName(String patName, ArchiveDeviceExtension arcDev) {
            this.pName = AuditInfoBuilder.toPatName(patName, arcDev);
            return this;
        }

        Builder patID(IDWithIssuer patIDWithIssuer, ArchiveDeviceExtension arcDev) {
            this.pID = AuditInfoBuilder.toPID(patIDWithIssuer, arcDev);
            return this;
        }

        Builder studyUIDAccNumDate(Attributes attrs, ArchiveDeviceExtension arcDev) {
            this.studyUID = arcDev.auditUnknownStudyInstanceUID();
            if (attrs != null) {
                this.studyUID = attrs.getString(0x20000D);
                this.accNum = attrs.getString(524368);
                this.studyDate = attrs.getString(524320);
            }
            return this;
        }

        Builder studyIUID(String val) {
            this.studyUID = val;
            return this;
        }

        Builder accNum(String val) {
            this.accNum = val;
            return this;
        }

        Builder outcome(String val) {
            this.outcome = val;
            return this;
        }

        Builder sopCUID(String val) {
            this.sopCUID = val;
            return this;
        }

        Builder sopIUID(String val) {
            this.sopIUID = val;
            return this;
        }

        Builder mppsUID(String val) {
            this.mppsUID = val;
            return this;
        }

        Builder queryPOID(String val) {
            this.queryPOID = val;
            return this;
        }

        Builder queryString(String val) {
            this.queryString = val;
            return this;
        }

        Builder destUserID(String val) {
            this.destUserID = val;
            return this;
        }

        Builder destNapID(String val) {
            this.destNapID = val;
            return this;
        }

        Builder moveUserID(String val) {
            this.moveUserID = val;
            return this;
        }

        Builder findSCP(String val) {
            this.findSCP = val;
            return this;
        }

        Builder warning(String val) {
            this.warning = val;
            return this;
        }

        Builder failedIUIDShow(boolean val) {
            this.failedIUIDShow = val;
            return this;
        }

        Builder submissionSetUID(String val) {
            this.submissionSetUID = val;
            return this;
        }

        Builder isExport() {
            this.isExport = true;
            return this;
        }

        Builder isOutgoingHL7() {
            this.isOutgoingHL7 = true;
            return this;
        }

        Builder outgoingHL7Sender(String val) {
            this.outgoingHL7Sender = val;
            return this;
        }

        Builder outgoingHL7Receiver(String val) {
            this.outgoingHL7Receiver = val;
            return this;
        }

        Builder filters(String val) {
            this.filters = val;
            return this;
        }

        Builder count(int val) {
            this.count = val;
            return this;
        }

        Builder queueMsg(String val) {
            this.queueMsg = val;
            return this;
        }

        Builder taskPOID(String val) {
            this.taskPOID = val;
            return this;
        }

        Builder errorCode(int val) {
            this.errorCode = val == 0 ? "0" : AuditInfoBuilder.errorCodeAsString(val);
            return this;
        }

        Builder patMismatchCode(String val) {
            this.patMismatchCode = val;
            return this;
        }

        Builder connType(ConnectionEvent.Type val) {
            this.connType = val;
            return this;
        }

        Builder patVerificationStatus(Patient.VerificationStatus val) {
            this.patVerificationStatus = val;
            return this;
        }

        Builder pdqServiceURI(String val) {
            this.pdqServiceURI = val;
            return this;
        }

        Builder impaxEndpoint(String val) {
            this.impaxEndpoint = val;
            return this;
        }

        Builder failed(int val) {
            this.failed = val;
            return this;
        }

        Builder expirationDate(String val) {
            this.expirationDate = val;
            return this;
        }

        Builder queueName(String val) {
            this.queueName = val;
            return this;
        }

        Builder status(String val) {
            this.status = val;
            return this;
        }

        Builder fhirWebAppName(String val) {
            this.fhirWebAppName = val;
            return this;
        }

        AuditInfoBuilder build() {
            return new AuditInfoBuilder(this);
        }
    }
}

