/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.net.InetAddress;
import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.AssociationEvent;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.SpoolFileReader;

class AssociationEventsAuditService {
    AssociationEventsAuditService() {
    }

    static AuditInfoBuilder associationFailureAuditInfo(AssociationEvent associationEvent) {
        return associationEvent.getType() == AssociationEvent.Type.FAILED ? AssociationEventsAuditService.associationFailedAuditInfo(associationEvent) : AssociationEventsAuditService.associationRejectAuditInfo(associationEvent);
    }

    private static AuditInfoBuilder associationFailedAuditInfo(AssociationEvent associationEvent) {
        Association association = associationEvent.getAssociation();
        return new AuditInfoBuilder.Builder().callingUserID(association.getLocalAET()).callingHost(association.getConnection().getHostname()).calledUserID(association.getRemoteAET()).calledHost(ReverseDNS.hostNameOf((InetAddress)association.getSocket().getInetAddress())).outcome(associationEvent.getException().getMessage()).build();
    }

    private static AuditInfoBuilder associationRejectAuditInfo(AssociationEvent associationEvent) {
        Association association = associationEvent.getAssociation();
        return new AuditInfoBuilder.Builder().callingUserID(association.getRemoteAET()).callingHost(ReverseDNS.hostNameOf((InetAddress)association.getSocket().getInetAddress())).calledUserID(association.getLocalAET()).calledHost(association.getConnection().getHostname()).outcome(associationEvent.getException().getMessage()).build();
    }

    static AuditMessage associationFailureAuditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])AssociationEventsAuditService.activeParticipants(auditInfo), (ParticipantObjectIdentification[])new ParticipantObjectIdentification[0]);
    }

    private static ActiveParticipant[] activeParticipants(AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[]{new ActiveParticipantBuilder(auditInfo.getField(1), auditInfo.getField(0)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).isRequester().build(), new ActiveParticipantBuilder(auditInfo.getField(2), auditInfo.getField(3)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).build()};
        return activeParticipants;
    }
}

