/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.rs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.UPS;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.UPSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpsCSV {
    private static final Logger LOG = LoggerFactory.getLogger(UpsCSV.class);
    private static final IDWithIssuer dummyPatientID = new IDWithIssuer("DummyPID^^^DummyIssuer");
    private final UPSService upsService;
    private final HttpServletRequestInfo httpServletRequestInfo;
    private final ArchiveAEExtension arcAE;
    private final Attributes upsTemplateAttrs;

    public UpsCSV(UPSService upsService, HttpServletRequestInfo httpServletRequestInfo, ArchiveAEExtension arcAE, Attributes upsTemplateAttrs) {
        this.upsService = upsService;
        this.httpServletRequestInfo = httpServletRequestInfo;
        this.arcAE = arcAE;
        this.upsTemplateAttrs = upsTemplateAttrs;
    }

    Response createWorkitems(int studyUIDField, int patientIDField, String movescp, InputStream in) {
        Response.Status status = Response.Status.NO_CONTENT;
        int count = 0;
        String warning = null;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.arcAE.getApplicationEntity().getDevice().getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        int csvUploadChunkSize = arcDev.getCSVUploadChunkSize();
        HashMap<String, IDWithIssuer> studyPatientMap = new HashMap<String, IDWithIssuer>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));
             CSVParser parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.builder().setDelimiter(this.csvDelimiter()).build());){
            boolean header = true;
            IDWithIssuer pid = dummyPatientID;
            for (CSVRecord csvRecord : parser) {
                if (csvRecord.size() == 0 || csvRecord.get(0).isEmpty()) continue;
                String studyUID = csvRecord.get(studyUIDField - 1).replaceAll("\"", "");
                if (header && studyUID.chars().allMatch(Character::isLetter)) {
                    header = false;
                    continue;
                }
                if (!arcDev.isValidateUID() || this.validateUID(studyUID)) {
                    if (patientIDField > 0) {
                        pid = new IDWithIssuer(csvRecord.get(patientIDField - 1).replaceAll("\"", ""));
                    }
                    studyPatientMap.put(studyUID, pid);
                }
                if (studyPatientMap.size() != csvUploadChunkSize) continue;
                count += this.createUPSRecords(studyPatientMap, movescp);
                studyPatientMap.clear();
            }
            if (!studyPatientMap.isEmpty()) {
                count += this.createUPSRecords(studyPatientMap, movescp);
            }
            if (count == 0) {
                warning = "Empty file or Incorrect field position or Not a CSV file or Invalid UIDs.";
            }
        }
        catch (Exception e) {
            warning = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (warning == null && count > 0) {
            return Response.accepted((Object)UpsCSV.count(count)).build();
        }
        LOG.warn("Response {} caused by {}", (Object)status, (Object)warning);
        Response.ResponseBuilder builder = Response.status((Response.Status)status).header("Warning", (Object)warning);
        if (count > 0) {
            builder.entity((Object)UpsCSV.count(count));
        }
        return builder.build();
    }

    private int createUPSRecords(Map<String, IDWithIssuer> studyPatientMap, String movescp) {
        int count = 0;
        for (Map.Entry<String, IDWithIssuer> studyPatient : studyPatientMap.entrySet()) {
            try {
                UPSContext ctx = this.upsService.newUPSContext(this.httpServletRequestInfo, this.arcAE);
                ctx.setUPSInstanceUID(UIDUtils.createUID());
                UPSUtils.updateUPSTemplateAttrs((ArchiveAEExtension)this.arcAE, (Attributes)this.upsTemplateAttrs, studyPatient, (String)movescp);
                ctx.setAttributes(this.upsTemplateAttrs);
                UPS ups = this.upsService.createUPS(ctx);
                LOG.info("UPSTemplateWorkitem[uid={}]: created {}", (Object)this.upsTemplateAttrs.getString(524312), (Object)ups);
                ++count;
            }
            catch (Exception e) {
                LOG.info("UPSTemplateWorkitem[uid={}]: create UPS failed for Study[uid={}] of Patient[id={}]\n", new Object[]{this.upsTemplateAttrs.getString(524312), studyPatient.getKey(), studyPatient.getValue(), e});
            }
        }
        return count;
    }

    private char csvDelimiter() {
        return "semicolon".equals(this.httpServletRequestInfo.getContentType().getParameters().get("delimiter")) ? (char)';' : ',';
    }

    private boolean validateUID(String uid) {
        boolean valid = UIDUtils.isValid((String)uid);
        if (!valid) {
            LOG.warn("Invalid UID in CSV file: " + uid);
        }
        return valid;
    }

    private static String count(int count) {
        return "{\"count\":" + count + "}";
    }
}

