/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impax.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.ws.WebServiceException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.UID;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.impax.report.ImpaxReportConverter;
import org.dcm4chee.arc.impax.report.ReportServiceProvider;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
public class ImportImpaxReportRS {
    private static final Logger LOG = LoggerFactory.getLogger(ImportImpaxReportRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Inject
    private Device device;
    @Inject
    private ReportServiceProvider reportService;
    @Inject
    private QueryService queryService;
    @Inject
    private StoreService storeService;
    @PathParam(value="AETitle")
    private String aet;

    @POST
    @Path(value="/studies/{studyUID}/impax/reports")
    @Produces(value={"application/dicom+json"})
    public Response importReportsOfStudy(@PathParam(value="studyUID") String studyUID) {
        Attributes studyAttrs;
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((studyAttrs = this.queryService.getStudyAttributes(studyUID)) == null) {
            return this.errResponse("No such Study: " + studyUID, Response.Status.NOT_FOUND);
        }
        List<String> xmlReports = this.queryReports(studyUID);
        try {
            Map props = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getImpaxReportProperties();
            ImpaxReportConverter converter = new ImpaxReportConverter(props, studyAttrs);
            List srReports = converter.convert(xmlReports);
            if (srReports.isEmpty()) {
                return this.errResponse("SR Reports not found for the study", Response.Status.CONFLICT);
            }
            Attributes response = new Attributes();
            response.setString(528784, VR.UR, this.studyRetrieveURL().toString());
            try (StoreSession session = this.storeService.newStoreSession(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), ae, this.aet, (String)props.get("SourceAET"));){
                session.setImpaxReportEndpoint(converter.getEndpoint());
                srReports.forEach(sr -> {
                    StoreContext storeCtx = this.storeService.newStoreContext(session);
                    storeCtx.setImpaxReportPatientMismatch(converter.patientMismatchOf(sr));
                    storeCtx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
                    this.storeReport(storeCtx, (Attributes)sr, response);
                });
            }
            return this.buildResponse(xmlReports, response, ae);
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private List<String> queryReports(String studyUID) {
        try {
            return this.reportService.queryReportByStudyUid(studyUID);
        }
        catch (WebServiceException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void storeReport(StoreContext ctx, Attributes attrs, Attributes response) {
        try {
            this.storeService.store(ctx, attrs);
            response.ensureSequence(528793, 1).add(this.mkSOPRefWithRetrieveURL(ctx));
        }
        catch (IOException e) {
            ctx.setAttributes(attrs);
            LOG.info("{}: Failed to store {}", new Object[]{ctx.getStoreSession(), UID.nameOf((String)ctx.getSopClassUID()), e});
            response.setString(2306, VR.LO, e.getMessage());
            response.ensureSequence(528793, 1).add(this.mkSOPRefWithFailureReason(ctx, e));
        }
        catch (Exception e) {
            LOG.warn("Exception caught while storing the SR report. {} \n", (Object)ctx.getStoreSession(), (Object)e);
        }
    }

    private Response buildResponse(List<String> xmlReports, Attributes response, ApplicationEntity ae) {
        Response.Status status = !response.contains(528793) ? Response.Status.CONFLICT : (!xmlReports.isEmpty() && !response.contains(528792) ? Response.Status.OK : Response.Status.ACCEPTED);
        return Response.status((Response.Status)status).entity(out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).encodeAsJSONNumber(new JSONWriter(gen)).write(response);
            gen.flush();
        }).build();
    }

    private StringBuffer studyRetrieveURL() {
        StringBuffer retrieveURL = this.request.getRequestURL();
        retrieveURL.setLength(retrieveURL.length() - 14);
        return retrieveURL;
    }

    private Attributes mkSOPRefWithRetrieveURL(StoreContext ctx) {
        Attributes attrs = this.mkSOPRef(ctx, 3);
        attrs.setString(528784, VR.UR, this.retrieveURL(ctx));
        return attrs;
    }

    private String retrieveURL(StoreContext ctx) {
        StringBuffer retrieveURL = this.studyRetrieveURL();
        retrieveURL.append("/series/").append(ctx.getSeriesInstanceUID());
        retrieveURL.append("/instances/").append(ctx.getSopInstanceUID());
        return retrieveURL.toString();
    }

    private Attributes mkSOPRefWithFailureReason(StoreContext ctx, Exception e) {
        Attributes attrs = this.mkSOPRef(ctx, 3);
        int status = e instanceof DicomServiceException ? ((DicomServiceException)e).getStatus() : 272;
        attrs.setInt(528791, VR.US, new int[]{status});
        return attrs;
    }

    private Attributes mkSOPRef(StoreContext ctx, int size) {
        Attributes attrs = new Attributes(size);
        attrs.setString(528720, VR.UI, ctx.getSopClassUID());
        attrs.setString(528725, VR.UI, ctx.getSopInstanceUID());
        return attrs;
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }
}

