/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.export.mgt.ExportBatch;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="monitor/export/batch")
public class ExportBatchRS {
    private static final Logger LOG = LoggerFactory.getLogger(ExportBatchRS.class);
    @Inject
    private ExportManager mgr;
    @Context
    private UriInfo uriInfo;
    @QueryParam(value="dicomDeviceName")
    private String deviceName;
    @QueryParam(value="status")
    @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED")
    private @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED") String status;
    @QueryParam(value="createdTime")
    private String createdTime;
    @QueryParam(value="updatedTime")
    private String updatedTime;
    @QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @QueryParam(value="orderby")
    @DefaultValue(value="-updatedTime")
    @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime")
    private @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime") String orderby;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="ExporterID")
    private List<String> exporterIDs;
    @Context
    private HttpServletRequest request;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response listExportBatches() {
        this.logRequest();
        try {
            List exportBatches = this.mgr.listExportBatches(this.taskQueryParam(), ExportBatchRS.parseInt(this.offset), ExportBatchRS.parseInt(this.limit));
            return Response.ok((Object)Output.JSON.entity(exportBatches)).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private TaskQueryParam taskQueryParam() {
        TaskQueryParam taskQueryParam = new TaskQueryParam();
        taskQueryParam.setDeviceName(this.deviceName);
        taskQueryParam.setStatus(this.status);
        taskQueryParam.setBatchID(this.batchID);
        taskQueryParam.setCreatedTime(this.createdTime);
        taskQueryParam.setUpdatedTime(this.updatedTime);
        taskQueryParam.setOrderBy(this.orderby);
        taskQueryParam.setType(Task.Type.EXPORT);
        taskQueryParam.setExporterIDs(this.exporterIDs.stream().flatMap(exporterID -> Stream.of(StringUtils.split((String)exporterID, (char)','))).collect(Collectors.toList()));
        return taskQueryParam;
    }

    private static enum Output {
        JSON{

            @Override
            Object entity(List<ExportBatch> exportBatches) {
                return out -> {
                    JsonGenerator gen = Json.createGenerator((OutputStream)out);
                    gen.writeStartArray();
                    exportBatches.forEach(exportBatch -> {
                        JsonWriter writer = new JsonWriter(gen);
                        gen.writeStartObject();
                        writer.writeNotNullOrDef("batchID", (Object)exportBatch.getBatchID(), null);
                        this.writeTasks((ExportBatch)exportBatch, writer);
                        writer.writeNotEmpty("dicomDeviceName", (Object[])exportBatch.getDeviceNames(), (Object[])new String[0]);
                        writer.writeNotEmpty("ExporterID", (Object[])exportBatch.getExporterIDs(), (Object[])new String[0]);
                        writer.writeNotEmpty("createdTimeRange", (Object[])this.datesAsStrings(exportBatch.getCreatedTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("updatedTimeRange", (Object[])this.datesAsStrings(exportBatch.getUpdatedTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("scheduledTimeRange", (Object[])this.datesAsStrings(exportBatch.getScheduledTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("processingStartTimeRange", (Object[])this.datesAsStrings(exportBatch.getProcessingStartTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("processingEndTimeRange", (Object[])this.datesAsStrings(exportBatch.getProcessingEndTimeRange()), (Object[])new String[0]);
                        gen.writeEnd();
                    });
                    gen.writeEnd();
                    gen.flush();
                };
            }

            private void writeTasks(ExportBatch exportBatch, JsonWriter writer) {
                writer.writeStartObject("tasks");
                writer.writeNotNullOrDef("scheduled", (Object)exportBatch.getScheduled(), (Object)0);
                writer.writeNotNullOrDef("in-process", (Object)exportBatch.getInProcess(), (Object)0);
                writer.writeNotNullOrDef("warning", (Object)exportBatch.getWarning(), (Object)0);
                writer.writeNotNullOrDef("failed", (Object)exportBatch.getFailed(), (Object)0);
                writer.writeNotNullOrDef("canceled", (Object)exportBatch.getCanceled(), (Object)0);
                writer.writeNotNullOrDef("completed", (Object)exportBatch.getCompleted(), (Object)0);
                writer.writeEnd();
            }

            private String[] datesAsStrings(Date[] dates) {
                String[] datesAsStrings = new String[dates.length];
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                for (int i = 0; i < dates.length; ++i) {
                    datesAsStrings[i] = df.format(dates[i]);
                }
                return datesAsStrings;
            }
        };


        abstract Object entity(List<ExportBatch> var1);
    }
}

