/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.dimse.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.mgt.RetrieveManager;
import org.dcm4chee.arc.retrieve.scu.CMoveSCU;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{ExternalAET}")
public class RetrieveRS {
    private static final Logger LOG = LoggerFactory.getLogger(RetrieveRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private IDeviceCache deviceCache;
    @Inject
    private Event<ExternalRetrieveContext> instancesRetrievedEvent;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="ExternalAET")
    private String externalAET;
    @QueryParam(value="priority")
    @Pattern(regexp="0|1|2")
    private @Pattern(regexp="0|1|2") String priority;
    @QueryParam(value="dcmQueueName")
    private String queueName;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="dicomDeviceName")
    private String deviceName;
    @QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @Inject
    private CMoveSCU moveSCU;
    @Inject
    private RetrieveManager retrieveManager;
    @Inject
    private TaskManager taskManager;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/studies/{StudyUID}/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response exportStudy(@PathParam(value="StudyUID") String studyUID, @PathParam(value="DestinationAET") String destinationAET) {
        return this.export(destinationAET, studyUID);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response exportSeries(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="DestinationAET") String destinationAET) {
        return this.export(destinationAET, studyUID, seriesUID);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/instances/{ObjectUID}/export/dicom:{DestinationAET}")
    @Produces(value={"application/json"})
    public Response exportSeries(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="ObjectUID") String objectUID, @PathParam(value="DestinationAET") String destinationAET) {
        return this.export(destinationAET, studyUID, seriesUID, objectUID);
    }

    private int priority() {
        return RetrieveRS.parseInt(this.priority, 0);
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private Response export(String destAET, String ... uids) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (uids[0].startsWith("csv")) {
            return this.errResponse("Missing Content-type Header in 'Retrieve Studies specified in CSV from external archive' service causes invocation of 'Retrieve Study from external archive' service.", Response.Status.BAD_REQUEST);
        }
        try {
            this.validate();
            Attributes keys = this.toKeys(uids);
            return this.queueName != null ? this.queueExport(destAET, this.toKeys(uids)) : this.export(destAET, keys);
        }
        catch (IllegalStateException | ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IOException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY);
        }
        catch (IllegalArgumentException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response queueExport(String destAET, Attributes keys) {
        ExternalRetrieveContext ctx = this.createExtRetrieveCtx(destAET, keys);
        this.retrieveManager.scheduleRetrieveTask(ctx, null);
        if (this.scheduledOnThisDevice() && this.scheduledTime == null) {
            this.taskManager.processQueue(this.queueName);
        }
        return Response.accepted().entity((Object)this.writeJSON(ctx.getRetrieveTask())).build();
    }

    private StreamingOutput writeJSON(Task retrieveTask) {
        return out -> {
            OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            try (JsonGenerator gen = Json.createGenerator((Writer)w);){
                retrieveTask.writeAsJSON(gen);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response export(String destAET, Attributes keys) throws Exception {
        ApplicationEntity localAE = this.device.getApplicationEntity(this.aet, true);
        if (localAE == null || !localAE.isInstalled()) {
            throw new ConfigurationException("No such Application Entity: " + this.aet);
        }
        Association as = this.moveSCU.openAssociation(localAE, this.externalAET);
        try {
            DimseRSP rsp = this.moveSCU.cmove(as, this.priority(), destAET, keys);
            while (rsp.next()) {
            }
            Attributes cmd = rsp.getCommand();
            this.instancesRetrievedEvent.fire((Object)this.createExtRetrieveCtx(destAET, keys).setRemoteHostName(ReverseDNS.hostNameOf((InetAddress)as.getSocket().getInetAddress())).setResponse(cmd));
            Response response = this.status(cmd).entity(this.entity(cmd)).build();
            return response;
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association:\\n", (Object)as, (Object)e);
            }
        }
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validate() throws ConfigurationException {
        this.aeCache.findApplicationEntity(this.externalAET);
        if (!this.scheduledOnThisDevice()) {
            Device device = this.deviceCache.findDevice(this.deviceName);
            ApplicationEntity ae = device.getApplicationEntity(this.aet, true);
            if (ae == null || !ae.isInstalled()) {
                throw new ConfigurationException("No such Application Entity: " + this.aet + " found in device: " + this.deviceName);
            }
            this.validateQueue(device);
        } else {
            this.validateQueue(this.device);
        }
    }

    private boolean scheduledOnThisDevice() {
        return this.deviceName == null || this.deviceName.equals(this.device.getDeviceName());
    }

    private void validateQueue(Device device) {
        if (this.queueName == null) {
            return;
        }
        ((ArchiveDeviceExtension)device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueueDescriptorNotNull(this.queueName);
    }

    private ExternalRetrieveContext createExtRetrieveCtx(String destAET, Attributes keys) {
        return new ExternalRetrieveContext().setDeviceName(this.deviceName != null ? this.deviceName : this.device.getDeviceName()).setQueueName(this.queueName).setBatchID(this.batchID).setLocalAET(this.aet).setRemoteAET(this.externalAET).setDestinationAET(destAET).setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request)).setScheduledTime(this.scheduledTime != null ? ParseDateTime.valueOf((String)this.scheduledTime) : new Date()).setKeys(keys);
    }

    private Attributes toKeys(String[] iuids) {
        int n = iuids.length;
        Attributes keys = new Attributes(n + 1);
        keys.setString(524370, VR.CS, QueryRetrieveLevel2.values()[n].name());
        keys.setString(0x20000D, VR.UI, iuids[0]);
        if (n > 1) {
            keys.setString(0x20000E, VR.UI, iuids[1]);
            if (n > 2) {
                keys.setString(524312, VR.UI, iuids[2]);
            }
        }
        return keys;
    }

    private Response.ResponseBuilder status(Attributes cmd) {
        int status = cmd.getInt(2304, -1);
        switch (status) {
            case 0: {
                return Response.ok();
            }
            case 45056: {
                return Response.status((Response.Status)Response.Status.PARTIAL_CONTENT).header("Warning", (Object)this.warning(status));
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_GATEWAY).header("Warning", (Object)this.warning(status));
    }

    private String warning(int status) {
        switch (status) {
            case 45056: {
                return "B000: Sub-operations Complete - One or more Failures";
            }
            case 42753: {
                return "A701: Refused: Out of Resources - Unable to calculate number of matches";
            }
            case 42754: {
                return "A702: Refused: Out of Resources - Unable to perform sub-operations";
            }
            case 43009: {
                return "A801: Refused: Move Destination unknown";
            }
            case 43264: {
                return "A900: Identifier does not match SOP Class";
            }
        }
        return TagUtils.shortToHexString((int)status) + ((status & 0xC000) == 49152 ? ": Unable to Process" : ": Unexpected status code");
    }

    private Object entity(Attributes cmd) {
        return out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JsonWriter writer = new JsonWriter(gen);
            gen.writeStartObject();
            gen.write("status", TagUtils.shortToHexString((int)cmd.getInt(2304, -1)));
            writer.writeNotNullOrDef("error", (Object)cmd.getString(2306), null);
            writer.writeNotDef("completed", cmd.getInt(4129, -1), -1);
            writer.writeNotDef("warning", cmd.getInt(4131, -1), -1);
            writer.writeNotDef("failed", cmd.getInt(4130, -1), -1);
            gen.writeEnd();
            gen.flush();
        };
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }
}

