/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.diff.rs;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Status;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.diff.DiffContext;
import org.dcm4chee.arc.diff.DiffSCU;
import org.dcm4chee.arc.diff.DiffService;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{ExternalAET}/diff/{OriginalAET}")
@InvokeValidate(type=DiffRS.class)
public class DiffRS {
    private static final Logger LOG = LoggerFactory.getLogger(DiffRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private DiffService diffService;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="ExternalAET")
    private String externalAET;
    @PathParam(value="OriginalAET")
    private String originalAET;
    @QueryParam(value="isFuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @QueryParam(value="different")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String different;
    @QueryParam(value="missing")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String missing;
    @QueryParam(value="priority")
    @Pattern(regexp="0|1|2")
    private @Pattern(regexp="0|1|2") String priority;
    @QueryParam(value="queue")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String queue;
    @QueryParam(value="ForceQueryByStudyUID")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String forceQueryByStudyUID;
    @QueryParam(value="SplitStudyDateRange")
    @ValidValueOf(type=Duration.class)
    private String splitStudyDateRange;
    @HeaderParam(value="Content-Type")
    private MediaType contentType;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    @GET
    @NoCache
    @Path(value="/studies")
    @Produces(value={"application/dicom+json,application/json"})
    public void compareStudies(@Suspended AsyncResponse ar) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        this.validateAcceptedUserRoles(arcAE);
        try {
            Attributes diff1;
            DiffContext ctx = this.createDiffContext();
            ctx.setQueryString(this.request.getQueryString(), this.uriInfo.getQueryParameters());
            if (Boolean.parseBoolean(this.queue)) {
                this.diffService.scheduleDiffTask(ctx);
                ar.resume((Object)Response.accepted().build());
                return;
            }
            DiffSCU diffSCU = this.diffService.createDiffSCU(ctx);
            ar.register(throwable -> SafeClose.close((Closeable)diffSCU));
            if (!Status.isPending((int)diffSCU.init())) {
                ar.resume((Object)Response.noContent().build());
                return;
            }
            int skip = this.offset();
            while ((diff1 = diffSCU.nextDiff()) != null && skip-- > 0) {
            }
            if (diff1 == null) {
                ar.resume((Object)Response.ok((Object)"[]").build());
            } else {
                ar.resume((Object)Response.ok((Object)this.entity(diff1, diffSCU)).build());
            }
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST));
        }
        catch (IOException e) {
            throw new WebApplicationException(this.errResponse(DiffRS.errorMessage(e), Response.Status.BAD_GATEWAY));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @NoCache
    @Path(value="/studies/count")
    @Produces(value={"application/json"})
    public void countDiffs(@Suspended AsyncResponse ar) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        this.validateAcceptedUserRoles(arcAE);
        try {
            DiffContext ctx = this.createDiffContext();
            ctx.setQueryString(this.request.getQueryString(), this.uriInfo.getQueryParameters());
            DiffSCU diffSCU = this.diffService.createDiffSCU(ctx);
            ar.register(throwable -> SafeClose.close((Closeable)diffSCU));
            diffSCU.init();
            diffSCU.countDiffs();
            ar.resume((Object)Response.ok((Object)("{\"count\":" + diffSCU.matches() + ",\"missing\":" + diffSCU.missing() + ",\"different\":" + diffSCU.different() + "}")).build());
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST));
        }
        catch (IOException e) {
            throw new WebApplicationException(this.errResponse(DiffRS.errorMessage(e), Response.Status.BAD_GATEWAY));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @POST
    @Path(value="/studies/csv:{field}")
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response compareStudiesFromCSV(@PathParam(value="field") int field, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        Response.Status status = Response.Status.BAD_REQUEST;
        if (field < 1) {
            return this.errResponse("CSV field for Study Instance UID should be greater than or equal to 1", status);
        }
        int count = 0;
        String warning = null;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        int csvUploadChunkSize = arcDev.getCSVUploadChunkSize();
        ArrayList<String> studyUIDs = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));
             CSVParser parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.builder().setDelimiter(this.csvDelimiter()).build());){
            boolean header = true;
            for (CSVRecord csvRecord : parser) {
                if (csvRecord.size() == 0 || csvRecord.get(0).isEmpty()) continue;
                String studyUID = csvRecord.get(field - 1).replaceAll("\"", "");
                if (header && studyUID.chars().allMatch(Character::isLetter)) {
                    header = false;
                    continue;
                }
                if (!arcDev.isValidateUID() || this.validateUID(studyUID)) {
                    studyUIDs.add(studyUID);
                }
                if (studyUIDs.size() != csvUploadChunkSize) continue;
                count = this.scheduleDiffTasks(count, studyUIDs);
            }
            if (!studyUIDs.isEmpty()) {
                count = this.scheduleDiffTasks(count, studyUIDs);
            }
            if (count == 0) {
                warning = "Empty file or Incorrect field position or Not a CSV file or Invalid UIDs.";
                status = Response.Status.NO_CONTENT;
            }
        }
        catch (ConfigurationException e) {
            warning = e.getMessage();
            status = Response.Status.NOT_FOUND;
        }
        catch (Exception e) {
            warning = e.getMessage();
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (warning == null && count > 0) {
            return Response.accepted((Object)DiffRS.count(count)).build();
        }
        LOG.warn("Response {} caused by {}", (Object)status, (Object)warning);
        Response.ResponseBuilder builder = Response.status((Response.Status)status).header("Warning", (Object)warning);
        if (count > 0) {
            builder.entity((Object)DiffRS.count(count));
        }
        return builder.build();
    }

    private int scheduleDiffTasks(int count, List<String> studyUIDs) throws ConfigurationException {
        String queryString = this.request.getQueryString();
        DiffContext ctx = this.createDiffContext();
        ctx.setQueryString(queryString == null ? "StudyInstanceUID=" : queryString.concat("&StudyInstanceUID="), this.uriInfo.getQueryParameters());
        this.diffService.scheduleDiffTasks(ctx, studyUIDs);
        studyUIDs.clear();
        return count += studyUIDs.size();
    }

    private boolean validateUID(String studyUID) {
        boolean valid = UIDUtils.isValid((String)studyUID);
        if (!valid) {
            LOG.warn("Invalid UID in CSV file: " + studyUID);
        }
        return valid;
    }

    private char csvDelimiter() {
        return "semicolon".equals(this.contentType.getParameters().get("delimiter")) ? (char)';' : ',';
    }

    private DiffContext createDiffContext() throws ConfigurationException {
        ApplicationEntity localAE = this.device.getApplicationEntity(this.aet, true);
        if (localAE == null || !localAE.isInstalled()) {
            throw new ConfigurationException("No such Application Entity: " + this.aet);
        }
        return new DiffContext().setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request)).setLocalAET(this.aet).setPrimaryAE(this.aeCache.findApplicationEntity(this.externalAET)).setSecondaryAE(this.aeCache.findApplicationEntity(this.originalAET)).setArcDev((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class));
    }

    private static String errorMessage(IOException e) {
        if (e instanceof DicomServiceException) {
            String statusAsString = DiffRS.statusAsString(((DicomServiceException)e).getStatus());
            return e.getMessage() == null ? statusAsString : statusAsString + " - " + e.getMessage();
        }
        return e.getMessage();
    }

    private static String count(int count) {
        return "{\"count\":" + count + "}";
    }

    private static String statusAsString(int status) {
        switch (status) {
            case 42752: {
                return "A700: Refused: Out of Resources";
            }
            case 43264: {
                return "A900: Identifier does not match SOP Class";
            }
        }
        return TagUtils.shortToHexString((int)status) + ((status & 0xF000) == 49152 ? ": Unable to Process" : ": Unexpected status code");
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private int offset() {
        return DiffRS.parseInt(this.offset, 0);
    }

    private int limit() {
        return DiffRS.parseInt(this.limit, Integer.MAX_VALUE);
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private StreamingOutput entity(Attributes diff1, DiffSCU diffSCU) {
        return output -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)output);){
                JSONWriter writer = ((ArchiveAEExtension)this.device.getApplicationEntity(diffSCU.getDiffCtx().getLocalAET(), true).getAEExtensionNotNull(ArchiveAEExtension.class)).encodeAsJSONNumber(new JSONWriter(gen));
                gen.writeStartArray();
                int remaining = this.limit();
                Attributes diff = diff1;
                while (diff != null) {
                    writer.write(diff);
                    try {
                        diff = --remaining > 0 ? diffSCU.nextDiff() : null;
                    }
                    catch (Exception e) {
                        LOG.info("Failure on query for matching studies:\\n", (Throwable)e);
                        Attributes attrs = new Attributes(1);
                        attrs.setString(2306, VR.LO, e.getMessage());
                        writer.write(attrs);
                        break;
                    }
                }
                gen.writeEnd();
            }
        };
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }
}

