/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.diff.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.diff.DiffBatch;
import org.dcm4chee.arc.diff.DiffService;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="monitor/diff/batch")
public class DiffBatchRS {
    private static final Logger LOG = LoggerFactory.getLogger(DiffBatchRS.class);
    @Inject
    private Device device;
    @Inject
    private DiffService diffService;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="dicomDeviceName")
    private String deviceName;
    @QueryParam(value="LocalAET")
    private String localAET;
    @QueryParam(value="PrimaryAET")
    private String primaryAET;
    @QueryParam(value="SecondaryAET")
    private String secondaryAET;
    @QueryParam(value="checkDifferent")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String checkDifferent;
    @QueryParam(value="checkMissing")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String checkMissing;
    @QueryParam(value="status")
    @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED")
    private @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED") String status;
    @QueryParam(value="createdTime")
    private String createdTime;
    @QueryParam(value="updatedTime")
    private String updatedTime;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="comparefield")
    private String comparefields;
    @QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @QueryParam(value="orderby")
    @DefaultValue(value="-updatedTime")
    @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime")
    private @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime") String orderby;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response listDiffBatches() {
        this.logRequest();
        try {
            List diffBatches = this.diffService.listDiffBatches(this.taskQueryParam(this.batchID), DiffBatchRS.parseInt(this.offset), DiffBatchRS.parseInt(this.limit));
            return Response.ok().entity(Output.JSON.entity(diffBatches)).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/{batchID}/studies")
    @Produces(value={"application/dicom+json,application/json"})
    public Response getDiffBatchResult(@PathParam(value="batchID") String batchID) {
        this.logRequest();
        try {
            if (this.diffService.diffTasksOfBatch(batchID) == 0L) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)this.entity(this.diffService.getDiffTaskAttributes(this.taskQueryParam(batchID), DiffBatchRS.parseInt(this.offset), DiffBatchRS.parseInt(this.limit)))).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private StreamingOutput entity(List<byte[]> diffTaskAttributesList) {
        return output -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)output);){
                JSONWriter writer = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).encodeAsJSONNumber(new JSONWriter(gen));
                gen.writeStartArray();
                for (byte[] diffTaskAttributes : diffTaskAttributesList) {
                    writer.write(AttributesBlob.decodeAttributes((byte[])diffTaskAttributes, null));
                }
                gen.writeEnd();
            }
        };
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private static int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private TaskQueryParam taskQueryParam(String batchID) {
        TaskQueryParam taskQueryParam = new TaskQueryParam();
        taskQueryParam.setDeviceName(this.deviceName);
        taskQueryParam.setStatus(this.status);
        taskQueryParam.setBatchID(batchID);
        taskQueryParam.setCreatedTime(this.createdTime);
        taskQueryParam.setUpdatedTime(this.updatedTime);
        taskQueryParam.setOrderBy(this.orderby);
        taskQueryParam.setType(Task.Type.DIFF);
        taskQueryParam.setLocalAET(this.localAET);
        taskQueryParam.setPrimaryAET(this.primaryAET);
        taskQueryParam.setSecondaryAET(this.secondaryAET);
        taskQueryParam.setCompareFields(this.comparefields);
        taskQueryParam.setCheckMissing(this.checkMissing);
        taskQueryParam.setCheckDifferent(this.checkDifferent);
        return taskQueryParam;
    }

    private static enum Output {
        JSON{

            @Override
            Object entity(List<DiffBatch> diffBatches) {
                return out -> {
                    JsonGenerator gen = Json.createGenerator((OutputStream)out);
                    gen.writeStartArray();
                    diffBatches.forEach(diffBatch -> {
                        JsonWriter writer = new JsonWriter(gen);
                        gen.writeStartObject();
                        writer.writeNotNullOrDef("batchID", (Object)diffBatch.getBatchID(), null);
                        this.writeTasks((DiffBatch)diffBatch, writer);
                        writer.writeNotEmpty("dicomDeviceName", (Object[])diffBatch.getDeviceNames(), (Object[])new String[0]);
                        writer.writeNotEmpty("LocalAET", (Object[])diffBatch.getLocalAETs(), (Object[])new String[0]);
                        writer.writeNotEmpty("PrimaryAET", (Object[])diffBatch.getPrimaryAETs(), (Object[])new String[0]);
                        writer.writeNotEmpty("SecondaryAET", (Object[])diffBatch.getSecondaryAETs(), (Object[])new String[0]);
                        writer.writeNotEmpty("comparefield", (Object[])diffBatch.getComparefields(), (Object[])new String[0]);
                        writer.writeNotEmpty("checkMissing", (Object[])diffBatch.getCheckMissing(), (Object[])new Boolean[0]);
                        writer.writeNotEmpty("checkDifferent", (Object[])diffBatch.getCheckDifferent(), (Object[])new Boolean[0]);
                        writer.writeNotDef("matches", diffBatch.getMatches(), 0);
                        writer.writeNotDef("missing", diffBatch.getMissing(), 0);
                        writer.writeNotDef("different", diffBatch.getDifferent(), 0);
                        writer.writeNotEmpty("createdTimeRange", (Object[])this.datesAsStrings(diffBatch.getCreatedTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("updatedTimeRange", (Object[])this.datesAsStrings(diffBatch.getUpdatedTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("scheduledTimeRange", (Object[])this.datesAsStrings(diffBatch.getScheduledTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("processingStartTimeRange", (Object[])this.datesAsStrings(diffBatch.getProcessingStartTimeRange()), (Object[])new String[0]);
                        writer.writeNotEmpty("processingEndTimeRange", (Object[])this.datesAsStrings(diffBatch.getProcessingEndTimeRange()), (Object[])new String[0]);
                        gen.writeEnd();
                    });
                    gen.writeEnd();
                    gen.flush();
                };
            }

            private void writeTasks(DiffBatch diffBatch, JsonWriter writer) {
                writer.writeStartObject("tasks");
                writer.writeNotNullOrDef("scheduled", (Object)diffBatch.getScheduled(), (Object)0);
                writer.writeNotNullOrDef("in-process", (Object)diffBatch.getInProcess(), (Object)0);
                writer.writeNotNullOrDef("warning", (Object)diffBatch.getWarning(), (Object)0);
                writer.writeNotNullOrDef("failed", (Object)diffBatch.getFailed(), (Object)0);
                writer.writeNotNullOrDef("canceled", (Object)diffBatch.getCanceled(), (Object)0);
                writer.writeNotNullOrDef("completed", (Object)diffBatch.getCompleted(), (Object)0);
                writer.writeEnd();
            }

            private String[] datesAsStrings(Date[] dates) {
                String[] datesAsStrings = new String[dates.length];
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                for (int i = 0; i < dates.length; ++i) {
                    datesAsStrings[i] = df.format(dates[i]);
                }
                return datesAsStrings;
            }
        };


        abstract Object entity(List<DiffBatch> var1);
    }
}

