/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.scp;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.CompatibleConnection;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.ups.UPSEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UPSEventSCP {
    private static final Logger LOG = LoggerFactory.getLogger(UPSEventSCP.class);
    private final ConcurrentHashMap<FromTo, Association> reuseAssociations = new ConcurrentHashMap();
    @Inject
    private IApplicationEntityCache aeCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUPSEvent(@Observes UPSEvent event) {
        Optional inprocessStateReport = event.inprocessStateReport();
        int keepAliveTimeout = event.arcAE.upsEventSCUKeepAlive();
        boolean keepAlive = keepAliveTimeout > 0;
        for (String subscriberAET : event.subscriberAETs) {
            if (!event.arcAE.isUPSEventSCU(subscriberAET)) continue;
            try {
                ApplicationEntity localAE = event.arcAE.getApplicationEntity();
                Association as = keepAlive ? this.getAssociation(localAE, subscriberAET, keepAliveTimeout) : localAE.connect(this.aeCache.findApplicationEntity(subscriberAET), UPSEventSCP.mkAAssociateRQ(localAE, subscriberAET));
                try {
                    if (inprocessStateReport.isPresent()) {
                        this.sendNEventReport(as, event, (Attributes)inprocessStateReport.get());
                    }
                    this.sendNEventReport(as, event, event.attrs);
                }
                finally {
                    if (keepAlive) continue;
                    as.release();
                }
            }
            catch (Exception e) {
                LOG.info("Failed to send {} EventReport to {} - {}", new Object[]{event.type, subscriberAET, e.getMessage()});
            }
        }
    }

    private Association getAssociation(ApplicationEntity localAE, String subscriberAET, int keepAlive) throws Exception {
        FromTo fromTo = new FromTo(localAE.getAETitle(), subscriberAET);
        Association as = this.reuseAssociations.get(fromTo);
        if (!as.isReadyForDataTransfer()) {
            ApplicationEntity remote = this.aeCache.get(subscriberAET);
            CompatibleConnection cc = localAE.findCompatibleConnection(remote);
            Connection localConnection = new Connection(cc.getLocalConnection());
            localConnection.setIdleTimeout(keepAlive);
            as = localAE.connect(localConnection, cc.getRemoteConnection(), UPSEventSCP.mkAAssociateRQ(localAE, subscriberAET));
            this.reuseAssociations.put(fromTo, as);
        }
        return as;
    }

    private void sendNEventReport(Association as, UPSEvent event, Attributes attrs) throws Exception {
        DimseRSP dimseRSP = as.neventReport("1.2.840.10008.5.1.4.34.6.4", "1.2.840.10008.5.1.4.34.6.1", event.upsIUID, event.type.eventTypeID(), attrs, null);
        dimseRSP.next();
        int status = dimseRSP.getCommand().getInt(2304, -1);
        if (status != 0) {
            throw new DicomServiceException(status);
        }
    }

    private static AAssociateRQ mkAAssociateRQ(ApplicationEntity localAE, String subscriberAET) {
        String[] stringArray;
        AAssociateRQ aarq = new AAssociateRQ();
        aarq.setCalledAET(subscriberAET);
        TransferCapability tc = localAE.getTransferCapabilityFor("1.2.840.10008.5.1.4.34.6.4", TransferCapability.Role.SCP);
        if (tc != null) {
            stringArray = tc.getTransferSyntaxes();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "1.2.840.10008.1.2";
        }
        aarq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.5.1.4.34.6.4", stringArray));
        aarq.addRoleSelection(new RoleSelection("1.2.840.10008.5.1.4.34.6.4", false, true));
        return aarq;
    }

    private static class FromTo {
        final String callingAET;
        final String calledAET;

        FromTo(String callingAET, String calledAET) {
            this.callingAET = callingAET;
            this.calledAET = calledAET;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromTo fromTo = (FromTo)o;
            return this.callingAET.equals(fromTo.callingAET) && this.calledAET.equals(fromTo.calledAET);
        }

        public int hashCode() {
            return Objects.hash(this.callingAET, this.calledAET);
        }
    }
}

