/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.movescu;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.dcmr.ScopeOfAccumulation;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.UPSProcessingRule;
import org.dcm4chee.arc.retrieve.scu.CMoveSCU;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.UPSUtils;
import org.dcm4chee.arc.ups.process.AbstractUPSProcessor;
import org.dcm4chee.arc.ups.process.UPSProcessorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPSMoveSCU
extends AbstractUPSProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(UPSMoveSCU.class);
    private final CMoveSCU moveSCU;
    private final String defDestinationAE;

    public UPSMoveSCU(UPSProcessingRule rule, UPSService upsService, CMoveSCU moveSCU) {
        super(rule, upsService, true);
        this.moveSCU = moveSCU;
        this.defDestinationAE = rule.getUPSProcessorURI().getSchemeSpecificPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processA(UPSContext upsCtx, Attributes ups) throws Exception {
        String moveDest = this.moveDestOf(ups);
        String retrieveAET = this.retrieveAETOf(ups);
        List<Attributes> keyss = new KeysBuilder(ups).keys();
        Association as = this.moveSCU.openAssociation(upsCtx.getApplicationEntity(), retrieveAET);
        try {
            Sum sum = new Sum();
            for (Attributes keys : keyss) {
                DimseRSP rsp = this.moveSCU.cmove(as, 0, moveDest, keys);
                while (rsp.next()) {
                }
                sum.add(rsp);
            }
            this.getPerformedProcedureStep(upsCtx).setString(4194900, VR.LO, this.toDescription(retrieveAET, moveDest, sum));
            if (sum.getStatus() != 0) {
                throw new DicomServiceException(sum.getStatus(), sum.getErrorComment());
            }
            if (sum.getNumberOfCompletedSuboperations() == 0 && sum.getNumberOfWarningSuboperations() == 0) {
                throw new UPSProcessorException(NOOP_UPS, "No DICOM instances transferred from " + retrieveAET + " to " + moveDest);
            }
        }
        finally {
            try {
                as.release();
            }
            catch (IOException e) {
                LOG.info("{}: Failed to release association:\\n", (Object)as, (Object)e);
            }
        }
    }

    private String toDescription(String retrieveAET, String moveDest, Sum sum) {
        int failed;
        StringBuilder sb = new StringBuilder(256).append("Transfer Instances from ").append(retrieveAET).append(" to ").append(moveDest);
        sb.append(" - completed:").append(sum.getNumberOfCompletedSuboperations());
        int warning = sum.getNumberOfWarningSuboperations();
        if (warning > 0) {
            sb.append(", warning:").append(warning);
        }
        if ((failed = sum.getNumberOfFailedSuboperations()) > 0) {
            sb.append(", failed:").append(failed);
        }
        return sb.length() > 64 ? sb.substring(0, 64) : sb.toString();
    }

    private String moveDestOf(Attributes ups) {
        Attributes dicomStorage;
        Attributes outputDestination = ups.getNestedDataset(0x404070);
        return outputDestination != null && (dicomStorage = outputDestination.getNestedDataset(4210801)) != null ? dicomStorage.getString(553648448, this.defDestinationAE) : this.defDestinationAE;
    }

    private String retrieveAETOf(Attributes ups) throws UPSProcessorException {
        return ups.getSequence(4210721).stream().map(item -> item.getNestedDataset(4251681)).filter(Objects::nonNull).map(item -> item.getString(524372)).filter(Objects::nonNull).findFirst().orElseThrow(UPSMoveSCU::missingRetrieveAETitle);
    }

    private static UPSProcessorException missingRetrieveAETitle() {
        return new UPSProcessorException(BAD_UPS, "Missing Retrieve AE Title in Input Information Sequence");
    }

    private static class Sum {
        private int status = 0;
        private String errorComment;
        private int completed;
        private int warning;
        private int failed;

        private Sum() {
        }

        public int getStatus() {
            return this.status;
        }

        public String getErrorComment() {
            return this.errorComment;
        }

        public int getNumberOfCompletedSuboperations() {
            return this.completed;
        }

        public int getNumberOfWarningSuboperations() {
            return this.warning;
        }

        public int getNumberOfFailedSuboperations() {
            return this.failed;
        }

        public void add(DimseRSP rsp) {
            Attributes cmd = rsp.getCommand();
            switch (cmd.getInt(2304, -1)) {
                case 45056: {
                    if (this.status == 0) {
                        this.updateStatus(cmd);
                    }
                }
                case 0: {
                    this.updateNumbers(cmd.getInt(4129, 0), cmd.getInt(4131, 0), cmd.getInt(4130, 0));
                    break;
                }
                default: {
                    this.updateStatus(cmd);
                }
            }
        }

        private void updateStatus(Attributes cmd) {
            this.status = cmd.getInt(2304, -1);
            this.errorComment = cmd.getString(2306);
        }

        private void updateNumbers(int completed, int warning, int failed) {
            this.completed += completed;
            this.warning += warning;
            this.failed += failed;
        }
    }

    private static class KeysBuilder {
        private final Set<String> studies = new HashSet<String>();
        private final Map<String, Set<String>> series = new HashMap<String, Set<String>>();
        private final Map<String, Map<String, List<String>>> insts = new HashMap<String, Map<String, List<String>>>();

        KeysBuilder(Attributes ups) {
            Consumer<Attributes> retrieve = this.retrieveOf(UPSUtils.getScheduledProcessingCodeParameter((Attributes)ups, (Code)ScopeOfAccumulation.CODE));
            ups.getSequence(4210721).stream().forEach(retrieve);
        }

        private Consumer<Attributes> retrieveOf(Optional<Code> scopeOfAccumlation) {
            return scopeOfAccumlation.isPresent() ? (scopeOfAccumlation.get().equalsIgnoreMeaning(ScopeOfAccumulation.Study) ? this::retrieveStudies : (scopeOfAccumlation.get().equalsIgnoreMeaning(ScopeOfAccumulation.Series) ? this::retrieveSeries : this::retrieveInstances)) : this::retrieveInstances;
        }

        private void retrieveStudies(Attributes item) {
            String studyIUID = item.getString(0x20000D);
            this.studies.add(studyIUID);
        }

        private void retrieveSeries(Attributes item) {
            String studyIUID = item.getString(0x20000D);
            if (this.studies.contains(studyIUID)) {
                return;
            }
            String seriesIUID = item.getString(0x20000E);
            if (seriesIUID == null) {
                this.studies.add(studyIUID);
                this.series.remove(studyIUID);
            } else {
                Set<String> seriesOfStudy = this.series.get(studyIUID);
                if (seriesOfStudy == null) {
                    seriesOfStudy = new HashSet<String>();
                    this.series.put(studyIUID, seriesOfStudy);
                }
                seriesOfStudy.add(seriesIUID);
            }
        }

        private void retrieveInstances(Attributes item) {
            String studyIUID = item.getString(0x20000D);
            if (this.studies.contains(studyIUID)) {
                return;
            }
            String seriesIUID = item.getString(0x20000E);
            if (seriesIUID == null) {
                this.studies.add(studyIUID);
                this.series.remove(studyIUID);
                this.insts.remove(studyIUID);
            } else {
                Set<String> seriesOfStudy = this.series.get(studyIUID);
                if (seriesOfStudy != null && seriesOfStudy.contains(seriesIUID)) {
                    return;
                }
                Map<String, List<String>> instsOfStudy = this.insts.get(studyIUID);
                Sequence refSOPSeq = item.getSequence(528793);
                if (refSOPSeq == null || refSOPSeq.isEmpty()) {
                    if (seriesOfStudy == null) {
                        seriesOfStudy = new HashSet<String>();
                        this.series.put(studyIUID, seriesOfStudy);
                    }
                    seriesOfStudy.add(seriesIUID);
                    if (instsOfStudy != null) {
                        instsOfStudy.remove(seriesIUID);
                    }
                } else {
                    if (instsOfStudy == null) {
                        instsOfStudy = new HashMap<String, List<String>>();
                        this.insts.put(studyIUID, instsOfStudy);
                    }
                    List iuids = refSOPSeq.stream().map(sopRef -> sopRef.getString(528725)).collect(Collectors.toList());
                    instsOfStudy.put(seriesIUID, iuids);
                }
            }
        }

        List<Attributes> keys() {
            Stream<Attributes> studyRetrieveKeys = this.studies.stream().map(KeysBuilder::toStudyRetrieveKeys);
            Stream<Attributes> seriesRetrieveKeys = this.series.entrySet().stream().map(KeysBuilder::toSeriesRetrieveKeys);
            Stream instanceRetrieveKeys = this.insts.entrySet().stream().flatMap(KeysBuilder::toInstanceRetrieveKeys);
            return Stream.concat(Stream.concat(studyRetrieveKeys, seriesRetrieveKeys), instanceRetrieveKeys).collect(Collectors.toList());
        }

        private static Attributes toStudyRetrieveKeys(String studyInstanceUID) {
            Attributes attrs = new Attributes(2);
            attrs.setString(524370, VR.CS, "STUDY");
            attrs.setString(0x20000D, VR.UI, studyInstanceUID);
            return attrs;
        }

        private static Attributes toSeriesRetrieveKeys(Map.Entry<String, Set<String>> study) {
            Attributes attrs = new Attributes(3);
            attrs.setString(524370, VR.CS, "SERIES");
            attrs.setString(0x20000D, VR.UI, study.getKey());
            attrs.setString(0x20000E, VR.UI, study.getValue().toArray(StringUtils.EMPTY_STRING));
            return attrs;
        }

        private static Stream<Attributes> toInstanceRetrieveKeys(Map.Entry<String, Map<String, List<String>>> study) {
            return study.getValue().entrySet().stream().map(series -> KeysBuilder.toInstanceRetrieveKeys(study, series));
        }

        private static Attributes toInstanceRetrieveKeys(Map.Entry<String, Map<String, List<String>>> study, Map.Entry<String, List<String>> series) {
            Attributes attrs = new Attributes(4);
            attrs.setString(524312, VR.UI, series.getValue().toArray(StringUtils.EMPTY_STRING));
            attrs.setString(524370, VR.CS, "IMAGE");
            attrs.setString(0x20000D, VR.UI, study.getKey());
            attrs.setString(0x20000E, VR.UI, series.getKey());
            return attrs;
        }
    }
}

