/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage.emc.ecs;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Exception;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.GetObjectResult;
import com.emc.object.s3.jersey.S3JerseyClient;
import com.emc.object.s3.request.PutObjectRequest;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadLocalRandom;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.BinaryPrefix;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.metrics.MetricsService;
import org.dcm4chee.arc.storage.AbstractStorage;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.WriteContext;
import org.dcm4chee.arc.storage.emc.ecs.EMCECSWriteContext;
import org.dcm4chee.arc.storage.emc.ecs.S3Uploader;
import org.dcm4chee.arc.storage.emc.ecs.Uploader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMCECSStorage
extends AbstractStorage {
    public static final String PROPERTY_URL_CONNECTION_CLIENT_HANDLER = "emc-ecs-s3.URLConnectionClientHandler";
    private static final Logger LOG = LoggerFactory.getLogger(EMCECSStorage.class);
    private static final String DEFAULT_CONTAINER = "org.dcm4chee.arc";
    private static final Uploader STREAMING_UPLOADER = new Uploader(){

        @Override
        public void upload(S3Client s3, InputStream in, long length, String container, String storagePath) {
            PutObjectRequest payload = new PutObjectRequest(container, storagePath, (Object)this);
            if (length >= 0L) {
                payload.withObjectMetadata(new S3ObjectMetadata().withContentLength(Long.valueOf(length)));
            }
            s3.putObject(payload);
        }
    };
    private final Device device;
    private final String container;
    private final S3Client s3;
    private final boolean streamingUpload;
    private final long maxPartSize;
    private int count;

    public EMCECSStorage(StorageDescriptor descriptor, MetricsService metricsService, Device device) {
        super(descriptor, metricsService);
        this.device = device;
        this.container = descriptor.getProperty("container", DEFAULT_CONTAINER);
        if (Boolean.parseBoolean(descriptor.getProperty("containerExists", null))) {
            ++this.count;
        }
        String endpoint = descriptor.getStorageURI().getSchemeSpecificPart();
        S3Config config = new S3Config(URI.create(endpoint));
        String identity = descriptor.getProperty("identity", null);
        if (identity != null) {
            ((S3Config)config.withIdentity(identity)).withSecretKey(descriptor.getProperty("credential", null));
        }
        this.streamingUpload = Boolean.parseBoolean(descriptor.getProperty("streamingUpload", null));
        this.maxPartSize = BinaryPrefix.parse((String)descriptor.getProperty("maxPartSize", "5G"));
        this.s3 = new S3JerseyClient(config, (ClientHandler)(Boolean.parseBoolean(descriptor.getProperty(PROPERTY_URL_CONNECTION_CLIENT_HANDLER, null)) ? new URLConnectionClientHandler() : null));
    }

    protected Logger log() {
        return LOG;
    }

    public WriteContext createWriteContext(String storagePath) {
        EMCECSWriteContext writeContext = new EMCECSWriteContext((Storage)this);
        writeContext.setStoragePath(storagePath);
        return writeContext;
    }

    public boolean exists(ReadContext ctx) {
        return this.exists(ctx.getStoragePath());
    }

    public long getContentLength(ReadContext ctx) throws IOException {
        return this.getObjectMetadata(ctx.getStoragePath()).getContentLength();
    }

    public byte[] getContentMD5(ReadContext ctx) throws IOException {
        String contentMd5 = this.getObjectMetadata(ctx.getStoragePath()).getContentMd5();
        return contentMd5 != null ? TagUtils.fromHexString((String)contentMd5) : null;
    }

    protected OutputStream openOutputStreamA(WriteContext ctx) throws IOException {
        PipedInputStream in = new PipedInputStream();
        this.copy(in, ctx);
        return new PipedOutputStream(in);
    }

    protected void copyA(InputStream in, WriteContext ctx) throws IOException {
        this.upload(ctx, in);
    }

    protected void afterOutputStreamClosed(WriteContext ctx) throws IOException {
        FutureTask<Void> task = ((EMCECSWriteContext)ctx).getUploadTask();
        try {
            task.get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw new IOException("Upload failed", c);
        }
    }

    private void upload(WriteContext ctx, InputStream in) throws IOException {
        String storagePath = ctx.getStoragePath();
        if (this.count++ == 0 && !this.s3.bucketExists(this.container)) {
            this.s3.createBucket(this.container);
        } else {
            while (this.exists(storagePath)) {
                storagePath = storagePath.substring(0, storagePath.lastIndexOf(47) + 1).concat(String.format("%08X", ThreadLocalRandom.current().nextInt()));
                ctx.setStoragePath(storagePath);
            }
        }
        long length = ctx.getContentLength();
        Uploader uploader = this.streamingUpload || length >= 0L && length <= this.maxPartSize ? STREAMING_UPLOADER : new S3Uploader();
        uploader.upload(this.s3, in, length, this.container, storagePath);
    }

    private boolean exists(String storagePath) {
        try {
            return this.s3.getObjectMetadata(this.container, storagePath) != null;
        }
        catch (S3Exception s3Exception) {
            return false;
        }
    }

    private S3ObjectMetadata getObjectMetadata(String storagePath) throws IOException {
        try {
            S3ObjectMetadata metadata = this.s3.getObjectMetadata(this.container, storagePath);
            if (metadata == null) {
                throw this.objectNotFound(storagePath);
            }
            return metadata;
        }
        catch (S3Exception e) {
            throw this.failedToAccess(storagePath, e);
        }
    }

    protected InputStream openInputStreamA(ReadContext readContext) throws IOException {
        GetObjectResult s3Object = this.s3.getObject(this.container, readContext.getStoragePath());
        if (s3Object == null) {
            throw this.objectNotFound(readContext.getStoragePath());
        }
        return (InputStream)s3Object.getObject();
    }

    private IOException objectNotFound(String storagePath) {
        return new NoSuchFileException("No Object[" + storagePath + "] in Container[" + this.container + "] on " + this.getStorageDescriptor());
    }

    private IOException failedToAccess(String storagePath, S3Exception e) {
        return new IOException("Failed to access Object[" + storagePath + "] in Container[" + this.container + "] on " + this.getStorageDescriptor(), e);
    }

    protected void deleteObjectA(String storagePath) throws IOException {
        this.s3.deleteObject(this.container, storagePath);
    }

    public void close() throws IOException {
        this.s3.destroy();
    }
}

