/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.metrics.MetricsService;
import org.dcm4chee.arc.storage.DefaultReadContext;
import org.dcm4chee.arc.storage.DefaultWriteContext;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageException;
import org.dcm4chee.arc.storage.WriteContext;
import org.slf4j.Logger;

public abstract class AbstractStorage
implements Storage {
    protected static final String DEFAULT_PATH_FORMAT = "{now,date,yyyy/MM/dd}/{0020000D,hash}/{0020000E,hash}/{00080018,hash}";
    protected final StorageDescriptor descriptor;
    protected final MetricsService metricsService;
    private final AttributesFormat pathFormat;

    protected AbstractStorage(StorageDescriptor descriptor, MetricsService metricsService) {
        this.descriptor = descriptor;
        this.metricsService = metricsService;
        this.pathFormat = new AttributesFormat(descriptor.getProperty("pathFormat", DEFAULT_PATH_FORMAT));
    }

    @Override
    public StorageDescriptor getStorageDescriptor() {
        return this.descriptor;
    }

    @Override
    public WriteContext createWriteContext(String storagePath) {
        DefaultWriteContext writeContext = new DefaultWriteContext(this);
        writeContext.setStoragePath(storagePath);
        return writeContext;
    }

    @Override
    public WriteContext createWriteContext(Attributes attrs) {
        WriteContext writeContext = this.createWriteContext(this.storagePathOf(attrs));
        writeContext.setAttributes(attrs);
        return writeContext;
    }

    @Override
    public String storagePathOf(Attributes attrs) {
        return this.pathFormat.format((Object)attrs);
    }

    @Override
    public ReadContext createReadContext() {
        return new DefaultReadContext(this);
    }

    @Override
    public boolean isAccessable() {
        return true;
    }

    @Override
    public boolean exists(ReadContext ctx) {
        throw new UnsupportedOperationException("exists() not supported by " + this.getClass().getName());
    }

    @Override
    public long getContentLength(ReadContext ctx) throws IOException {
        return -1L;
    }

    @Override
    public byte[] getContentMD5(ReadContext ctx) throws IOException {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.descriptor.toString();
    }

    @Override
    public OutputStream openOutputStream(final WriteContext ctx) throws IOException {
        OutputStream stream;
        this.checkAccessable();
        long startTime0 = System.nanoTime();
        int retries = this.descriptor.getMaxRetries();
        Duration retryDelay = this.descriptor.getRetryDelay();
        while (true) {
            try {
                stream = this.openOutputStreamA(ctx);
            }
            catch (IOException e) {
                if (--retries < 0) {
                    throw e;
                }
                this.log().info("Failed to write to {} - retry:\n", (Object)this.descriptor, (Object)e);
                if (retryDelay != null) {
                    try {
                        Thread.sleep(retryDelay.getSeconds() * 1000L);
                    }
                    catch (InterruptedException ie) {
                        this.log().info("Delay of retry got interrupted:\n", (Throwable)ie);
                    }
                }
                startTime0 = System.nanoTime();
                continue;
            }
            break;
        }
        if (ctx.getMessageDigest() != null) {
            stream = new DigestOutputStream(stream, ctx.getMessageDigest());
        }
        final long startTime = startTime0;
        return new FilterOutputStream(new BufferedOutputStream(stream)){

            @Override
            public void write(int b) throws IOException {
                try {
                    this.out.write(b);
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
                ctx.incrementSize(1L);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    this.out.write(b, off, len);
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
                ctx.incrementSize(len);
            }

            @Override
            public void close() throws IOException {
                try {
                    AbstractStorage.this.beforeOutputStreamClosed(ctx, this);
                }
                finally {
                    try {
                        super.close();
                        AbstractStorage.this.metricsService.acceptDataRate("write-to-" + AbstractStorage.this.descriptor.getStorageID(), ctx.getSize(), startTime);
                    }
                    catch (IOException e) {
                        throw new StorageException(e);
                    }
                    finally {
                        AbstractStorage.this.afterOutputStreamClosed(ctx);
                    }
                }
            }
        };
    }

    @Override
    public void copy(InputStream in, WriteContext ctx) throws IOException {
        long startTime = System.nanoTime();
        this.copyA(in, ctx);
        this.metricsService.acceptDataRate("write-to-" + this.descriptor.getStorageID(), ctx.getContentLength(), startTime);
    }

    @Override
    public void deleteObject(String storagePath) throws IOException {
        this.checkAccessable();
        long startTime = System.nanoTime();
        this.deleteObjectA(storagePath);
        this.metricsService.acceptNanoTime("delete-from-" + this.descriptor.getStorageID(), startTime);
    }

    private void checkAccessable() throws IOException {
        if (!this.isAccessable()) {
            throw new IOException(this.descriptor + " not accessable");
        }
    }

    @Override
    public long getUsableSpace() throws IOException {
        return -1L;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return -1L;
    }

    protected abstract Logger log();

    protected abstract OutputStream openOutputStreamA(WriteContext var1) throws IOException;

    protected void copyA(InputStream in, WriteContext ctx) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected abstract void deleteObjectA(String var1) throws IOException;

    protected void beforeOutputStreamClosed(WriteContext ctx, OutputStream stream) throws IOException {
    }

    protected void afterOutputStreamClosed(WriteContext ctx) throws IOException {
    }

    @Override
    public void commitStorage(WriteContext ctx) throws IOException {
    }

    @Override
    public void revokeStorage(WriteContext ctx) throws IOException {
        if (!ctx.isDeletionLock()) {
            this.deleteObject(ctx.getStoragePath());
        }
    }

    @Override
    public InputStream openInputStream(final ReadContext ctx) throws IOException {
        InputStream stream;
        this.checkAccessable();
        final long startTime = System.nanoTime();
        InputStream inputStream = stream = ctx.getStorage().getStorageDescriptor().isTarArchiver() ? this.openTarEntryInputStreamA(ctx) : this.openInputStreamA(ctx);
        if (ctx.getMessageDigest() != null) {
            stream = new DigestInputStream(stream, ctx.getMessageDigest());
        }
        return new FilterInputStream(new BufferedInputStream(stream)){
            private long markSize;

            @Override
            public int read() throws IOException {
                int read = 0;
                try {
                    read = this.in.read();
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
                if (read >= 0) {
                    ctx.incrementSize(1L);
                }
                return read;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int read = 0;
                try {
                    read = this.in.read(b, off, len);
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
                if (read > 0) {
                    ctx.incrementSize(read);
                }
                return read;
            }

            @Override
            public long skip(long n) throws IOException {
                long skip = 0L;
                try {
                    skip = this.in.skip(n);
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
                ctx.incrementSize(skip);
                return skip;
            }

            @Override
            public synchronized void mark(int readlimit) {
                this.in.mark(readlimit);
                this.markSize = ctx.getSize();
            }

            @Override
            public synchronized void reset() throws IOException {
                this.in.reset();
                ctx.setSize(this.markSize);
            }

            @Override
            public void close() throws IOException {
                try {
                    AbstractStorage.this.beforeInputStreamClosed(ctx, this);
                }
                finally {
                    try {
                        super.close();
                        AbstractStorage.this.metricsService.acceptDataRate("read-from-" + AbstractStorage.this.descriptor.getStorageID(), ctx.getSize(), startTime);
                    }
                    catch (IOException e) {
                        throw new StorageException(e);
                    }
                    finally {
                        AbstractStorage.this.afterInputStreamClosed(ctx);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream openTarEntryInputStreamA(ReadContext ctx) throws IOException {
        String storagePath = ctx.getStoragePath();
        int tarPathEnd = storagePath.indexOf(33);
        if (tarPathEnd < 0) {
            return this.openInputStreamA(ctx);
        }
        ctx.setStoragePath(storagePath.substring(0, tarPathEnd));
        String entryName = storagePath.substring(tarPathEnd + 1);
        boolean entryFound = false;
        TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new BufferedInputStream(this.openInputStreamA(ctx)));
        try {
            TarArchiveEntry entry;
            while ((entry = tar.getNextTarEntry()) != null && !entry.getName().equals(entryName)) {
            }
            if (entry == null) {
                throw new NoSuchFileException("No entry: " + entryName + " in TAR: " + storagePath + " on " + this.getStorageDescriptor());
            }
            entryFound = true;
            TarArchiveInputStream tarArchiveInputStream = tar;
            return tarArchiveInputStream;
        }
        finally {
            if (!entryFound) {
                tar.close();
            }
        }
    }

    protected abstract InputStream openInputStreamA(ReadContext var1) throws IOException;

    protected void beforeInputStreamClosed(ReadContext ctx, InputStream stream) throws IOException {
    }

    protected void afterInputStreamClosed(ReadContext ctx) throws IOException {
    }
}

