/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.rs.client.impl;

import java.io.Serializable;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.keycloak.AccessTokenRequestor;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.rs.client.RSClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RSClientImpl
implements RSClient {
    private static final Logger LOG = LoggerFactory.getLogger(RSClientImpl.class);
    @Inject
    private TaskManager taskManager;
    @Inject
    private AccessTokenRequestor accessTokenRequestor;
    @Inject
    private IDeviceCache iDeviceCache;
    @Inject
    private IWebApplicationCache iWebAppCache;
    @Inject
    private Device device;

    @Override
    public void scheduleRequest(RSOperation rsOp, String requestURI, String requestQueryStr, String webAppName, String patientID, byte[] content, boolean tlsAllowAnyHostName, boolean tlsDisableTrustManager) {
        Task task = new Task();
        task.setDeviceName(this.device.getDeviceName());
        task.setQueueName("RSClient");
        task.setType(Task.Type.REST);
        task.setScheduledTime(new Date());
        task.setRSOperation(rsOp.name());
        task.setRequestURI(requestURI);
        task.setQueryString(requestQueryStr);
        task.setWebApplicationName(webAppName);
        task.setPatientID(patientID);
        task.setTLSAllowAnyHostname(tlsAllowAnyHostName);
        task.setTLSDisableTrustManager(tlsDisableTrustManager);
        task.setPayload((Serializable)content);
        task.setStatus(Task.Status.SCHEDULED);
        this.taskManager.scheduleTask(task);
    }

    @Override
    public Outcome request(String rsOp, String requestURI, String requestQueryString, String webAppName, String patientID, boolean tlsAllowAnyHostname, boolean tlsDisableTrustManager, byte[] content) throws Exception {
        WebApplication webApplication;
        RSOperation rsOperation = RSOperation.valueOf((String)rsOp);
        Task.Status status = Task.Status.WARNING;
        try {
            webApplication = this.iWebAppCache.findWebApplication(webAppName);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
            return new Outcome(status, "No such Web Application found: " + webAppName);
        }
        Object targetURI = this.targetURI(rsOperation, requestURI, webApplication, patientID);
        if (targetURI == null) {
            return new Outcome(status, "Target URL not available.");
        }
        if (((String)targetURI).equals(requestURI)) {
            return new Outcome(status, "Target URL same as Source Request URL!");
        }
        if (requestQueryString != null) {
            targetURI = (String)targetURI + "?" + requestQueryString;
        }
        Response response = this.toResponse(this.getMethod(rsOperation), (String)targetURI, tlsAllowAnyHostname, tlsDisableTrustManager, content, this.accessTokenFromWebApp(webApplication));
        Outcome outcome = this.buildOutcome(Response.Status.fromStatusCode((int)response.getStatus()), response.getStatusInfo());
        response.close();
        return outcome;
    }

    private String accessTokenFromWebApp(WebApplication webApp) throws Exception {
        if (webApp.getKeycloakClientID() == null) {
            return null;
        }
        return "Bearer " + this.accessTokenRequestor.getAccessToken2(webApp).getToken();
    }

    private String targetURI(RSOperation rsOp, String requestURI, WebApplication webApplication, String patientID) {
        String targetURI = null;
        try {
            if (webApplication.containsServiceClass(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)) {
                String serviceURL;
                targetURI = serviceURL + ((serviceURL = webApplication.getServiceURL().toString()).endsWith("rs/") ? "" : "/") + requestURI.substring(requestURI.indexOf("/rs/") + 4);
                if (rsOp == RSOperation.CreatePatient) {
                    targetURI = targetURI + patientID;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to construct Target URL. \n", (Throwable)e);
        }
        LOG.info("Target URL is {}", targetURI);
        return targetURI;
    }

    private Response toResponse(String method, String uri, boolean allowAnyHostname, boolean disableTrustManager, byte[] content, String authorization) throws Exception {
        ResteasyClient client = this.accessTokenRequestor.resteasyClientBuilder(uri, allowAnyHostname, disableTrustManager).build();
        ResteasyWebTarget target = client.target(uri);
        Invocation.Builder request = target.request();
        if (authorization != null) {
            request.header("Authorization", (Object)authorization);
        }
        LOG.info("Restful Service Forward : {} {}", (Object)method, (Object)uri);
        return method.equals("POST") ? (content != null ? request.post(Entity.json((Object)content)) : request.post(Entity.json((Object)""))) : (method.equals("PUT") ? request.put(Entity.json((Object)content)) : request.delete());
    }

    @Override
    public Response forward(HttpServletRequest request, String deviceName, String append) throws Exception {
        LOG.info("Forward {} {} from {}@{} to device {}", new Object[]{request.getMethod(), request.getRequestURI(), request.getRemoteUser(), request.getRemoteHost(), deviceName});
        String authorization = request.getHeader("Authorization");
        String targetURI = null;
        String requestURI = request.getRequestURI();
        Device device = this.iDeviceCache.findDevice(deviceName);
        for (WebApplication webApplication : device.getWebApplications()) {
            if (!webApplication.containsServiceClass(WebApplication.ServiceClass.DCM4CHEE_ARC)) continue;
            targetURI = webApplication.getServiceURL().toString() + requestURI.substring(requestURI.indexOf("/", requestURI.indexOf("/") + 1)) + "?" + request.getQueryString() + append;
        }
        return targetURI == null ? Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Either Web Application with Service Class 'DCM4CHEE_ARC' not configured for device: " + deviceName + " or HTTP connection not configured for WebApplication with Service Class 'DCM4CHEE_ARC' of this device.")).build() : this.toResponse("POST", targetURI, true, false, null, authorization);
    }

    private Outcome buildOutcome(Response.Status status, Response.StatusType st) {
        switch (status) {
            case OK: 
            case NO_CONTENT: {
                return new Outcome(Task.Status.COMPLETED, "Completed : " + st);
            }
            case REQUEST_TIMEOUT: 
            case SERVICE_UNAVAILABLE: 
            case NOT_FOUND: 
            case FORBIDDEN: 
            case BAD_REQUEST: 
            case UNAUTHORIZED: 
            case INTERNAL_SERVER_ERROR: {
                return new Outcome(Task.Status.FAILED, st.toString());
            }
        }
        return new Outcome(Task.Status.WARNING, "Http Response Status from other archive is : " + status.toString());
    }

    private String getMethod(RSOperation rsOp) {
        String method = null;
        switch (rsOp) {
            case CreatePatient: 
            case UpdatePatient: 
            case UpdateStudyExpirationDate: 
            case UpdateSeriesExpirationDate: 
            case UpdateStudyAccessControlID: 
            case ChangePatientID2: 
            case MergePatient2: 
            case UpdateStudy: 
            case UpdateStudyRequest: 
            case UpdateSeries: 
            case UpdateSeriesRequest: {
                method = "PUT";
                break;
            }
            case ChangePatientID: 
            case MergePatient: 
            case UnmergePatient: 
            case SupplementIssuer: 
            case UpdateCharset: 
            case ReimportStudy: 
            case RejectStudy: 
            case RejectSeries: 
            case RejectInstance: 
            case CreateMWL: 
            case UpdateMWL: 
            case ApplyRetentionPolicy: 
            case MoveStudyToPatient: {
                method = "POST";
                break;
            }
            case DeletePatient: 
            case DeleteStudy: 
            case DeleteMWL: {
                method = "DELETE";
            }
        }
        return method;
    }
}

