/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.mgt.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.entity.Task_;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.mgt.RetrieveBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class RetrieveManagerEJB {
    private static final Logger LOG = LoggerFactory.getLogger(RetrieveManagerEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    public int scheduleRetrieveTask(ExternalRetrieveContext ctx, Date notRetrievedAfter) {
        String[] studyUIDs;
        int count = 0;
        Attributes keys = ctx.getKeys();
        for (String studyUID : studyUIDs = keys.getStrings(0x20000D)) {
            keys.setString(0x20000D, VR.UI, studyUID);
            if (!this.scheduleRetrieveTask(ctx, notRetrievedAfter, keys)) continue;
            ++count;
        }
        return count;
    }

    private boolean scheduleRetrieveTask(ExternalRetrieveContext ctx, Date notRetrievedAfter, Attributes keys) {
        String studyUID = keys.getString(0x20000D);
        if (this.isAlreadyScheduledOrRetrievedAfter(ctx, notRetrievedAfter, studyUID)) {
            return false;
        }
        Task task = new Task();
        task.setDeviceName(ctx.getDeviceName());
        task.setQueueName(ctx.getQueueName());
        task.setType(Task.Type.RETRIEVE);
        task.setFindSCP(ctx.getFindSCP());
        task.setPayload((Serializable)ctx.getKeys());
        task.setStatus(Task.Status.SCHEDULED);
        task.setBatchID(ctx.getBatchID());
        task.setLocalAET(ctx.getLocalAET());
        task.setRemoteAET(ctx.getRemoteAET());
        task.setDestinationAET(ctx.getDestinationAET());
        task.setStudyInstanceUID(ctx.getStudyInstanceUID());
        task.setSeriesInstanceUID(ctx.getSeriesInstanceUID());
        task.setSOPInstanceUID(ctx.getSOPInstanceUID());
        task.setScheduledTime(ctx.getScheduledTime());
        if (ctx.getHttpServletRequestInfo() != null) {
            task.setRequesterUserID(ctx.getHttpServletRequestInfo().requesterUserID);
            task.setRequesterHost(ctx.getHttpServletRequestInfo().requesterHost);
            task.setRequestURI(this.requestURL(ctx.getHttpServletRequestInfo()));
        }
        this.em.persist((Object)task);
        LOG.info("Create {}", (Object)task);
        ctx.setRetrieveTask(task);
        return true;
    }

    private String requestURL(HttpServletRequestInfo httpServletRequestInfo) {
        String requestURI = httpServletRequestInfo.requestURI;
        String queryString = httpServletRequestInfo.queryString;
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    private boolean isAlreadyScheduledOrRetrievedAfter(ExternalRetrieveContext ctx, Date retrievedAfter, String studyUID) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Task.class);
        Root task = q.from(Task.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(cb.equal((Expression)task.get(Task_.type), (Object)Task.Type.RETRIEVE));
        Predicate statusPredicate = task.get(Task_.status).in(new Object[]{Task.Status.SCHEDULED, Task.Status.IN_PROCESS});
        predicates.add(retrievedAfter != null ? cb.or((Expression)statusPredicate, (Expression)cb.greaterThan((Expression)task.get(Task_.updatedTime), (Comparable)retrievedAfter)) : statusPredicate);
        predicates.add(cb.equal((Expression)task.get(Task_.remoteAET), (Object)ctx.getRemoteAET()));
        predicates.add(cb.equal((Expression)task.get(Task_.destinationAET), (Object)ctx.getDestinationAET()));
        predicates.add(cb.equal((Expression)task.get(Task_.studyInstanceUID), (Object)studyUID));
        if (ctx.getSeriesInstanceUID() != null) {
            predicates.add(cb.equal((Expression)task.get(Task_.seriesInstanceUID), (Object)ctx.getSeriesInstanceUID()));
        } else {
            predicates.add(cb.or((Expression)task.get(Task_.seriesInstanceUID).isNull(), (Expression)cb.equal((Expression)task.get(Task_.seriesInstanceUID), (Object)ctx.getSeriesInstanceUID())));
            if (ctx.getSOPInstanceUID() == null) {
                predicates.add(task.get(Task_.sopInstanceUID).isNull());
            } else {
                predicates.add(cb.or((Expression)task.get(Task_.sopInstanceUID).isNull(), (Expression)cb.equal((Expression)task.get(Task_.sopInstanceUID), (Object)ctx.getSOPInstanceUID())));
            }
        }
        try (Stream resultStream = this.em.createQuery(q.where(predicates.toArray(new Predicate[0])).select((Selection)task)).getResultStream();){
            Iterator iterator = resultStream.iterator();
            if (iterator.hasNext()) {
                iterator.forEachRemaining(retrieveTask1 -> {
                    if (ctx.getScheduledTime().before(retrieveTask1.getScheduledTime())) {
                        LOG.info("Previous {} found - Update scheduled time to {}", retrieveTask1, (Object)ctx.getScheduledTime());
                        retrieveTask1.setScheduledTime(ctx.getScheduledTime());
                    } else {
                        LOG.info("Previous {} found - suppress duplicate retrieve", retrieveTask1);
                    }
                    ctx.setRetrieveTask(retrieveTask1);
                });
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void updateRetrieveTask(Task task, Attributes cmd) {
        this.em.createNamedQuery("Task.UpdateRetrieveResultByPk").setParameter(1, (Object)task.getPk()).setParameter(2, (Object)cmd.getInt(4128, 0)).setParameter(3, (Object)cmd.getInt(4129, 0)).setParameter(4, (Object)cmd.getInt(4130, 0)).setParameter(5, (Object)cmd.getInt(4131, 0)).setParameter(6, (Object)cmd.getInt(2304, 0)).setParameter(7, (Object)cmd.getString(2306, null)).executeUpdate();
    }

    public void resetRetrieveTask(Task task) {
        this.em.createNamedQuery("Task.UpdateRetrieveResultByPk").setParameter(1, (Object)task.getPk()).setParameter(2, (Object)-1).setParameter(3, (Object)0).setParameter(4, (Object)0).setParameter(5, (Object)0).setParameter(6, (Object)-1).setParameter(7, null).executeUpdate();
    }

    public List<RetrieveBatch> listRetrieveBatches(TaskQueryParam queryParam, int offset, int limit) {
        ListRetrieveBatches listRetrieveBatches1 = new ListRetrieveBatches(queryParam);
        TypedQuery query = this.em.createQuery(listRetrieveBatches1.query);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultStream().map(listRetrieveBatches1::toRetrieveBatch).collect(Collectors.toList());
    }

    private class ListRetrieveBatches {
        final CriteriaBuilder cb;
        final QueryBuilder queryBuilder;
        final CriteriaQuery<Tuple> query;
        final Root<Task> task;
        final Path<String> batchIDPath;
        Expression<Date> minProcessingStartTime;
        Expression<Date> maxProcessingStartTime;
        Expression<Date> minProcessingEndTime;
        Expression<Date> maxProcessingEndTime;
        final Expression<Date> minScheduledTime;
        final Expression<Date> maxScheduledTime;
        final Expression<Date> minCreatedTime;
        final Expression<Date> maxCreatedTime;
        final Expression<Date> minUpdatedTime;
        final Expression<Date> maxUpdatedTime;
        final Expression<Long> completed;
        final Expression<Long> failed;
        final Expression<Long> warning;
        final Expression<Long> canceled;
        final Expression<Long> scheduled;
        final Expression<Long> inprocess;
        final TaskQueryParam queryParam;

        ListRetrieveBatches(TaskQueryParam queryParam) {
            this.cb = RetrieveManagerEJB.this.em.getCriteriaBuilder();
            this.queryBuilder = new QueryBuilder(this.cb);
            this.query = this.cb.createTupleQuery();
            this.task = this.query.from(Task.class);
            this.batchIDPath = this.task.get(Task_.batchID);
            this.minScheduledTime = this.cb.least((Expression)this.task.get(Task_.scheduledTime));
            this.maxScheduledTime = this.cb.greatest((Expression)this.task.get(Task_.scheduledTime));
            this.minCreatedTime = this.cb.least((Expression)this.task.get(Task_.createdTime));
            this.maxCreatedTime = this.cb.greatest((Expression)this.task.get(Task_.createdTime));
            this.minUpdatedTime = this.cb.least((Expression)this.task.get(Task_.updatedTime));
            this.maxUpdatedTime = this.cb.greatest((Expression)this.task.get(Task_.updatedTime));
            this.queryParam = queryParam;
            this.minProcessingStartTime = this.cb.least((Expression)this.task.get(Task_.processingStartTime));
            this.maxProcessingStartTime = this.cb.greatest((Expression)this.task.get(Task_.processingStartTime));
            this.minProcessingEndTime = this.cb.least((Expression)this.task.get(Task_.processingEndTime));
            this.maxProcessingEndTime = this.cb.greatest((Expression)this.task.get(Task_.processingEndTime));
            this.completed = this.statusSubquery(Task.Status.COMPLETED).getSelection();
            this.failed = this.statusSubquery(Task.Status.FAILED).getSelection();
            this.warning = this.statusSubquery(Task.Status.WARNING).getSelection();
            this.canceled = this.statusSubquery(Task.Status.CANCELED).getSelection();
            this.scheduled = this.statusSubquery(Task.Status.SCHEDULED).getSelection();
            this.inprocess = this.statusSubquery(Task.Status.IN_PROCESS).getSelection();
            this.query.multiselect(new Selection[]{this.batchIDPath, this.minProcessingStartTime, this.maxProcessingStartTime, this.minProcessingEndTime, this.maxProcessingEndTime, this.minScheduledTime, this.maxScheduledTime, this.minCreatedTime, this.maxCreatedTime, this.minUpdatedTime, this.maxUpdatedTime, this.completed, this.failed, this.warning, this.canceled, this.scheduled, this.inprocess});
            this.query.groupBy(new Expression[]{this.task.get(Task_.batchID)});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)this.task.get(Task_.type), (Object)queryParam.getType()));
            if (queryParam.getBatchID() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.batchID), (Object)queryParam.getBatchID()));
            } else {
                predicates.add(this.task.get(Task_.batchID).isNotNull());
            }
            if (queryParam.getStatus() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.status), (Object)queryParam.getStatus()));
            }
            this.queryBuilder.matchRetrieveBatch(predicates, queryParam, this.task);
            if (!predicates.isEmpty()) {
                this.query.where(predicates.toArray(new Predicate[0]));
            }
            if (queryParam.getOrderBy() != null) {
                this.query.orderBy(new Order[]{this.queryBuilder.orderBatches(this.task, queryParam.getOrderBy())});
            }
        }

        private Subquery<Long> statusSubquery(Task.Status status) {
            CriteriaQuery query = this.cb.createQuery(Task.class);
            Subquery sq = query.subquery(Long.class);
            Root sqtask = sq.from(Task.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.status), (Object)status));
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.batchID), (Expression)this.task.get(Task_.batchID)));
            this.queryBuilder.matchRetrieveBatch(predicates, this.queryParam, (Path)sqtask);
            sq.where(predicates.toArray(new Predicate[0]));
            sq.select(this.cb.count((Expression)sqtask));
            return sq;
        }

        RetrieveBatch toRetrieveBatch(Tuple tuple) {
            String batchID = (String)tuple.get(this.batchIDPath);
            RetrieveBatch retrieveBatch = new RetrieveBatch(batchID);
            retrieveBatch.setScheduledTimeRange((Date)tuple.get(this.minScheduledTime), (Date)tuple.get(this.maxScheduledTime));
            retrieveBatch.setCreatedTimeRange((Date)tuple.get(this.minCreatedTime), (Date)tuple.get(this.maxCreatedTime));
            retrieveBatch.setUpdatedTimeRange((Date)tuple.get(this.minUpdatedTime), (Date)tuple.get(this.maxUpdatedTime));
            retrieveBatch.setProcessingStartTimeRange((Date)tuple.get(this.minProcessingStartTime), (Date)tuple.get(this.maxProcessingStartTime));
            retrieveBatch.setProcessingEndTimeRange((Date)tuple.get(this.minProcessingEndTime), (Date)tuple.get(this.maxProcessingEndTime));
            CriteriaQuery distinct = this.cb.createQuery(String.class).distinct(true);
            Root retrieveTask = distinct.from(Task.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)retrieveTask.get(Task_.batchID), (Object)batchID));
            this.queryBuilder.matchRetrieveBatch(predicates, this.queryParam, (Path)retrieveTask);
            distinct.where(predicates.toArray(new Predicate[0]));
            retrieveBatch.setDeviceNames(this.select((CriteriaQuery<String>)distinct, (Path<String>)retrieveTask.get(Task_.deviceName)));
            retrieveBatch.setQueueNames(this.select((CriteriaQuery<String>)distinct, (Path<String>)retrieveTask.get(Task_.queueName)));
            retrieveBatch.setLocalAETs(this.select((CriteriaQuery<String>)distinct, (Path<String>)retrieveTask.get(Task_.localAET)));
            retrieveBatch.setRemoteAETs(this.select((CriteriaQuery<String>)distinct, (Path<String>)retrieveTask.get(Task_.remoteAET)));
            retrieveBatch.setDestinationAETs(this.select((CriteriaQuery<String>)distinct, (Path<String>)retrieveTask.get(Task_.destinationAET)));
            retrieveBatch.setCompleted((Long)tuple.get(this.completed));
            retrieveBatch.setCanceled((Long)tuple.get(this.canceled));
            retrieveBatch.setWarning((Long)tuple.get(this.warning));
            retrieveBatch.setFailed((Long)tuple.get(this.failed));
            retrieveBatch.setScheduled((Long)tuple.get(this.scheduled));
            retrieveBatch.setInProcess((Long)tuple.get(this.inprocess));
            return retrieveBatch;
        }

        private List<String> select(CriteriaQuery<String> query, Path<String> path) {
            return RetrieveManagerEJB.this.em.createQuery(query.select(path)).getResultList();
        }
    }
}

