/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.impl;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.retrieve.SeriesInfo;
import org.dcm4chee.arc.retrieve.StudyInfo;
import org.dcm4chee.arc.retrieve.impl.SeriesInfoImpl;
import org.dcm4chee.arc.retrieve.impl.StudyInfoImpl;

class SeriesAttributes {
    final Attributes attrs;
    final StudyInfo studyInfo;
    final SeriesInfo seriesInfo;
    final Date patientUpdatedTime;

    SeriesAttributes(EntityManager em, CriteriaBuilder cb, Long seriesPk) {
        CriteriaQuery q = cb.createTupleQuery();
        Root series = q.from(Series.class);
        Join study = series.join(Series_.study);
        Join patient = study.join(Study_.patient);
        Path patientAttrBlob = patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        Path studyAttrBlob = study.join(Study_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        Path seriesAttrBlob = series.join(Series_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        Tuple tuple = (Tuple)em.createQuery(q.where((Expression)cb.equal((Expression)series.get(Series_.pk), (Object)seriesPk)).multiselect(new Selection[]{patient.get(Patient_.updatedTime), study.get(Study_.pk), study.get(Study_.studyInstanceUID), study.get(Study_.accessTime), study.get(Study_.failedRetrieves), study.get(Study_.completeness), study.get(Study_.modifiedTime), study.get(Study_.expirationDate), study.get(Study_.accessControlID), study.get(Study_.size), series.get(Series_.seriesInstanceUID), series.get(Series_.failedRetrieves), series.get(Series_.completeness), series.get(Series_.modifiedTime), series.get(Series_.expirationDate), series.get(Series_.sendingAET), series.get(Series_.receivingAET), series.get(Series_.sendingPresentationAddress), series.get(Series_.receivingPresentationAddress), series.get(Series_.size), series.get(Series_.pk), patientAttrBlob, studyAttrBlob, seriesAttrBlob})).getSingleResult();
        this.studyInfo = new StudyInfoImpl((Long)tuple.get((TupleElement)study.get(Study_.pk)), (String)tuple.get((TupleElement)study.get(Study_.studyInstanceUID)), (Date)tuple.get((TupleElement)study.get(Study_.accessTime)), (Integer)tuple.get((TupleElement)study.get(Study_.failedRetrieves)), (Completeness)tuple.get((TupleElement)study.get(Study_.completeness)), (Date)tuple.get((TupleElement)study.get(Study_.modifiedTime)), (String)tuple.get((TupleElement)study.get(Study_.expirationDate)), (String)tuple.get((TupleElement)study.get(Study_.accessControlID)), (Long)tuple.get((TupleElement)study.get(Study_.size)));
        this.seriesInfo = new SeriesInfoImpl(this.studyInfo.getStudyInstanceUID(), (String)tuple.get((TupleElement)series.get(Series_.seriesInstanceUID)), (Integer)tuple.get((TupleElement)series.get(Series_.failedRetrieves)), (Completeness)tuple.get((TupleElement)series.get(Series_.completeness)), (Date)tuple.get((TupleElement)series.get(Series_.modifiedTime)), (String)tuple.get((TupleElement)series.get(Series_.expirationDate)), (String)tuple.get((TupleElement)series.get(Series_.sendingAET)), (String)tuple.get((TupleElement)series.get(Series_.receivingAET)), (String)tuple.get((TupleElement)series.get(Series_.sendingPresentationAddress)), (String)tuple.get((TupleElement)series.get(Series_.receivingPresentationAddress)), (Long)tuple.get((TupleElement)series.get(Series_.size)), (Long)tuple.get((TupleElement)series.get(Series_.pk)));
        this.patientUpdatedTime = (Date)tuple.get((TupleElement)patient.get(Patient_.updatedTime));
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])tuple.get((TupleElement)patientAttrBlob)), null);
        Attributes studyAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])tuple.get((TupleElement)studyAttrBlob)), null);
        Attributes seriesAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])tuple.get((TupleElement)seriesAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, studyAttrs, seriesAttrs});
        this.attrs = new Attributes(patAttrs.size() + studyAttrs.size() + seriesAttrs.size() + 5);
        this.attrs.addAll(patAttrs);
        this.attrs.addAll(studyAttrs, true);
        this.attrs.addAll(seriesAttrs, true);
    }
}

