/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.MergeAttributesCoercion;
import org.dcm4che3.data.NullifyAttributesCoercion;
import org.dcm4che3.data.RemapUIDsAttributesCoercion;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.deident.DeIdentificationAttributesCoercion;
import org.dcm4che3.deident.DeIdentifier;
import org.dcm4che3.imageio.codec.Transcoder;
import org.dcm4che3.io.BulkDataCreator;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.io.XSLTAttributesCoercion;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.NoPresentationContextException;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.LeadingCFindSCPQueryCache;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.coerce.CoercionFactory;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Metadata_;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.entity.UIDMap;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.metrics.MetricsService;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.scu.CFindSCUAttributeCoercion;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.retrieve.LocationInputStream;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveFailures;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.retrieve.SeriesInfo;
import org.dcm4chee.arc.retrieve.StudyInfo;
import org.dcm4chee.arc.retrieve.impl.InstanceLocationsImpl;
import org.dcm4chee.arc.retrieve.impl.LocationQuery;
import org.dcm4chee.arc.retrieve.impl.RetrieveContextImpl;
import org.dcm4chee.arc.retrieve.impl.RetrieveServiceEJB;
import org.dcm4chee.arc.retrieve.impl.SeriesAttributes;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.store.UpdateLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RetrieveServiceImpl
implements RetrieveService {
    private static Logger LOG = LoggerFactory.getLogger(RetrieveServiceImpl.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private StorageFactory storageFactory;
    @Inject
    private StoreService storeService;
    @Inject
    private MetricsService metricsService;
    @Inject
    private Device device;
    @Inject
    private CodeCache codeCache;
    @Inject
    private RetrieveServiceEJB ejb;
    @Inject
    private CFindSCU cfindscu;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private IWebApplicationCache webAppCache;
    @Inject
    private LeadingCFindSCPQueryCache leadingCFindSCPQueryCache;
    @Inject
    private CoercionFactory coercionFactory;
    @Inject
    @RetrieveFailures
    private Event<RetrieveContext> retrieveFailures;

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    @Override
    public RetrieveContext newRetrieveContextGET(ArchiveAEExtension arcAE, Association as, Attributes rqCmd, QueryRetrieveLevel2 qrLevel, Attributes keys) {
        RetrieveContext ctx = this.newRetrieveContext(arcAE, as, qrLevel, keys);
        ctx.setPriority(rqCmd.getInt(1792, 0));
        ctx.setDestinationAETitle(as.getRemoteAET());
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextMOVE(ArchiveAEExtension arcAE, Association as, Attributes rqCmd, QueryRetrieveLevel2 qrLevel, Attributes keys) throws ConfigurationException {
        RetrieveContext ctx = this.newRetrieveContext(arcAE, as, qrLevel, keys);
        ctx.setPriority(rqCmd.getInt(1792, 0));
        ctx.setDestinationAETitle(rqCmd.getString(1536));
        ctx.setMoveOriginatorMessageID(rqCmd.getInt(272, 0));
        ctx.setMoveOriginatorAETitle(as.getRemoteAET());
        ctx.setDestinationAE(this.aeCache.findApplicationEntity(ctx.getDestinationAETitle()));
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextWADO(HttpServletRequestInfo httpServletRequestInfo, String localAET, String studyUID, String seriesUID, String objectUID) {
        RetrieveContext ctx = this.newRetrieveContext(localAET, studyUID, seriesUID, objectUID);
        ctx.setHttpServletRequestInfo(httpServletRequestInfo);
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextSTORE(String localAET, String studyUID, String seriesUID, String objectUID, String destAET) throws ConfigurationException {
        RetrieveContext ctx = this.newRetrieveContext(localAET, studyUID, seriesUID, objectUID);
        ctx.setDestinationAETitle(destAET);
        ctx.setDestinationAE(this.aeCache.findApplicationEntity(destAET));
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextSTOW(String localAET, String studyUID, String seriesUID, String objectUID, String destWebApp) throws ConfigurationException {
        RetrieveContext ctx = this.newRetrieveContext(localAET, studyUID, seriesUID, objectUID);
        ctx.setDestinationWebApp(this.webAppCache.findWebApplication(destWebApp));
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextSTORE(String localAET, String studyUID, String seriesUID, Sequence refSopSeq, String destAET) throws ConfigurationException {
        if (refSopSeq == null || refSopSeq.isEmpty()) {
            return this.newRetrieveContextSTORE(localAET, studyUID, seriesUID, (String)null, destAET);
        }
        RetrieveContext ctx = this.newRetrieveContext(localAET, refSopSeq);
        ctx.setStudyInstanceUIDs(studyUID);
        ctx.setSeriesInstanceUIDs(seriesUID);
        ctx.setDestinationAETitle(destAET);
        ctx.setDestinationAE(this.aeCache.findApplicationEntity(destAET));
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextIOCM(HttpServletRequestInfo request, String localAET, String studyUID, String ... seriesUIDs) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)this.device.getApplicationEntity(localAET, true).getAEExtension(ArchiveAEExtension.class);
        RetrieveContextImpl ctx = new RetrieveContextImpl(this, arcAE, localAET, null);
        ctx.setHttpServletRequestInfo(request);
        ctx.setStudyInstanceUIDs(studyUID);
        ctx.setSeriesInstanceUIDs(seriesUIDs);
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextXDSI(HttpServletRequest request, String localAET, String[] studyUIDs, String[] seriesUIDs, String[] objectUIDs) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)this.device.getApplicationEntity(localAET, true).getAEExtension(ArchiveAEExtension.class);
        RetrieveContextImpl ctx = new RetrieveContextImpl(this, arcAE, localAET, arcAE.getQueryRetrieveView());
        ctx.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)request));
        ctx.setStudyInstanceUIDs(studyUIDs);
        if (studyUIDs.length == 1) {
            ctx.setSeriesInstanceUIDs(seriesUIDs);
            if (seriesUIDs.length == 1) {
                ctx.setSopInstanceUIDs(objectUIDs);
            }
        }
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContext(String localAET, String studyUID, String seriesUID, String objectUID) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)this.device.getApplicationEntity(localAET, true).getAEExtension(ArchiveAEExtension.class);
        RetrieveContextImpl ctx = new RetrieveContextImpl(this, arcAE, localAET, arcAE.getQueryRetrieveView());
        if (studyUID != null) {
            ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.STUDY);
            ctx.setStudyInstanceUIDs(studyUID);
        }
        if (seriesUID != null) {
            ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.SERIES);
            ctx.setSeriesInstanceUIDs(seriesUID);
        }
        if (objectUID != null) {
            ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.IMAGE);
            ctx.setSopInstanceUIDs(objectUID);
        }
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContext(String localAET, Sequence refSopSeq) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)this.device.getApplicationEntity(localAET, true).getAEExtension(ArchiveAEExtension.class);
        RetrieveContextImpl ctx = new RetrieveContextImpl(this, arcAE, localAET, arcAE.getQueryRetrieveView());
        ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.IMAGE);
        String[] uids = (String[])refSopSeq.stream().map(refSop -> refSop.getString(528725)).toArray(String[]::new);
        ctx.setSopInstanceUIDs(uids);
        return ctx;
    }

    private RetrieveContext newRetrieveContext(ArchiveAEExtension arcAE, Association as, QueryRetrieveLevel2 qrLevel, Attributes keys) {
        RetrieveContextImpl ctx = new RetrieveContextImpl(this, arcAE, as.getLocalAET(), arcAE.getQueryRetrieveView());
        ctx.setRequestAssociation(as);
        ctx.setQueryRetrieveLevel(qrLevel);
        IDWithIssuer pid = IDWithIssuer.pidOf((Attributes)keys);
        if (pid != null) {
            ctx.setPatientIDs(pid);
        }
        switch (qrLevel) {
            case IMAGE: {
                ctx.setSopInstanceUIDs(keys.getStrings(524312));
            }
            case SERIES: {
                ctx.setSeriesInstanceUIDs(keys.getStrings(0x20000E));
            }
            case STUDY: {
                ctx.setStudyInstanceUIDs(keys.getStrings(0x20000D));
            }
        }
        return ctx;
    }

    @Override
    public RetrieveContext newRetrieveContextSeriesMetadata(Series.MetadataUpdate metadataUpdate) {
        RetrieveContextImpl ctx = new RetrieveContextImpl(this, null, null, null);
        ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.SERIES);
        ctx.setSeriesMetadataUpdate(metadataUpdate);
        ctx.setObjectType(null);
        return ctx;
    }

    @Override
    public Date getLastModified(RetrieveContext ctx, boolean ignorePatientUpdates) {
        List<Object[]> dates = this.queryLastModified(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUIDs());
        int first = ignorePatientUpdates ? 1 : 0;
        Date lastModified = null;
        for (Object[] objs : dates) {
            for (int i = first; i < objs.length; ++i) {
                Date date = (Date)objs[i];
                if (lastModified != null && lastModified.compareTo(date) >= 0) continue;
                lastModified = date;
            }
        }
        return lastModified;
    }

    @Override
    public Date getLastModifiedFromMatches(RetrieveContext ctx, boolean ignorePatientUpdates) {
        Date lastModified = ctx.getStudyInfos().iterator().next().getModifiedTime();
        if (!ignorePatientUpdates && lastModified.compareTo(ctx.getPatientUpdatedTime()) < 0) {
            lastModified = ctx.getPatientUpdatedTime();
        }
        for (SeriesInfo si : ctx.getSeriesInfos()) {
            if (lastModified.compareTo(si.getModifiedTime()) >= 0) continue;
            lastModified = si.getModifiedTime();
        }
        for (InstanceLocations il : ctx.getMatches()) {
            if (il.getUpdatedTime() == null || lastModified.compareTo(il.getUpdatedTime()) >= 0) continue;
            lastModified = il.getUpdatedTime();
        }
        return lastModified;
    }

    private List<Object[]> queryLastModified(String studyIUID, String seriesIUID, String[] sopIUIDs) {
        boolean purgeInstanceRecords = this.getArchiveDeviceExtension().isPurgeInstanceRecords();
        List resultList = (sopIUIDs.length > 0 ? this.em.createNamedQuery("Instance.findLastModifiedInstanceLevel", Object[].class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)seriesIUID).setParameter(3, (Object)sopIUIDs[0]) : (seriesIUID != null ? this.em.createNamedQuery("Instance.findLastModifiedSeriesLevel", Object[].class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)seriesIUID) : this.em.createNamedQuery("Instance.findLastModifiedStudyLevel", Object[].class).setParameter(1, (Object)studyIUID))).getResultList();
        if (purgeInstanceRecords) {
            resultList.addAll((seriesIUID != null ? this.em.createNamedQuery("Series.findLastModifiedSeriesLevel", Object[].class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)seriesIUID).setParameter(3, (Object)Series.InstancePurgeState.PURGED) : this.em.createNamedQuery("Series.findLastModifiedStudyLevel", Object[].class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)Series.InstancePurgeState.PURGED)).getResultList());
        }
        return resultList;
    }

    @Override
    public boolean calculateMatches(RetrieveContext ctx) throws DicomServiceException {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        List<InstanceLocations> matches = ctx.getMatches();
        matches.clear();
        try {
            HashMap<Long, StudyInfo> studyInfoMap = new HashMap<Long, StudyInfo>();
            Series.MetadataUpdate metadataUpdate = ctx.getSeriesMetadataUpdate();
            if (metadataUpdate != null && metadataUpdate.instancePurgeState == Series.InstancePurgeState.PURGED) {
                SeriesAttributes seriesAttributes = new SeriesAttributes(this.em, cb, metadataUpdate.seriesPk);
                studyInfoMap.put(seriesAttributes.studyInfo.getStudyPk(), seriesAttributes.studyInfo);
                ctx.getSeriesInfos().add(seriesAttributes.seriesInfo);
                this.addLocationsFromMetadata(ctx, metadataUpdate.storageID, metadataUpdate.storagePath, seriesAttributes.attrs);
            } else {
                new LocationQuery(this.em, cb, ctx, this.codeCache).execute(studyInfoMap);
                if (ctx.isConsiderPurgedInstances()) {
                    this.queryLocationsFromMetadata(ctx, cb, studyInfoMap);
                }
            }
            ctx.setNumberOfMatches(matches.size());
            ctx.getStudyInfos().addAll(studyInfoMap.values());
            this.updateStudyAccessTime(ctx);
            return !matches.isEmpty();
        }
        catch (IOException e) {
            throw new DicomServiceException(42753, (Throwable)e);
        }
    }

    private void queryLocationsFromMetadata(RetrieveContext ctx, CriteriaBuilder cb, Map<Long, StudyInfo> studyInfoMap) throws IOException {
        CriteriaQuery q = cb.createTupleQuery();
        Root series = q.from(Series.class);
        Join study = series.join(Series_.study);
        Join metadata = series.join(Series_.metadata, JoinType.LEFT);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        QueryBuilder builder = new QueryBuilder(cb);
        if (!QueryBuilder.isUniversalMatching((IDWithIssuer[])ctx.getPatientIDs())) {
            builder.patientIDPredicate(predicates, (From)study.join(Study_.patient), ctx.getPatientIDs());
        }
        QueryBuilder.accessControl(predicates, (Path)study, (String[])ctx.getAccessControlIDs());
        builder.uidsPredicate(predicates, study.get(Study_.studyInstanceUID), ctx.getStudyInstanceUIDs());
        builder.uidsPredicate(predicates, series.get(Series_.seriesInstanceUID), ctx.getSeriesInstanceUIDs());
        predicates.add(cb.equal((Expression)series.get(Series_.instancePurgeState), (Object)Series.InstancePurgeState.PURGED));
        q.multiselect(new Selection[]{series.get(Series_.pk), metadata.get(Metadata_.storageID), metadata.get(Metadata_.storagePath)});
        q.where(predicates.toArray(new Predicate[0]));
        for (Tuple tuple : this.em.createQuery(q).getResultList()) {
            Long seriesPk = (Long)tuple.get((TupleElement)series.get(Series_.pk));
            SeriesAttributes seriesAttributes = new SeriesAttributes(this.em, cb, seriesPk);
            studyInfoMap.put(seriesAttributes.studyInfo.getStudyPk(), seriesAttributes.studyInfo);
            ctx.getSeriesInfos().add(seriesAttributes.seriesInfo);
            ctx.setPatientUpdatedTime(seriesAttributes.patientUpdatedTime);
            this.addLocationsFromMetadata(ctx, (String)tuple.get((TupleElement)metadata.get(Metadata_.storageID)), (String)tuple.get((TupleElement)metadata.get(Metadata_.storagePath)), seriesAttributes.attrs);
        }
    }

    @Override
    public Collection<InstanceLocations> queryInstances(StoreSession session, Attributes instanceRefs, String targetStudyIUID) throws IOException {
        RetrieveContext ctx;
        Map uidMap = session.getUIDMap();
        String sourceStudyUID = instanceRefs.getString(0x20000D);
        uidMap.put(sourceStudyUID, targetStudyIUID);
        Sequence refSeriesSeq = instanceRefs.getSequence(528661);
        HashMap<String, Set<String>> refIUIDsBySeriesIUID = new HashMap<String, Set<String>>();
        if (refSeriesSeq == null) {
            ctx = this.newRetrieveContextIOCM(session.getHttpRequest(), session.getCalledAET(), sourceStudyUID, new String[0]);
        } else {
            for (Attributes item : refSeriesSeq) {
                String seriesIUID = item.getString(0x20000E);
                uidMap.put(seriesIUID, UIDUtils.createUID());
                refIUIDsBySeriesIUID.put(seriesIUID, this.refIUIDs(item.getSequence(528793)));
            }
            ctx = this.newRetrieveContextIOCM(session.getHttpRequest(), session.getCalledAET(), sourceStudyUID, refIUIDsBySeriesIUID.keySet().toArray(StringUtils.EMPTY_STRING));
        }
        ctx.setObjectType(null);
        if (!this.calculateMatches(ctx)) {
            return Collections.EMPTY_LIST;
        }
        List<InstanceLocations> matches = ctx.getMatches();
        Iterator matchesIter = matches.iterator();
        while (matchesIter.hasNext()) {
            InstanceLocations il = (InstanceLocations)matchesIter.next();
            if (this.contains(refIUIDsBySeriesIUID, il)) {
                uidMap.put(il.getSopInstanceUID(), UIDUtils.createUID());
                if (refSeriesSeq != null || uidMap.containsKey(il.getAttributes().getString(0x20000E))) continue;
                uidMap.put(il.getAttributes().getString(0x20000E), UIDUtils.createUID());
                continue;
            }
            matchesIter.remove();
        }
        return matches;
    }

    private Set<String> refIUIDs(Sequence refSOPSeq) {
        if (refSOPSeq == null) {
            return null;
        }
        HashSet<String> iuids = new HashSet<String>(refSOPSeq.size() * 4 / 3 + 1);
        for (Attributes refSOP : refSOPSeq) {
            iuids.add(refSOP.getString(528725));
        }
        return iuids;
    }

    private boolean contains(Map<String, Set<String>> refIUIDsBySeriesIUID, InstanceLocations il) {
        Set<String> iuids = refIUIDsBySeriesIUID.get(il.getAttributes().getString(0x20000E));
        return iuids == null || iuids.contains(il.getSopInstanceUID());
    }

    private void addLocationsFromMetadata(RetrieveContext ctx, String storageID, String storagePath, Attributes seriesAttrs) throws IOException {
        QueryRetrieveView qrView = ctx.getQueryRetrieveView();
        Storage storage = this.getStorage(storageID, ctx);
        try (InputStream in = storage.openInputStream(this.createReadContext(storage, storagePath, null));){
            ZipEntry entry;
            ZipInputStream zip = new ZipInputStream(in);
            while ((entry = zip.getNextEntry()) != null) {
                if (RetrieveServiceImpl.isEmptyOrContains(ctx.getSopInstanceUIDs(), entry.getName())) {
                    Attributes metadata = this.parseJSON(zip, !ctx.isRetrieveMetadata());
                    if (qrView == null || !qrView.hideRejectedInstance(metadata.getNestedDataset("DCM4CHEE Archive 5", 2004287554)) && !qrView.hideRejectionNote(metadata)) {
                        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{seriesAttrs, metadata});
                        metadata.addAll(seriesAttrs);
                        ctx.getMatches().add(this.instanceLocationsFromMetadata(ctx, metadata));
                    }
                }
                zip.closeEntry();
            }
        }
    }

    private static boolean isEmptyOrContains(String[] ss, String s) {
        if (ss.length == 0) {
            return true;
        }
        for (String s1 : ss) {
            if (!s1.equals(s)) continue;
            return true;
        }
        return false;
    }

    private InstanceLocations instanceLocationsFromMetadata(RetrieveContext ctx, Attributes attrs) {
        InstanceLocationsImpl inst = new InstanceLocationsImpl(attrs);
        inst.setRetrieveAETs(StringUtils.concat((String[])attrs.getStrings(524372), (char)'\\'));
        inst.setAvailability(Availability.valueOf((String)attrs.getString(524374)));
        inst.setCreatedTime(attrs.getDate("DCM4CHEE Archive 5", 0x77770040));
        inst.setUpdatedTime(attrs.getDate("DCM4CHEE Archive 5", 2004287553));
        inst.setRejectionCode(attrs.getNestedDataset("DCM4CHEE Archive 5", 2004287554));
        inst.setExternalRetrieveAET(attrs.getString("DCM4CHEE Archive 5", 2004287555));
        inst.setContainsMetadata(true);
        this.addLocationFromMetadata(inst, attrs);
        Sequence otherStorageSeq = attrs.getSequence("DCM4CHEE Archive 5", 0x77770055);
        if (otherStorageSeq != null) {
            for (Attributes otherStorageItem : otherStorageSeq) {
                this.addLocationFromMetadata(inst, otherStorageItem);
            }
        }
        if (ctx.getSeriesMetadataUpdate() == null) {
            attrs.removePrivateAttributes("DCM4CHEE Archive 5", 30583);
        }
        return inst;
    }

    private void addLocationFromMetadata(InstanceLocationsImpl inst, Attributes attrs) {
        inst.getLocations().add(new Location.Builder().storageID(attrs.getString("DCM4CHEE Archive 5", 0x77770050)).storagePath(StringUtils.concat((String[])attrs.getStrings("DCM4CHEE Archive 5", 2004287569), (char)'/')).transferSyntaxUID(attrs.getString("DCM4CHEE Archive 5", 2004287570)).digest(attrs.getString("DCM4CHEE Archive 5", 2004287572)).size((long)attrs.getInt("DCM4CHEE Archive 5", 2004287571, -1)).status(attrs.getString("DCM4CHEE Archive 5", 2004287574)).multiReference(attrs.getString("DCM4CHEE Archive 5", 0x77770057)).build());
    }

    @Override
    public InstanceLocations newInstanceLocations(Attributes attrs) {
        return new InstanceLocationsImpl(attrs);
    }

    private void updateStudyAccessTime(RetrieveContext ctx) {
        if (ctx.isUpdateSeriesMetadata()) {
            return;
        }
        Duration maxAccessTimeStaleness = this.getArchiveDeviceExtension().getMaxAccessTimeStaleness();
        if (maxAccessTimeStaleness == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long minAccessTime = now - maxAccessTimeStaleness.getSeconds() * 1000L;
        for (StudyInfo study : ctx.getStudyInfos()) {
            if (study.getAccessTime().getTime() >= minAccessTime) continue;
            this.ejb.updateStudyAccessTime(study.getStudyPk());
        }
    }

    @Override
    public StoreService getStoreService() {
        return this.storeService;
    }

    @Override
    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    @Override
    public Transcoder openTranscoder(RetrieveContext ctx, InstanceLocations inst, Collection<String> tsuids, boolean fmi) throws IOException {
        RetrieveServiceImpl.removeUnsupportedTransferSyntax(inst, tsuids);
        LocationInputStream locationInputStream = this.openLocationInputStream(ctx, inst);
        Transcoder transcoder = new Transcoder(RetrieveServiceImpl.toDicomInputStream(locationInputStream));
        transcoder.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        transcoder.setBulkDataDescriptor(arcAE.getBulkDataDescriptor());
        transcoder.setBulkDataDirectory(arcAE.getBulkDataSpoolDirectoryFile());
        transcoder.setConcatenateBulkDataFiles(true);
        transcoder.setDestinationTransferSyntax(RetrieveServiceImpl.selectTransferSyntax(locationInputStream, tsuids));
        transcoder.setCloseOutputStream(false);
        transcoder.setIncludeFileMetaInformation(fmi);
        return transcoder;
    }

    private static void removeUnsupportedTransferSyntax(InstanceLocations inst, Collection<String> tsuids) throws NoPresentationContextException {
        if (tsuids.isEmpty() || tsuids.contains("1.2.840.10008.1.2.1") || tsuids.contains("1.2.840.10008.1.2")) {
            return;
        }
        Location prev = null;
        List locations = inst.getLocations();
        Iterator iter = locations.iterator();
        while (iter.hasNext()) {
            Location next = (Location)iter.next();
            if (next.getObjectType() == Location.ObjectType.DICOM_FILE && tsuids.contains((prev = next).getTransferSyntaxUID())) continue;
            iter.remove();
        }
        if (locations.isEmpty()) {
            throw new NoPresentationContextException(inst.getSopClassUID(), prev.getTransferSyntaxUID());
        }
    }

    private static String selectTransferSyntax(LocationInputStream lis, Collection<String> tsuids) {
        String tsuid = lis.location.getTransferSyntaxUID();
        return tsuids.isEmpty() || tsuids.contains(tsuid) ? tsuid : (tsuids.contains("1.2.840.10008.1.2.1") ? "1.2.840.10008.1.2.1" : "1.2.840.10008.1.2");
    }

    @Override
    public DicomInputStream openDicomInputStream(RetrieveContext ctx, InstanceLocations inst) throws IOException {
        return RetrieveServiceImpl.toDicomInputStream(this.openLocationInputStream(ctx, inst));
    }

    private static DicomInputStream toDicomInputStream(LocationInputStream lis) throws IOException {
        try {
            return new DicomInputStream(lis.stream);
        }
        catch (IOException e) {
            SafeClose.close((Closeable)lis.stream);
            throw e;
        }
    }

    @Override
    public boolean restrictRetrieveAccordingTransferCapabilities(RetrieveContext ctx) {
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        ApplicationEntity destAE = ctx.getDestinationAE();
        boolean noDestinationRestriction = destAE.getTransferCapabilitiesWithRole(TransferCapability.Role.SCP).isEmpty();
        List<InstanceLocations> matches = ctx.getMatches();
        Iterator iter = matches.iterator();
        boolean restrictRetrieveSilently = arcAE.restrictRetrieveSilently();
        while (iter.hasNext()) {
            InstanceLocations match = (InstanceLocations)iter.next();
            if (ctx.getLocalApplicationEntity().hasTransferCapabilityFor(match.getSopClassUID(), TransferCapability.Role.SCU) && (noDestinationRestriction || destAE.hasTransferCapabilityFor(match.getSopClassUID(), TransferCapability.Role.SCP))) continue;
            iter.remove();
            if (restrictRetrieveSilently) {
                ctx.decrementNumberOfMatches();
            } else {
                ctx.incrementFailed();
                ctx.addFailedMatch(match);
            }
            LOG.info("{}: failed to send {} to {} - no Presentation Context offered", new Object[]{ctx.getRequestAssociation(), match, ctx.getDestinationAETitle()});
        }
        return !matches.isEmpty();
    }

    @Override
    public Map<String, Collection<InstanceLocations>> removeNotAccessableMatches(RetrieveContext ctx) {
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        String altCMoveSCP = arcAE.alternativeCMoveSCP();
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        List<InstanceLocations> matches = ctx.getMatches();
        int numMatches = matches.size();
        HashMap<String, Collection<InstanceLocations>> notAccessable = new HashMap<String, Collection<InstanceLocations>>(1);
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            InstanceLocations match = (InstanceLocations)iter.next();
            if (this.isAccessable(arcDev, match)) continue;
            iter.remove();
            if (!match.getLocations().isEmpty()) {
                this.putMatchTo(notAccessable, altCMoveSCP, match, numMatches);
                continue;
            }
            this.putMatchTo(notAccessable, (String)StringUtils.maskNull((Object)match.getExternalRetrieveAET(), (Object)altCMoveSCP), match, numMatches);
        }
        return notAccessable;
    }

    private void putMatchTo(Map<String, Collection<InstanceLocations>> map, String aet, InstanceLocations match, int numMatches) {
        Collection<InstanceLocations> list = map.get(aet);
        if (list == null) {
            list = new ArrayList<InstanceLocations>(numMatches);
            map.put(aet, list);
        }
        list.add(match);
    }

    @Override
    public ArchiveAttributeCoercion getArchiveAttributeCoercion(RetrieveContext ctx, InstanceLocations inst) {
        ArchiveAEExtension aeExt = ctx.getArchiveAEExtension();
        ArchiveAttributeCoercion rule = aeExt.findAttributeCoercion(Dimse.C_STORE_RQ, TransferCapability.Role.SCP, inst.getSopClassUID(), ctx.getDestinationHostName(), ctx.getLocalAETitle(), ctx.getRequestorHostName(), ctx.getDestinationAETitle(), inst.getAttributes());
        return rule;
    }

    @Override
    public List<ArchiveAttributeCoercion2> getArchiveAttributeCoercions(RetrieveContext ctx, InstanceLocations inst) {
        return ctx.getArchiveAEExtension().attributeCoercions2().filter(descriptor -> descriptor.match(TransferCapability.Role.SCP, Dimse.C_STORE_RQ, inst.getSopClassUID(), ctx.getDestinationHostName(), ctx.getLocalAETitle(), ctx.getRequestorHostName(), ctx.getDestinationAETitle(), inst.getAttributes())).collect(Collectors.toList());
    }

    @Override
    public AttributesCoercion getAttributesCoercion(RetrieveContext ctx, InstanceLocations inst, ArchiveAttributeCoercion rule) {
        MergeAttributesCoercion coercion = rule != null ? this.coercion(ctx, inst, rule) : new MergeAttributesCoercion(inst.getAttributes(), AttributesCoercion.NONE);
        UIDMap uidMap = ((Location)inst.getLocations().get(0)).getUidMap();
        return uidMap != null ? new RemapUIDsAttributesCoercion(uidMap.getUIDMap(), (AttributesCoercion)coercion) : coercion;
    }

    @Override
    public AttributesCoercion getAttributesCoercion(final RetrieveContext ctx, final InstanceLocations inst, final List<ArchiveAttributeCoercion2> coercions) {
        final UIDMap uidMap = ((Location)inst.getLocations().get(0)).getUidMap();
        return new AttributesCoercion(){

            public void coerce(Attributes attrs, Attributes modified) throws Exception {
                if (uidMap != null) {
                    UIDUtils.remapUIDs((Attributes)attrs, (Map)uidMap.getUIDMap());
                }
                if (!ArchiveAttributeCoercion2.containsScheme((Collection)coercions, (String)"retrieve-as-received")) {
                    Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, inst.getAttributes()});
                    if (modified != null) {
                        attrs.update(Attributes.UpdatePolicy.OVERWRITE, inst.getAttributes(), modified);
                    } else {
                        attrs.addAll(inst.getAttributes());
                    }
                }
                block6: for (ArchiveAttributeCoercion2 coercion : coercions) {
                    try {
                        if (!RetrieveServiceImpl.this.coercionFactory.getCoercionProcessor(coercion).coerce(coercion, inst.getSopClassUID(), ctx.getLocalHostName(), ctx.getLocalAETitle(), ctx.getDestinationHostName(), ctx.getDestinationAETitle(), attrs, modified) || !coercion.isCoercionSufficient()) continue;
                    }
                    catch (Exception e) {
                        LOG.info("Failed to apply {}:\n", (Object)coercion, (Object)e);
                        switch (coercion.getCoercionOnFailure()) {
                            case RETHROW: {
                                throw e;
                            }
                            case CONTINUE: {
                                continue block6;
                            }
                        }
                    }
                    break;
                }
            }

            public String remapUID(String uid) {
                if (uidMap != null) {
                    uid = uidMap.getUIDMap().getOrDefault(uid, uid);
                }
                for (ArchiveAttributeCoercion2 coercion : coercions) {
                    uid = RetrieveServiceImpl.this.coercionFactory.getCoercionProcessor(coercion).remapUID(coercion, uid);
                }
                return uid;
            }
        };
    }

    private void coerceSeriesMetadata(RetrieveContext ctx, InstanceLocations inst, Attributes attrs) {
        SeriesInfo seriesInfo;
        UIDMap uidMap = ((Location)inst.getLocations().get(0)).getUidMap();
        if (uidMap != null) {
            UIDUtils.remapUIDs((Attributes)attrs, (Map)uidMap.getUIDMap());
        }
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, inst.getAttributes()});
        attrs.addAll(inst.getAttributes());
        attrs.setString(524372, VR.AE, inst.getRetrieveAETs());
        attrs.setString(524374, VR.CS, inst.getAvailability().toString());
        StudyInfo studyInfo = ctx.getStudyInfos().get(0);
        if (studyInfo.getExpirationDate() != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287523, VR.DA, studyInfo.getExpirationDate());
        }
        if (!studyInfo.getAccessControlID().equals("*")) {
            attrs.setString("DCM4CHEE Archive 5", 0x77770027, VR.LO, studyInfo.getAccessControlID());
        }
        if ((seriesInfo = ctx.getSeriesInfos().get(0)).getExpirationDate() != null) {
            attrs.setString("DCM4CHEE Archive 5", 0x77770033, VR.DA, seriesInfo.getExpirationDate());
        }
        if (seriesInfo.getSendingAET() != null) {
            attrs.setString("DCM4CHEE Archive 5", 0x77770037, VR.AE, seriesInfo.getSendingAET());
        }
        if (seriesInfo.getReceivingAET() != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287592, VR.AE, seriesInfo.getReceivingAET());
        }
        if (seriesInfo.getSendingPresentationAddress() != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287593, VR.UR, seriesInfo.getSendingPresentationAddress());
        }
        if (seriesInfo.getSendingAET() != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287594, VR.UR, seriesInfo.getReceivingPresentationAddress());
        }
        RetrieveServiceImpl.setDTwTZ(attrs, 0x77770040, inst.getCreatedTime());
        RetrieveServiceImpl.setDTwTZ(attrs, 2004287553, inst.getUpdatedTime());
        if (inst.getRejectionCode() != null) {
            attrs.newSequence("DCM4CHEE Archive 5", 2004287554, 1).add(inst.getRejectionCode());
        }
        if (inst.getExternalRetrieveAET() != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287555, VR.AE, inst.getExternalRetrieveAET());
        }
        Attributes item = null;
        for (Location location : inst.getLocations()) {
            if (location.getObjectType() != Location.ObjectType.DICOM_FILE) continue;
            if (item == null) {
                item = attrs;
            } else {
                item = new Attributes(5);
                attrs.ensureSequence("DCM4CHEE Archive 5", 0x77770055, 1).add(item);
            }
            item.setString("DCM4CHEE Archive 5", 0x77770050, VR.LO, location.getStorageID());
            item.setString("DCM4CHEE Archive 5", 2004287569, VR.LO, StringUtils.split((String)location.getStoragePath(), (char)'/'));
            item.setString("DCM4CHEE Archive 5", 2004287570, VR.UI, location.getTransferSyntaxUID());
            item.setInt("DCM4CHEE Archive 5", 2004287571, VR.UL, new int[]{(int)location.getSize()});
            if (location.getDigestAsHexString() != null) {
                item.setString("DCM4CHEE Archive 5", 2004287572, VR.LO, location.getDigestAsHexString());
            }
            if (location.getStatus() != Location.Status.OK) {
                item.setString("DCM4CHEE Archive 5", 2004287574, VR.CS, location.getStatus().name());
            }
            if (location.getMultiReference() == null) continue;
            item.setInt("DCM4CHEE Archive 5", 0x77770057, VR.IS, new int[]{location.getMultiReference()});
        }
    }

    static void setDTwTZ(Attributes attrs, int tag, Date value) {
        attrs.setString("DCM4CHEE Archive 5", tag, VR.DT, DateUtils.formatDT(null, (Date)value, (DatePrecision)new DatePrecision(14, true)));
    }

    @Override
    public AttributesCoercion getAttributesCoercion(RetrieveContext ctx, InstanceLocations inst) {
        return this.getAttributesCoercion(ctx, inst, this.getArchiveAttributeCoercion(ctx, inst));
    }

    @Override
    public void waitForPendingCStoreForward(RetrieveContext ctx) {
        Association fwdas = ctx.getFallbackAssociation();
        if (fwdas == null) {
            return;
        }
        Association rqas = ctx.getRequestAssociation();
        String fallbackMoveSCP = fwdas.getCalledAET();
        String suids = Arrays.toString(ctx.getStudyInstanceUIDs());
        String destAET = ctx.getDestinationAETitle();
        try {
            LOG.info("{}: wait for pending forward of objects of study{} from {} to {}", new Object[]{rqas, suids, fallbackMoveSCP, destAET});
            ctx.waitForPendingCStoreForward();
            LOG.info("{}: complete forward of objects of study{} from {} to {} - remaining={}, completed={}, failed={}, warning={}", new Object[]{rqas, suids, fallbackMoveSCP, destAET, ctx.remaining(), ctx.completed(), ctx.failed(), ctx.warning()});
        }
        catch (InterruptedException e) {
            LOG.warn("{}: failed to wait for pending forward of  objects of study{} from {} to {}:\n", new Object[]{rqas, suids, fallbackMoveSCP, destAET, e});
        }
    }

    @Override
    public void waitForPendingCMoveForward(RetrieveContext ctx) {
        this.waitForPendingCMoveForward(ctx, ctx.getForwardAssociation());
        this.waitForPendingCMoveForward(ctx, ctx.getFallbackAssociation());
    }

    private void waitForPendingCMoveForward(RetrieveContext ctx, Association fwdas) {
        if (fwdas == null) {
            return;
        }
        Association rqas = ctx.getRequestAssociation();
        String moveSCP = fwdas.getRemoteAET();
        LOG.info("{}: wait for outstanding C-MOVE RSP(s) for C-MOVE RQ(s) forwarded to {}", (Object)rqas, (Object)moveSCP);
        try {
            fwdas.waitForOutstandingRSP();
        }
        catch (InterruptedException e) {
            LOG.warn("{}: failed to wait for outstanding C-MOVE RSP(s) for C-MOVE RQ(s) forwarded to {}", new Object[]{rqas, moveSCP, e});
        }
        try {
            fwdas.release();
        }
        catch (IOException e) {
            LOG.warn("{}: failed to release association to {}:\n", new Object[]{rqas, moveSCP, e});
        }
    }

    @Override
    public void updateCompleteness(RetrieveContext ctx) {
        if (ctx.isRetryFailedRetrieve()) {
            try {
                this.ejb.updateCompleteness(ctx, this.completeness(ctx));
            }
            catch (Exception e) {
                LOG.warn("{}: failed to update completeness of {}\n", new Object[]{ctx.getRequestAssociation(), ctx.getQueryRetrieveLevel(), e});
            }
        }
    }

    private Completeness completeness(RetrieveContext ctx) {
        Association as = ctx.getRequestAssociation();
        Association fwdas = ctx.getFallbackAssociation();
        String fallbackMoveSCP = fwdas.getRemoteAET();
        int expected = this.queryFallbackCMoveSCPLeadingCFindSCP(ctx);
        if (expected > 0) {
            int retrieved = ctx.completed() + ctx.warning();
            if (retrieved >= expected) {
                return Completeness.COMPLETE;
            }
            LOG.warn("{}: Expected {} but actual retrieved {} objects of study{} from {}", new Object[]{as, expected, retrieved, Arrays.toString(ctx.getStudyInstanceUIDs()), fallbackMoveSCP});
            return Completeness.PARTIAL;
        }
        if (ctx.getFallbackMoveRSPStatus() == 0) {
            return Completeness.COMPLETE;
        }
        int failed = ctx.getFallbackMoveRSPFailed();
        LOG.warn("{}: Failed to retrieve {} from {} objects of study{} from {} with status: {}H", new Object[]{as, failed, ctx.getFallbackMoveRSPNumberOfMatches(), Arrays.toString(ctx.getStudyInstanceUIDs()), fallbackMoveSCP, TagUtils.shortToHexString((int)ctx.getFallbackMoveRSPStatus())});
        String[] failedIUIDs = ctx.getFallbackMoveRSPFailedIUIDs();
        if (failedIUIDs.length == 0) {
            LOG.warn("{}: Missing Failed SOP Instance UID List in C-MOVE-RSP from {}", (Object)as, (Object)fallbackMoveSCP);
            return Completeness.PARTIAL;
        }
        if (failed != failedIUIDs.length) {
            LOG.warn("{}: Number Of Failed Suboperations [{}] does not match size of Failed SOP Instance UID List [{}] in C-MOVE-RSP from {}", new Object[]{as, failed, failedIUIDs.length, fallbackMoveSCP});
        }
        return Completeness.PARTIAL;
    }

    private int queryFallbackCMoveSCPLeadingCFindSCP(RetrieveContext ctx) {
        String findSCP = ctx.getArchiveAEExtension().fallbackCMoveSCPLeadingCFindSCP();
        if (findSCP == null || ctx.getQueryRetrieveLevel() != QueryRetrieveLevel2.STUDY) {
            return -1;
        }
        int expected = 0;
        ApplicationEntity localAE = ctx.getLocalApplicationEntity();
        for (String studyIUID : ctx.getStudyInstanceUIDs()) {
            List studies;
            try {
                studies = this.cfindscu.findStudy(localAE, findSCP, 0, studyIUID, new int[]{2101768});
            }
            catch (Exception e) {
                LOG.warn("Failed to query Study[{}] from {} - cannot verify number of retrieved objects from {}:\n", new Object[]{studyIUID, findSCP, ctx.getFallbackAssociation().getRemoteAET(), e});
                return -1;
            }
            if (studies.isEmpty()) {
                LOG.warn("Study[{}] not found at {} - cannot verify number of retrieved objects from {}", new Object[]{studyIUID, findSCP, ctx.getFallbackAssociation().getRemoteAET()});
                return -1;
            }
            expected += ((Attributes)studies.get(0)).getInt(2101768, 0);
        }
        return expected;
    }

    private AttributesCoercion coercion(RetrieveContext ctx, InstanceLocations inst, ArchiveAttributeCoercion rule) {
        AttributesCoercion coercion = DeIdentificationAttributesCoercion.valueOf((DeIdentifier.Option[])rule.getDeIdentification(), (AttributesCoercion)AttributesCoercion.NONE);
        String xsltStylesheetURI = rule.getXSLTStylesheetURI();
        if (xsltStylesheetURI != null) {
            try {
                Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)xsltStylesheetURI));
                coercion = new XSLTAttributesCoercion(tpls, coercion).includeKeyword(!rule.isNoKeywords()).setupTransformer(this.setupTransformer(ctx));
            }
            catch (TransformerConfigurationException e) {
                LOG.error("{}: Failed to compile XSL: {}", new Object[]{ctx.getLocalAETitle(), xsltStylesheetURI, e});
            }
        }
        coercion = rule.mergeAttributes(coercion);
        coercion = NullifyAttributesCoercion.valueOf((int[])rule.getNullifyTags(), (AttributesCoercion)coercion);
        String leadingCFindSCP = rule.getLeadingCFindSCP();
        if (leadingCFindSCP != null) {
            coercion = new CFindSCUAttributeCoercion(ctx.getLocalApplicationEntity(), leadingCFindSCP, rule.getAttributeUpdatePolicy(), this.cfindscu, this.leadingCFindSCPQueryCache, coercion);
        }
        if (!rule.isRetrieveAsReceived()) {
            coercion = new MergeAttributesCoercion(inst.getAttributes(), coercion);
        }
        LOG.info("Coerce Attributes from rule: {}", (Object)rule);
        return coercion;
    }

    private SAXTransformer.SetupTransformer setupTransformer(RetrieveContext ctx) {
        return t -> {
            t.setParameter("LocalAET", ctx.getLocalAETitle());
            if (ctx.getDestinationAETitle() != null) {
                t.setParameter("RemoteAET", ctx.getDestinationAETitle());
            }
            t.setParameter("RemoteHostname", ctx.getDestinationHostName());
        };
    }

    private boolean isAccessable(ArchiveDeviceExtension arcDev, InstanceLocations match) {
        for (Location location : match.getLocations()) {
            if (arcDev.getStorageDescriptor(location.getStorageID()) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public LocationInputStream openLocationInputStream(RetrieveContext ctx, InstanceLocations inst) throws IOException {
        String studyInstanceUID = inst.getAttributes().getString(0x20000D);
        ArchiveDeviceExtension arcdev = this.getArchiveDeviceExtension();
        Map<Availability, List<Location>> locationsByAvailability = inst.getLocations().stream().filter(Location::isDicomFile).collect(Collectors.groupingBy(l -> arcdev.getStorageDescriptor(l.getStorageID()).getInstanceAvailability()));
        List<Location> locations = locationsByAvailability.get(Availability.ONLINE);
        if (locations == null) {
            locations = locationsByAvailability.get(Availability.NEARLINE);
        } else if (locationsByAvailability.containsKey(Availability.NEARLINE)) {
            locations.addAll((Collection<Location>)locationsByAvailability.get(Availability.NEARLINE));
        }
        if (locations == null || locations.isEmpty()) {
            throw new IOException("Failed to find location of " + inst);
        }
        IOException ex = null;
        for (Location location : locations) {
            try {
                LOG.debug("Read {} from {}", (Object)inst, (Object)location);
                return this.openLocationInputStream(this.getStorage(location.getStorageID(), ctx), location, studyInstanceUID);
            }
            catch (IOException e) {
                ex = e;
                Location.Status errStatus = RetrieveServiceImpl.toStatus(e);
                if (errStatus == Location.Status.MISSING_OBJECT && !this.exists(location)) {
                    LOG.warn("{} of {} no longer exists", (Object)location, (Object)inst);
                    ctx.incrementMissing();
                    continue;
                }
                LOG.warn("Failed to read {} from {}:\n", new Object[]{inst, location, e});
                ctx.getUpdateLocations().add(new UpdateLocation(inst, location, errStatus, null));
            }
        }
        throw ex;
    }

    private boolean exists(Location location) {
        try {
            this.em.createNamedQuery("Location.Exists").setParameter(1, (Object)location.getPk()).getSingleResult();
            return true;
        }
        catch (NoResultException e) {
            return false;
        }
    }

    private static Location.Status toStatus(IOException e) {
        return e instanceof NoSuchFileException ? Location.Status.MISSING_OBJECT : Location.Status.FAILED_TO_FETCH_OBJECT;
    }

    @Override
    public void updateLocations(RetrieveContext ctx) {
        if (!ctx.getUpdateLocations().isEmpty()) {
            if (ctx.isUpdateLocationStatusOnRetrieve()) {
                this.storeService.updateLocations(ctx.getArchiveAEExtension(), ctx.getUpdateLocations());
            }
            this.retrieveFailures.fire((Object)ctx);
        }
    }

    @Override
    public void updateInstanceAvailability(RetrieveContext ctx) {
        if (ctx.getUpdateInstanceAvailability() != null && ctx.failuresOnCopyToRetrieveCache() == 0) {
            this.ejb.updateInstanceAvailability(ctx);
        }
    }

    private LocationInputStream openLocationInputStream(Storage storage, Location location, String studyInstanceUID) throws IOException {
        ReadContext readContext = this.createReadContext(storage, location.getStoragePath(), studyInstanceUID);
        InputStream stream = storage.openInputStream(readContext);
        return new LocationInputStream(stream, readContext, location);
    }

    private ReadContext createReadContext(Storage storage, String storagePath, String studyInstanceUID) {
        ReadContext readContext = storage.createReadContext();
        readContext.setStoragePath(storagePath);
        readContext.setStudyInstanceUID(studyInstanceUID);
        return readContext;
    }

    @Override
    public Storage getStorage(String storageID, RetrieveContext ctx) {
        Storage storage = ctx.getStorage(storageID);
        if (storage == null) {
            ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
            storage = this.storageFactory.getStorage(arcDev.getStorageDescriptorNotNull(storageID));
            ctx.putStorage(storageID, storage);
        }
        return storage;
    }

    @Override
    public Attributes loadMetadata(RetrieveContext ctx, InstanceLocations inst) throws Exception {
        Attributes attrs = this.loadMetadataFromJSONFile(ctx, inst);
        if (attrs == null) {
            attrs = this.loadMetadataFromDicomFile(ctx, inst);
        }
        if (ctx.isUpdateSeriesMetadata()) {
            this.coerceSeriesMetadata(ctx, inst, attrs);
        } else {
            this.getAttributesCoercion(ctx, inst).coerce(attrs, null);
        }
        return attrs;
    }

    private Attributes loadMetadataFromJSONFile(RetrieveContext ctx, InstanceLocations inst) throws IOException {
        String studyInstanceUID = inst.getAttributes().getString(0x20000D);
        for (Location location : inst.getLocations()) {
            if (location.getObjectType() != Location.ObjectType.METADATA) continue;
            Storage storage = this.getStorage(location.getStorageID(), ctx);
            try (InputStream in = storage.openInputStream(this.createReadContext(storage, location.getStoragePath(), studyInstanceUID));){
                Attributes attributes = this.parseJSON(in, false);
                return attributes;
            }
        }
        return null;
    }

    private Attributes parseJSON(InputStream in, boolean skipBulkDataURI) throws IOException {
        JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)));
        jsonReader.setSkipBulkDataURI(skipBulkDataURI);
        return jsonReader.readDataset(null);
    }

    private Attributes loadMetadataFromDicomFile(RetrieveContext ctx, InstanceLocations inst) throws IOException {
        Attributes attrs;
        try (DicomInputStream dis = this.openDicomInputStream(ctx, inst);){
            dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
            ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
            dis.setBulkDataDescriptor(arcAE != null ? arcAE.getBulkDataDescriptor() : this.getArchiveDeviceExtension().getBulkDataDescriptor());
            dis.setBulkDataCreator(new BulkDataCreator(){

                public BulkData createBulkData(DicomInputStream dis) throws IOException {
                    dis.skipFully((long)dis.length());
                    return new BulkData(null, "", dis.bigEndian());
                }
            });
            attrs = dis.readDataset(-1, 2145386512);
            if (dis.tag() == 2145386512) {
                attrs.setValue(2145386512, dis.vr(), (Object)new BulkData(null, "", dis.bigEndian()));
            }
        }
        return attrs;
    }
}

