/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.impl;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class RetrieveServiceEJB {
    private static Logger LOG = LoggerFactory.getLogger(RetrieveServiceEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    public void updateStudyAccessTime(Long studyPk) {
        this.em.createNamedQuery("Study.UpdateAccessTime").setParameter(1, (Object)studyPk).executeUpdate();
    }

    public void updateCompleteness(RetrieveContext ctx, Completeness completeness) {
        String[] studyIUIDs = ctx.getStudyInstanceUIDs();
        String[] seriesIUIDs = ctx.getSeriesInstanceUIDs();
        switch (ctx.getQueryRetrieveLevel()) {
            case STUDY: {
                for (String studyIUID : studyIUIDs) {
                    this.setCompletenessOfStudy(studyIUID, completeness);
                }
                break;
            }
            case SERIES: {
                for (String seriesIUID : seriesIUIDs) {
                    this.setCompletenessOfSeries(studyIUIDs[0], seriesIUID, completeness);
                }
                this.setCompletenessOfStudy(studyIUIDs[0], Completeness.UNKNOWN);
                break;
            }
            case IMAGE: {
                this.setCompletenessOfSeries(studyIUIDs[0], seriesIUIDs[0], Completeness.UNKNOWN);
                this.setCompletenessOfStudy(studyIUIDs[0], Completeness.UNKNOWN);
            }
        }
    }

    private void setCompletenessOfStudy(String studyInstanceUID, Completeness completeness) {
        this.em.createNamedQuery(completeness == Completeness.PARTIAL ? "Study.incrementFailedRetrieves" : "Study.setCompleteness").setParameter(1, (Object)studyInstanceUID).setParameter(2, (Object)completeness).executeUpdate();
        if (completeness != Completeness.UNKNOWN) {
            this.em.createNamedQuery("Series.SetCompletenessOfStudy").setParameter(1, (Object)studyInstanceUID).setParameter(2, (Object)Completeness.COMPLETE).executeUpdate();
        }
    }

    private void setCompletenessOfSeries(String studyInstanceUID, String seriesInstanceUID, Completeness completeness) {
        this.em.createNamedQuery(completeness == Completeness.PARTIAL ? "Series.IncrementFailedRetrieves" : "Series.SetCompleteness").setParameter(1, (Object)studyInstanceUID).setParameter(2, (Object)seriesInstanceUID).setParameter(3, (Object)completeness).executeUpdate();
    }

    public void updateInstanceAvailability(RetrieveContext ctx) {
        switch (ctx.getQueryRetrieveLevel()) {
            case STUDY: {
                this.updateInstanceAvailability("StudyQueryAttributes.updateAvailabilityByStudyIUID", ctx.getStudyInstanceUIDs(), ctx.getUpdateInstanceAvailability());
                this.updateInstanceAvailability("SeriesQueryAttributes.updateAvailabilityByStudyIUID", ctx.getStudyInstanceUIDs(), ctx.getUpdateInstanceAvailability());
                this.updateInstanceAvailability("Instance.updateAvailabilityByStudyIUID", ctx.getStudyInstanceUIDs(), ctx.getUpdateInstanceAvailability());
                break;
            }
            case SERIES: {
                this.updateInstanceAvailability("SeriesQueryAttributes.updateAvailabilityBySeriesIUID", ctx.getSeriesInstanceUIDs(), ctx.getUpdateInstanceAvailability());
                this.updateInstanceAvailability("Instance.updateAvailabilityBySeriesIUID", ctx.getSeriesInstanceUIDs(), ctx.getUpdateInstanceAvailability());
                break;
            }
            case IMAGE: {
                this.updateInstanceAvailability("Instance.updateAvailabilityBySopIUID", ctx.getSopInstanceUIDs(), ctx.getUpdateInstanceAvailability());
            }
        }
    }

    private void updateInstanceAvailability(String name, String[] uids, Availability availability) {
        for (String uid : uids) {
            this.em.createNamedQuery(name).setParameter(1, (Object)uid).setParameter(2, (Object)availability).executeUpdate();
        }
    }
}

