/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValueSelector;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.conf.UPSPriority;
import org.dcm4chee.arc.conf.UPSState;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.CodeEntity_;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.ContentItem;
import org.dcm4chee.arc.entity.ContentItem_;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.InstanceRequestAttributes;
import org.dcm4chee.arc.entity.InstanceRequestAttributes_;
import org.dcm4chee.arc.entity.Instance_;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.MPPS_;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.entity.MWLItem_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.PatientID_;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.entity.PersonName;
import org.dcm4chee.arc.entity.PersonName_;
import org.dcm4chee.arc.entity.RejectedInstance;
import org.dcm4chee.arc.entity.RejectedInstance_;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.SeriesQueryAttributes_;
import org.dcm4chee.arc.entity.SeriesRequestAttributes;
import org.dcm4chee.arc.entity.SeriesRequestAttributes_;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.SoundexCode;
import org.dcm4chee.arc.entity.SoundexCode_;
import org.dcm4chee.arc.entity.StgCmtResult;
import org.dcm4chee.arc.entity.StgCmtResult_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.StudyQueryAttributes;
import org.dcm4chee.arc.entity.StudyQueryAttributes_;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.entity.Subscription;
import org.dcm4chee.arc.entity.Subscription_;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.entity.Task_;
import org.dcm4chee.arc.entity.UPS;
import org.dcm4chee.arc.entity.UPSRequest;
import org.dcm4chee.arc.entity.UPSRequest_;
import org.dcm4chee.arc.entity.UPS_;
import org.dcm4chee.arc.entity.VerifyingObserver;
import org.dcm4chee.arc.entity.VerifyingObserver_;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.query.util.StgCmtResultQueryParam;
import org.dcm4chee.arc.query.util.TaskQueryParam;

public class QueryBuilder {
    private final CriteriaBuilder cb;

    public QueryBuilder(CriteriaBuilder cb) {
        this.cb = Objects.requireNonNull(cb);
    }

    public List<Order> orderPatients(Root<Patient> patient, List<OrderByTag> orderByTags) {
        ArrayList<Order> result = new ArrayList<Order>(orderByTags.size());
        for (OrderByTag orderByTag : orderByTags) {
            this.orderPatients((From)patient, orderByTag, (List<Order>)result);
        }
        return result;
    }

    public List<Order> orderStudies(From<Study, Patient> patient, Root<Study> study, List<OrderByTag> orderByTags) {
        ArrayList<Order> result = new ArrayList<Order>(orderByTags.size());
        for (OrderByTag orderByTag : orderByTags) {
            this.orderStudies(patient, (From)study, orderByTag, (List<Order>)result);
        }
        return result;
    }

    public List<Order> orderSeries(From<Study, Patient> patient, From<Series, Study> study, Root<Series> series, List<OrderByTag> orderByTags) {
        ArrayList<Order> result = new ArrayList<Order>(orderByTags.size());
        for (OrderByTag orderByTag : orderByTags) {
            this.orderSeries(patient, study, (From)series, orderByTag, (List<Order>)result);
        }
        return result;
    }

    public List<Order> orderInstances(From<Study, Patient> patient, From<Series, Study> study, From<Instance, Series> series, Root<Instance> instance, List<OrderByTag> orderByTags) {
        ArrayList<Order> result = new ArrayList<Order>(orderByTags.size());
        for (OrderByTag orderByTag : orderByTags) {
            this.orderInstances(patient, study, series, (From)instance, orderByTag, (List<Order>)result);
        }
        return result;
    }

    public List<Order> orderMWLItems(From<MWLItem, Patient> patient, Root<MWLItem> mwlItem, List<OrderByTag> orderByTags) {
        ArrayList<Order> result = new ArrayList<Order>(orderByTags.size());
        for (OrderByTag orderByTag : orderByTags) {
            this.orderMWLItems(patient, (From)mwlItem, orderByTag, (List<Order>)result);
        }
        return result;
    }

    public List<Order> orderWorkitems(Join<UPS, Patient> patient, Root<UPS> ups, List<OrderByTag> orderByTags) {
        ArrayList<Order> result = new ArrayList<Order>(orderByTags.size());
        for (OrderByTag orderByTag : orderByTags) {
            this.orderWorkitems(patient, ups, orderByTag, result);
        }
        return result;
    }

    public List<Order> orderMPPS(From<MPPS, Patient> patient, Root<MPPS> mpps, List<OrderByTag> orderByTags) {
        ArrayList<Order> result = new ArrayList<Order>(orderByTags.size());
        for (OrderByTag orderByTag : orderByTags) {
            this.orderMPPS(patient, (From)mpps, orderByTag, (List<Order>)result);
        }
        return result;
    }

    public Order orderTasks(Root<Task> task, String orderBy) {
        switch (orderBy) {
            case "createdTime": {
                return this.cb.asc((Expression)task.get(Task_.createdTime));
            }
            case "updatedTime": {
                return this.cb.asc((Expression)task.get(Task_.updatedTime));
            }
            case "-createdTime": {
                return this.cb.desc((Expression)task.get(Task_.createdTime));
            }
            case "-updatedTime": {
                return this.cb.desc((Expression)task.get(Task_.updatedTime));
            }
            case "scheduledTime": {
                return this.cb.asc((Expression)task.get(Task_.scheduledTime));
            }
            case "-scheduledTime": {
                return this.cb.desc((Expression)task.get(Task_.scheduledTime));
            }
        }
        throw new IllegalArgumentException(orderBy);
    }

    public Order orderBatches(Root<Task> task, String orderBy) {
        switch (orderBy) {
            case "createdTime": {
                return this.cb.asc(this.cb.least((Expression)task.get(Task_.createdTime)));
            }
            case "updatedTime": {
                return this.cb.asc(this.cb.least((Expression)task.get(Task_.updatedTime)));
            }
            case "-createdTime": {
                return this.cb.desc(this.cb.greatest((Expression)task.get(Task_.createdTime)));
            }
            case "-updatedTime": {
                return this.cb.desc(this.cb.greatest((Expression)task.get(Task_.updatedTime)));
            }
            case "scheduledTime": {
                return this.cb.asc(this.cb.least((Expression)task.get(Task_.scheduledTime)));
            }
            case "-scheduledTime": {
                return this.cb.desc(this.cb.greatest((Expression)task.get(Task_.scheduledTime)));
            }
        }
        throw new IllegalArgumentException(orderBy);
    }

    private <Z> boolean orderPatients(From<Z, Patient> patient, OrderByTag orderByTag, List<Order> result) {
        switch (orderByTag.tag) {
            case 0x100010: {
                return this.orderPersonName(patient, Patient_.patientName, orderByTag, result);
            }
            case 0x100040: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)patient.get(Patient_.patientSex)));
            }
            case 0x100030: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)patient.get(Patient_.patientBirthDate)));
            }
        }
        return false;
    }

    private <Z> boolean orderStudies(From<Study, Patient> patient, From<Z, Study> study, OrderByTag orderByTag, List<Order> result) {
        if (patient != null && this.orderPatients(patient, orderByTag, result)) {
            return true;
        }
        switch (orderByTag.tag) {
            case 0x20000D: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)study.get(Study_.studyInstanceUID)));
            }
            case 0x200010: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)study.get(Study_.studyID)));
            }
            case 524320: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)study.get(Study_.studyDate)));
            }
            case 524336: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)study.get(Study_.studyTime)));
            }
            case 524432: {
                return this.orderPersonName(study, Study_.referringPhysicianName, orderByTag, result);
            }
            case 528432: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)study.get(Study_.studyDescription)));
            }
            case 524368: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)study.get(Study_.accessionNumber)));
            }
        }
        return false;
    }

    private <Z> boolean orderSeries(From<Study, Patient> patient, From<Series, Study> study, From<Z, Series> series, OrderByTag orderByTag, List<Order> result) {
        if (study != null && this.orderStudies(patient, study, orderByTag, result)) {
            return true;
        }
        switch (orderByTag.tag) {
            case 0x20000E: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.seriesInstanceUID)));
            }
            case 0x200011: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.seriesNumber)));
            }
            case 524384: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.modality)));
            }
            case 1572885: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.bodyPartExamined)));
            }
            case 0x200060: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.laterality)));
            }
            case 0x400244: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.performedProcedureStepStartDate)));
            }
            case 4194885: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.performedProcedureStepStartTime)));
            }
            case 528464: {
                return this.orderPersonName(series, Series_.performingPhysicianName, orderByTag, result);
            }
            case 528446: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.seriesDescription)));
            }
            case 528400: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.stationName)));
            }
            case 524416: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.institutionName)));
            }
            case 528448: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)series.get(Series_.institutionalDepartmentName)));
            }
        }
        return false;
    }

    private <Z> boolean orderInstances(From<Study, Patient> patient, From<Series, Study> study, From<Instance, Series> series, From<Z, Instance> instance, OrderByTag orderByTag, List<Order> result) {
        if (series != null && this.orderSeries(patient, study, series, orderByTag, result)) {
            return true;
        }
        switch (orderByTag.tag) {
            case 524312: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)instance.get(Instance_.sopInstanceUID)));
            }
            case 524310: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)instance.get(Instance_.sopClassUID)));
            }
            case 2097171: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)instance.get(Instance_.instanceNumber)));
            }
            case 4236435: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)instance.get(Instance_.verificationFlag)));
            }
            case 4236433: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)instance.get(Instance_.completionFlag)));
            }
            case 524323: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)instance.get(Instance_.contentDate)));
            }
            case 524339: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)instance.get(Instance_.contentTime)));
            }
        }
        return false;
    }

    private <Z> boolean orderMWLItems(From<MWLItem, Patient> patient, From<Z, MWLItem> mwlItem, OrderByTag orderByTag, List<Order> result) {
        if (patient != null && this.orderPatients(patient, orderByTag, result)) {
            return true;
        }
        switch (orderByTag.tag) {
            case 7606786: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.worklistLabel)));
            }
            case 524368: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.accessionNumber)));
            }
            case 524384: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.modality)));
            }
            case 0x20000D: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.studyInstanceUID)));
            }
            case 0x400002: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.scheduledStartDate)));
            }
            case 0x400003: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.scheduledStartTime)));
            }
            case 0x400006: {
                return this.orderPersonName(mwlItem, MWLItem_.scheduledPerformingPhysicianName, orderByTag, result);
            }
            case 0x400009: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.scheduledProcedureStepID)));
            }
            case 0x401001: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mwlItem.get(MWLItem_.requestedProcedureID)));
            }
        }
        return false;
    }

    private <Z> boolean orderWorkitems(Join<UPS, Patient> patient, Root<UPS> ups, OrderByTag orderByTag, List<Order> result) {
        if (patient != null && this.orderPatients((From<Z, Patient>)patient, orderByTag, result)) {
            return true;
        }
        switch (orderByTag.tag) {
            case 7606784: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.upsPriority)));
            }
            case 0x404010: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.updatedTime)));
            }
            case 7606788: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.upsLabel)));
            }
            case 7606786: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.worklistLabel)));
            }
            case 0x404005: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.scheduledStartDateAndTime)));
            }
            case 0x404011: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.expectedCompletionDateAndTime)));
            }
            case 0x404008: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.scheduledProcedureStepExpirationDateTime)));
            }
            case 0x404041: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.inputReadinessState)));
            }
            case 3670032: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.admissionID)));
            }
            case 7606272: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)ups.get(UPS_.procedureStepState)));
            }
        }
        return false;
    }

    private <Z> boolean orderMPPS(From<MPPS, Patient> patient, From<Z, MPPS> mpps, OrderByTag orderByTag, List<Order> result) {
        if (patient != null && this.orderPatients(patient, orderByTag, result)) {
            return true;
        }
        switch (orderByTag.tag) {
            case 0x400244: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mpps.get(MPPS_.performedProcedureStepStartDate)));
            }
            case 4194885: {
                return result.add(orderByTag.order(this.cb, (Expression<?>)mpps.get(MPPS_.performedProcedureStepStartTime)));
            }
        }
        return false;
    }

    private <Z, X> boolean orderPersonName(From<Z, X> entity, SingularAttribute<X, PersonName> attribute, OrderByTag orderByTag, List<Order> result) {
        return this.orderPersonName(this.joinPersonName(entity, attribute), orderByTag, result);
    }

    private <Z, X> Path<PersonName> joinPersonName(From<Z, X> entity, SingularAttribute<X, PersonName> attribute) {
        return (Path)entity.getJoins().stream().filter(j -> j.getAttribute().equals(attribute)).findFirst().orElseGet(() -> entity.join(attribute, JoinType.LEFT));
    }

    private boolean orderPersonName(Path<PersonName> personName, OrderByTag orderByTag, List<Order> result) {
        result.add(orderByTag.order(this.cb, (Expression<?>)personName.get(PersonName_.alphabeticName)));
        return true;
    }

    private <Z> void patIDWithoutIssuerPredicate(List<Predicate> predicates, From<Z, Patient> patient, IDWithIssuer[] pids) {
        Join patientID = patient.join(Patient_.patientID);
        predicates.add(patientID.get(PatientID_.localNamespaceEntityID).isNull());
        predicates.add(patientID.get(PatientID_.universalEntityID).isNull());
        if (QueryBuilder.isUniversalMatching(pids)) {
            return;
        }
        ArrayList<Predicate> idPredicates = new ArrayList<Predicate>(pids.length);
        for (IDWithIssuer pid : pids) {
            ArrayList<Predicate> idPredicate;
            if (QueryBuilder.isUniversalMatching(pid.getID()) || !this.wildCard(idPredicate = new ArrayList<Predicate>(1), (Expression<String>)patientID.get(PatientID_.id), pid.getID())) continue;
            idPredicates.add(this.cb.and(idPredicate.toArray(new Predicate[0])));
        }
        if (!idPredicates.isEmpty()) {
            predicates.add(this.cb.or(idPredicates.toArray(new Predicate[0])));
        }
    }

    public <Z> void patientIDPredicate(List<Predicate> predicates, From<Z, Patient> patient, IDWithIssuer[] pids) {
        Join patientID = patient.join(Patient_.patientID);
        ArrayList<Predicate> idPredicates = new ArrayList<Predicate>(pids.length);
        for (IDWithIssuer pid : pids) {
            ArrayList<Predicate> idPredicate;
            if (QueryBuilder.isUniversalMatching(pid.getID()) || !this.wildCard(idPredicate = new ArrayList<Predicate>(3), (Expression<String>)patientID.get(PatientID_.id), pid.getID())) continue;
            if (pid.getIssuer() != null) {
                this.issuer(idPredicate, (Path<String>)patientID.get(PatientID_.localNamespaceEntityID), (Path<String>)patientID.get(PatientID_.universalEntityID), (Path<String>)patientID.get(PatientID_.universalEntityIDType), pid.getIssuer());
            }
            idPredicates.add(this.cb.and(idPredicate.toArray(new Predicate[0])));
        }
        if (!idPredicates.isEmpty()) {
            predicates.add(this.cb.or(idPredicates.toArray(new Predicate[0])));
        }
    }

    private <Z> void patIDIssuerPredicate(List<Predicate> predicates, From<Z, Patient> patient, Issuer issuer) {
        Join patientID = patient.join(Patient_.patientID);
        this.issuer(predicates, (Path<String>)patientID.get(PatientID_.localNamespaceEntityID), (Path<String>)patientID.get(PatientID_.universalEntityID), (Path<String>)patientID.get(PatientID_.universalEntityIDType), issuer);
    }

    public <T> List<Predicate> patientPredicates(CriteriaQuery<T> q, Root<Patient> patient, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.patientLevelPredicates((List<Predicate>)predicates, q, (From)patient, pids, issuer, keys, queryParam, QueryRetrieveLevel2.PATIENT);
        return predicates;
    }

    public <T> List<Predicate> studyPredicates(CriteriaQuery<T> q, From<Study, Patient> patient, Root<Study> study, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam, CodeEntity[] showInstancesRejectedByCodes) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.patientLevelPredicates(predicates, q, patient, pids, issuer, keys, queryParam, QueryRetrieveLevel2.STUDY);
        this.studyLevelPredicates((List<Predicate>)predicates, q, (From)study, keys, queryParam, QueryRetrieveLevel2.STUDY, showInstancesRejectedByCodes);
        return predicates;
    }

    public <T> List<Predicate> seriesPredicates(CriteriaQuery<T> q, From<Study, Patient> patient, From<Series, Study> study, Root<Series> series, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam, CodeEntity[] showInstancesRejectedByCodes) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.patientLevelPredicates(predicates, q, patient, pids, issuer, keys, queryParam, QueryRetrieveLevel2.SERIES);
        this.studyLevelPredicates(predicates, q, study, keys, queryParam, QueryRetrieveLevel2.SERIES, showInstancesRejectedByCodes);
        this.seriesLevelPredicates((List<Predicate>)predicates, q, study, (From)series, keys, queryParam, QueryRetrieveLevel2.SERIES, showInstancesRejectedByCodes);
        return predicates;
    }

    public <T> List<Predicate> instancePredicates(CriteriaQuery<T> q, From<Study, Patient> patient, From<Series, Study> study, From<Instance, Series> series, Root<Instance> instance, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam, CodeEntity[] showInstancesRejectedByCodes, CodeEntity[] hideRejectionNoteWithCodes) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.patientLevelPredicates(predicates, q, patient, pids, issuer, keys, queryParam, QueryRetrieveLevel2.IMAGE);
        this.studyLevelPredicates(predicates, q, study, keys, queryParam, QueryRetrieveLevel2.IMAGE, showInstancesRejectedByCodes);
        this.seriesLevelPredicates(predicates, q, study, series, keys, queryParam, QueryRetrieveLevel2.SERIES, showInstancesRejectedByCodes);
        this.instanceLevelPredicates((List<Predicate>)predicates, q, (Path<Study>)study, (Path<Series>)series, instance, keys, queryParam, showInstancesRejectedByCodes, hideRejectionNoteWithCodes);
        return predicates;
    }

    public <T> List<Predicate> mwlItemPredicates(CriteriaQuery<T> q, From<MWLItem, Patient> patient, Root<MWLItem> mwlItem, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.patientLevelPredicates(predicates, q, patient, pids, issuer, keys, queryParam, null);
        this.mwlItemLevelPredicates(predicates, q, mwlItem, keys, queryParam);
        return predicates;
    }

    public <T> List<Predicate> upsPredicates(CriteriaQuery<T> q, Join<UPS, Patient> patient, Root<UPS> ups, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.patientLevelPredicates((List<Predicate>)predicates, q, (From)patient, pids, issuer, keys, queryParam, null);
        this.upsLevelPredicates(predicates, q, ups, keys, queryParam);
        return predicates;
    }

    public <T> List<Predicate> mppsPredicates(CriteriaQuery<T> q, From<MPPS, Patient> patient, Root<MPPS> mpps, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.patientLevelPredicates(predicates, q, patient, pids, issuer, keys, queryParam, null);
        this.mppsLevelPredicates(predicates, q, mpps, keys, queryParam);
        return predicates;
    }

    public List<Predicate> stgCmtResultPredicates(Root<StgCmtResult> stgCmtResult, StgCmtResultQueryParam queryParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (queryParam.status != null) {
            predicates.add(this.cb.equal((Expression)stgCmtResult.get(StgCmtResult_.status), (Object)queryParam.status));
        }
        if (queryParam.studyUID != null) {
            predicates.add(this.cb.equal((Expression)stgCmtResult.get(StgCmtResult_.studyInstanceUID), (Object)queryParam.studyUID));
        }
        if (queryParam.exporterID != null) {
            predicates.add(this.cb.equal((Expression)stgCmtResult.get(StgCmtResult_.exporterID), (Object)queryParam.exporterID));
        }
        if (queryParam.batchID != null) {
            predicates.add(this.cb.equal((Expression)stgCmtResult.get(StgCmtResult_.batchID), (Object)queryParam.batchID));
        }
        if (queryParam.taskPK != null) {
            predicates.add(this.cb.equal((Expression)stgCmtResult.get(StgCmtResult_.taskPK), (Object)queryParam.taskPK));
        }
        if (queryParam.updatedBefore != null) {
            predicates.add(this.cb.lessThan((Expression)stgCmtResult.get(StgCmtResult_.updatedTime), (Comparable)queryParam.updatedBefore));
        }
        return predicates;
    }

    public List<Predicate> taskPredicates(Root<Task> task, TaskQueryParam taskQueryParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (taskQueryParam.getTaskPK() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.pk), (Object)taskQueryParam.getTaskPK()));
        }
        if (taskQueryParam.getQueueNames() != null && !taskQueryParam.getQueueNames().isEmpty()) {
            predicates.add(task.get(Task_.queueName).in(taskQueryParam.getQueueNames()));
        }
        if (taskQueryParam.getNotStatus() != null) {
            predicates.add(this.cb.notEqual((Expression)task.get(Task_.status), (Object)taskQueryParam.getNotStatus()));
        }
        if (taskQueryParam.getStatus() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.status), (Object)taskQueryParam.getStatus()));
        }
        if (taskQueryParam.getDeviceName() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.deviceName), (Object)taskQueryParam.getDeviceName()));
        }
        if (taskQueryParam.getBatchID() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.batchID), (Object)taskQueryParam.getBatchID()));
        }
        if (taskQueryParam.getCreatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.createdTime), taskQueryParam.getCreatedTime());
        }
        if (taskQueryParam.getUpdatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.updatedTime), taskQueryParam.getUpdatedTime());
        }
        if (taskQueryParam.getUpdatedBefore() != null) {
            predicates.add(this.cb.lessThan((Expression)task.get(Task_.updatedTime), (Comparable)taskQueryParam.getUpdatedBefore()));
        }
        if (taskQueryParam.getNotType() != null) {
            predicates.add(this.cb.notEqual((Expression)task.get(Task_.type), (Object)taskQueryParam.getNotType()));
        }
        if (taskQueryParam.getType() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.type), (Object)taskQueryParam.getType()));
            switch (taskQueryParam.getType()) {
                case EXPORT: {
                    if (taskQueryParam.getExporterIDs() != null && !taskQueryParam.getExporterIDs().isEmpty()) {
                        predicates.add(task.get(Task_.exporterID).in(taskQueryParam.getExporterIDs()));
                    }
                    if (taskQueryParam.getStudyIUID() == null) break;
                    predicates.add(this.cb.equal((Expression)task.get(Task_.studyInstanceUID), (Object)taskQueryParam.getStudyIUID()));
                    break;
                }
                case RETRIEVE: {
                    if (taskQueryParam.getLocalAET() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.localAET), (Object)taskQueryParam.getLocalAET()));
                    }
                    if (taskQueryParam.getRemoteAET() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.remoteAET), (Object)taskQueryParam.getRemoteAET()));
                    }
                    if (taskQueryParam.getDestinationAET() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.destinationAET), (Object)taskQueryParam.getDestinationAET()));
                    }
                    if (taskQueryParam.getStudyIUID() == null) break;
                    predicates.add(this.cb.equal((Expression)task.get(Task_.studyInstanceUID), (Object)taskQueryParam.getStudyIUID()));
                    break;
                }
                case STGVER: {
                    if (taskQueryParam.getLocalAET() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.localAET), (Object)taskQueryParam.getLocalAET()));
                    }
                    if (taskQueryParam.getStudyIUID() == null) break;
                    predicates.add(this.cb.equal((Expression)task.get(Task_.studyInstanceUID), (Object)taskQueryParam.getStudyIUID()));
                    break;
                }
                case DIFF: {
                    if (taskQueryParam.getLocalAET() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.localAET), (Object)taskQueryParam.getLocalAET()));
                    }
                    if (taskQueryParam.getPrimaryAET() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.remoteAET), (Object)taskQueryParam.getPrimaryAET()));
                    }
                    if (taskQueryParam.getSecondaryAET() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.destinationAET), (Object)taskQueryParam.getSecondaryAET()));
                    }
                    if (taskQueryParam.getCompareFields() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.compareFields), (Object)taskQueryParam.getCompareFields()));
                    }
                    if (taskQueryParam.getCheckMissing() != null) {
                        predicates.add(this.cb.equal((Expression)task.get(Task_.checkMissing), (Object)Boolean.parseBoolean(taskQueryParam.getCheckMissing())));
                    }
                    if (taskQueryParam.getCheckDifferent() == null) break;
                    predicates.add(this.cb.equal((Expression)task.get(Task_.checkDifferent), (Object)Boolean.parseBoolean(taskQueryParam.getCheckDifferent())));
                }
            }
        } else {
            if (taskQueryParam.getLocalAET() != null) {
                predicates.add(this.cb.equal((Expression)task.get(Task_.localAET), (Object)taskQueryParam.getLocalAET()));
            }
            if (taskQueryParam.getRemoteAET() != null) {
                predicates.add(this.cb.equal((Expression)task.get(Task_.remoteAET), (Object)taskQueryParam.getRemoteAET()));
            }
        }
        return predicates;
    }

    private <T, Z> void patientLevelPredicates(List<Predicate> predicates, CriteriaQuery<T> q, From<Z, Patient> patient, IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam, QueryRetrieveLevel2 queryRetrieveLevel) {
        if (patient == null) {
            return;
        }
        if (queryRetrieveLevel == QueryRetrieveLevel2.PATIENT) {
            if (queryParam.isMerged()) {
                predicates.add(patient.get(Patient_.mergedWith).isNotNull());
            } else {
                predicates.add(patient.get(Patient_.mergedWith).isNull());
            }
            if (queryParam.isOnlyWithStudies()) {
                predicates.add(this.cb.greaterThan((Expression)patient.get(Patient_.numberOfStudies), (Comparable)Integer.valueOf(0)));
            }
        }
        if (queryParam.isWithoutIssuer()) {
            this.patIDWithoutIssuerPredicate(predicates, patient, pids);
        } else if (!QueryBuilder.isUniversalMatching(pids)) {
            this.patientIDPredicate(predicates, patient, pids);
        } else if (!QueryBuilder.isUniversalMatching(issuer)) {
            this.patIDIssuerPredicate(predicates, patient, issuer);
        }
        this.personName(predicates, q, patient, Patient_.patientName, keys.getString(0x100010, "*"), queryParam);
        this.anyOf(predicates, (Expression<String>)patient.get(Patient_.patientSex), QueryBuilder.toUpperCase(keys.getStrings(0x100040)), false);
        this.dateRange(predicates, (Path<String>)patient.get(Patient_.patientBirthDate), keys.getDateRange(0x100030), FormatDate.DA);
        this.personName(predicates, q, patient, Patient_.responsiblePerson, keys.getString(1057431, "*"), queryParam);
        AttributeFilter attrFilter = queryParam.getAttributeFilter(Entity.Patient);
        this.wildCard(predicates, (Expression<String>)patient.get(Patient_.patientCustomAttribute1), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute1(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)patient.get(Patient_.patientCustomAttribute2), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute2(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)patient.get(Patient_.patientCustomAttribute3), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute3(), (String)"*"), true);
        if (queryParam.getPatientVerificationStatus() != null) {
            predicates.add(this.cb.equal((Expression)patient.get(Patient_.verificationStatus), (Object)queryParam.getPatientVerificationStatus()));
        }
    }

    public static boolean hasPatientLevelPredicates(IDWithIssuer[] pids, Issuer issuer, Attributes keys, QueryParam queryParam) {
        if (!QueryBuilder.isUniversalMatching(pids) || !QueryBuilder.isUniversalMatching(issuer)) {
            return true;
        }
        AttributeFilter attrFilter = queryParam.getAttributeFilter(Entity.Patient);
        return queryParam.getPatientVerificationStatus() != null || !QueryBuilder.isUniversalMatching(keys.getString(0x100010)) || !QueryBuilder.isUniversalMatching(keys.getString(0x100040)) || !QueryBuilder.isUniversalMatching(keys.getString(0x100040)) || !QueryBuilder.isUniversalMatching(keys.getString(0x100030)) || !QueryBuilder.isUniversalMatching(keys.getString(1057431)) || !QueryBuilder.isUniversalMatching(AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute1(), null)) || !QueryBuilder.isUniversalMatching(AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute2(), null)) || !QueryBuilder.isUniversalMatching(AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute3(), null));
    }

    public static <X> CollectionJoin<Study, StudyQueryAttributes> joinStudyQueryAttributes(CriteriaBuilder cb, From<X, Study> study, String viewID) {
        CollectionJoin join = study.join(Study_.queryAttributes, JoinType.LEFT);
        return join.on((Expression)cb.equal((Expression)join.get(StudyQueryAttributes_.viewID), (Object)viewID));
    }

    public static <X> CollectionJoin<Series, SeriesQueryAttributes> joinSeriesQueryAttributes(CriteriaBuilder cb, From<X, Series> series, String viewID) {
        CollectionJoin join = series.join(Series_.queryAttributes, JoinType.LEFT);
        return join.on((Expression)cb.equal((Expression)join.get(SeriesQueryAttributes_.viewID), (Object)viewID));
    }

    public void uidsPredicate(List<Predicate> x, Path<String> path, String ... values) {
        if (!QueryBuilder.isUniversalMatching(values)) {
            x.add(values.length == 1 ? this.cb.equal(path, (Object)values[0]) : path.in((Object[])values));
        }
    }

    public Predicate[] splitUIDPredicates(Path<String> path, String[] values, int inExpressionCountLimit) {
        Object[] dst;
        if (QueryBuilder.isUniversalMatching(values)) {
            return new Predicate[0];
        }
        if (values.length <= inExpressionCountLimit) {
            return new Predicate[]{path.in((Object[])values)};
        }
        Predicate[] predicates = new Predicate[(values.length - 1) / inExpressionCountLimit + 1];
        int remaining = values.length % inExpressionCountLimit;
        int last = predicates.length;
        if (remaining > 0) {
            dst = new String[remaining];
            System.arraycopy(values, values.length - remaining, dst, 0, remaining);
            predicates[--last] = path.in(dst);
        }
        dst = new String[inExpressionCountLimit];
        for (int i = 0; i < last; ++i) {
            System.arraycopy(values, i * inExpressionCountLimit, dst, 0, inExpressionCountLimit);
            predicates[i] = path.in(dst);
        }
        return predicates;
    }

    private <T, Z> List<Predicate> studyLevelPredicates(List<Predicate> predicates, CriteriaQuery<T> q, From<Z, Study> study, Attributes keys, QueryParam queryParam, QueryRetrieveLevel2 queryRetrieveLevel, CodeEntity[] showInstancesRejectedByCodes) {
        String admissionID;
        String requested;
        boolean combinedDatetimeMatching = queryParam.isCombinedDatetimeMatching();
        QueryBuilder.accessControl(predicates, study, queryParam.getAccessControlIDs());
        this.anyOf(predicates, (Expression<String>)study.get(Study_.studyInstanceUID), keys.getStrings(0x20000D), false);
        this.anyOf(predicates, (Expression<String>)study.get(Study_.studyID), keys.getStrings(0x200010), false);
        this.dateRange(predicates, (Path<String>)study.get(Study_.studyDate), (Path<String>)study.get(Study_.studyTime), 524320, 524336, 2251937253163056L, keys, combinedDatetimeMatching);
        this.personName(predicates, q, study, Study_.referringPhysicianName, keys.getString(524432, "*"), queryParam);
        this.anyOf(predicates, (Expression<String>)study.get(Study_.studyDescription), keys.getStrings(528432), true);
        String accNo = keys.getString(524368, "*");
        if (!QueryBuilder.isUniversalMatching(accNo)) {
            Issuer issuer = Issuer.valueOf((Attributes)keys.getNestedDataset(524369));
            if (issuer == null) {
                issuer = queryParam.getDefaultIssuerOfAccessionNumber();
            }
            if (this.wildCard(predicates, (Expression<String>)study.get(Study_.accessionNumber), accNo) && issuer != null) {
                this.issuer(predicates, (Path<String>)study.get(Study_.accessionNumberLocalNamespaceEntityID), (Path<String>)study.get(Study_.accessionNumberUniversalEntityID), (Path<String>)study.get(Study_.accessionNumberUniversalEntityIDType), issuer);
            }
        }
        String[] modalitiesInStudy = keys.getStrings(524385);
        if (queryParam.isAllOfModalitiesInStudy() && modalitiesInStudy != null && modalitiesInStudy.length > 1) {
            for (String modality : modalitiesInStudy) {
                this.seriesAttributesInStudy(predicates, q, (Path<Study>)study, keys, queryParam, queryRetrieveLevel, modality);
            }
        } else {
            this.seriesAttributesInStudy(predicates, q, (Path<Study>)study, keys, queryParam, queryRetrieveLevel, modalitiesInStudy);
        }
        this.codes(predicates, q, study, Study_.procedureCodes, keys.getNestedDataset(528434));
        if (queryRetrieveLevel == QueryRetrieveLevel2.STUDY && (requested = queryParam.getRequested()) != null) {
            Subquery sq = q.subquery(Series.class);
            Root series = sq.from(Series.class);
            Predicate exists = this.cb.exists(sq.select((Expression)series).where((Expression)this.cb.and((Expression)this.cb.isNotEmpty(series.get((PluralAttribute)Series_.requestAttributes)), (Expression)this.cb.equal((Expression)series.get(Series_.study), study))));
            predicates.add(Boolean.parseBoolean(requested) ? exists : exists.not());
        }
        AttributeFilter attrFilter = queryParam.getAttributeFilter(Entity.Study);
        this.wildCard(predicates, (Expression<String>)study.get(Study_.studyCustomAttribute1), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute1(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)study.get(Study_.studyCustomAttribute2), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute2(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)study.get(Study_.studyCustomAttribute3), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute3(), (String)"*"), true);
        this.dateRange(predicates, (Path<Date>)study.get(Study_.createdTime), keys.getDateRange("DCM4CHEE Archive 5", 0x77770020, VR.DT));
        this.dateRange(predicates, (Path<Date>)study.get(Study_.accessTime), keys.getDateRange("DCM4CHEE Archive 5", 0x77770022, VR.DT));
        if (queryParam.getExternalRetrieveAET() != null) {
            predicates.add(this.cb.equal((Expression)study.get(Study_.externalRetrieveAET), (Object)queryParam.getExternalRetrieveAET()));
        }
        if (queryParam.getExternalRetrieveAETNot() != null) {
            predicates.add(this.cb.notEqual((Expression)study.get(Study_.externalRetrieveAET), (Object)queryParam.getExternalRetrieveAETNot()));
        }
        if (queryRetrieveLevel == QueryRetrieveLevel2.STUDY) {
            if (queryParam.isHideNotRejectedInstances()) {
                Subquery sq = q.subquery(RejectedInstance.class);
                Root ri = sq.from(RejectedInstance.class);
                Predicate y = this.cb.equal((Expression)ri.get(RejectedInstance_.studyInstanceUID), (Expression)study.get(Study_.studyInstanceUID));
                if (showInstancesRejectedByCodes.length > 0) {
                    y = this.cb.and((Expression)y, (Expression)ri.get(RejectedInstance_.rejectionNoteCode).in((Object[])showInstancesRejectedByCodes));
                }
                predicates.add(this.cb.exists(sq.select((Expression)ri).where((Expression)y)));
            }
            if (queryParam.isIncomplete()) {
                predicates.add(this.cb.notEqual((Expression)study.get(Study_.completeness), (Object)Completeness.COMPLETE));
            }
            if (queryParam.isRetrieveFailed()) {
                predicates.add(this.cb.greaterThan((Expression)study.get(Study_.failedRetrieves), (Comparable)Integer.valueOf(0)));
            }
        }
        if (queryParam.getExpirationDate() != null) {
            this.dateRange(predicates, (Path<String>)study.get(Study_.expirationDate), queryParam.getExpirationDate(), FormatDate.DA);
        }
        if (queryParam.getStudyStorageIDs() != null) {
            predicates.add(study.get(Study_.storageIDs).in(queryParam.getStudyStorageIDs()));
        }
        if (queryParam.getMinStudySize() != 0L) {
            predicates.add(this.cb.greaterThanOrEqualTo((Expression)study.get(Study_.size), (Comparable)Long.valueOf(queryParam.getMinStudySize())));
        }
        if (queryParam.getMaxStudySize() != 0L) {
            predicates.add(this.cb.lessThanOrEqualTo((Expression)study.get(Study_.size), (Comparable)Long.valueOf(queryParam.getMaxStudySize())));
        }
        if (queryParam.getExpirationState() != null) {
            predicates.add(study.get(Study_.expirationState).in((Object[])queryParam.getExpirationState()));
        }
        if (!QueryBuilder.isUniversalMatching(admissionID = keys.getString(3670032, "*"))) {
            Issuer issuer = Issuer.valueOf((Attributes)keys.getNestedDataset(3670036));
            if (issuer == null) {
                issuer = queryParam.getDefaultIssuerOfAdmissionID();
            }
            if (this.wildCard(predicates, (Expression<String>)study.get(Study_.admissionID), admissionID) && issuer != null) {
                this.issuer(predicates, (Path<String>)study.get(Study_.admissionIDLocalNamespaceEntityID), (Path<String>)study.get(Study_.admissionIDUniversalEntityID), (Path<String>)study.get(Study_.admissionIDUniversalEntityIDType), issuer);
            }
        }
        return predicates;
    }

    public static void accessControl(List<Predicate> predicates, Path<Study> study, String[] accessControlIDs) {
        if (accessControlIDs.length == 0) {
            return;
        }
        Object[] a = new String[accessControlIDs.length + 1];
        a[0] = "*";
        System.arraycopy(accessControlIDs, 0, a, 1, accessControlIDs.length);
        predicates.add(study.get(Study_.accessControlID).in(a));
    }

    private <T, Z> List<Predicate> seriesLevelPredicates(List<Predicate> predicates, CriteriaQuery<T> q, From<Series, Study> study, From<Z, Series> series, Attributes keys, QueryParam queryParam, QueryRetrieveLevel2 queryRetrieveLevel2, CodeEntity[] showInstancesRejectedByCodes) {
        this.anyOf(predicates, (Expression<String>)series.get(Series_.seriesInstanceUID), keys.getStrings(0x20000E), false);
        this.numberPredicate(predicates, (Expression<Integer>)series.get(Series_.seriesNumber), keys.getString(0x200011, "*"));
        this.anyOf(predicates, (Expression<String>)series.get(Series_.modality), QueryBuilder.toUpperCase(keys.getStrings(524384)), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.bodyPartExamined), QueryBuilder.toUpperCase(keys.getStrings(1572885)), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.laterality), QueryBuilder.toUpperCase(keys.getStrings(0x200060)), false);
        this.dateRange(predicates, (Path<String>)series.get(Series_.performedProcedureStepStartDate), (Path<String>)series.get(Series_.performedProcedureStepStartTime), 0x400244, 4194885, 18016889594708549L, keys, queryParam.isCombinedDatetimeMatching());
        this.personName(predicates, q, series, Series_.performingPhysicianName, keys.getString(528464), queryParam);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.seriesDescription), keys.getStrings(528446), true);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.stationName), keys.getStrings(528400), true);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.institutionalDepartmentName), keys.getStrings(528448), true);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.institutionName), keys.getStrings(524416), true);
        Attributes reqAttrs = keys.getNestedDataset(4194933);
        this.requestAttributes(predicates, q, series, reqAttrs, queryParam);
        this.code(predicates, (Path<CodeEntity>)series.get(Series_.institutionCode), keys.getNestedDataset(524418));
        this.code(predicates, (Path<CodeEntity>)series.get(Series_.institutionalDepartmentTypeCode), keys.getNestedDataset(528449));
        if (queryRetrieveLevel2 == QueryRetrieveLevel2.SERIES && queryParam.isHideNotRejectedInstances()) {
            Subquery sq = q.subquery(RejectedInstance.class);
            Root ri = sq.from(RejectedInstance.class);
            Predicate y = this.cb.and((Expression)this.cb.equal((Expression)ri.get(RejectedInstance_.studyInstanceUID), (Expression)study.get(Study_.studyInstanceUID)), (Expression)this.cb.equal((Expression)ri.get(RejectedInstance_.seriesInstanceUID), (Expression)series.get(Series_.seriesInstanceUID)));
            if (showInstancesRejectedByCodes.length > 0) {
                y = this.cb.and((Expression)y, (Expression)ri.get(RejectedInstance_.rejectionNoteCode).in((Object[])showInstancesRejectedByCodes));
            }
            predicates.add(this.cb.exists(sq.select((Expression)ri).where((Expression)y)));
        }
        AttributeFilter attrFilter = queryParam.getAttributeFilter(Entity.Series);
        this.wildCard(predicates, (Expression<String>)series.get(Series_.seriesCustomAttribute1), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute1(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)series.get(Series_.seriesCustomAttribute2), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute2(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)series.get(Series_.seriesCustomAttribute3), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute3(), (String)"*"), true);
        if (queryParam.isIncomplete()) {
            predicates.add(this.cb.notEqual((Expression)series.get(Series_.completeness), (Object)Completeness.COMPLETE));
        }
        if (queryParam.isRetrieveFailed()) {
            predicates.add(this.cb.greaterThan((Expression)series.get(Series_.failedRetrieves), (Comparable)Integer.valueOf(0)));
        }
        if (queryParam.isStorageVerificationFailed()) {
            predicates.add(this.cb.greaterThan((Expression)series.get(Series_.failuresOfLastStorageVerification), (Comparable)Integer.valueOf(0)));
        }
        if (queryParam.isMetadataUpdateFailed()) {
            predicates.add(this.cb.greaterThan((Expression)series.get(Series_.metadataUpdateFailures), (Comparable)Integer.valueOf(0)));
        }
        if (queryParam.isCompressionFailed()) {
            predicates.add(this.cb.greaterThan((Expression)series.get(Series_.compressionFailures), (Comparable)Integer.valueOf(0)));
        }
        this.anyOf(predicates, (Expression<String>)series.get(Series_.sendingAET), keys.getStrings("DCM4CHEE Archive 5", 0x77770037, VR.AE), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.receivingAET), keys.getStrings("DCM4CHEE Archive 5", 2004287592, VR.AE), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.sendingPresentationAddress), keys.getStrings("DCM4CHEE Archive 5", 2004287593, VR.UR), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.receivingPresentationAddress), keys.getStrings("DCM4CHEE Archive 5", 2004287594, VR.UR), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.sendingHL7Application), keys.getStrings("DCM4CHEE Archive 5", 2004287595, VR.LO), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.sendingHL7Facility), keys.getStrings("DCM4CHEE Archive 5", 2004287596, VR.LO), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.receivingHL7Application), keys.getStrings("DCM4CHEE Archive 5", 2004287597, VR.LO), false);
        this.anyOf(predicates, (Expression<String>)series.get(Series_.receivingHL7Facility), keys.getStrings("DCM4CHEE Archive 5", 2004287598, VR.LO), false);
        if (queryParam.getExpirationDate() != null) {
            this.dateRange(predicates, (Path<String>)series.get(Series_.expirationDate), queryParam.getExpirationDate(), FormatDate.DA);
        }
        return predicates;
    }

    private <T> void instanceLevelPredicates(List<Predicate> predicates, CriteriaQuery<T> q, Path<Study> study, Path<Series> series, Root<Instance> instance, Attributes keys, QueryParam queryParam, CodeEntity[] showInstancesRejectedByCodes, CodeEntity[] hideRejectionNoteWithCodes) {
        boolean combinedDatetimeMatching = queryParam.isCombinedDatetimeMatching();
        this.anyOf(predicates, (Expression<String>)instance.get(Instance_.sopInstanceUID), keys.getStrings(524312), false);
        this.anyOf(predicates, (Expression<String>)instance.get(Instance_.sopClassUID), keys.getStrings(524310), false);
        this.numberPredicate(predicates, (Expression<Integer>)instance.get(Instance_.instanceNumber), keys.getString(2097171, "*"));
        this.anyOf(predicates, (Expression<String>)instance.get(Instance_.verificationFlag), QueryBuilder.toUpperCase(keys.getStrings(4236435)), false);
        this.anyOf(predicates, (Expression<String>)instance.get(Instance_.completionFlag), QueryBuilder.toUpperCase(keys.getStrings(4236433)), false);
        this.dateRange(predicates, (Path<String>)instance.get(Instance_.contentDate), (Path<String>)instance.get(Instance_.contentTime), 524323, 524339, 2251950138064947L, keys, combinedDatetimeMatching);
        if (!this.code(predicates, (Path<CodeEntity>)instance.get(Instance_.conceptNameCode), keys.getNestedDataset(4235331))) {
            this.hideRejectionNote(predicates, (Path<Instance>)instance, hideRejectionNoteWithCodes);
        }
        Attributes reqAttrs = keys.getNestedDataset(4236144);
        this.instanceRequestAttributes(predicates, q, (From)instance, reqAttrs, queryParam);
        this.verifyingObserver(predicates, q, instance, keys.getNestedDataset(4235379), queryParam);
        Sequence contentSeq = keys.getSequence(4237104);
        if (contentSeq != null) {
            for (Attributes item : contentSeq) {
                this.contentItem(predicates, q, instance, item);
            }
        }
        AttributeFilter attrFilter = queryParam.getAttributeFilter(Entity.Instance);
        this.wildCard(predicates, (Expression<String>)instance.get(Instance_.instanceCustomAttribute1), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute1(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)instance.get(Instance_.instanceCustomAttribute2), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute2(), (String)"*"), true);
        this.wildCard(predicates, (Expression<String>)instance.get(Instance_.instanceCustomAttribute3), AttributeFilter.selectStringValue((Attributes)keys, (ValueSelector)attrFilter.getCustomAttribute3(), (String)"*"), true);
        this.hideRejectedInstance(predicates, q, study, series, (Path<Instance>)instance, showInstancesRejectedByCodes, queryParam.isHideNotRejectedInstances());
    }

    public <T> List<Predicate> sopInstanceRefs(CriteriaQuery<T> q, Path<Study> study, Path<Series> series, Root<Instance> instance, String studyIUID, String objectUID, QueryRetrieveView qrView, CodeEntity[] showInstancesRejectedByCodes, CodeEntity[] hideRejectionNoteWithCodes, String ... seriesUID) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(this.cb.equal((Expression)study.get(Study_.studyInstanceUID), (Object)studyIUID));
        if (!QueryBuilder.isUniversalMatching(seriesUID)) {
            this.uidsPredicate(predicates, (Path<String>)series.get(Series_.seriesInstanceUID), seriesUID);
        }
        if (!QueryBuilder.isUniversalMatching(objectUID)) {
            predicates.add(this.cb.equal((Expression)instance.get(Instance_.sopInstanceUID), (Object)objectUID));
        }
        this.hideRejectedInstance((List<Predicate>)predicates, q, study, series, (Path<Instance>)instance, showInstancesRejectedByCodes, qrView.isHideNotRejectedInstances());
        this.hideRejectionNote((List<Predicate>)predicates, (Path<Instance>)instance, hideRejectionNoteWithCodes);
        return predicates;
    }

    private <T> void mwlItemLevelPredicates(List<Predicate> predicates, CriteriaQuery<T> q, Root<MWLItem> mwlItem, Attributes keys, QueryParam queryParam) {
        String admissionID;
        this.anyOf(predicates, (Expression<String>)mwlItem.get(MWLItem_.worklistLabel), keys.getStrings(7606786), false, true);
        this.anyOf(predicates, (Expression<String>)mwlItem.get(MWLItem_.studyInstanceUID), keys.getStrings(0x20000D), false);
        this.anyOf(predicates, (Expression<String>)mwlItem.get(MWLItem_.requestedProcedureID), keys.getStrings(0x401001), false);
        String accNo = keys.getString(524368, "*");
        if (!QueryBuilder.isUniversalMatching(accNo)) {
            Issuer issuer = Issuer.valueOf((Attributes)keys.getNestedDataset(524369));
            if (issuer == null) {
                issuer = queryParam.getDefaultIssuerOfAccessionNumber();
            }
            if (this.wildCard(predicates, (Expression<String>)mwlItem.get(MWLItem_.accessionNumber), accNo) && issuer != null) {
                this.issuer(predicates, (Path<String>)mwlItem.get(MWLItem_.accessionNumberLocalNamespaceEntityID), (Path<String>)mwlItem.get(MWLItem_.accessionNumberUniversalEntityID), (Path<String>)mwlItem.get(MWLItem_.accessionNumberUniversalEntityIDType), issuer);
            }
        }
        Attributes sps = keys.getNestedDataset(0x400100);
        String[] spsStatus = null;
        if (sps != null) {
            this.anyOf(predicates, (Expression<String>)mwlItem.get(MWLItem_.scheduledProcedureStepID), sps.getStrings(0x400009), false);
            this.dateRange(predicates, (Path<String>)mwlItem.get(MWLItem_.scheduledStartDate), (Path<String>)mwlItem.get(MWLItem_.scheduledStartTime), 0x400002, 0x400003, 18014407103610883L, sps, true);
            this.personName(predicates, q, (From)mwlItem, (SingularAttribute)MWLItem_.scheduledPerformingPhysicianName, sps.getString(0x400006, "*"), queryParam);
            this.anyOf(predicates, (Expression<String>)mwlItem.get(MWLItem_.modality), QueryBuilder.toUpperCase(sps.getStrings(524384)), false);
            spsStatus = sps.getStrings(0x400020);
            this.anyOf(predicates, mwlItem.get(MWLItem_.status), SPSStatus::valueOf, QueryBuilder.toUpperCase(spsStatus));
            String spsAET = sps.getString(0x400001, "*");
            if (!QueryBuilder.isUniversalMatching(spsAET)) {
                predicates.add(this.cb.isMember((Object)spsAET, mwlItem.get((PluralAttribute)MWLItem_.scheduledStationAETs)));
            }
        }
        if (spsStatus == null || spsStatus.length == 0) {
            this.hideSPSWithStatus(predicates, (Path<MWLItem>)mwlItem, queryParam);
        }
        if (!QueryBuilder.isUniversalMatching(admissionID = keys.getString(3670032, "*"))) {
            Issuer issuer = Issuer.valueOf((Attributes)keys.getNestedDataset(3670036));
            if (issuer == null) {
                issuer = queryParam.getDefaultIssuerOfAdmissionID();
            }
            if (this.wildCard(predicates, (Expression<String>)mwlItem.get(MWLItem_.admissionID), admissionID) && issuer != null) {
                this.issuer(predicates, (Path<String>)mwlItem.get(MWLItem_.admissionIDLocalNamespaceEntityID), (Path<String>)mwlItem.get(MWLItem_.admissionIDUniversalEntityID), (Path<String>)mwlItem.get(MWLItem_.admissionIDUniversalEntityIDType), issuer);
            }
        }
        this.anyOf(predicates, (Expression<String>)mwlItem.get(MWLItem_.institutionName), keys.getStrings(524416), true);
        this.code(predicates, (Path<CodeEntity>)mwlItem.get(MWLItem_.institutionCode), keys.getNestedDataset(524418));
        this.anyOf(predicates, (Expression<String>)mwlItem.get(MWLItem_.institutionalDepartmentName), keys.getStrings(528448), true);
        this.code(predicates, (Path<CodeEntity>)mwlItem.get(MWLItem_.institutionalDepartmentTypeCode), keys.getNestedDataset(528449));
    }

    private <T> boolean anyOf(List<Predicate> predicates, Path<T> path, Function<String, T> valueOf, String[] names) {
        if (QueryBuilder.isUniversalMatching(names)) {
            return false;
        }
        if (names.length == 1) {
            try {
                predicates.add(this.cb.equal(path, valueOf.apply(names[0])));
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        ArrayList<Predicate> y = new ArrayList<Predicate>(names.length);
        for (String name : names) {
            if (QueryBuilder.isUniversalMatching(name)) {
                return false;
            }
            try {
                y.add(this.cb.equal(path, valueOf.apply(name)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (y.isEmpty()) {
            return false;
        }
        predicates.add(this.cb.or(y.toArray(new Predicate[0])));
        return true;
    }

    private void hideSPSWithStatus(List<Predicate> predicates, Path<MWLItem> mwlItem, QueryParam queryParam) {
        Object[] hideSPSWithStatusFromMWL = queryParam.getHideSPSWithStatusFromMWL();
        if (hideSPSWithStatusFromMWL.length > 0) {
            predicates.add(mwlItem.get(MWLItem_.status).in(hideSPSWithStatusFromMWL).not());
        }
    }

    private <T> void upsLevelPredicates(List<Predicate> predicates, CriteriaQuery<T> q, Root<UPS> ups, Attributes keys, QueryParam queryParam) {
        this.anyOf(predicates, (Expression<String>)ups.get(UPS_.upsInstanceUID), keys.getStrings(524312), false);
        this.anyOf(predicates, ups.get(UPS_.upsPriority), UPSPriority::valueOf, QueryBuilder.toUpperCase(keys.getStrings(7606784)));
        this.dateRange(predicates, (Path<Date>)ups.get(UPS_.updatedTime), keys.getDateRange(0x404010));
        this.anyOf(predicates, (Expression<String>)ups.get(UPS_.upsLabel), keys.getStrings(7606788), true);
        this.anyOf(predicates, (Expression<String>)ups.get(UPS_.worklistLabel), keys.getStrings(7606786), true);
        this.codes(predicates, q, (From)ups, (CollectionAttribute)UPS_.scheduledStationNameCodes, keys.getNestedDataset(4210725));
        this.codes(predicates, q, (From)ups, (CollectionAttribute)UPS_.scheduledStationClassCodes, keys.getNestedDataset(4210726));
        this.codes(predicates, q, (From)ups, (CollectionAttribute)UPS_.scheduledStationGeographicLocationCodes, keys.getNestedDataset(4210727));
        Attributes scheduledHumanPerformersSequence = keys.getNestedDataset(0x404034);
        if (scheduledHumanPerformersSequence != null) {
            this.codes(predicates, q, (From)ups, (CollectionAttribute)UPS_.humanPerformerCodes, scheduledHumanPerformersSequence.getNestedDataset(0x404009));
        }
        if (queryParam.isTemplate()) {
            predicates.add(this.cb.equal((Expression)ups.get(UPS_.scheduledStartDateAndTime), (Object)"*"));
        } else {
            this.dateRange(predicates, (Path<String>)ups.get(UPS_.scheduledStartDateAndTime), keys.getDateRange(0x404005), FormatDate.DT);
            predicates.add(this.cb.notEqual((Expression)ups.get(UPS_.scheduledStartDateAndTime), (Object)"*"));
        }
        this.dateRange(predicates, (Path<String>)ups.get(UPS_.expectedCompletionDateAndTime), keys.getDateRange(0x404011), FormatDate.DT);
        this.dateRange(predicates, (Path<String>)ups.get(UPS_.scheduledProcedureStepExpirationDateTime), keys.getDateRange(0x404008), FormatDate.DT);
        this.code(predicates, (Path<CodeEntity>)ups.get(UPS_.scheduledWorkitemCode), keys.getNestedDataset(4210712));
        this.anyOf(predicates, ups.get(UPS_.inputReadinessState), InputReadinessState::valueOf, QueryBuilder.toUpperCase(keys.getStrings(0x404041)));
        String admissionID = keys.getString(3670032, "*");
        if (!QueryBuilder.isUniversalMatching(admissionID)) {
            Issuer issuer = Issuer.valueOf((Attributes)keys.getNestedDataset(3670036));
            if (issuer == null) {
                issuer = queryParam.getDefaultIssuerOfAdmissionID();
            }
            if (this.wildCard(predicates, (Expression<String>)ups.get(UPS_.admissionID), admissionID) && issuer != null) {
                this.issuer(predicates, (Path<String>)ups.get(UPS_.admissionIDLocalNamespaceEntityID), (Path<String>)ups.get(UPS_.admissionIDUniversalEntityID), (Path<String>)ups.get(UPS_.admissionIDUniversalEntityIDType), issuer);
            }
        }
        this.upsRequestAttributes(predicates, q, ups, keys.getNestedDataset(4236144), queryParam);
        Attributes replacedProcedureStep = keys.getNestedDataset(7606820);
        if (replacedProcedureStep != null) {
            this.anyOf(predicates, (Expression<String>)ups.get(UPS_.replacedSOPInstanceUID), replacedProcedureStep.getStrings(528725), false);
        }
        this.anyOf(predicates, ups.get(UPS_.procedureStepState), UPSState::fromString, QueryBuilder.toUpperCase(keys.getStrings(7606272)));
        this.notSubscribedBy(predicates, q, (From)ups, queryParam.getNotSubscribedByAET());
    }

    private <T> void mppsLevelPredicates(List<Predicate> predicates, CriteriaQuery<T> q, Root<MPPS> mpps, Attributes keys, QueryParam queryParam) {
        this.anyOf(predicates, (Expression<String>)mpps.get(MPPS_.sopInstanceUID), keys.getStrings(524312), true);
        this.dateRange(predicates, (Path<String>)mpps.get(MPPS_.performedProcedureStepStartDate), (Path<String>)mpps.get(MPPS_.performedProcedureStepStartTime), 0x400244, 0x400244, 18016889594708549L, keys, true);
        this.anyOf(predicates, mpps.get(MPPS_.status), MPPS.Status::valueOf, QueryBuilder.toUpperCase(keys.getStrings(4194898)));
        Attributes ssa = keys.getNestedDataset(4194928);
        if (ssa != null) {
            this.anyOf(predicates, (Expression<String>)mpps.get(MPPS_.studyInstanceUID), ssa.getStrings(0x20000D), false);
            String accNo = ssa.getString(524368, "*");
            if (!QueryBuilder.isUniversalMatching(accNo)) {
                Issuer issuer = Issuer.valueOf((Attributes)ssa.getNestedDataset(524369));
                if (issuer == null) {
                    issuer = queryParam.getDefaultIssuerOfAccessionNumber();
                }
                if (this.wildCard(predicates, (Expression<String>)mpps.get(MPPS_.accessionNumber), accNo) && issuer != null) {
                    this.issuer(predicates, (Path<String>)mpps.get(MPPS_.accessionNumberLocalNamespaceEntityID), (Path<String>)mpps.get(MPPS_.accessionNumberUniversalEntityID), (Path<String>)mpps.get(MPPS_.accessionNumberUniversalEntityIDType), issuer);
                }
            }
        }
    }

    public <T> void hideRejectedInstance(List<Predicate> predicates, CriteriaQuery<T> q, Path<Study> study, Path<Series> series, Path<Instance> instance, CodeEntity[] codes, boolean hideNotRejectedInstances) {
        Subquery sq = q.subquery(RejectedInstance.class);
        Root ri = sq.from(RejectedInstance.class);
        Predicate[] y = new Predicate[codes.length > 0 ? 4 : 3];
        y[0] = this.cb.equal((Expression)ri.get(RejectedInstance_.studyInstanceUID), (Expression)study.get(Study_.studyInstanceUID));
        y[1] = this.cb.equal((Expression)ri.get(RejectedInstance_.seriesInstanceUID), (Expression)series.get(Series_.seriesInstanceUID));
        y[2] = this.cb.equal((Expression)ri.get(RejectedInstance_.sopInstanceUID), (Expression)instance.get(Instance_.sopInstanceUID));
        if (codes.length > 0) {
            y[3] = ri.get(RejectedInstance_.rejectionNoteCode).in((Object[])codes);
            if (!hideNotRejectedInstances) {
                y[3] = y[3].not();
            }
        }
        Predicate exists = this.cb.exists(sq.select((Expression)ri).where(y));
        predicates.add(hideNotRejectedInstances ? exists : exists.not());
    }

    public void hideRejectionNote(List<Predicate> predicates, Path<Instance> instance, CodeEntity[] codes) {
        if (codes.length > 0) {
            predicates.add(this.cb.or((Expression)instance.get(Instance_.conceptNameCode).isNull(), (Expression)instance.get(Instance_.conceptNameCode).in((Object[])codes).not()));
        }
    }

    private void issuer(List<Predicate> predicates, Path<String> localNamespaceEntityID, Path<String> universalEntityID, Path<String> universalEntityIDType, Issuer issuer) {
        String entityID = issuer.getLocalNamespaceEntityID();
        String entityUID = issuer.getUniversalEntityID();
        String entityUIDType = issuer.getUniversalEntityIDType();
        if (!QueryBuilder.isUniversalMatching(entityID)) {
            this.wildCardIssuer(predicates, (Expression<String>)localNamespaceEntityID, entityID);
        }
        if (!QueryBuilder.isUniversalMatching(entityUID)) {
            predicates.add(this.cb.or((Expression)universalEntityID.isNull(), (Expression)this.cb.and((Expression)this.cb.equal(universalEntityID, (Object)entityUID), (Expression)this.cb.equal(universalEntityIDType, (Object)entityUIDType))));
        }
    }

    private static boolean isUniversalMatching(Attributes item) {
        return item == null || item.isEmpty();
    }

    private static boolean isUniversalMatching(String value) {
        return value == null || value.equals("*");
    }

    public static boolean isUniversalMatching(String[] values) {
        return values == null || values.length == 0 || values[0] == null || values[0].equals("*");
    }

    public static boolean isUniversalMatching(IDWithIssuer[] pids) {
        for (IDWithIssuer pid : pids) {
            if (QueryBuilder.isUniversalMatching(pid.getID())) continue;
            return false;
        }
        return true;
    }

    private static boolean isUniversalMatching(Issuer issuer) {
        return issuer == null || QueryBuilder.isUniversalMatching(issuer.getLocalNamespaceEntityID()) && QueryBuilder.isUniversalMatching(issuer.getUniversalEntityID());
    }

    private static boolean isUniversalMatching(DateRange range) {
        return range == null || range.getStartDate() == null && range.getEndDate() == null;
    }

    private boolean anyOf(List<Predicate> predicates, Expression<String> path, String[] values, boolean ignoreCase) {
        return this.anyOf(predicates, path, values, ignoreCase, false);
    }

    private boolean anyOf(List<Predicate> predicates, Expression<String> path, String[] values, boolean ignoreCase, boolean matchNotAvailable) {
        if (QueryBuilder.isUniversalMatching(values)) {
            return false;
        }
        if (values.length == 1 && !matchNotAvailable) {
            return this.wildCard(predicates, path, values[0], ignoreCase);
        }
        ArrayList<Predicate> y = new ArrayList<Predicate>(values.length);
        for (String value : values) {
            if (this.wildCard(y, path, value, ignoreCase)) continue;
            return false;
        }
        if (matchNotAvailable) {
            y.add(this.cb.equal(path, (Object)"*"));
        }
        predicates.add(this.cb.or(y.toArray(new Predicate[0])));
        return true;
    }

    private boolean wildCard(List<Predicate> predicates, Expression<String> path, String value) {
        return this.wildCard(predicates, path, value, false);
    }

    private boolean wildCard(List<Predicate> predicates, Expression<String> path, String value, boolean ignoreCase) {
        if (QueryBuilder.isUniversalMatching(value)) {
            return false;
        }
        if (ignoreCase && StringUtils.isUpperCase((String)value)) {
            path = this.cb.upper(path);
        }
        if (QueryBuilder.containsWildcard(value)) {
            String pattern = QueryBuilder.toLikePattern(value);
            if (pattern.equals("%")) {
                return false;
            }
            predicates.add(this.cb.like(path, pattern, '!'));
        } else {
            predicates.add(this.cb.equal(path, (Object)value));
        }
        return true;
    }

    private boolean wildCardIssuer(List<Predicate> predicates, Expression<String> path, String value) {
        if (QueryBuilder.containsWildcard(value)) {
            String pattern = QueryBuilder.toLikePattern(value);
            if (pattern.equals("%")) {
                return false;
            }
            predicates.add(this.cb.or((Expression)path.isNull(), (Expression)this.cb.like(path, pattern, '!')));
        } else {
            predicates.add(this.cb.or((Expression)path.isNull(), (Expression)this.cb.equal(path, (Object)value)));
        }
        return true;
    }

    private void numberPredicate(List<Predicate> predicates, Expression<Integer> path, String value) {
        if (!QueryBuilder.isUniversalMatching(value)) {
            try {
                predicates.add(this.cb.equal(path, (Object)Integer.parseInt(value)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static boolean containsWildcard(String s) {
        return s.indexOf(42) >= 0 || s.indexOf(63) >= 0;
    }

    private static String toLikePattern(String s) {
        StringBuilder like = new StringBuilder(s.length());
        char[] cs = s.toCharArray();
        char p = '\u0000';
        for (char c : cs) {
            switch (c) {
                case '*': {
                    if (c == p) break;
                    like.append('%');
                    break;
                }
                case '?': {
                    like.append('_');
                    break;
                }
                case '!': 
                case '%': 
                case '_': {
                    like.append('!');
                }
                default: {
                    like.append(c);
                }
            }
            p = c;
        }
        return like.toString();
    }

    private static String[] toUpperCase(String[] ss) {
        if (ss != null) {
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i].toUpperCase();
            }
        }
        return ss;
    }

    private <T> void seriesAttributesInStudy(List<Predicate> predicates, CriteriaQuery<T> q, Path<Study> study, Attributes keys, QueryParam queryParam, QueryRetrieveLevel2 queryRetrieveLevel, String ... modalitiesInStudy) {
        Subquery sq = q.subquery(Series.class);
        Root series = sq.from(Series.class);
        ArrayList<Predicate> y = new ArrayList<Predicate>();
        this.anyOf(y, (Expression<String>)series.get(Series_.modality), QueryBuilder.toUpperCase(modalitiesInStudy), false);
        Object[] cuidsInStudy = keys.getStrings(524386);
        if (!QueryBuilder.isUniversalMatching((String[])cuidsInStudy)) {
            if (queryParam.isMatchSOPClassOnInstanceLevel()) {
                Subquery ssq = sq.subquery(Instance.class);
                Root inst = ssq.from(Instance.class);
                y.add(this.cb.or((Expression)series.get(Series_.sopClassUID).in(cuidsInStudy), (Expression)this.cb.exists(ssq.select((Expression)inst).where(new Predicate[]{this.cb.equal((Expression)inst.get(Instance_.series), (Expression)series), inst.get(Instance_.sopClassUID).in(cuidsInStudy)}))));
            } else {
                y.add(series.get(Series_.sopClassUID).in(cuidsInStudy));
            }
        }
        if (queryRetrieveLevel == QueryRetrieveLevel2.STUDY) {
            this.anyOf(y, (Expression<String>)series.get(Series_.institutionName), keys.getStrings(524416), true);
            this.anyOf(y, (Expression<String>)series.get(Series_.institutionalDepartmentName), keys.getStrings(528448), true);
            this.anyOf(y, (Expression<String>)series.get(Series_.stationName), keys.getStrings(528400), true);
            this.anyOf(y, (Expression<String>)series.get(Series_.seriesDescription), keys.getStrings(528446), true);
            this.anyOf(y, (Expression<String>)series.get(Series_.bodyPartExamined), QueryBuilder.toUpperCase(keys.getStrings(1572885)), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.laterality), QueryBuilder.toUpperCase(keys.getStrings(0x200060)), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.sendingAET), keys.getStrings("DCM4CHEE Archive 5", 0x77770037, VR.AE), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.receivingAET), keys.getStrings("DCM4CHEE Archive 5", 2004287592, VR.AE), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.sendingPresentationAddress), keys.getStrings("DCM4CHEE Archive 5", 2004287593, VR.UR), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.receivingPresentationAddress), keys.getStrings("DCM4CHEE Archive 5", 2004287594, VR.UR), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.sendingHL7Application), keys.getStrings("DCM4CHEE Archive 5", 2004287595, VR.LO), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.sendingHL7Facility), keys.getStrings("DCM4CHEE Archive 5", 2004287596, VR.LO), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.receivingHL7Application), keys.getStrings("DCM4CHEE Archive 5", 2004287597, VR.LO), false);
            this.anyOf(y, (Expression<String>)series.get(Series_.receivingHL7Facility), keys.getStrings("DCM4CHEE Archive 5", 2004287598, VR.LO), false);
            if (queryParam.isStorageVerificationFailed()) {
                y.add(this.cb.greaterThan((Expression)series.get(Series_.failuresOfLastStorageVerification), (Comparable)Integer.valueOf(0)));
            }
            if (queryParam.isMetadataUpdateFailed()) {
                y.add(this.cb.greaterThan((Expression)series.get(Series_.metadataUpdateFailures), (Comparable)Integer.valueOf(0)));
            }
            if (queryParam.isCompressionFailed()) {
                y.add(this.cb.greaterThan((Expression)series.get(Series_.compressionFailures), (Comparable)Integer.valueOf(0)));
            }
            this.code(y, (Path<CodeEntity>)series.get(Series_.institutionalDepartmentTypeCode), keys.getNestedDataset(528449));
        }
        if (!y.isEmpty()) {
            y.add(this.cb.equal((Expression)series.get(Series_.study), study));
            predicates.add(this.cb.exists(sq.select((Expression)series).where(y.toArray(new Predicate[0]))));
        }
    }

    private boolean code(List<Predicate> predicates, Path<CodeEntity> code, Attributes item) {
        if (QueryBuilder.isUniversalMatching(item)) {
            return false;
        }
        boolean result = this.wildCard(predicates, (Expression<String>)code.get(CodeEntity_.codeValue), item.getString(524544, "*"));
        result = this.wildCard(predicates, (Expression<String>)code.get(CodeEntity_.codingSchemeDesignator), item.getString(524546, "*")) || result;
        result = this.wildCard(predicates, (Expression<String>)code.get(CodeEntity_.codingSchemeVersion), item.getString(524547, "*")) || result;
        return result;
    }

    private <T, Z, X> void codes(List<Predicate> predicates, CriteriaQuery<T> q, From<Z, X> from, CollectionAttribute<X, CodeEntity> collection, Attributes item) {
        if (QueryBuilder.isUniversalMatching(item)) {
            return;
        }
        Subquery sq = q.subquery(CodeEntity.class);
        From<Z, X> sqFrom = QueryBuilder.correlate(sq, from);
        CollectionJoin code = sqFrom.join(collection);
        ArrayList<Predicate> y = new ArrayList<Predicate>();
        this.code(y, (Path<CodeEntity>)code, item);
        if (!y.isEmpty()) {
            predicates.add(this.cb.exists(sq.select((Expression)code).where(y.toArray(new Predicate[0]))));
        }
    }

    private <T, Z> void notSubscribedBy(List<Predicate> predicates, CriteriaQuery<T> q, From<Z, UPS> ups, String subscriberAET) {
        if (subscriberAET == null) {
            return;
        }
        Subquery sq = q.subquery(Subscription.class);
        From<Z, UPS> sqUPS = QueryBuilder.correlate(sq, ups);
        CollectionJoin sub = sqUPS.join(UPS_.subscriptions);
        predicates.add(this.cb.exists(sq.select((Expression)sub).where((Expression)this.cb.equal((Expression)sub.get(Subscription_.subscriberAET), (Object)subscriberAET))).not());
    }

    private <T, Z> void requestAttributes(List<Predicate> predicates, CriteriaQuery<T> q, From<Z, Series> series, Attributes item, QueryParam queryParam) {
        if (QueryBuilder.isUniversalMatching(item)) {
            String requested = queryParam.getRequested();
            if (requested != null) {
                predicates.add(Boolean.parseBoolean(requested) ? this.cb.isNotEmpty(series.get((PluralAttribute)Series_.requestAttributes)) : this.cb.isEmpty(series.get((PluralAttribute)Series_.requestAttributes)));
            }
            return;
        }
        Subquery sq = q.subquery(SeriesRequestAttributes.class);
        From<Z, Series> sqSeries = QueryBuilder.correlate(sq, series);
        CollectionJoin request = sqSeries.join(Series_.requestAttributes);
        ArrayList<Predicate> requestPredicates = new ArrayList<Predicate>();
        String accNo = item.getString(524368, "*");
        if (!QueryBuilder.isUniversalMatching(accNo)) {
            Issuer issuerOfAccessionNumber = Issuer.valueOf((Attributes)item.getNestedDataset(524369));
            if (issuerOfAccessionNumber == null) {
                issuerOfAccessionNumber = queryParam.getDefaultIssuerOfAccessionNumber();
            }
            if (this.wildCard(requestPredicates, (Expression<String>)request.get(SeriesRequestAttributes_.accessionNumber), accNo) && issuerOfAccessionNumber != null) {
                this.issuer(requestPredicates, (Path<String>)request.get(SeriesRequestAttributes_.accessionNumberLocalNamespaceEntityID), (Path<String>)request.get(SeriesRequestAttributes_.accessionNumberUniversalEntityID), (Path<String>)request.get(SeriesRequestAttributes_.accessionNumberUniversalEntityIDType), issuerOfAccessionNumber);
            }
        }
        this.anyOf(requestPredicates, (Expression<String>)request.get(SeriesRequestAttributes_.requestingService), item.getStrings(3280947), true);
        this.personName((List<Predicate>)requestPredicates, q, (From)request, (SingularAttribute)SeriesRequestAttributes_.requestingPhysician, item.getString(3280946, "*"), queryParam);
        this.anyOf(requestPredicates, (Expression<String>)request.get(SeriesRequestAttributes_.requestedProcedureID), item.getStrings(0x401001), false);
        this.anyOf(requestPredicates, (Expression<String>)request.get(SeriesRequestAttributes_.studyInstanceUID), item.getStrings(0x20000D), false);
        this.anyOf(requestPredicates, (Expression<String>)request.get(SeriesRequestAttributes_.scheduledProcedureStepID), item.getStrings(0x400009), false);
        if (!requestPredicates.isEmpty()) {
            predicates.add(this.cb.exists(sq.select((Expression)request).where(requestPredicates.toArray(new Predicate[0]))));
        }
    }

    private <T, Z> void instanceRequestAttributes(List<Predicate> predicates, CriteriaQuery<T> q, From<Z, Instance> instance, Attributes item, QueryParam queryParam) {
        if (QueryBuilder.isUniversalMatching(item)) {
            return;
        }
        Subquery sq = q.subquery(InstanceRequestAttributes.class);
        From<Z, Instance> sqSeries = QueryBuilder.correlate(sq, instance);
        CollectionJoin request = sqSeries.join(Instance_.requestAttributes);
        ArrayList<Predicate> requestPredicates = new ArrayList<Predicate>();
        String accNo = item.getString(524368, "*");
        if (!QueryBuilder.isUniversalMatching(accNo)) {
            Issuer issuerOfAccessionNumber = Issuer.valueOf((Attributes)item.getNestedDataset(524369));
            if (issuerOfAccessionNumber == null) {
                issuerOfAccessionNumber = queryParam.getDefaultIssuerOfAccessionNumber();
            }
            if (this.wildCard(requestPredicates, (Expression<String>)request.get(InstanceRequestAttributes_.accessionNumber), accNo) && issuerOfAccessionNumber != null) {
                this.issuer(requestPredicates, (Path<String>)request.get(InstanceRequestAttributes_.accessionNumberLocalNamespaceEntityID), (Path<String>)request.get(InstanceRequestAttributes_.accessionNumberUniversalEntityID), (Path<String>)request.get(InstanceRequestAttributes_.accessionNumberUniversalEntityIDType), issuerOfAccessionNumber);
            }
        }
        this.anyOf(requestPredicates, (Expression<String>)request.get(InstanceRequestAttributes_.requestingService), item.getStrings(3280947), true);
        this.personName((List<Predicate>)requestPredicates, q, (From)request, (SingularAttribute)InstanceRequestAttributes_.requestingPhysician, item.getString(3280946, "*"), queryParam);
        this.anyOf(requestPredicates, (Expression<String>)request.get(InstanceRequestAttributes_.requestedProcedureID), item.getStrings(0x401001), false);
        this.anyOf(requestPredicates, (Expression<String>)request.get(InstanceRequestAttributes_.studyInstanceUID), item.getStrings(0x20000D), false);
        this.anyOf(requestPredicates, (Expression<String>)request.get(InstanceRequestAttributes_.scheduledProcedureStepID), item.getStrings(0x400009), false);
        if (!requestPredicates.isEmpty()) {
            predicates.add(this.cb.exists(sq.select((Expression)request).where(requestPredicates.toArray(new Predicate[0]))));
        }
    }

    private <T> void upsRequestAttributes(List<Predicate> predicates, CriteriaQuery<T> q, Root<UPS> ups, Attributes item, QueryParam queryParam) {
        if (QueryBuilder.isUniversalMatching(item)) {
            return;
        }
        Subquery sq = q.subquery(UPSRequest.class);
        Root sqUPS = sq.correlate(ups);
        CollectionJoin request = sqUPS.join(UPS_.referencedRequests);
        ArrayList<Predicate> requestPredicates = new ArrayList<Predicate>();
        String accNo = item.getString(524368, "*");
        if (!QueryBuilder.isUniversalMatching(accNo)) {
            Issuer issuerOfAccessionNumber = Issuer.valueOf((Attributes)item.getNestedDataset(524369));
            if (issuerOfAccessionNumber == null) {
                issuerOfAccessionNumber = queryParam.getDefaultIssuerOfAccessionNumber();
            }
            if (this.wildCard(requestPredicates, (Expression<String>)request.get(UPSRequest_.accessionNumber), accNo) && issuerOfAccessionNumber != null) {
                this.issuer(requestPredicates, (Path<String>)request.get(UPSRequest_.accessionNumberLocalNamespaceEntityID), (Path<String>)request.get(UPSRequest_.accessionNumberUniversalEntityID), (Path<String>)request.get(UPSRequest_.accessionNumberUniversalEntityIDType), issuerOfAccessionNumber);
            }
        }
        this.anyOf(requestPredicates, (Expression<String>)request.get(UPSRequest_.requestingService), item.getStrings(3280947), true);
        this.personName((List<Predicate>)requestPredicates, q, (From)request, (SingularAttribute)UPSRequest_.requestingPhysician, item.getString(3280946, "*"), queryParam);
        this.anyOf(requestPredicates, (Expression<String>)request.get(UPSRequest_.requestedProcedureID), item.getStrings(0x401001), false);
        this.anyOf(requestPredicates, (Expression<String>)request.get(UPSRequest_.studyInstanceUID), item.getStrings(0x20000D), false);
        if (!requestPredicates.isEmpty()) {
            predicates.add(this.cb.exists(sq.select((Expression)request).where(requestPredicates.toArray(new Predicate[0]))));
        }
    }

    private static <T, Z, X> From<Z, X> correlate(Subquery<T> sq, From<Z, X> parent) {
        return parent instanceof Root ? sq.correlate((Root)parent) : sq.correlate((Join)parent);
    }

    private <T> void verifyingObserver(List<Predicate> predicates, CriteriaQuery<T> q, Root<Instance> instance, Attributes item, QueryParam queryParam) {
        if (QueryBuilder.isUniversalMatching(item)) {
            return;
        }
        Subquery sq = q.subquery(VerifyingObserver.class);
        Root sqInstance = sq.correlate(instance);
        CollectionJoin observer = sqInstance.join(Instance_.verifyingObservers);
        ArrayList<Predicate> y = new ArrayList<Predicate>();
        this.personName((List<Predicate>)y, q, (From)observer, (SingularAttribute)VerifyingObserver_.verifyingObserverName, item.getString(4235381, "*"), queryParam);
        this.dateRange(y, (Path<String>)observer.get(VerifyingObserver_.verificationDateTime), item.getDateRange(4235312), FormatDate.DT);
        if (!y.isEmpty()) {
            predicates.add(this.cb.exists(sq.select((Expression)observer).where(y.toArray(new Predicate[0]))));
        }
    }

    private <T> void contentItem(List<Predicate> predicates, CriteriaQuery<T> q, Root<Instance> instance, Attributes item) {
        String valueType = item.getString(0x40A040);
        if (!"CODE".equals(valueType) && !"TEXT".equals(valueType)) {
            return;
        }
        Subquery sq = q.subquery(ContentItem.class);
        Root sqInstance = sq.correlate(instance);
        CollectionJoin contentItem = sqInstance.join(Instance_.contentItems);
        ArrayList<Predicate> y = new ArrayList<Predicate>();
        this.code(y, (Path<CodeEntity>)contentItem.get(ContentItem_.conceptName), item.getNestedDataset(4235331));
        this.wildCard(y, (Expression<String>)contentItem.get(ContentItem_.relationshipType), item.getString(4235280, "*").toUpperCase());
        this.code(y, (Path<CodeEntity>)contentItem.get(ContentItem_.conceptCode), item.getNestedDataset(4235624));
        this.wildCard(y, (Expression<String>)contentItem.get(ContentItem_.textValue), item.getString(4235616, "*"), true);
        if (!y.isEmpty()) {
            predicates.add(this.cb.exists(sq.select((Expression)contentItem).where(y.toArray(new Predicate[0]))));
        }
    }

    private <T, Z, X> void personName(List<Predicate> predicates, CriteriaQuery<T> q, From<Z, X> patient, SingularAttribute<X, PersonName> attribute, String value, QueryParam queryParam) {
        if (!QueryBuilder.isUniversalMatching(value)) {
            String[] pnGroupValues = StringUtils.split((String)value, (char)'=');
            if (queryParam.isFuzzySemanticMatching()) {
                this.fuzzyMatch(predicates, q, (Path<PersonName>)patient.join(attribute), new org.dcm4che3.data.PersonName(pnGroupValues[0], true), queryParam);
            } else {
                this.literalMatch(predicates, (Path<PersonName>)patient.join(attribute), pnGroupValues);
            }
        }
    }

    private void literalMatch(List<Predicate> predicates, Path<PersonName> qpn, String[] pnGroupValues) {
        for (int i = 0; i < pnGroupValues.length; ++i) {
            pnGroupValues[i] = QueryBuilder.normalizePNGroupValue(pnGroupValues[i]);
        }
        if (pnGroupValues.length == 1 && !QueryBuilder.isEmptyPNGroupMatching(pnGroupValues[0])) {
            predicates.add(this.cb.or(new Predicate[]{this.match((Path<String>)qpn.get(PersonName_.alphabeticName), pnGroupValues[0], true), this.match((Path<String>)qpn.get(PersonName_.ideographicName), pnGroupValues[0], false), this.match((Path<String>)qpn.get(PersonName_.phoneticName), pnGroupValues[0], false)}));
        } else {
            if (!QueryBuilder.isUniversalMatching(pnGroupValues[0])) {
                this.match(predicates, (Path<String>)qpn.get(PersonName_.alphabeticName), pnGroupValues[0], true);
            }
            if (pnGroupValues.length >= 2 && !QueryBuilder.isUniversalMatching(pnGroupValues[1])) {
                this.match(predicates, (Path<String>)qpn.get(PersonName_.ideographicName), pnGroupValues[1], false);
            }
            if (pnGroupValues.length >= 3 && !QueryBuilder.isUniversalMatching(pnGroupValues[2])) {
                this.match(predicates, (Path<String>)qpn.get(PersonName_.phoneticName), pnGroupValues[2], false);
            }
        }
    }

    private static boolean isEmptyPNGroupMatching(String pnGroupValue) {
        return pnGroupValue.chars().allMatch(ch -> ch == 94 || ch == 42);
    }

    private static String normalizePNGroupValue(String pnGroupValue) {
        if (pnGroupValue.isEmpty()) {
            return "*";
        }
        int length = pnGroupValue.length();
        char[] value = new char[length + 2];
        pnGroupValue.getChars(0, length, value, 0);
        for (int i = 1; i < length; ++i) {
            if (value[i] != '*' || value[i - 1] != '*') continue;
            System.arraycopy(value, i + 1, value, i, --length - i);
        }
        if (value[length - 1] != '*') {
            while (length >= 2 && value[length - 1] == '*' && value[length - 2] == '^') {
                length -= 2;
            }
            value[length++] = 94;
            value[length++] = 42;
        }
        return new String(value, 0, length);
    }

    private Predicate match(Path<String> qpn, String pn, boolean ignoreCase) {
        ArrayList<Predicate> x = new ArrayList<Predicate>(1);
        this.match(x, qpn, pn, ignoreCase);
        return this.cb.and(x.toArray(new Predicate[0]));
    }

    private void match(List<Predicate> predicates, Path<String> qpn, String pn, boolean ignoreCase) {
        this.wildCard(predicates, (Expression<String>)qpn, pn, ignoreCase);
    }

    private <T> void fuzzyMatch(List<Predicate> predicates, CriteriaQuery<T> q, Path<PersonName> qpn, org.dcm4che3.data.PersonName pn, QueryParam param) {
        this.fuzzyMatch(predicates, q, qpn, pn, PersonName.Component.FamilyName, param);
        this.fuzzyMatch(predicates, q, qpn, pn, PersonName.Component.GivenName, param);
        this.fuzzyMatch(predicates, q, qpn, pn, PersonName.Component.MiddleName, param);
    }

    private <T> void fuzzyMatch(List<Predicate> predicates, CriteriaQuery<T> q, Path<PersonName> qpn, org.dcm4che3.data.PersonName pn, PersonName.Component c, QueryParam param) {
        String name = pn.get(c);
        if (QueryBuilder.isUniversalMatching(name)) {
            return;
        }
        Iterator parts = SoundexCode.tokenizePersonNameComponent((String)name);
        int i = 0;
        while (parts.hasNext()) {
            this.fuzzyMatch(predicates, q, qpn, c, i, (String)parts.next(), param);
            ++i;
        }
    }

    private <T> void fuzzyMatch(List<Predicate> predicates, CriteriaQuery<T> q, Path<PersonName> qpn, PersonName.Component c, int partIndex, String name, QueryParam param) {
        boolean wc = name.endsWith("*");
        if (wc && (name = name.substring(0, name.length() - 1)).isEmpty()) {
            return;
        }
        FuzzyStr fuzzyStr = param.getFuzzyStr();
        String fuzzyName = fuzzyStr.toFuzzy(name);
        if (fuzzyName.isEmpty()) {
            if (wc) {
                return;
            }
            fuzzyName = "*";
        }
        Subquery sq = q.subquery(SoundexCode.class);
        Root soundexCode = sq.from(SoundexCode.class);
        Predicate y = this.cb.and((Expression)this.cb.equal((Expression)soundexCode.get(SoundexCode_.personName), qpn), (Expression)(wc ? this.cb.like((Expression)soundexCode.get(SoundexCode_.codeValue), fuzzyName + "%") : this.cb.equal((Expression)soundexCode.get(SoundexCode_.codeValue), (Object)fuzzyName)));
        if (!param.isPersonNameComponentOrderInsensitiveMatching()) {
            y = this.cb.and((Expression)y, (Expression)this.cb.and((Expression)this.cb.equal((Expression)soundexCode.get(SoundexCode_.personNameComponent), (Object)c), (Expression)this.cb.equal((Expression)soundexCode.get(SoundexCode_.componentPartIndex), (Object)partIndex)));
        }
        predicates.add(this.cb.exists(sq.select((Expression)soundexCode).where((Expression)y)));
    }

    public void matchExportBatch(List<Predicate> predicates, TaskQueryParam taskQueryParam, Path<Task> task) {
        if (!taskQueryParam.getExporterIDs().isEmpty()) {
            predicates.add(this.cb.and(new Predicate[]{task.get(Task_.exporterID).in(taskQueryParam.getExporterIDs())}));
        }
        if (taskQueryParam.getDeviceName() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.deviceName), (Object)taskQueryParam.getDeviceName()));
        }
        if (taskQueryParam.getCreatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.createdTime), taskQueryParam.getCreatedTime());
        }
        if (taskQueryParam.getUpdatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.updatedTime), taskQueryParam.getUpdatedTime());
        }
    }

    public void matchRetrieveBatch(List<Predicate> predicates, TaskQueryParam taskQueryParam, Path<Task> task) {
        if (!taskQueryParam.getQueueNames().isEmpty()) {
            predicates.add(this.cb.and(new Predicate[]{task.get(Task_.queueName).in(taskQueryParam.getQueueNames())}));
        }
        if (taskQueryParam.getDeviceName() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.deviceName), (Object)taskQueryParam.getDeviceName()));
        }
        if (taskQueryParam.getLocalAET() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.localAET), (Object)taskQueryParam.getLocalAET()));
        }
        if (taskQueryParam.getRemoteAET() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.remoteAET), (Object)taskQueryParam.getRemoteAET()));
        }
        if (taskQueryParam.getDestinationAET() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.destinationAET), (Object)taskQueryParam.getDestinationAET()));
        }
        if (taskQueryParam.getCreatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.createdTime), taskQueryParam.getCreatedTime());
        }
        if (taskQueryParam.getUpdatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.updatedTime), taskQueryParam.getUpdatedTime());
        }
    }

    public void matchStgVerBatch(List<Predicate> predicates, TaskQueryParam taskQueryParam, Path<Task> task) {
        if (taskQueryParam.getDeviceName() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.deviceName), (Object)taskQueryParam.getDeviceName()));
        }
        if (taskQueryParam.getLocalAET() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.localAET), (Object)taskQueryParam.getLocalAET()));
        }
        if (taskQueryParam.getCreatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.createdTime), taskQueryParam.getCreatedTime());
        }
        if (taskQueryParam.getUpdatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.updatedTime), taskQueryParam.getUpdatedTime());
        }
    }

    public void matchDiffBatch(List<Predicate> predicates, TaskQueryParam taskQueryParam, Path<Task> task) {
        if (taskQueryParam.getDeviceName() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.deviceName), (Object)taskQueryParam.getDeviceName()));
        }
        if (taskQueryParam.getLocalAET() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.localAET), (Object)taskQueryParam.getLocalAET()));
        }
        if (taskQueryParam.getPrimaryAET() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.remoteAET), (Object)taskQueryParam.getPrimaryAET()));
        }
        if (taskQueryParam.getSecondaryAET() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.destinationAET), (Object)taskQueryParam.getSecondaryAET()));
        }
        if (taskQueryParam.getCompareFields() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.compareFields), (Object)taskQueryParam.getCompareFields()));
        }
        if (taskQueryParam.getCheckMissing() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.checkMissing), (Object)Boolean.parseBoolean(taskQueryParam.getCheckMissing())));
        }
        if (taskQueryParam.getCheckDifferent() != null) {
            predicates.add(this.cb.equal((Expression)task.get(Task_.checkDifferent), (Object)Boolean.parseBoolean(taskQueryParam.getCheckDifferent())));
        }
        if (taskQueryParam.getCreatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.createdTime), taskQueryParam.getCreatedTime());
        }
        if (taskQueryParam.getUpdatedTime() != null) {
            this.dateRange(predicates, (Path<Date>)task.get(Task_.updatedTime), taskQueryParam.getUpdatedTime());
        }
    }

    private void dateRange(List<Predicate> predicates, Path<String> path, String s, FormatDate dt) {
        this.dateRange(predicates, path, QueryBuilder.parseDateRange(s), dt);
    }

    private void dateRange(List<Predicate> predicates, Path<String> path, DateRange range, FormatDate dt) {
        if (!QueryBuilder.isUniversalMatching(range)) {
            predicates.add(this.dateRange(path, range, dt));
            predicates.add(this.cb.notEqual(path, (Object)"*"));
        }
    }

    private Predicate dateRange(Path<String> path, DateRange range, FormatDate dt) {
        String start = QueryBuilder.format(range.getStartDate(), dt);
        String end = QueryBuilder.format(range.getEndDate(), dt);
        return start == null ? this.cb.lessThanOrEqualTo(path, (Comparable)((Object)end)) : (end == null ? this.cb.greaterThanOrEqualTo(path, (Comparable)((Object)start)) : (start.equals(end) ? this.cb.equal(path, (Object)start) : (dt.equals((Object)FormatDate.TM) && range.isStartDateExeedsEndDate() ? this.cb.or((Expression)this.cb.between(path, (Comparable)((Object)start), (Comparable)((Object)"235959.999")), (Expression)this.cb.between(path, (Comparable)((Object)"000000.000"), (Comparable)((Object)end))) : this.cb.between(path, (Comparable)((Object)start), (Comparable)((Object)end)))));
    }

    void dateRange(List<Predicate> predicates, Path<Date> path, String s) {
        DateRange range = QueryBuilder.parseDateRange(s);
        this.dateRange(predicates, path, range);
    }

    private void dateRange(List<Predicate> x, Path<Date> path, DateRange range) {
        if (!QueryBuilder.isUniversalMatching(range)) {
            x.add(this.dateRange(path, range));
        }
    }

    private Predicate dateRange(Path<Date> path, DateRange range) {
        Date startDate = range.getStartDate();
        Date endDate = range.getEndDate();
        return startDate == null ? this.cb.lessThanOrEqualTo(path, (Comparable)endDate) : (endDate == null ? this.cb.greaterThanOrEqualTo(path, (Comparable)startDate) : (startDate.equals(endDate) ? this.cb.equal(path, (Object)startDate) : this.cb.between(path, (Comparable)startDate, (Comparable)endDate)));
    }

    private static String format(Date date, FormatDate dt) {
        return date != null ? dt.format(date) : null;
    }

    private void dateRange(List<Predicate> predicates, Path<String> datePath, Path<String> timePath, int dateTag, int timeTag, long dateAndTimeTag, Attributes keys, boolean combinedDatetimeMatching) {
        DateRange dateRange = keys.getDateRange(dateTag, null);
        DateRange timeRange = keys.getDateRange(timeTag, null);
        if (combinedDatetimeMatching && !QueryBuilder.isUniversalMatching(dateRange) && !QueryBuilder.isUniversalMatching(timeRange)) {
            predicates.add(this.combinedRange(datePath, timePath, keys.getDateRange(dateAndTimeTag, null)));
            predicates.add(this.cb.notEqual(datePath, (Object)"*"));
        } else {
            this.dateRange(predicates, datePath, dateRange, FormatDate.DA);
            this.dateRange(predicates, timePath, timeRange, FormatDate.TM);
        }
    }

    private Predicate combinedRange(Path<String> datePath, Path<String> timePath, DateRange dateRange) {
        if (dateRange.getStartDate() == null) {
            return this.combinedRangeEnd(datePath, timePath, DateUtils.formatDA(null, (Date)dateRange.getEndDate()), DateUtils.formatTM(null, (Date)dateRange.getEndDate()));
        }
        if (dateRange.getEndDate() == null) {
            return this.combinedRangeStart(datePath, timePath, DateUtils.formatDA(null, (Date)dateRange.getStartDate()), DateUtils.formatTM(null, (Date)dateRange.getStartDate()));
        }
        return this.combinedRangeInterval(datePath, timePath, dateRange.getStartDate(), dateRange.getEndDate());
    }

    private Predicate combinedRangeInterval(Path<String> datePath, Path<String> timePath, Date startDateRange, Date endDateRange) {
        String startTime = DateUtils.formatTM(null, (Date)startDateRange);
        String endTime = DateUtils.formatTM(null, (Date)endDateRange);
        String startDate = DateUtils.formatDA(null, (Date)startDateRange);
        String endDate = DateUtils.formatDA(null, (Date)endDateRange);
        return endDate.equals(startDate) ? this.cb.and(new Predicate[]{this.cb.equal(datePath, (Object)startDate), this.cb.greaterThanOrEqualTo(timePath, (Comparable)((Object)startTime)), this.cb.lessThanOrEqualTo(timePath, (Comparable)((Object)endTime))}) : this.cb.and((Expression)this.combinedRangeStart(datePath, timePath, startDate, startTime), (Expression)this.combinedRangeEnd(datePath, timePath, endDate, endTime));
    }

    private Predicate combinedRangeEnd(Path<String> datePath, Path<String> timePath, String endDate, String endTime) {
        return this.cb.or((Expression)this.cb.lessThan(datePath, (Comparable)((Object)endDate)), (Expression)this.cb.and((Expression)this.cb.equal(datePath, (Object)endDate), (Expression)this.cb.or((Expression)this.cb.lessThanOrEqualTo(timePath, (Comparable)((Object)endTime)), (Expression)this.cb.equal(timePath, (Object)"*"))));
    }

    private Predicate combinedRangeStart(Path<String> datePath, Path<String> timePath, String startDate, String startTime) {
        return this.cb.or((Expression)this.cb.greaterThan(datePath, (Comparable)((Object)startDate)), (Expression)this.cb.and((Expression)this.cb.equal(datePath, (Object)startDate), (Expression)this.cb.or((Expression)this.cb.greaterThanOrEqualTo(timePath, (Comparable)((Object)startTime)), (Expression)this.cb.equal(timePath, (Object)"*"))));
    }

    private static DateRange parseDateRange(String s) {
        if (s == null) {
            return null;
        }
        String[] range = QueryBuilder.splitRange(s);
        DatePrecision precision = new DatePrecision();
        Date start = range[0] == null ? null : VR.DT.toDate((Object)range[0], null, 0, false, null, precision);
        Date end = range[1] == null ? null : VR.DT.toDate((Object)range[1], null, 0, true, null, precision);
        return new DateRange(start, end);
    }

    private static String[] splitRange(String s) {
        String[] range = new String[2];
        int delim = s.indexOf(45);
        if (delim == -1) {
            range[0] = range[1] = s;
        } else {
            if (delim > 0) {
                range[0] = s.substring(0, delim);
            }
            if (delim < s.length() - 1) {
                range[1] = s.substring(delim + 1);
            }
        }
        return range;
    }

    public static long unbox(Long value, long defaultValue) {
        return value != null ? value : defaultValue;
    }

    private static enum FormatDate {
        DA{

            @Override
            String format(Date date) {
                return DateUtils.formatDA(null, (Date)date);
            }
        }
        ,
        TM{

            @Override
            String format(Date date) {
                return DateUtils.formatTM(null, (Date)date);
            }
        }
        ,
        DT{

            @Override
            String format(Date date) {
                return DateUtils.formatDT(null, (Date)date);
            }
        };


        abstract String format(Date var1);
    }
}

