/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.AttributesBuilder;
import org.dcm4chee.arc.query.util.OrderByTag;

public class QueryAttributes {
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private final Attributes keys = new Attributes();
    private final AttributesBuilder builder = new AttributesBuilder(this.keys);
    private boolean includeAll;
    private List<int[]> modified = new ArrayList<int[]>(2);
    private final ArrayList<OrderByTag> orderByTags = new ArrayList();

    public QueryAttributes(UriInfo info, Map<String, AttributeSet> attributeSetMap) {
        this(QueryAttributes.splitAndDecode((MultivaluedMap<String, String>)info.getQueryParameters(false)), attributeSetMap);
    }

    public static MultivaluedMap<String, String> parseQueryString(String queryString) {
        String[] params;
        MultivaluedHashMap queryParameters = new MultivaluedHashMap();
        for (String param : params = queryString.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=", 2);
                try {
                    String name = URLDecoder.decode(nv[0], "UTF-8");
                    queryParameters.add((Object)name, (Object)(nv.length > 1 ? URLDecoder.decode(nv[1], "UTF-8") : ""));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String name = URLDecoder.decode(param, "UTF-8");
                queryParameters.add((Object)name, (Object)"");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return queryParameters;
    }

    private static MultivaluedMap<String, String> splitAndDecode(MultivaluedMap<String, String> queryParameters) {
        MultivaluedHashMap map = new MultivaluedHashMap();
        for (Map.Entry entry : queryParameters.entrySet()) {
            for (String values : (List)entry.getValue()) {
                for (String value : StringUtils.split((String)values, (char)',')) {
                    map.add((Object)((String)entry.getKey()), (Object)QueryAttributes.decodeURL(value));
                }
            }
        }
        return map;
    }

    private static String decodeURL(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public QueryAttributes(MultivaluedMap<String, String> map, Map<String, AttributeSet> attributeSetMap) {
        block89: for (Map.Entry entry : map.entrySet()) {
            String key;
            switch (key = (String)entry.getKey()) {
                case "includefield": {
                    this.addIncludeTag((List)entry.getValue(), attributeSetMap);
                    continue block89;
                }
                case "orderby": {
                    this.addOrderByTag((List)entry.getValue());
                    continue block89;
                }
                case "accept": 
                case "access_token": 
                case "charset": 
                case "comparefield": 
                case "count": 
                case "deletionlock": 
                case "template": 
                case "workitem": 
                case "different": 
                case "missing": 
                case "offset": 
                case "limit": 
                case "priority": 
                case "onlyWithStudies": 
                case "fuzzymatching": 
                case "retrievefailed": 
                case "compressionfailed": 
                case "delete": 
                case "filterbyscu": 
                case "patientVerificationStatus": 
                case "metadataUpdateFailed": 
                case "storageVerificationFailed": 
                case "storageVerificationPolicy": 
                case "storageVerificationUpdateLocationStatus": 
                case "storageVerificationStorageID": 
                case "incomplete": 
                case "ExternalRetrieveAET": 
                case "ExternalRetrieveAET!": 
                case "batchID": 
                case "scheduledTime": 
                case "dicomDeviceName": 
                case "queue": 
                case "dcmQueueName": 
                case "SplitStudyDateRange": 
                case "ForceQueryByStudyUID": 
                case "includedefaults": 
                case "ExpirationDate": 
                case "storageID": 
                case "storageClustered": 
                case "storageExported": 
                case "allOfModalitiesInStudy": 
                case "StudySizeInKB": 
                case "ExpirationState": 
                case "upsLabel": 
                case "upsScheduledTime": 
                case "readPixelData": 
                case "updatePolicy": 
                case "reasonForModification": 
                case "sourceOfPreviousValues": 
                case "csvPatientID": 
                case "test": 
                case "requested": 
                case "merged": 
                case "ExporterID": 
                case "FreezeExpirationDate": 
                case "allmodified": 
                case "irwf": 
                case "strategy": {
                    continue block89;
                }
                case "SendingApplicationEntityTitleOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 0x77770037, VR.AE, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "ReceivingApplicationEntityTitleOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 2004287592, VR.AE, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "SendingPresentationAddressOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 2004287593, VR.UR, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "ReceivingPresentationAddressOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 2004287594, VR.UR, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "SendingHL7ApplicationOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 2004287595, VR.LO, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "SendingHL7FacilityOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 2004287596, VR.LO, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "ReceivingHL7ApplicationOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 2004287597, VR.LO, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "ReceivingHL7FacilityOfSeries": {
                    this.keys.setString("DCM4CHEE Archive 5", 2004287598, VR.LO, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "StudyReceiveDateTime": {
                    this.keys.setString("DCM4CHEE Archive 5", 0x77770020, VR.DT, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "StudyAccessDateTime": {
                    this.keys.setString("DCM4CHEE Archive 5", 0x77770022, VR.DT, ((List)entry.getValue()).toArray(StringUtils.EMPTY_STRING));
                    continue block89;
                }
                case "modified": {
                    this.addModified((List)entry.getValue());
                    continue block89;
                }
            }
            this.addQueryKey(key, (List)entry.getValue());
        }
    }

    private void addModified(List<String> values) {
        for (String s : values) {
            for (String value : StringUtils.split((String)s, (char)',')) {
                try {
                    this.modified.add(TagUtils.parseTagPath((String)value));
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException("modified=" + s);
                }
            }
        }
    }

    private void addIncludeTag(List<String> includefields, Map<String, AttributeSet> attributeSetMap) {
        for (String s : includefields) {
            if (s.equals("all")) {
                this.includeAll = true;
                break;
            }
            for (String field : StringUtils.split((String)s, (char)',')) {
                if (this.includeAttributeSet(s, attributeSetMap)) continue;
                try {
                    int[] tagPath = TagUtils.parseTagPath((String)field);
                    this.builder.setNullIfAbsent(tagPath);
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException("includefield=" + s);
                }
            }
        }
    }

    private boolean includeAttributeSet(String includefield, Map<String, AttributeSet> attributeSetMap) {
        AttributeSet attributeSet;
        if (attributeSetMap != null && (attributeSet = attributeSetMap.get(includefield)) != null) {
            for (int tag : attributeSet.getSelection()) {
                this.builder.setNullIfAbsent(new int[]{tag});
            }
            return true;
        }
        return false;
    }

    public void addReturnTags(int ... tags) {
        for (int tag : tags) {
            this.builder.setNullIfAbsent(new int[]{tag});
        }
    }

    private void addOrderByTag(List<String> orderby) {
        for (String s : orderby) {
            try {
                for (String field : StringUtils.split((String)s, (char)',')) {
                    boolean desc = field.charAt(0) == '-';
                    int[] tags = TagUtils.parseTagPath((String)(desc ? field.substring(1) : field));
                    int tag = tags[tags.length - 1];
                    this.orderByTags.add(desc ? OrderByTag.desc(tag) : OrderByTag.asc(tag));
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("orderby=" + s);
            }
        }
    }

    public boolean isIncludeAll() {
        return this.includeAll;
    }

    public boolean isIncludePrivate() {
        return this.includeAll || this.keys.contains(0x77770010);
    }

    public Attributes getQueryKeys() {
        return this.keys;
    }

    public Attributes getReturnKeys(int[] includetags) {
        Attributes returnKeys = new Attributes(this.keys.size() + 4 + includetags.length);
        returnKeys.addAll(this.keys);
        returnKeys.setNull(524293, VR.CS);
        returnKeys.setNull(524372, VR.AE);
        returnKeys.setNull(524374, VR.CS);
        returnKeys.setNull(524801, VR.SH);
        for (int tag : includetags) {
            returnKeys.setNull(tag, DICT.vrOf(tag));
        }
        return returnKeys;
    }

    public ArrayList<OrderByTag> getOrderByTags() {
        return this.orderByTags;
    }

    private void addQueryKey(String attrPath, List<String> values) {
        try {
            this.builder.setString(TagUtils.parseTagPath((String)attrPath), values.toArray(new String[values.size()]));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(attrPath + "=" + values.get(0));
        }
    }

    public List<int[]> getModified() {
        return this.modified;
    }
}

