/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.scp;

import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicCFindSCP;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.net.service.QueryTask;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.scp.ArchiveQueryTask;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommonCFindSCP
extends BasicCFindSCP {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCFindSCP.class);
    private final EnumSet<QueryRetrieveLevel2> qrLevels;
    @Inject
    private QueryService queryService;
    @EJB
    private RunInTransaction runInTx;

    protected CommonCFindSCP(String sopClass, EnumSet<QueryRetrieveLevel2> qrLevels) {
        super(new String[]{sopClass});
        this.qrLevels = qrLevels;
    }

    protected QueryTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) throws DicomServiceException {
        LOG.info("{}: Process C-FIND RQ:\n{}", (Object)as, (Object)keys);
        String sopClassUID = rq.getString(2);
        EnumSet queryOpts = as.getQueryOptionsFor(sopClassUID);
        QueryRetrieveLevel2 qrLevel = QueryRetrieveLevel2.validateQueryIdentifier((Attributes)keys, this.qrLevels, (boolean)queryOpts.contains(QueryOption.RELATIONAL), (boolean)CommonCFindSCP.relationalQueryNegotiationLenient(as));
        QueryContext ctx = this.queryService.newQueryContextFIND(as, sopClassUID, queryOpts);
        ctx.setQueryRetrieveLevel(qrLevel);
        ctx.setQueryKeys(keys);
        ctx.setReturnKeys(this.createReturnKeys(keys));
        try {
            this.queryService.coerceAttributes(ctx);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272);
        }
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        Sequence sortingOperationSeq = (Sequence)keys.remove(7472640);
        if (sortingOperationSeq != null) {
            ctx.setOrderByTags(sortingOperationSeq.stream().map(OrderByTag::valueOf).collect(Collectors.toList()));
        }
        return new ArchiveQueryTask(as, pc, rq, keys, ctx, this.runInTx);
    }

    private static boolean relationalQueryNegotiationLenient(Association as) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtension(ArchiveAEExtension.class);
        return arcAE != null && arcAE.relationalQueryNegotiationLenient();
    }

    private Attributes createReturnKeys(Attributes keys) {
        Attributes returnKeys = new Attributes(keys.size() + 3);
        returnKeys.addAll(keys);
        returnKeys.removePrivateAttributes("DCM4CHEE Archive 5", 30583);
        returnKeys.setNull(524293, VR.CS);
        returnKeys.setNull(524372, VR.AE);
        returnKeys.setNull(524374, VR.CS);
        returnKeys.setNull(524801, VR.SH);
        return returnKeys;
    }
}

