/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.scp;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicQueryTask;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.SpanningCFindSCPPolicy;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveQueryTask
extends BasicQueryTask {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveQueryTask.class);
    private final QueryContext ctx;
    private final RunInTransaction runInTx;
    private final AttributesCoercion coercion;
    private final int uniqueKey;
    private final VR vrOfUniqueKey;
    private final String spanningCFindSCP;
    private final String[] spanningRetrieveAETs;
    private final SpanningCFindSCPPolicy spanningPolicy;
    private final int queryMaxNumberOfResults;
    private final int queryFetchSize;
    private CFindSCU cfindscu;
    private Association spanningAssoc;
    private DimseRSP spanningCFindRSP;
    private Attributes spanningMatch;
    private Query query;
    private State state = State.NOT_INITALIZED;
    private Set<String> uniqueKeys = new HashSet<String>();
    private int removeUniqueKeyFromSpanningMatch;

    public ArchiveQueryTask(Association as, PresentationContext pc, Attributes rq, Attributes keys, QueryContext ctx, RunInTransaction runInTx) {
        super(as, pc, rq, keys);
        this.ctx = ctx;
        this.runInTx = runInTx;
        this.coercion = ctx.getQueryService().getAttributesCoercion(ctx);
        this.uniqueKey = ctx.getQueryRetrieveLevel().uniqueKey();
        this.vrOfUniqueKey = ctx.getQueryRetrieveLevel().vrOfUniqueKey();
        ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
        this.spanningCFindSCP = arcAE.spanningCFindSCP();
        this.spanningRetrieveAETs = arcAE.spanningCFindSCPRetrieveAETitles();
        this.spanningPolicy = arcAE.spanningCFindSCPPolicy();
        this.queryMaxNumberOfResults = arcAE.queryMaxNumberOfResults();
        this.queryFetchSize = arcAE.getArchiveDeviceExtension().getQueryFetchSize();
    }

    public void run() {
        this.runInTx.execute(() -> super.run());
    }

    protected void close() {
        this.closeQuery();
        this.releaseSpanningAssociation();
    }

    private void closeQuery() {
        if (this.query != null) {
            this.query.close();
            this.query = null;
        }
    }

    private void releaseSpanningAssociation() {
        if (this.spanningAssoc != null) {
            try {
                this.spanningAssoc.release();
            }
            catch (IOException e) {
                LOG.info("{}: failed to release association", (Object)this.spanningAssoc, (Object)e);
            }
            this.spanningAssoc = null;
        }
    }

    protected boolean hasMoreMatches() throws DicomServiceException {
        try {
            return this.state.hasMoreMatches(this);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected Attributes nextMatch() throws DicomServiceException {
        try {
            return this.state.nextMatch(this);
        }
        catch (Exception e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected Attributes adjust(Attributes match) throws DicomServiceException {
        try {
            return this.state.adjust(this, match);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    private void initQuery() throws DicomServiceException {
        this.query = this.ctx.getQueryService().createQuery(this.ctx);
        this.setOptionalKeysNotSupported(this.query.isOptionalKeysNotSupported());
        if (this.queryMaxNumberOfResults > 0 && !this.ctx.containsUniqueKey() && this.query.fetchCount() > (long)this.queryMaxNumberOfResults) {
            throw new DicomServiceException(49152, "Request entity too large");
        }
        this.query.executeQuery(this.queryFetchSize);
    }

    private void initSpanning() throws Exception {
        this.cfindscu = this.ctx.getQueryService().cfindSCU();
        this.spanningAssoc = this.cfindscu.openAssociation(this.as.getApplicationEntity(), this.spanningCFindSCP, this.ctx.getSOPClassUID(), this.as.getQueryOptionsFor(this.ctx.getSOPClassUID()));
        Attributes spanningQueryKeys = this.spanningQueryKeys();
        this.spanningCFindRSP = this.cfindscu.query(this.spanningAssoc, 0, this.cfindscu.coerceCFindRQ(this.spanningAssoc, spanningQueryKeys), 0, 1, null);
        this.spanningCFindRSP.next();
        this.nextSpanningMatch();
    }

    private Attributes spanningQueryKeys() {
        Attributes queryKeys = this.ctx.getQueryKeys();
        if (!queryKeys.contains(this.uniqueKey)) {
            queryKeys = new Attributes(queryKeys);
            queryKeys.setNull(this.uniqueKey, this.vrOfUniqueKey);
            this.removeUniqueKeyFromSpanningMatch = this.uniqueKey;
        }
        return queryKeys;
    }

    private Attributes registerUniqueKey(Attributes match) {
        if (match != null && (this.queryMaxNumberOfResults == 0 || this.uniqueKeys.size() < this.queryMaxNumberOfResults)) {
            this.uniqueKeys.add(match.getString(this.uniqueKey));
        }
        return match;
    }

    private Attributes nullifyDuplicate(Attributes match) {
        return match != null && !this.uniqueKeys.contains(match.getString(this.uniqueKey)) ? match : null;
    }

    private Attributes nextSpanningMatch() throws Exception {
        Attributes match = this.spanningMatch;
        this.spanningMatch = this.spanningCFindRSP.getDataset();
        this.spanningCFindRSP.next();
        return match != null ? this.cfindscu.coerceCFindRSP(this.spanningAssoc, match) : match;
    }

    private boolean hasMoreQueryMatches() throws DicomServiceException {
        return this.query.hasMoreMatches();
    }

    private boolean hasMoreSpanningMatches() {
        return this.spanningMatch != null;
    }

    public Attributes nextQueryMatch() {
        return this.query.nextMatch();
    }

    private Attributes adjustQueryMatch(Attributes match) throws Exception {
        if (match == null) {
            return null;
        }
        if (this.coercion != null) {
            this.coercion.coerce(match, null);
        }
        Attributes adjust = this.query.adjust(match);
        adjust.addSelected(this.keys, null, 524370);
        return adjust;
    }

    private Attributes adjustSpanningMatch(Attributes match) {
        if (match == null) {
            return null;
        }
        if (this.removeUniqueKeyFromSpanningMatch != 0) {
            match.remove(this.removeUniqueKeyFromSpanningMatch);
        }
        if (this.spanningRetrieveAETs.length > 0) {
            match.setString(524372, VR.AE, this.spanningRetrieveAETs);
        }
        return match;
    }

    private State initState() throws Exception {
        if (this.spanningCFindSCP == null || this.spanningPolicy == SpanningCFindSCPPolicy.SUPPLEMENT) {
            this.initQuery();
            this.state = this.spanningCFindSCP == null ? State.QUERY : State.QUERY_BEFORE_SPANNING;
        } else {
            this.initSpanning();
            this.state = this.spanningPolicy == SpanningCFindSCPPolicy.REPLACE ? State.SPANNING : State.SPANNING_BEFORE_QUERY;
        }
        return this.state;
    }

    private State initSpanningAfterQuery() throws Exception {
        this.closeQuery();
        this.initSpanning();
        this.state = State.SPANNING;
        return this.state;
    }

    private State initQueryAfterSpanning() throws Exception {
        this.releaseSpanningAssociation();
        this.initQuery();
        this.state = State.QUERY;
        return this.state;
    }

    private static enum State {
        NOT_INITALIZED{

            @Override
            public boolean hasMoreMatches(ArchiveQueryTask task) throws Exception {
                return task.initState().hasMoreMatches(task);
            }
        }
        ,
        QUERY{

            @Override
            public boolean hasMoreMatches(ArchiveQueryTask task) throws Exception {
                return task.hasMoreQueryMatches();
            }

            @Override
            public Attributes nextMatch(ArchiveQueryTask task) {
                return task.nullifyDuplicate(task.nextQueryMatch());
            }

            @Override
            public Attributes adjust(ArchiveQueryTask task, Attributes match) throws Exception {
                return task.adjustQueryMatch(match);
            }
        }
        ,
        QUERY_BEFORE_SPANNING{

            @Override
            public boolean hasMoreMatches(ArchiveQueryTask task) throws Exception {
                return task.hasMoreQueryMatches() || task.initSpanningAfterQuery().hasMoreMatches(task);
            }

            @Override
            public Attributes nextMatch(ArchiveQueryTask task) {
                return task.registerUniqueKey(task.nextQueryMatch());
            }

            @Override
            public Attributes adjust(ArchiveQueryTask task, Attributes match) throws Exception {
                return task.adjustQueryMatch(match);
            }
        }
        ,
        SPANNING{

            @Override
            public boolean hasMoreMatches(ArchiveQueryTask task) throws Exception {
                return task.hasMoreSpanningMatches();
            }

            @Override
            public Attributes nextMatch(ArchiveQueryTask task) throws Exception {
                return task.nullifyDuplicate(task.nextSpanningMatch());
            }

            @Override
            public Attributes adjust(ArchiveQueryTask task, Attributes match) {
                return task.adjustSpanningMatch(match);
            }
        }
        ,
        SPANNING_BEFORE_QUERY{

            @Override
            public boolean hasMoreMatches(ArchiveQueryTask task) throws Exception {
                return task.hasMoreSpanningMatches() || task.initQueryAfterSpanning().hasMoreMatches(task);
            }

            @Override
            public Attributes nextMatch(ArchiveQueryTask task) throws Exception {
                return task.registerUniqueKey(task.nextSpanningMatch());
            }

            @Override
            public Attributes adjust(ArchiveQueryTask task, Attributes match) {
                return task.adjustSpanningMatch(match);
            }
        };


        public abstract boolean hasMoreMatches(ArchiveQueryTask var1) throws Exception;

        public Attributes nextMatch(ArchiveQueryTask task) throws Exception {
            throw new IllegalStateException("State: " + this);
        }

        public Attributes adjust(ArchiveQueryTask task, Attributes match) throws Exception {
            throw new IllegalStateException("State: " + this);
        }
    }
}

