/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.entity.UPS;
import org.dcm4chee.arc.entity.UPS_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.impl.AbstractQuery;

public class UPSQuery
extends AbstractQuery {
    private Root<UPS> ups;
    private Join<UPS, Patient> patient;
    private Path<byte[]> patientAttrBlob;
    private Path<byte[]> upsAttrBlob;

    UPSQuery(QueryContext context, EntityManager em) {
        super(context, em);
    }

    @Override
    protected CriteriaQuery<Tuple> multiselect() {
        CriteriaQuery q = this.cb.createTupleQuery();
        this.ups = q.from(UPS.class);
        this.patient = this.ups.join(UPS_.patient);
        Selection[] selectionArray = new Selection[4];
        selectionArray[0] = this.ups.get(UPS_.upsInstanceUID);
        selectionArray[1] = this.ups.get(UPS_.updatedTime);
        this.patientAttrBlob = this.patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[2] = this.patientAttrBlob;
        this.upsAttrBlob = this.ups.join(UPS_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[3] = this.upsAttrBlob;
        return this.order(this.restrict(q, this.patient, this.ups)).multiselect(selectionArray);
    }

    @Override
    protected CriteriaQuery<Long> count() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root ups = q.from(UPS.class);
        Join patient = ups.join(UPS_.patient);
        return this.restrict(q, (Join<UPS, Patient>)patient, (Root<UPS>)ups).select((Selection)this.cb.count((Expression)ups));
    }

    @Override
    protected Attributes toAttributes(Tuple results) {
        Attributes upsAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.upsAttrBlob)), null);
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.patientAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, upsAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + upsAttrs.size() + 3);
        attrs.addAll(patAttrs);
        attrs.addAll(upsAttrs);
        attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.34.6.1");
        attrs.setString(524312, VR.UI, (String)results.get((TupleElement)this.ups.get(UPS_.upsInstanceUID)));
        attrs.setDate(0x404010, VR.DT, new Date[]{(Date)results.get((TupleElement)this.ups.get(UPS_.updatedTime))});
        return attrs;
    }

    @Override
    public boolean isOptionalKeysNotSupported() {
        return false;
    }

    private CriteriaQuery<Tuple> order(CriteriaQuery<Tuple> q) {
        if (this.context.getOrderByTags() != null) {
            q.orderBy(this.builder.orderWorkitems(this.patient, this.ups, this.context.getOrderByTags()));
        }
        return q;
    }

    private <T> CriteriaQuery<T> restrict(CriteriaQuery<T> q, Join<UPS, Patient> patient, Root<UPS> ups) {
        List predicates = this.builder.upsPredicates(q, patient, ups, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam());
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return q;
    }
}

