/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Metadata_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.SeriesQueryAttributes_;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.StudyQueryAttributes;
import org.dcm4chee.arc.entity.StudyQueryAttributes_;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.impl.AbstractQuery;
import org.dcm4chee.arc.query.impl.PatientQuery;
import org.dcm4chee.arc.query.impl.StudyQuery;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.QueryParam;

class SeriesQuery
extends AbstractQuery {
    private final CodeCache codeCache;
    private Root<Series> series;
    private Join<Series, Study> study;
    private Join<Study, Patient> patient;
    private Join<Series, Metadata> metadata;
    private CollectionJoin<Study, StudyQueryAttributes> studyQueryAttributes;
    private CollectionJoin<Series, SeriesQueryAttributes> seriesQueryAttributes;
    private Path<byte[]> patientAttrBlob;
    private Path<byte[]> studyAttrBlob;
    private Path<byte[]> seriesAttrBlob;
    private Long studyPk;
    private Attributes studyAttrs;

    SeriesQuery(QueryContext context, EntityManager em, CodeCache codeCache) {
        super(context, em);
        this.codeCache = codeCache;
    }

    @Override
    protected CriteriaQuery<Tuple> multiselect() {
        CriteriaQuery q = this.cb.createTupleQuery();
        this.series = q.from(Series.class);
        this.study = this.series.join(Series_.study);
        this.patient = this.study.join(Study_.patient);
        this.metadata = this.series.join(Series_.metadata, JoinType.LEFT);
        this.studyQueryAttributes = QueryBuilder.joinStudyQueryAttributes((CriteriaBuilder)this.cb, this.study, (String)this.context.getQueryParam().getViewID());
        this.seriesQueryAttributes = QueryBuilder.joinSeriesQueryAttributes((CriteriaBuilder)this.cb, this.series, (String)this.context.getQueryParam().getViewID());
        Selection[] selectionArray = new Selection[64];
        selectionArray[0] = this.study.get(Study_.pk);
        selectionArray[1] = this.series.get(Series_.pk);
        selectionArray[2] = this.patient.get(Patient_.numberOfStudies);
        selectionArray[3] = this.patient.get(Patient_.createdTime);
        selectionArray[4] = this.patient.get(Patient_.updatedTime);
        selectionArray[5] = this.patient.get(Patient_.verificationTime);
        selectionArray[6] = this.patient.get(Patient_.verificationStatus);
        selectionArray[7] = this.patient.get(Patient_.failedVerifications);
        selectionArray[8] = this.study.get(Study_.createdTime);
        selectionArray[9] = this.study.get(Study_.updatedTime);
        selectionArray[10] = this.study.get(Study_.modifiedTime);
        selectionArray[11] = this.study.get(Study_.accessTime);
        selectionArray[12] = this.study.get(Study_.expirationState);
        selectionArray[13] = this.study.get(Study_.expirationDate);
        selectionArray[14] = this.study.get(Study_.expirationExporterID);
        selectionArray[15] = this.study.get(Study_.rejectionState);
        selectionArray[16] = this.study.get(Study_.completeness);
        selectionArray[17] = this.study.get(Study_.failedRetrieves);
        selectionArray[18] = this.study.get(Study_.accessControlID);
        selectionArray[19] = this.study.get(Study_.storageIDs);
        selectionArray[20] = this.study.get(Study_.size);
        selectionArray[21] = this.series.get(Series_.createdTime);
        selectionArray[22] = this.series.get(Series_.updatedTime);
        selectionArray[23] = this.series.get(Series_.modifiedTime);
        selectionArray[24] = this.series.get(Series_.expirationState);
        selectionArray[25] = this.series.get(Series_.expirationDate);
        selectionArray[26] = this.series.get(Series_.expirationExporterID);
        selectionArray[27] = this.series.get(Series_.rejectionState);
        selectionArray[28] = this.series.get(Series_.completeness);
        selectionArray[29] = this.series.get(Series_.failedRetrieves);
        selectionArray[30] = this.series.get(Series_.sendingAET);
        selectionArray[31] = this.series.get(Series_.receivingAET);
        selectionArray[32] = this.series.get(Series_.sendingPresentationAddress);
        selectionArray[33] = this.series.get(Series_.receivingPresentationAddress);
        selectionArray[34] = this.series.get(Series_.sendingHL7Application);
        selectionArray[35] = this.series.get(Series_.sendingHL7Facility);
        selectionArray[36] = this.series.get(Series_.receivingHL7Application);
        selectionArray[37] = this.series.get(Series_.receivingHL7Facility);
        selectionArray[38] = this.series.get(Series_.externalRetrieveAET);
        selectionArray[39] = this.series.get(Series_.metadataScheduledUpdateTime);
        selectionArray[40] = this.series.get(Series_.metadataUpdateFailures);
        selectionArray[41] = this.series.get(Series_.instancePurgeTime);
        selectionArray[42] = this.series.get(Series_.instancePurgeState);
        selectionArray[43] = this.series.get(Series_.storageVerificationTime);
        selectionArray[44] = this.series.get(Series_.failuresOfLastStorageVerification);
        selectionArray[45] = this.series.get(Series_.compressionTime);
        selectionArray[46] = this.series.get(Series_.compressionFailures);
        selectionArray[47] = this.series.get(Series_.transferSyntaxUID);
        selectionArray[48] = this.metadata.get(Metadata_.createdTime);
        selectionArray[49] = this.metadata.get(Metadata_.storageID);
        selectionArray[50] = this.metadata.get(Metadata_.storagePath);
        selectionArray[51] = this.metadata.get(Metadata_.digest);
        selectionArray[52] = this.metadata.get(Metadata_.size);
        selectionArray[53] = this.metadata.get(Metadata_.status);
        selectionArray[54] = this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfInstances);
        selectionArray[55] = this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfSeries);
        selectionArray[56] = this.studyQueryAttributes.get(StudyQueryAttributes_.modalitiesInStudy);
        selectionArray[57] = this.studyQueryAttributes.get(StudyQueryAttributes_.sopClassesInStudy);
        selectionArray[58] = this.seriesQueryAttributes.get(SeriesQueryAttributes_.numberOfInstances);
        selectionArray[59] = this.seriesQueryAttributes.get(SeriesQueryAttributes_.retrieveAETs);
        selectionArray[60] = this.seriesQueryAttributes.get(SeriesQueryAttributes_.availability);
        this.patientAttrBlob = this.patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[61] = this.patientAttrBlob;
        this.studyAttrBlob = this.study.join(Study_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[62] = this.studyAttrBlob;
        this.seriesAttrBlob = this.series.join(Series_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[63] = this.seriesAttrBlob;
        return this.order(this.restrict(q, this.patient, this.study, this.series)).multiselect(selectionArray);
    }

    @Override
    protected CriteriaQuery<Long> count() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root series = q.from(Series.class);
        Join study = series.join(Series_.study);
        Join patient = study.join(Study_.patient);
        return this.restrict(q, (Join<Study, Patient>)patient, (Join<Series, Study>)study, (Root<Series>)series).select((Selection)this.cb.count((Expression)patient));
    }

    @Override
    protected Attributes toAttributes(Tuple results) {
        Availability availability;
        String retrieveAETs;
        int numberOfSeriesRelatedInstances;
        Long studyPk = (Long)results.get((TupleElement)this.study.get(Study_.pk));
        Long seriesPk = (Long)results.get((TupleElement)this.series.get(Series_.pk));
        Integer numberOfInstancesI = (Integer)results.get((TupleElement)this.seriesQueryAttributes.get(SeriesQueryAttributes_.numberOfInstances));
        QueryParam queryParam = this.context.getQueryParam();
        if (numberOfInstancesI != null) {
            numberOfSeriesRelatedInstances = numberOfInstancesI;
            if (numberOfSeriesRelatedInstances == 0) {
                return null;
            }
            retrieveAETs = (String)results.get((TupleElement)this.seriesQueryAttributes.get(SeriesQueryAttributes_.retrieveAETs));
            availability = (Availability)results.get((TupleElement)this.seriesQueryAttributes.get(SeriesQueryAttributes_.availability));
        } else {
            SeriesQueryAttributes seriesView = this.context.getQueryService().calculateSeriesQueryAttributes(seriesPk, (Series.InstancePurgeState)results.get((TupleElement)this.series.get(Series_.instancePurgeState)), (String)results.get((TupleElement)this.metadata.get(Metadata_.storageID)), (String)results.get((TupleElement)this.metadata.get(Metadata_.storagePath)), queryParam.getQueryRetrieveView());
            numberOfSeriesRelatedInstances = seriesView.getNumberOfInstances();
            if (numberOfSeriesRelatedInstances == 0) {
                return null;
            }
            retrieveAETs = seriesView.getRetrieveAETs();
            availability = seriesView.getAvailability();
        }
        if (!studyPk.equals(this.studyPk)) {
            this.studyAttrs = this.toStudyAttributes(studyPk, results);
            this.studyPk = studyPk;
        }
        Attributes seriesAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.seriesAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{this.studyAttrs, seriesAttrs});
        Attributes attrs = new Attributes(this.studyAttrs.size() + seriesAttrs.size() + 20);
        attrs.addAll(this.studyAttrs);
        attrs.addAll(seriesAttrs, true);
        String externalRetrieveAET = (String)results.get((TupleElement)this.series.get(Series_.externalRetrieveAET));
        attrs.setString(524372, VR.AE, this.retrieveAETs(retrieveAETs, externalRetrieveAET));
        attrs.setString(524374, VR.CS, ((Availability)StringUtils.maskNull((Object)availability, (Object)Availability.UNAVAILABLE)).toString());
        SeriesQuery.addSeriesQRAttrs(this.series, this.metadata, this.context, results, numberOfSeriesRelatedInstances, attrs);
        return attrs;
    }

    private CriteriaQuery<Tuple> order(CriteriaQuery<Tuple> q) {
        if (this.context.getOrderByTags() != null) {
            q.orderBy(this.builder.orderSeries(this.patient, this.study, this.series, this.context.getOrderByTags()));
        }
        return q;
    }

    private <T> CriteriaQuery<T> restrict(CriteriaQuery<T> q, Join<Study, Patient> patient, Join<Series, Study> study, Root<Series> series) {
        List predicates = this.builder.seriesPredicates(q, patient, study, series, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam(), this.codeCache.findOrCreateEntities(this.context.getQueryParam().getQueryRetrieveView().getShowInstancesRejectedByCodes()));
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return q;
    }

    static void addSeriesQRAttrs(Root<Series> series, Join<Series, Metadata> metadata, QueryContext context, Tuple results, int numberOfSeriesRelatedInstances, Attributes attrs) {
        attrs.setInt(2101769, VR.IS, new int[]{numberOfSeriesRelatedInstances});
        attrs.setString(536578, VR.UI, (String)results.get((TupleElement)series.get(Series_.transferSyntaxUID)));
        if (!context.isReturnPrivate()) {
            return;
        }
        SeriesQuery.setDTwTZ(attrs, 0x77770030, (Date)results.get((TupleElement)series.get(Series_.createdTime)));
        SeriesQuery.setDTwTZ(attrs, 2004287537, (Date)results.get((TupleElement)series.get(Series_.updatedTime)));
        SeriesQuery.setDTwTZ(attrs, 2004287599, (Date)results.get((TupleElement)series.get(Series_.modifiedTime)));
        if (results.get((TupleElement)series.get(Series_.expirationState)) != ExpirationState.UPDATEABLE) {
            attrs.setString("DCM4CHEE Archive 5", 2004287588, VR.CS, ((ExpirationState)results.get((TupleElement)series.get(Series_.expirationState))).toString());
        }
        if (results.get((TupleElement)series.get(Series_.expirationDate)) != null) {
            attrs.setString("DCM4CHEE Archive 5", 0x77770033, VR.DA, (String)results.get((TupleElement)series.get(Series_.expirationDate)));
        }
        if (results.get((TupleElement)series.get(Series_.expirationExporterID)) != null) {
            attrs.setString("DCM4CHEE Archive 5", 2004287589, VR.LO, (String)results.get((TupleElement)series.get(Series_.expirationExporterID)));
        }
        if (results.get((TupleElement)series.get(Series_.rejectionState)) != RejectionState.NONE) {
            attrs.setString("DCM4CHEE Archive 5", 2004287540, VR.CS, ((RejectionState)results.get((TupleElement)series.get(Series_.rejectionState))).toString());
        }
        if (results.get((TupleElement)series.get(Series_.completeness)) != Completeness.COMPLETE) {
            attrs.setString("DCM4CHEE Archive 5", 2004287541, VR.CS, ((Completeness)results.get((TupleElement)series.get(Series_.completeness))).toString());
        }
        if ((Integer)results.get((TupleElement)series.get(Series_.failedRetrieves)) != 0) {
            attrs.setInt("DCM4CHEE Archive 5", 2004287542, VR.US, new int[]{(Integer)results.get((TupleElement)series.get(Series_.failedRetrieves))});
        }
        SeriesQuery.setStringNotNull(attrs, 0x77770037, VR.AE, (String)results.get((TupleElement)series.get(Series_.sendingAET)));
        SeriesQuery.setStringNotNull(attrs, 2004287592, VR.AE, (String)results.get((TupleElement)series.get(Series_.receivingAET)));
        SeriesQuery.setStringNotNull(attrs, 2004287593, VR.UR, (String)results.get((TupleElement)series.get(Series_.sendingPresentationAddress)));
        SeriesQuery.setStringNotNull(attrs, 2004287594, VR.UR, (String)results.get((TupleElement)series.get(Series_.receivingPresentationAddress)));
        SeriesQuery.setStringNotNull(attrs, 2004287595, VR.LO, (String)results.get((TupleElement)series.get(Series_.sendingHL7Application)));
        SeriesQuery.setStringNotNull(attrs, 2004287596, VR.LO, (String)results.get((TupleElement)series.get(Series_.sendingHL7Facility)));
        SeriesQuery.setStringNotNull(attrs, 2004287597, VR.LO, (String)results.get((TupleElement)series.get(Series_.receivingHL7Application)));
        SeriesQuery.setStringNotNull(attrs, 2004287598, VR.LO, (String)results.get((TupleElement)series.get(Series_.receivingHL7Facility)));
        if (results.get((TupleElement)series.get(Series_.metadataScheduledUpdateTime)) != null) {
            SeriesQuery.setDTwTZ(attrs, 2004287544, (Date)results.get((TupleElement)series.get(Series_.metadataScheduledUpdateTime)));
        }
        if ((Integer)results.get((TupleElement)series.get(Series_.metadataUpdateFailures)) != 0) {
            attrs.setInt("DCM4CHEE Archive 5", 0x77770067, VR.US, new int[]{(Integer)results.get((TupleElement)series.get(Series_.metadataUpdateFailures))});
        }
        if (results.get((TupleElement)series.get(Series_.instancePurgeTime)) != null) {
            SeriesQuery.setDTwTZ(attrs, 2004287545, (Date)results.get((TupleElement)series.get(Series_.instancePurgeTime)));
        }
        if (results.get((TupleElement)series.get(Series_.instancePurgeState)) != Series.InstancePurgeState.NO) {
            attrs.setString("DCM4CHEE Archive 5", 2004287546, VR.CS, ((Series.InstancePurgeState)results.get((TupleElement)series.get(Series_.instancePurgeState))).name());
        }
        if (results.get((TupleElement)series.get(Series_.storageVerificationTime)) != null) {
            SeriesQuery.setDTwTZ(attrs, 0x77770060, (Date)results.get((TupleElement)series.get(Series_.storageVerificationTime)));
        }
        if ((Integer)results.get((TupleElement)series.get(Series_.failuresOfLastStorageVerification)) != 0) {
            attrs.setInt("DCM4CHEE Archive 5", 2004287585, VR.US, new int[]{(Integer)results.get((TupleElement)series.get(Series_.failuresOfLastStorageVerification))});
        }
        if (results.get((TupleElement)series.get(Series_.compressionTime)) != null) {
            SeriesQuery.setDTwTZ(attrs, 2004287586, (Date)results.get((TupleElement)series.get(Series_.compressionTime)));
        }
        if ((Integer)results.get((TupleElement)series.get(Series_.compressionFailures)) != 0) {
            attrs.setInt("DCM4CHEE Archive 5", 2004287587, VR.US, new int[]{(Integer)results.get((TupleElement)series.get(Series_.compressionFailures))});
        }
        if (results.get((TupleElement)metadata.get(Metadata_.storageID)) != null) {
            SeriesQuery.setDTwTZ(attrs, 0x77770066, (Date)results.get((TupleElement)metadata.get(Metadata_.createdTime)));
            attrs.setString("DCM4CHEE Archive 5", 2004287547, VR.LO, (String)results.get((TupleElement)metadata.get(Metadata_.storageID)));
            attrs.setString("DCM4CHEE Archive 5", 2004287548, VR.LO, StringUtils.split((String)((String)results.get((TupleElement)metadata.get(Metadata_.storagePath))), (char)'/'));
            attrs.setInt("DCM4CHEE Archive 5", 2004287549, VR.UL, new int[]{((Long)results.get((TupleElement)metadata.get(Metadata_.size))).intValue()});
            if (results.get((TupleElement)metadata.get(Metadata_.digest)) != null) {
                attrs.setString("DCM4CHEE Archive 5", 2004287550, VR.LO, (String)results.get((TupleElement)metadata.get(Metadata_.digest)));
            }
            if (results.get((TupleElement)metadata.get(Metadata_.status)) != Metadata.Status.OK) {
                attrs.setString("DCM4CHEE Archive 5", 2004287551, VR.CS, ((Metadata.Status)results.get((TupleElement)metadata.get(Metadata_.status))).name());
            }
        }
    }

    private static void setStringNotNull(Attributes attrs, int tag, VR vr, String value) {
        if (value != null) {
            attrs.setString("DCM4CHEE Archive 5", tag, vr, value);
        }
    }

    private Attributes toStudyAttributes(Long studyPk, Tuple results) {
        String sopClassesInStudy;
        String modalitiesInStudy;
        int numberOfStudyRelatedSeries;
        int numberOfStudyRelatedInstances;
        Integer numberOfInstancesI;
        long studySize = (Long)results.get((TupleElement)this.study.get(Study_.size));
        if (studySize < 0L) {
            studySize = this.context.getQueryService().calculateStudySize(studyPk);
        }
        if ((numberOfInstancesI = (Integer)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfInstances))) != null) {
            numberOfStudyRelatedInstances = numberOfInstancesI;
            numberOfStudyRelatedSeries = (Integer)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.numberOfSeries));
            modalitiesInStudy = (String)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.modalitiesInStudy));
            sopClassesInStudy = (String)results.get((TupleElement)this.studyQueryAttributes.get(StudyQueryAttributes_.sopClassesInStudy));
        } else {
            StudyQueryAttributes studyView = this.context.getQueryService().calculateStudyQueryAttributes(studyPk, this.context.getQueryParam().getQueryRetrieveView());
            numberOfStudyRelatedInstances = studyView.getNumberOfInstances();
            numberOfStudyRelatedSeries = studyView.getNumberOfSeries();
            modalitiesInStudy = studyView.getModalitiesInStudy();
            sopClassesInStudy = studyView.getSOPClassesInStudy();
        }
        Attributes studyAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.studyAttrBlob)), null);
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.patientAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, studyAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + studyAttrs.size() + 20);
        attrs.addAll(patAttrs);
        attrs.addAll(studyAttrs, true);
        PatientQuery.addPatientQRAttrs(this.patient, this.context, results, attrs);
        StudyQuery.addStudyQRAddrs(this.study, this.context, results, studySize, numberOfStudyRelatedInstances, numberOfStudyRelatedSeries, modalitiesInStudy, sopClassesInStudy, attrs);
        return attrs;
    }

    @Override
    public boolean isOptionalKeysNotSupported() {
        return false;
    }
}

