/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.entity.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class QuerySizeEJB {
    private static final Long ZERO = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(QuerySizeEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    EntityManager em;

    public long calculateStudySize(Long studyPk, String updateStudySize) {
        for (Long seriesPk : this.em.createNamedQuery("Series.seriesPKsOfStudyWithUnknownSize", Long.class).setParameter(1, (Object)studyPk).getResultList()) {
            this.calculateSeriesSize(seriesPk);
        }
        Long size = (Long)StringUtils.maskNull((Object)((Long)this.em.createNamedQuery("Series.sizeOfStudy", Long.class).setParameter(1, (Object)studyPk).getSingleResult()), (Object)ZERO);
        return this.em.createNamedQuery(updateStudySize).setParameter(1, (Object)studyPk).setParameter(2, (Object)size).executeUpdate() > 0 ? size : 0L;
    }

    public long calculateSeriesSize(Long seriesPk) {
        Object result = this.em.createNamedQuery("Location.SizeOfSeries").setParameter(1, (Object)seriesPk).setParameter(2, (Object)Location.ObjectType.DICOM_FILE.ordinal()).getSingleResult();
        long size = result instanceof Number ? ((Number)result).longValue() : 0L;
        this.em.createNamedQuery("Series.SetSeriesSize").setParameter(1, (Object)seriesPk).setParameter(2, (Object)size).executeUpdate();
        return size;
    }

    public long claimAndCalculateStudySize(Long studyPk) {
        try {
            if (this.em.createNamedQuery("Study.claimUnknownSizeStudy").setParameter(1, (Object)studyPk).executeUpdate() > 0) {
                return this.calculateStudySize(studyPk, "Study.setStudySizeIfClaimed");
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
        return ZERO;
    }
}

