/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ejb.EJBException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.NullifyAttributesCoercion;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.TrimISO2020CharacterSetAttributesCoercion;
import org.dcm4che3.data.UID;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.io.XSLTAttributesCoercion;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.LeadingCFindSCPQueryCache;
import org.dcm4chee.arc.MergeMWLQueryParam;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.coerce.CoercionFactory;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.conf.UseCallingAETitleAsCoercion;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.entity.MWLItem_;
import org.dcm4chee.arc.entity.Metadata_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.PatientID_;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.StudyQueryAttributes;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.mima.SupplementAssigningAuthorities;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.impl.InstanceQuery;
import org.dcm4chee.arc.query.impl.MPPSQuery;
import org.dcm4chee.arc.query.impl.MWLQuery;
import org.dcm4chee.arc.query.impl.PatientQuery;
import org.dcm4chee.arc.query.impl.QueryAttributesEJB;
import org.dcm4chee.arc.query.impl.QueryContextImpl;
import org.dcm4chee.arc.query.impl.QueryServiceEJB;
import org.dcm4chee.arc.query.impl.QuerySizeEJB;
import org.dcm4chee.arc.query.impl.SeriesQuery;
import org.dcm4chee.arc.query.impl.StudyQuery;
import org.dcm4chee.arc.query.impl.UPSQuery;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.scu.CFindSCUAttributeCoercion;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class QueryServiceImpl
implements QueryService {
    private static Logger LOG = LoggerFactory.getLogger(QueryServiceImpl.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;
    @Inject
    private QueryServiceEJB ejb;
    @Inject
    QuerySizeEJB querySizeEJB;
    @Inject
    QueryAttributesEJB queryAttributesEJB;
    @Inject
    private CFindSCU cfindscu;
    @Inject
    private LeadingCFindSCPQueryCache leadingCFindSCPQueryCache;
    @Inject
    private CodeCache codeCache;
    @Inject
    private StorageFactory storageFactory;
    @Inject
    private Event<QueryContext> queryEvent;
    @Inject
    private CoercionFactory coercionFactory;

    QueryServiceImpl() {
    }

    @Override
    public QueryContext newQueryContextFIND(Association as, String sopClassUID, EnumSet<QueryOption> queryOpts) {
        ApplicationEntity ae = as.getApplicationEntity();
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(queryOpts.contains(QueryOption.DATETIME));
        queryParam.setFuzzySemanticMatching(queryOpts.contains(QueryOption.FUZZY));
        queryParam.setCalledAET(as.getCalledAET());
        QueryContextImpl ctx = new QueryContextImpl(ae, queryParam, this).find(as, sopClassUID);
        queryParam.setHideSPSWithStatusFromMWL(ctx.getArchiveAEExtension().hideSPSWithStatusFromMWL());
        return ctx;
    }

    @Override
    public QueryContext newQueryContextQIDO(HttpServletRequestInfo httpRequest, String searchMethod, String aet, ApplicationEntity ae, QueryParam queryParam) {
        QueryContextImpl ctx = new QueryContextImpl(ae, queryParam, this).qido(httpRequest, searchMethod, aet);
        queryParam.setHideSPSWithStatusFromMWL(ctx.getArchiveAEExtension().hideSPSWithStatusFromMWLRS());
        return ctx;
    }

    @Override
    public QueryContext newQueryContext(ApplicationEntity ae, QueryParam queryParam) {
        return new QueryContextImpl(ae, queryParam, this);
    }

    @Override
    public void coerceAttributes(QueryContext ctx) throws Exception {
        ArchiveAEExtension aeExt = ctx.getArchiveAEExtension();
        List coercions = aeExt.attributeCoercions2().filter(descriptor -> descriptor.match(TransferCapability.Role.SCU, Dimse.C_FIND_RQ, ctx.getSOPClassUID(), ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), ctx.getQueryKeys())).collect(Collectors.toList());
        if (coercions.isEmpty()) {
            ArchiveAttributeCoercion rule = aeExt.findAttributeCoercion(Dimse.C_FIND_RQ, TransferCapability.Role.SCU, ctx.getSOPClassUID(), ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), ctx.getQueryKeys());
            if (rule != null) {
                this.coerceLegacy(ctx, rule);
            }
        } else {
            block6: for (ArchiveAttributeCoercion2 coercion : coercions) {
                try {
                    if (!this.coercionFactory.getCoercionProcessor(coercion).coerce(coercion, ctx.getSOPClassUID(), ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), ctx.getQueryKeys(), ctx.getCoercedQueryKeys()) || !coercion.isCoercionSufficient()) continue;
                }
                catch (Exception e) {
                    LOG.info("Failed to apply {}:\n", (Object)coercion, (Object)e);
                    switch (coercion.getCoercionOnFailure()) {
                        case RETHROW: {
                            throw e;
                        }
                        case CONTINUE: {
                            continue block6;
                        }
                    }
                }
                break;
            }
            if (LOG.isDebugEnabled() && !ctx.getCoercedQueryKeys().isEmpty()) {
                LOG.debug("Coerced Search Attributes:\n{} to:\n{}", (Object)ctx.getCoercedQueryKeys(), (Object)new Attributes(ctx.getQueryKeys(), false, ctx.getCoercedQueryKeys()));
            }
        }
    }

    private void coerceLegacy(QueryContext ctx, ArchiveAttributeCoercion rule) throws Exception {
        LOG.info("Apply {} to Search Attributes", (Object)rule);
        AttributesCoercion coercion = null;
        coercion = this.coerceAttributesByXSL(ctx, rule, coercion);
        switch (ctx.getSOPClassUID()) {
            case "1.2.840.10008.5.1.4.1.2.1.1": 
            case "1.2.840.10008.5.1.4.1.2.2.1": 
            case "1.2.840.10008.5.1.4.1.2.3.1": {
                coercion = SupplementAssigningAuthorities.forQuery((Device)rule.getSupplementFromDevice(), (AttributesCoercion)coercion);
                break;
            }
            case "1.2.840.10008.5.1.4.31": {
                coercion = SupplementAssigningAuthorities.forMWL((Device)rule.getSupplementFromDevice(), (AttributesCoercion)coercion);
            }
        }
        coercion = rule.supplementIssuerOfPatientID(coercion);
        coercion = rule.nullifyIssuerOfPatientID(ctx.getQueryKeys(), coercion);
        coercion = rule.mergeAttributes(coercion);
        coercion = NullifyAttributesCoercion.valueOf((int[])rule.getNullifyTags(), (AttributesCoercion)coercion);
        if (rule.isTrimISO2022CharacterSet()) {
            coercion = new TrimISO2020CharacterSetAttributesCoercion(coercion);
        }
        if ((coercion = UseCallingAETitleAsCoercion.of((UseCallingAETitleAsCoercion.Type)rule.getUseCallingAETitleAs(), (String)ctx.getCallingAET(), (AttributesCoercion)coercion)) != null) {
            coercion.coerce(ctx.getQueryKeys(), ctx.getCoercedQueryKeys());
            if (LOG.isDebugEnabled() && !ctx.getCoercedQueryKeys().isEmpty()) {
                LOG.debug("Coerced Search Attributes:\n{} to:\n{}", (Object)ctx.getCoercedQueryKeys(), (Object)new Attributes(ctx.getQueryKeys(), false, ctx.getCoercedQueryKeys()));
            }
        }
    }

    private AttributesCoercion coerceAttributesByXSL(QueryContext ctx, ArchiveAttributeCoercion rule, AttributesCoercion next) {
        String xsltStylesheetURI = rule.getXSLTStylesheetURI();
        if (xsltStylesheetURI != null) {
            try {
                Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)xsltStylesheetURI));
                return new XSLTAttributesCoercion(tpls, null).includeKeyword(!rule.isNoKeywords()).setupTransformer(this.setupTransformer(ctx));
            }
            catch (TransformerConfigurationException e) {
                LOG.error("{}: Failed to compile XSL: {}", new Object[]{ctx, xsltStylesheetURI, e});
            }
        }
        return next;
    }

    @Override
    public Query createQuery(QueryContext ctx) {
        this.queryEvent.fire((Object)ctx);
        switch (ctx.getQueryRetrieveLevel()) {
            case PATIENT: {
                return this.createPatientQuery(ctx);
            }
            case STUDY: {
                return this.createStudyQuery(ctx);
            }
            case SERIES: {
                return this.createSeriesQuery(ctx);
            }
        }
        return this.createInstanceQuery(ctx);
    }

    @Override
    public Query createPatientQuery(QueryContext ctx) {
        return new PatientQuery(ctx, this.em);
    }

    @Override
    public Query createStudyQuery(QueryContext ctx) {
        return new StudyQuery(ctx, this.em, this.codeCache);
    }

    @Override
    public Query createSeriesQuery(QueryContext ctx) {
        return new SeriesQuery(ctx, this.em, this.codeCache);
    }

    @Override
    public Query createInstanceQuery(QueryContext ctx) {
        return new InstanceQuery(ctx, this.em, this.codeCache);
    }

    @Override
    public Query createMWLQuery(QueryContext ctx) {
        this.queryEvent.fire((Object)ctx);
        return new MWLQuery(ctx, this.em);
    }

    @Override
    public Query createMPPSQuery(QueryContext ctx) {
        this.queryEvent.fire((Object)ctx);
        return new MPPSQuery(ctx, this.em);
    }

    @Override
    public Query createUPSQuery(QueryContext ctx) {
        this.queryEvent.fire((Object)ctx);
        return this.createUPSWithoutQueryEvent(ctx);
    }

    @Override
    public Query createUPSWithoutQueryEvent(QueryContext ctx) {
        return new UPSQuery(ctx, this.em);
    }

    @Override
    public Attributes getSeriesAttributes(QueryContext context, Long seriesPk) {
        return this.ejb.getSeriesAttributes(seriesPk, context);
    }

    @Override
    public void addLocationAttributes(Attributes attrs, Long instancePk) {
        this.ejb.addLocationAttributes(attrs, instancePk);
    }

    @Override
    public long calculateStudySize(Long studyPk) {
        return this.querySizeEJB.calculateStudySize(studyPk, "Study.setStudySize");
    }

    @Override
    public StudyQueryAttributes calculateStudyQueryAttributes(Long studyPk, QueryRetrieveView qrView) {
        ArchiveDeviceExtension arcDev = this.arcDev();
        int retries = arcDev.getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                return this.queryAttributesEJB.findOrCalculateStudyQueryAttributes(studyPk, qrView);
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    throw e;
                }
                LOG.info("Failed to calculate Query Attributes for Study[pk={}] and View[{}] caused by {} - retry", new Object[]{studyPk, qrView.getViewID(), DicomServiceException.initialCauseOf((Throwable)e).getMessage()});
                try {
                    Thread.sleep(arcDev.storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("Failed to delay retry to calculate Query Attributes for Study[pk={}] and View[{}]:\n", new Object[]{studyPk, qrView.getViewID(), e2});
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public SeriesQueryAttributes calculateSeriesQueryAttributes(Long seriesPk, Series.InstancePurgeState purgeState, String storageID, String storagePath, QueryRetrieveView qrView) {
        return purgeState == Series.InstancePurgeState.PURGED ? (qrView.isHideNotRejectedInstances() ? new SeriesQueryAttributes() : this.calculateSeriesQueryAttributes(seriesPk, storageID, storagePath, qrView)) : this.calculateSeriesQueryAttributes(seriesPk, qrView);
    }

    private SeriesQueryAttributes calculateSeriesQueryAttributes(Long seriesPk, String storageID, String storagePath, QueryRetrieveView qrView) {
        int numberOfInstances = 0;
        String[] retrieveAETs = null;
        Availability availability = Availability.ONLINE;
        HashSet<String> cuids = new HashSet<String>();
        Storage storage = this.storageFactory.getStorage(this.arcDev().getStorageDescriptorNotNull(storageID));
        try (ZipInputStream seriesMetadataStream = QueryServiceImpl.openZipInputStream(storage, storagePath, null);){
            while (seriesMetadataStream.getNextEntry() != null) {
                JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)seriesMetadataStream, StandardCharsets.UTF_8)));
                jsonReader.setSkipBulkDataURI(true);
                Attributes metadata = jsonReader.readDataset(null);
                String[] retrieveAETs1 = metadata.getStrings(524372);
                Availability availability1 = Availability.valueOf((String)metadata.getString(524374));
                if (numberOfInstances++ == 0) {
                    retrieveAETs = retrieveAETs1;
                    availability = availability1;
                } else {
                    retrieveAETs = QueryAttributesEJB.intersection(retrieveAETs, retrieveAETs1);
                    if (availability.compareTo((Enum)availability1) < 0) {
                        availability = availability1;
                    }
                }
                cuids.add(metadata.getString(524310));
                seriesMetadataStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SeriesQueryAttributes queryAttrs = new SeriesQueryAttributes();
        queryAttrs.setViewID(qrView.getViewID());
        queryAttrs.setSeries((Series)this.em.getReference(Series.class, (Object)seriesPk));
        queryAttrs.setNumberOfInstances(numberOfInstances);
        if (numberOfInstances > 0) {
            queryAttrs.setSOPClassesInSeries(StringUtils.concat(cuids, (char)'\\'));
            queryAttrs.setRetrieveAETs(StringUtils.concat((String[])retrieveAETs, (char)'\\'));
            queryAttrs.setAvailability(availability);
        }
        this.queryAttributesEJB.persist(queryAttrs);
        return queryAttrs;
    }

    public SeriesQueryAttributes calculateSeriesQueryAttributes(Long seriesPk, QueryRetrieveView qrView) {
        int retries = this.arcDev().getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                return this.queryAttributesEJB.findOrCalculateSeriesQueryAttributes(seriesPk, qrView);
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    throw e;
                }
                LOG.info("Failed to calculate Query Attributes for Series[pk={}] and View[{}] caused by {} - retry", new Object[]{seriesPk, qrView.getViewID(), DicomServiceException.initialCauseOf((Throwable)e).getMessage()});
                try {
                    Thread.sleep(this.arcDev().storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("Failed to delay retry to calculate Query Attributes for Series[pk={}] and View[{}]:\n", new Object[]{seriesPk, qrView.getViewID(), e2});
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public Attributes getStudyAttributesWithSOPInstanceRefs(String studyUID, ApplicationEntity ae, Collection<Attributes> seriesAttrs) {
        QueryRetrieveView qrView = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).getQueryRetrieveView();
        return this.ejb.getStudyAttributesWithSOPInstanceRefs(QueryServiceEJB.SOPInstanceRefsType.KOS_XDSI, studyUID, null, null, qrView, seriesAttrs, null, null);
    }

    @Override
    public Attributes createIAN(ApplicationEntity ae, String studyUID, String[] seriesUID, String sopUID, String[] retrieveAETs, String retrieveLocationUID, Availability availability) {
        QueryRetrieveView qrView = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).getQueryRetrieveView();
        Attributes refStudy = new Attributes(2);
        Sequence refSeriesSeq = refStudy.newSequence(528661, 10);
        refStudy.setString(0x20000D, VR.UI, studyUID);
        this.addPurgedSOPInstanceRefs(refSeriesSeq, studyUID, seriesUID, sopUID);
        return this.ejb.getSOPInstanceRefs(refStudy, QueryServiceEJB.SOPInstanceRefsType.IAN, studyUID, sopUID, qrView, null, retrieveAETs, retrieveLocationUID, availability, seriesUID);
    }

    @Override
    public Attributes createXDSiManifest(ApplicationEntity ae, String studyUID, String[] retrieveAETs, String retrieveLocationUID, Code conceptNameCode, int seriesNumber, int instanceNumber, Collection<Attributes> seriesAttrs) {
        QueryRetrieveView qrView = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).getQueryRetrieveView();
        Attributes attrs = this.ejb.getStudyAttributesWithSOPInstanceRefs(QueryServiceEJB.SOPInstanceRefsType.KOS_XDSI, studyUID, null, null, qrView, seriesAttrs, retrieveAETs, retrieveLocationUID);
        if (attrs == null || !attrs.containsValue(4236149)) {
            return null;
        }
        QueryServiceImpl.mkKOS(attrs, conceptNameCode, seriesNumber, instanceNumber);
        return attrs;
    }

    @Override
    public Attributes createUPSInfo(ApplicationEntity ae, String studyIUID, String seriesIUID, String sopIUID, ExporterDescriptor exporterDescriptor) {
        QueryRetrieveView qrView = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).getQueryRetrieveView();
        Attributes attrs = this.getStudyAttributes(studyIUID);
        if (attrs == null) {
            return null;
        }
        Attributes sopInstanceRefs = this.ejb.getSOPInstanceRefs(QueryServiceEJB.SOPInstanceRefsType.UPS, studyIUID, sopIUID, qrView, null, exporterDescriptor.getRetrieveAETitles(), exporterDescriptor.getRetrieveLocationUID(), exporterDescriptor.getInstanceAvailability(), seriesIUID);
        if (sopInstanceRefs != null) {
            attrs.addAll(sopInstanceRefs);
        }
        return attrs;
    }

    @Override
    public Attributes createActionInfo(String studyIUID, String seriesIUID, String sopIUID, ApplicationEntity ae) {
        QueryRetrieveView qrView = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).getQueryRetrieveView();
        return this.ejb.getSOPInstanceRefs(QueryServiceEJB.SOPInstanceRefsType.STGCMT, studyIUID, sopIUID, qrView, null, null, null, null, seriesIUID);
    }

    @Override
    public Attributes queryExportTaskInfo(Task exportTask, ApplicationEntity ae) {
        QueryRetrieveView qrView = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).getQueryRetrieveView();
        int retries = this.arcDev().getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                String seriesInstanceUID = exportTask.getSeriesInstanceUID();
                if (seriesInstanceUID == null || seriesInstanceUID.equals("*")) {
                    return this.ejb.queryStudyExportTaskInfo(exportTask.getStudyInstanceUID(), qrView);
                }
                Attributes attrs = this.ejb.querySeriesExportTaskInfo(exportTask.getStudyInstanceUID(), seriesInstanceUID, qrView);
                String sopInstanceUID = exportTask.getSOPInstanceUID();
                if (sopInstanceUID != null && !sopInstanceUID.equals("*")) {
                    attrs.setInt(2101768, VR.IS, new int[]{1});
                }
                return attrs;
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    LOG.warn("Failed to query Export Task Info for {}:\n", (Object)exportTask, (Object)e);
                    return null;
                }
                LOG.info("Failed to query Export Task Info for {} caused by {} - retry", (Object)exportTask, (Object)DicomServiceException.initialCauseOf((Throwable)e));
                try {
                    Thread.sleep(this.arcDev().storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("Failed to delay retry to query Export Task Info for {}:\n", (Object)exportTask, (Object)e2);
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public Attributes createRejectionNote(ApplicationEntity ae, String studyUID, String seriesUID, String objectUID, RejectionNote rjNote) {
        QueryRetrieveView qrView = ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).getQueryRetrieveView();
        Attributes attrs = this.ejb.getStudyAttributesWithSOPInstanceRefs(QueryServiceEJB.SOPInstanceRefsType.KOS_IOCM, studyUID, seriesUID, objectUID, qrView, null, null, null);
        if (attrs == null || !attrs.containsValue(4236149)) {
            return null;
        }
        this.mkKOS(attrs, rjNote);
        return attrs;
    }

    @Override
    public Attributes createRejectionNote(Attributes sopInstanceRefs, RejectionNote rjNote) {
        Attributes attrs = this.ejb.getStudyAttributes(sopInstanceRefs.getString(0x20000D));
        attrs.newSequence(4236149, 1).add(sopInstanceRefs);
        this.mkKOS(attrs, rjNote);
        return attrs;
    }

    private void mkKOS(Attributes attrs, RejectionNote rjNote) {
        QueryServiceImpl.mkKOS(attrs, rjNote.getRejectionNoteCode(), rjNote.getSeriesNumber(), rjNote.getInstanceNumber());
    }

    @Override
    public Attributes getStudyAttributes(String studyUID) {
        return this.ejb.getStudyAttributes(studyUID);
    }

    @Override
    public List<Object[]> getSeriesInstanceUIDs(String studyUID) {
        return this.em.createNamedQuery("Series.seriesIUIDsOfStudy", Object[].class).setParameter(1, (Object)studyUID).getResultList();
    }

    @Override
    public List<Object[]> getSOPInstanceUIDs(String studyUID) {
        return this.em.createNamedQuery("Instance.iuidsOfStudy", Object[].class).setParameter(1, (Object)studyUID).getResultList();
    }

    @Override
    public List<Object[]> getSOPInstanceUIDs(String studyUID, String seriesUID) {
        return this.em.createNamedQuery("Instance.iuidsOfSeries", Object[].class).setParameter(1, (Object)studyUID).setParameter(2, (Object)seriesUID).getResultList();
    }

    @Override
    public Integer getNumberOfFrames(String studyUID, String seriesUID, String objUID) {
        return (Integer)this.em.createNamedQuery("Instance.numberOfFrames", Integer.class).setParameter(1, (Object)studyUID).setParameter(2, (Object)seriesUID).setParameter(3, (Object)objUID).getSingleResult();
    }

    @Override
    public ZipInputStream openZipInputStream(QueryContext ctx, String storageID, String storagePath) throws IOException {
        return QueryServiceImpl.openZipInputStream(this.getStorage(storageID, ctx), storagePath, ctx.getQueryKeys().getString(0x20000D));
    }

    private static ZipInputStream openZipInputStream(Storage storage, String storagePath, String studyInstanceUID) throws IOException {
        return new ZipInputStream(storage.openInputStream(QueryServiceImpl.createReadContext(storage, storagePath, studyInstanceUID)));
    }

    private Storage getStorage(String storageID, QueryContext ctx) {
        Storage storage = ctx.getStorage(storageID);
        if (storage == null) {
            storage = this.getStorage(storageID);
            ctx.putStorage(storageID, storage);
        }
        return storage;
    }

    private Storage getStorage(String storageID) {
        return this.storageFactory.getStorage(this.arcDev().getStorageDescriptorNotNull(storageID));
    }

    private ArchiveDeviceExtension arcDev() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
    }

    private void addPurgedSOPInstanceRefs(Sequence refSeriesSeq, String studyUID, String[] seriesUIDs, String sopUID) {
        if (!this.arcDev().isPurgeInstanceRecords()) {
            return;
        }
        try (StorageCache storageCache = new StorageCache();){
            CriteriaBuilder cb = this.em.getCriteriaBuilder();
            CriteriaQuery q = cb.createTupleQuery();
            Root series = q.from(Series.class);
            Join metadata = series.join(Series_.metadata);
            Join study = series.join(Series_.study);
            this.em.createQuery(q.where(QueryServiceImpl.purgedSeriesPredicate(cb, studyUID, seriesUIDs, (Root<Series>)series, (Join<Series, Study>)study)).multiselect(new Selection[]{series.get(Series_.seriesInstanceUID), metadata.get(Metadata_.storageID), metadata.get(Metadata_.storagePath)})).getResultList().stream().forEach(tuple -> QueryServiceImpl.addSOPInstanceRefsFromMetadata(refSeriesSeq, studyUID, (String)tuple.get((TupleElement)series.get(Series_.seriesInstanceUID)), sopUID, (String)tuple.get((TupleElement)metadata.get(Metadata_.storageID)), (String)tuple.get((TupleElement)metadata.get(Metadata_.storagePath)), storageCache));
        }
    }

    private static Predicate[] purgedSeriesPredicate(CriteriaBuilder cb, String studyIUID, String[] seriesUID, Root<Series> series, Join<Series, Study> study) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(3);
        predicates.add(cb.equal((Expression)study.get(Study_.studyInstanceUID), (Object)studyIUID));
        if (!QueryBuilder.isUniversalMatching((String[])seriesUID)) {
            Path path = series.get(Series_.seriesInstanceUID);
            predicates.add(seriesUID.length == 1 ? cb.equal((Expression)path, (Object)seriesUID[0]) : path.in((Object[])seriesUID));
        }
        predicates.add(cb.equal((Expression)series.get(Series_.instancePurgeState), (Object)Series.InstancePurgeState.PURGED));
        return predicates.toArray(new Predicate[0]);
    }

    private static void addSOPInstanceRefsFromMetadata(Sequence refSeriesSeq, String studyUID, String seriesUID, String sopUID, String storageID, String storagePath, StorageCache storageCache) {
        Sequence refSOPSeq = null;
        Storage storage = storageCache.getStorage(storageID);
        try (ZipInputStream seriesMetadataStream = QueryServiceImpl.openZipInputStream(storage, storagePath, studyUID);){
            ZipEntry entry;
            while ((entry = seriesMetadataStream.getNextEntry()) != null) {
                if (sopUID == null || sopUID.equals(entry.getName())) {
                    JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)seriesMetadataStream, StandardCharsets.UTF_8)));
                    jsonReader.setSkipBulkDataURI(true);
                    Attributes metadata = jsonReader.readDataset(null);
                    if (refSOPSeq == null) {
                        Attributes refSeries = new Attributes(2);
                        refSeries.setString(0x20000E, VR.UI, seriesUID);
                        refSOPSeq = refSeries.newSequence(528793, 10);
                        refSeriesSeq.add(refSeries);
                    }
                    Attributes refSOP = new Attributes(4);
                    refSOP.setString(524372, VR.AE, metadata.getString(524372));
                    refSOP.setString(524374, VR.CS, metadata.getString(524374));
                    refSOP.setString(528720, VR.UI, metadata.getString(524310));
                    refSOP.setString(528725, VR.UI, entry.getName());
                    refSOPSeq.add(refSOP);
                }
                seriesMetadataStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read Series Metadata " + storagePath + "@" + storage.getStorageDescriptor(), e);
        }
    }

    private static ReadContext createReadContext(Storage storage, String storagePath, String studyInstanceUID) {
        ReadContext readContext = storage.createReadContext();
        readContext.setStoragePath(storagePath);
        readContext.setStudyInstanceUID(studyInstanceUID);
        return readContext;
    }

    private static void mkKOS(Attributes attrs, Code conceptNameCode, int seriesNumber, int instanceNumber) {
        Attributes studyRef = attrs.getNestedDataset(4236149);
        attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        attrs.setString(524312, VR.UI, UIDUtils.createUID());
        attrs.setDate(2251950138064947L, new Date[]{new Date()});
        attrs.setString(524384, VR.CS, "KO");
        attrs.setNull(528657, VR.SQ);
        attrs.setString(0x20000E, VR.UI, UIDUtils.createUID());
        attrs.setInt(0x200011, VR.IS, new int[]{seriesNumber});
        attrs.setInt(2097171, VR.IS, new int[]{instanceNumber});
        attrs.setString(0x40A040, VR.CS, "CONTAINER");
        attrs.setString(4235344, VR.CS, "SEPARATE");
        attrs.newSequence(4235331, 1).add(conceptNameCode.toItem());
        attrs.newSequence(4236548, 1).add(QueryServiceImpl.templateIdentifier());
        Sequence contentSeq = attrs.newSequence(4237104, 1);
        for (Attributes seriesRef : studyRef.getSequence(528661)) {
            for (Attributes sopRef : seriesRef.getSequence(528793)) {
                String cuid = sopRef.getString(528720);
                String iuid = sopRef.getString(528725);
                contentSeq.add(QueryServiceImpl.contentItem(QueryServiceImpl.typeOf(cuid), QueryServiceImpl.refSOP(cuid, iuid)));
            }
        }
    }

    private static String typeOf(String cuid) {
        int index;
        String uidName = UID.nameOf((String)cuid);
        return uidName.startsWith("Image", (index = uidName.lastIndexOf(" Storage")) - 5) ? "IMAGE" : (uidName.startsWith("Waveform", index - 8) ? "WAVEFORM" : "COMPOSITE");
    }

    private static Attributes templateIdentifier() {
        Attributes attrs = new Attributes(2);
        attrs.setString(524549, VR.CS, "DCMR");
        attrs.setString(4250368, VR.CS, "2010");
        return attrs;
    }

    private static Attributes contentItem(String valueType, Attributes refSOP) {
        Attributes item = new Attributes(3);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, valueType);
        item.newSequence(528793, 1).add(refSOP);
        return item;
    }

    private static Attributes refSOP(String cuid, String iuid) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, cuid);
        item.setString(528725, VR.UI, iuid);
        return item;
    }

    @Override
    public AttributesCoercion getAttributesCoercion(final QueryContext ctx) {
        return new AttributesCoercion(){

            public void coerce(Attributes attrs, Attributes modified) throws Exception {
                ArchiveAttributeCoercion rule;
                ArchiveAEExtension aeExt = ctx.getArchiveAEExtension();
                List coercions = aeExt.attributeCoercions2().filter(descriptor -> descriptor.match(TransferCapability.Role.SCU, Dimse.C_FIND_RSP, ctx.getSOPClassUID(), ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), attrs)).collect(Collectors.toList());
                block6: for (ArchiveAttributeCoercion2 coercion : coercions) {
                    try {
                        if (!QueryServiceImpl.this.coercionFactory.getCoercionProcessor(coercion).coerce(coercion, ctx.getSOPClassUID(), ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), attrs, modified) || !coercion.isCoercionSufficient()) continue;
                    }
                    catch (Exception e) {
                        LOG.info("Failed to apply {}:\n", (Object)coercion, (Object)e);
                        switch (coercion.getCoercionOnFailure()) {
                            case RETHROW: {
                                throw e;
                            }
                            case CONTINUE: {
                                continue block6;
                            }
                        }
                    }
                    break;
                }
                if (coercions.isEmpty() && (rule = aeExt.findAttributeCoercion(Dimse.C_FIND_RSP, TransferCapability.Role.SCU, ctx.getSOPClassUID(), ctx.getRemoteHostName(), ctx.getCallingAET(), ctx.getLocalHostName(), ctx.getCalledAET(), attrs)) != null) {
                    QueryServiceImpl.this.getAttributesCoercion(ctx, rule).coerce(attrs, modified);
                }
            }

            public String remapUID(String uid) {
                return uid;
            }
        };
    }

    private AttributesCoercion getAttributesCoercion(QueryContext ctx, ArchiveAttributeCoercion rule) {
        AttributesCoercion coercion = null;
        String xsltStylesheetURI = rule.getXSLTStylesheetURI();
        if (xsltStylesheetURI != null) {
            try {
                Templates tpls = TemplatesCache.getDefault().get(StringUtils.replaceSystemProperties((String)xsltStylesheetURI));
                coercion = new XSLTAttributesCoercion(tpls, null).includeKeyword(!rule.isNoKeywords()).setupTransformer(this.setupTransformer(ctx));
            }
            catch (TransformerConfigurationException e) {
                LOG.error("{}: Failed to compile XSL: {}", new Object[]{ctx.getAssociation(), xsltStylesheetURI, e});
            }
        }
        coercion = rule.mergeAttributes(coercion);
        coercion = NullifyAttributesCoercion.valueOf((int[])rule.getNullifyTags(), (AttributesCoercion)coercion);
        String leadingCFindSCP = rule.getLeadingCFindSCP();
        if (leadingCFindSCP != null) {
            if (ctx.getQueryRetrieveLevel() == QueryRetrieveLevel2.PATIENT || ctx.getQueryRetrieveLevel() == null && ctx.getSOPClassUID().equals("1.2.840.10008.5.1.4.31")) {
                LOG.info("Leading C-FIND coercion not intended for Patient / MWL queries.");
            } else {
                coercion = new CFindSCUAttributeCoercion(ctx.getLocalApplicationEntity(), leadingCFindSCP, rule.getAttributeUpdatePolicy(), this.cfindscu, this.leadingCFindSCPQueryCache, coercion);
            }
        }
        LOG.info("Coerce Attributes from rule: {}", (Object)rule);
        return coercion;
    }

    private SAXTransformer.SetupTransformer setupTransformer(QueryContext ctx) {
        return t -> {
            t.setParameter("LocalAET", ctx.getCalledAET());
            if (ctx.getCallingAET() != null) {
                t.setParameter("RemoteAET", ctx.getCallingAET());
            }
            if (ctx.getRemoteHostName() != null) {
                t.setParameter("RemoteHost", ctx.getRemoteHostName());
            }
        };
    }

    @Override
    public CFindSCU cfindSCU() {
        return this.cfindscu;
    }

    @Override
    public List<String> getDistinctModalities() {
        return this.em.createNamedQuery("Series.findDistinctModalities", String.class).getResultList();
    }

    @Override
    public List<String> getDistinctInstitutions(String entity) {
        return this.em.createNamedQuery(entity.equals(Entity.Series.name()) ? "Series.findDistinctInstitutions" : "MWLItem.findDistinctInstitutions", String.class).getResultList();
    }

    @Override
    public List<Tuple> unknownSizeStudies(Date dt, int fetchSize) {
        return this.ejb.unknownSizeStudies(dt, fetchSize);
    }

    @Override
    public CriteriaQuery<Patient> createPatientWithUnknownIssuerQuery(QueryParam queryParam, Attributes queryKeys) {
        IDWithIssuer[] iDWithIssuerArray;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        QueryBuilder builder = new QueryBuilder(cb);
        CriteriaQuery q = cb.createQuery(Patient.class);
        Root patient = q.from(Patient.class);
        patient.join(Patient_.attributesBlob);
        patient.join(Patient_.patientID);
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)queryKeys);
        if (idWithIssuer != null) {
            IDWithIssuer[] iDWithIssuerArray2 = new IDWithIssuer[1];
            iDWithIssuerArray = iDWithIssuerArray2;
            iDWithIssuerArray2[0] = idWithIssuer;
        } else {
            iDWithIssuerArray = IDWithIssuer.EMPTY;
        }
        List predicates = builder.patientPredicates(q, patient, iDWithIssuerArray, null, queryKeys, queryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        q.orderBy(builder.orderPatients(patient, Collections.singletonList(OrderByTag.asc((int)0x100020))));
        return q;
    }

    @Override
    public CriteriaQuery<AttributesBlob> createPatientAttributesQuery(QueryParam queryParam, Attributes queryKeys) {
        IDWithIssuer[] iDWithIssuerArray;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        QueryBuilder builder = new QueryBuilder(cb);
        CriteriaQuery q = cb.createQuery(AttributesBlob.class);
        Root patient = q.from(Patient.class);
        Join blobJoin = patient.join(Patient_.attributesBlob);
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)queryKeys);
        if (idWithIssuer != null) {
            IDWithIssuer[] iDWithIssuerArray2 = new IDWithIssuer[1];
            iDWithIssuerArray = iDWithIssuerArray2;
            iDWithIssuerArray2[0] = idWithIssuer;
        } else {
            iDWithIssuerArray = IDWithIssuer.EMPTY;
        }
        List predicates = builder.patientPredicates(q, patient, iDWithIssuerArray, idWithIssuer == null && queryParam.isFilterByIssuerOfPatientID() ? Issuer.fromIssuerOfPatientID((Attributes)queryKeys) : null, queryKeys, queryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        q.orderBy(new Order[]{cb.asc((Expression)blobJoin.get(AttributesBlob_.pk))});
        return q.select((Selection)blobJoin);
    }

    @Override
    public Date getLastModified(boolean ignorePatientUpdates, String studyUID, String seriesUID) {
        List<Object[]> dates = this.queryLastModified(studyUID, seriesUID);
        int first = ignorePatientUpdates ? 1 : 0;
        Date lastModified = null;
        for (Object[] objs : dates) {
            for (int i = first; i < objs.length; ++i) {
                Date date = (Date)objs[i];
                if (lastModified != null && lastModified.compareTo(date) >= 0) continue;
                lastModified = date;
            }
        }
        return lastModified;
    }

    private List<Object[]> queryLastModified(String studyIUID, String seriesIUID) {
        List resultList = (seriesIUID != null ? this.em.createNamedQuery("Instance.findLastModifiedSeriesLevel", Object[].class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)seriesIUID) : this.em.createNamedQuery("Instance.findLastModifiedStudyLevel", Object[].class).setParameter(1, (Object)studyIUID)).getResultList();
        if (this.arcDev().isPurgeInstanceRecords()) {
            resultList.addAll((seriesIUID != null ? this.em.createNamedQuery("Series.findLastModifiedSeriesLevel", Object[].class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)seriesIUID).setParameter(3, (Object)Series.InstancePurgeState.PURGED) : this.em.createNamedQuery("Series.findLastModifiedStudyLevel", Object[].class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)Series.InstancePurgeState.PURGED)).getResultList());
        }
        return resultList;
    }

    @Override
    public List<Attributes> queryMWL(MergeMWLQueryParam queryParam) {
        LOG.info("Query for MWL Items with {}", (Object)queryParam);
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root mwlItem = q.from(MWLItem.class);
        Join patient = mwlItem.join(MWLItem_.patient);
        Join patientID = patient.join(Patient_.patientID);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (queryParam.localMwlWorklistLabels.length > 0) {
            predicates.add(cb.or((Expression)mwlItem.get(MWLItem_.worklistLabel).in((Object[])queryParam.localMwlWorklistLabels), (Expression)cb.equal((Expression)mwlItem.get(MWLItem_.worklistLabel), (Object)"*")));
        }
        if (queryParam.localMwlStatus.length > 0) {
            predicates.add(mwlItem.get(MWLItem_.status).in((Object[])queryParam.localMwlStatus));
        }
        if (queryParam.patientID != null) {
            predicates.add(cb.equal((Expression)patientID.get(PatientID_.id), (Object)queryParam.patientID));
        }
        if (queryParam.accessionNumber != null) {
            predicates.add(cb.equal((Expression)mwlItem.get(MWLItem_.accessionNumber), (Object)queryParam.accessionNumber));
        }
        if (queryParam.studyIUID != null) {
            predicates.add(cb.equal((Expression)mwlItem.get(MWLItem_.studyInstanceUID), (Object)queryParam.studyIUID));
        }
        if (queryParam.spsID != null) {
            predicates.add(cb.equal((Expression)mwlItem.get(MWLItem_.scheduledProcedureStepID), (Object)queryParam.spsID));
        }
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        q.multiselect(new Selection[]{mwlItem.get(MWLItem_.attributesBlob).get(AttributesBlob_.encodedAttributes), patient.get(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes)});
        TypedQuery namedQuery = this.em.createQuery(q);
        try (Stream resultStream = namedQuery.getResultStream();){
            List<Attributes> list = resultStream.map(result -> {
                Attributes mwlAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])result.get(0, byte[].class)), null);
                Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])result.get(1, byte[].class)), null);
                Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, mwlAttrs});
                mwlAttrs.addAll(patAttrs);
                return mwlAttrs;
            }).collect(Collectors.toList());
            return list;
        }
    }

    private class StorageCache
    implements Closeable {
        private final Map<String, Storage> storageMap = new HashMap<String, Storage>();

        private StorageCache() {
        }

        public Storage getStorage(String storageID) {
            return this.storageMap.computeIfAbsent(storageID, x$0 -> QueryServiceImpl.this.getStorage((String)x$0));
        }

        @Override
        public void close() {
            for (Storage storage : this.storageMap.values()) {
                SafeClose.close((Closeable)storage);
            }
        }
    }
}

