/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.procedure.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.DateUtils;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.MWLIdleTimeout;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.procedure.impl.ProcedureServiceEJB;
import org.dcm4chee.arc.query.util.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MWLScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MWLScheduler.class);
    @Inject
    private ProcedureServiceEJB ejb;

    protected MWLScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getMWLPollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        this.deleteMWL(arcDev);
        this.updateMWL(arcDev);
    }

    private void deleteMWL(ArchiveDeviceExtension arcDev) {
        ArrayList<SPSStatus> specifiedSPSStatus = new ArrayList<SPSStatus>();
        Duration unspecifiedSPSStatusDelay = null;
        for (String string : arcDev.getDeleteMWLDelay()) {
            String[] spsStatusWithDelay = string.split(":");
            if (spsStatusWithDelay.length == 1) {
                unspecifiedSPSStatusDelay = this.delay(spsStatusWithDelay[0]);
                continue;
            }
            SPSStatus spsStatus = this.spsStatus(spsStatusWithDelay[0]);
            Duration delay = this.delay(spsStatusWithDelay[1]);
            if (spsStatus == null || delay == null) continue;
            specifiedSPSStatus.add(spsStatus);
            this.deleteMWL(spsStatus, delay);
        }
        if (unspecifiedSPSStatusDelay != null) {
            for (String string : SPSStatus.values()) {
                if (specifiedSPSStatus.contains(string)) continue;
                this.deleteMWL((SPSStatus)string, unspecifiedSPSStatusDelay);
            }
        }
    }

    private void deleteMWL(SPSStatus spsStatus, Duration delay) {
        int count;
        Date before = new Date(System.currentTimeMillis() - delay.getSeconds() * 1000L);
        int deleted = 0;
        int mwlFetchSize = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getMWLFetchSize();
        do {
            count = 0;
            for (long mwlItemPK : this.ejb.mwlItemPKs(spsStatus, before, mwlFetchSize)) {
                try {
                    if (!this.ejb.deleteMWL(mwlItemPK)) continue;
                    ++count;
                }
                catch (Exception e) {
                    LOG.warn("Failed to delete MWL[pk={}]:{}", new Object[]{mwlItemPK, System.lineSeparator(), e});
                }
            }
            deleted += count;
        } while (count >= mwlFetchSize);
        if (deleted > 0) {
            LOG.info("Deleted {} MWL Items with SPS Status {}", (Object)deleted, (Object)spsStatus);
        }
    }

    private SPSStatus spsStatus(String name) {
        try {
            return SPSStatus.valueOf((String)name);
        }
        catch (Exception e) {
            LOG.info("Invalid SPS Status: {}", (Object)name);
            return null;
        }
    }

    private Duration delay(String val) {
        try {
            return Duration.valueOf((String)val);
        }
        catch (Exception e) {
            LOG.info("Invalid duration: {}", (Object)val);
            return null;
        }
    }

    private void updateMWL(ArchiveDeviceExtension arcDev) {
        int mwlFetchSize = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getMWLFetchSize();
        arcDev.getMWLIdleTimeouts().forEach(mwlIdleTimeout -> {
            int count;
            int updated = 0;
            do {
                count = this.ejb.updateMatchingSPS(mwlIdleTimeout.getStatusOnIdle(), this.queryKeys((MWLIdleTimeout)mwlIdleTimeout), this.queryParam((MWLIdleTimeout)mwlIdleTimeout), mwlFetchSize);
                updated += count;
            } while (count >= mwlFetchSize);
            if (updated > 0) {
                LOG.info("Updated {} MWL Items with MWL Idle Timeout {}", (Object)updated, mwlIdleTimeout);
            }
        });
    }

    private Attributes queryKeys(MWLIdleTimeout mwlIdleTimeout) {
        Attributes attrs = new Attributes();
        Attributes sps = new Attributes();
        sps.setString(0x400020, VR.CS, (String[])Stream.of(SPSStatus.values()).filter(spsStatus -> spsStatus != mwlIdleTimeout.getStatusOnIdle()).map(Enum::name).toArray(String[]::new));
        Date date = new Date(System.currentTimeMillis() - mwlIdleTimeout.getIdleTimeout().getSeconds() * 1000L);
        sps.setString(0x400002, VR.DA, "-" + DateUtils.formatDA(null, (Date)date));
        sps.setString(0x400003, VR.TM, DateUtils.formatTM(null, (Date)date));
        if (mwlIdleTimeout.getScheduledStationAETitles().length > 0) {
            sps.setString(0x400001, VR.AE, mwlIdleTimeout.getScheduledStationAETitles());
        }
        attrs.newSequence(0x400100, 1).add(sps);
        return attrs;
    }

    private QueryParam queryParam(MWLIdleTimeout mwlIdleTimeout) {
        QueryParam queryParam = new QueryParam(this.device.getApplicationEntity(mwlIdleTimeout.getAETitle(), true));
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(false);
        queryParam.setCalledAET(mwlIdleTimeout.getAETitle());
        return queryParam;
    }
}

