/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.prefetch.impl;

import java.net.InetAddress;
import java.net.Socket;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.HL7PrefetchHistory;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.EntitySelector;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.HL7PrefetchRule;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.mgt.RetrieveManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PrefetchScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PrefetchScheduler.class);
    @Inject
    private Device device;
    @Inject
    private CFindSCU findSCU;
    @Inject
    private RetrieveManager retrieveManager;
    @Inject
    private TaskManager taskManager;
    @Inject
    private HL7PrefetchHistory hl7PrefetchHistory;

    public void onHL7Connection(@Observes HL7ConnectionEvent event) {
        if (event.getType() != HL7ConnectionEvent.Type.MESSAGE_PROCESSED || event.getException() != null) {
            return;
        }
        UnparsedHL7Message hl7Message = event.getHL7Message();
        HL7Application hl7App = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(hl7Message.msh().getReceivingApplicationWithFacility(), true);
        if (hl7App == null) {
            return;
        }
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (arcHL7App == null || !arcHL7App.hasHL7PrefetchRules()) {
            return;
        }
        Socket sock = event.getSocket();
        String host = ReverseDNS.hostNameOf((InetAddress)sock.getInetAddress());
        HL7Fields hl7Fields = new HL7Fields(hl7Message, hl7App.getHL7DefaultCharacterSet());
        Calendar now = Calendar.getInstance();
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        arcHL7App.hl7PrefetchRules().filter(rule -> rule.match(host, hl7Fields)).forEach(rule -> this.prefetch(sock, hl7Fields, (HL7PrefetchRule)rule, arcdev, now, hl7Message));
    }

    private void prefetch(Socket sock, HL7Fields hl7Fields, HL7PrefetchRule rule, ArchiveDeviceExtension arcdev, Calendar now, UnparsedHL7Message hl7Message) {
        try {
            LOG.info("{}: Apply {}", (Object)sock, (Object)rule);
            Date notRetrievedAfter = new Date(now.getTimeInMillis() - rule.getSuppressDuplicateRetrieveInterval().getSeconds() * 1000L);
            Calendar hl7PrefetchDateTime = this.hl7PrefetchDateTime(hl7Fields, rule, now, hl7Message);
            Date scheduledTime = ScheduleExpression.ceil((Calendar)hl7PrefetchDateTime, (ScheduleExpression[])rule.getSchedules()).getTime();
            String cx = hl7Fields.get("PID-3", null);
            IDWithIssuer idWithIssuer = this.idWithIssuer(rule, cx);
            if (idWithIssuer == null) {
                LOG.info("None of the qualified patient identifier pairs in PID-3 {} match with configured HL7 Prefetch Rule[name={}, PrefetchForAssigningAuthorityOfPatientID={}]", new Object[]{cx, rule.getCommonName(), rule.getPrefetchForAssigningAuthorityOfPatientID()});
                return;
            }
            if (this.hl7PrefetchHistory.suppressDuplicate(rule, idWithIssuer)) {
                LOG.info("HL7 Prefetch Rule[name={}] already applied on previous received HL7 Message with PID-3 {}", (Object)rule.getCommonName(), (Object)cx);
                return;
            }
            IDWithIssuer pid = rule.ignoreAssigningAuthorityOfPatientID(idWithIssuer);
            String batchID = rule.getCommonName() + "[" + pid + "]";
            int count = 0;
            if (rule.getEntitySelectors().length == 0) {
                count = this.prefetch(pid, batchID, new Attributes(0), -1, rule, arcdev, scheduledTime, notRetrievedAfter);
            } else {
                for (EntitySelector selector : rule.getEntitySelectors()) {
                    count += this.prefetch(pid, batchID, selector.getQueryKeys(hl7Fields), selector.getNumberOfPriors(), rule, arcdev, scheduledTime, notRetrievedAfter);
                }
            }
            if (count > 0 && this.scheduledOnThisDevice(rule.getPrefetchDeviceName()) && scheduledTime.getTime() <= now.getTimeInMillis()) {
                this.taskManager.processQueue(rule.getQueueName());
            }
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to apply {}:\n", new Object[]{sock, rule, e});
        }
    }

    private boolean scheduledOnThisDevice(String deviceName) {
        return deviceName == null || deviceName.equals(this.device.getDeviceName());
    }

    private IDWithIssuer idWithIssuer(HL7PrefetchRule rule, String cx) {
        Issuer prefetchForAssigningAuthorityOfPatientID = rule.getPrefetchForAssigningAuthorityOfPatientID();
        if (prefetchForAssigningAuthorityOfPatientID == null) {
            return new IDWithIssuer(cx);
        }
        for (String cx1 : cx.split("~")) {
            IDWithIssuer idWithIssuer = new IDWithIssuer(cx1);
            if (!prefetchForAssigningAuthorityOfPatientID.equals((Object)idWithIssuer.getIssuer())) continue;
            return idWithIssuer;
        }
        return null;
    }

    private int prefetch(IDWithIssuer pid, String batchID, Attributes queryKeys, int numberOfPriors, HL7PrefetchRule rule, ArchiveDeviceExtension arcdev, Date scheduledDate, Date notRetrievedAfter) throws Exception {
        Attributes keys = new Attributes(queryKeys.size() + 4);
        keys.addAll(queryKeys);
        keys.setString(524370, VR.CS, "STUDY");
        if (keys.containsValue(0x20000D)) {
            return this.scheduleRetrieveTasks(keys, rule, batchID, scheduledDate, notRetrievedAfter);
        }
        keys.setString(0x100020, VR.LO, pid.getID());
        Issuer issuer = pid.getIssuer();
        if (issuer != null) {
            issuer.toIssuerOfPatientID(keys);
        }
        if (!keys.contains(524320)) {
            keys.setNull(524320, VR.DA);
        }
        keys.setNull(0x20000D, VR.UI);
        keys.setNull(2101768, VR.IS);
        ApplicationEntity localAE = arcdev.getDevice().getApplicationEntity(rule.getAETitle(), true);
        List matches = this.findSCU.find(localAE, rule.getPrefetchCFindSCP(), EnumSet.of(QueryOption.DATETIME), 0, keys);
        if (numberOfPriors > 0 && matches.size() > numberOfPriors) {
            matches.sort(Comparator.comparing(match -> match.getString(524320, "")));
            do {
                matches.remove(0);
            } while (matches.size() > numberOfPriors);
        }
        int count = 0;
        for (Attributes match2 : matches) {
            if (rule.getDestinationCFindSCP() != null && this.isAvailableAt(match2, localAE, rule.getDestinationCFindSCP())) continue;
            this.scheduleRetrieveTasks(match2, rule, batchID, scheduledDate, notRetrievedAfter);
        }
        return count;
    }

    private boolean isAvailableAt(Attributes match, ApplicationEntity localAE, String destinationCFindSCP) throws Exception {
        List matches = this.findSCU.findStudy(localAE, destinationCFindSCP, 0, match.getString(0x20000D), new int[]{2101768});
        return !matches.isEmpty() && ((Attributes)matches.get(0)).getInt(2101768, 0) >= match.getInt(2101768, 0);
    }

    private int scheduleRetrieveTasks(Attributes keys, HL7PrefetchRule rule, String batchID, Date scheduledDate, Date notRetrievedAfter) {
        int count = 0;
        for (String destination : rule.getPrefetchCStoreSCPs()) {
            count += this.scheduleRetrieveTask(keys, rule, batchID, scheduledDate, notRetrievedAfter, destination);
        }
        return count;
    }

    private int scheduleRetrieveTask(Attributes keys, HL7PrefetchRule rule, String batchID, Date scheduledDate, Date notRetrievedAfter, String destination) {
        ExternalRetrieveContext ctx = new ExternalRetrieveContext().setDeviceName(rule.getPrefetchDeviceName() == null ? this.device.getDeviceName() : rule.getPrefetchDeviceName()).setQueueName(rule.getQueueName()).setBatchID(batchID).setLocalAET(rule.getAETitle()).setFindSCP(rule.getPrefetchCFindSCP()).setRemoteAET(rule.getPrefetchCMoveSCP()).setDestinationAET(destination).setScheduledTime(scheduledDate).setKeys(new Attributes(keys, new int[]{524370, 0x20000D}));
        return this.retrieveManager.scheduleRetrieveTask(ctx, notRetrievedAfter);
    }

    private Calendar hl7PrefetchDateTime(HL7Fields hl7Fields, HL7PrefetchRule rule, Calendar now, UnparsedHL7Message hl7Message) {
        String prefetchDateTimeField = rule.getPrefetchDateTimeField();
        if (prefetchDateTimeField == null) {
            return now;
        }
        String value = hl7Fields.get(prefetchDateTimeField, null);
        HL7Segment msh = hl7Message.msh();
        if (value == null || value.length() < 8) {
            LOG.info("Configured PrefetchDateTimeField {} either absent or imprecise in HL7 message[type={}, controlID={}] : {} ", new Object[]{prefetchDateTimeField, msh.getMessageType(), msh.getMessageControlID(), value});
            return now;
        }
        DatePrecision precision = new DatePrecision();
        Date date = DateUtils.parseDT(null, (String)value, (DatePrecision)precision);
        if (precision.lastField <= 2) {
            LOG.info("Configured PrefetchDateTimeField {} imprecise in HL7 message[type={}, controlID={}] : {} ", new Object[]{prefetchDateTimeField, msh.getMessageType(), msh.getMessageControlID(), value});
            return now;
        }
        Duration prefetchInAdvance = rule.getPrefetchInAdvance();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime() - (prefetchInAdvance != null ? prefetchInAdvance.getSeconds() * 1000L : 0L));
        return cal;
    }
}

