/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.fhir;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.Base64;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.keycloak.AccessTokenRequestor;
import org.dcm4chee.arc.pdq.AbstractPDQService;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.dcm4chee.arc.pdq.fhir.SAXTransformer;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FHIRPDQService
extends AbstractPDQService {
    private static final Logger LOG = LoggerFactory.getLogger(FHIRPDQService.class);
    private static final String FHIR_PAT_2_DCM_XSL = "${jboss.server.temp.url}/dcm4chee-arc/fhir-pat2dcm.xsl";
    private final IWebApplicationCache webAppCache;
    private final AccessTokenRequestor accessTokenRequestor;
    private final Event<PDQServiceContext> pdqEvent;

    public FHIRPDQService(PDQServiceDescriptor descriptor, IWebApplicationCache webAppCache, AccessTokenRequestor accessTokenRequestor, Event<PDQServiceContext> pdqEvent) {
        super(descriptor);
        this.webAppCache = webAppCache;
        this.accessTokenRequestor = accessTokenRequestor;
        this.pdqEvent = pdqEvent;
    }

    public Attributes query(PDQServiceContext ctx) throws PDQServiceException {
        try {
            this.requireQueryEntity(Entity.Patient);
            Attributes demographics = this.query(ctx, this.webApp());
            ctx.setPatientAttrs(demographics);
            this.pdqEvent.fire((Object)ctx);
            return demographics;
        }
        catch (ConfigurationException e) {
            throw new PDQServiceException((Throwable)e);
        }
    }

    private Attributes query(PDQServiceContext ctx, WebApplication webApp) throws PDQServiceException {
        ctx.setFhirWebAppName(webApp.getApplicationName());
        Map props = webApp.getProperties();
        try {
            String url = webApp.getServiceURL().toString();
            ResteasyClient client = this.accessTokenRequestor.resteasyClientBuilder(url, Boolean.parseBoolean((String)props.get("allow-any-hostname")), Boolean.parseBoolean((String)props.get("disable-trust-manager"))).build();
            ResteasyWebTarget target = client.target(url);
            target = this.setQueryParameters(target, ctx);
            Invocation.Builder request = target.request();
            this.setHeaders(request);
            String authorization = this.authorization(webApp);
            if (authorization != null) {
                request.header("Authorization", (Object)authorization);
            }
            LOG.info("Request invoked is : {}", (Object)target.getUri());
            Response response = request.get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return null;
            }
            return SAXTransformer.transform(response, this.descriptor.getProperties().getOrDefault("XSLStylesheetURI", FHIR_PAT_2_DCM_XSL), null);
        }
        catch (Exception e) {
            LOG.info("Exception caught on querying FHIR Supplier {}", (Object)webApp);
            throw new PDQServiceException((Throwable)e);
        }
    }

    private String authorization(WebApplication webApp) throws Exception {
        Map props = webApp.getProperties();
        return webApp.getKeycloakClientID() != null ? "Bearer " + this.accessTokenRequestor.getAccessToken2(webApp).getToken() : (props.containsKey("bearer-token") ? "Bearer " + (String)props.get("bearer-token") : (props.containsKey("basic-auth") ? "Basic " + FHIRPDQService.encodeBase64(((String)props.get("basic-auth")).getBytes(StandardCharsets.UTF_8)) : null));
    }

    private WebApplication webApp() throws ConfigurationException {
        return this.webAppCache.findWebApplication(this.descriptor.getPDQServiceURI().getSchemeSpecificPart());
    }

    private String identifier(IDWithIssuer pid) {
        String system = this.systemOf(pid.getIssuer());
        return system != null ? system + "|" + pid.getID() : pid.getID();
    }

    private String systemOf(Issuer issuer) {
        if (issuer != null) {
            String system;
            String prefix;
            String universalEntityID = issuer.getUniversalEntityID();
            String type = issuer.getUniversalEntityIDType();
            if (universalEntityID != null && type != null && (prefix = (String)this.descriptor.getProperties().get("search.identifier.system.type." + type)) != null) {
                return prefix.equals("NONE") ? universalEntityID : prefix + universalEntityID;
            }
            String issuerOfPatientID = issuer.getLocalNamespaceEntityID();
            if (issuerOfPatientID != null && (system = (String)this.descriptor.getProperties().get("search.identifier.system.issuer." + issuerOfPatientID)) != null) {
                return system;
            }
        }
        return (String)this.descriptor.getProperties().get("search.identifier.system");
    }

    private void setHeaders(Invocation.Builder request) {
        this.descriptor.getProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("header.")).forEach(e -> request.header(((String)e.getKey()).substring(7), e.getValue()));
    }

    private ResteasyWebTarget setQueryParameters(ResteasyWebTarget webTarget, PDQServiceContext ctx) {
        webTarget = webTarget.queryParam("identifier", new Object[]{this.identifier(ctx.getPatientID())});
        for (Map.Entry e : this.descriptor.getProperties().entrySet()) {
            if (!((String)e.getKey()).startsWith("search.") || ((String)e.getKey()).startsWith("identifier.", 7)) continue;
            webTarget = webTarget.queryParam(((String)e.getKey()).substring(7), new Object[]{e.getValue()});
        }
        String targetURI = webTarget.getUri().toString();
        LOG.info("Web Target is : {}", (Object)targetURI);
        ctx.setFhirQueryParams(targetURI.substring(targetURI.indexOf(63) + 1));
        return webTarget;
    }

    private static String encodeBase64(byte[] b) {
        int len = b.length * 4 / 3 + 3 & 0xFFFFFFFC;
        char[] ch = new char[len];
        Base64.encode((byte[])b, (int)0, (int)b.length, (char[])ch, (int)0);
        return new String(ch);
    }
}

