/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.metrics.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.MetricsDescriptor;
import org.dcm4chee.arc.metrics.MetricsService;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="/metrics")
public class MetricsRS {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRS.class);
    @Inject
    private Device device;
    @Inject
    private MetricsService metricsService;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="bin")
    @Pattern(regexp="^[1-9][0-9]*$")
    @DefaultValue(value="1")
    private @Pattern(regexp="^[1-9][0-9]*$") String binSize;
    @QueryParam(value="limit")
    @Pattern(regexp="^[1-9][0-9]*$")
    private @Pattern(regexp="^[1-9][0-9]*$") String limit;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    public Response listMetricsDescriptors() {
        this.logRequest();
        try {
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                for (MetricsDescriptor metricsDescriptor : this.sortedMetricsDescriptors()) {
                    JsonWriter writer = new JsonWriter(gen);
                    gen.writeStartObject();
                    writer.writeNotNullOrDef("dcmMetricsName", (Object)metricsDescriptor.getMetricsName(), null);
                    writer.writeNotNullOrDef("dicomDescription", (Object)metricsDescriptor.getDescription(), null);
                    writer.writeNotNullOrDef("dcmMetricsRetentionPeriod", (Object)metricsDescriptor.getRetentionPeriod(), null);
                    writer.writeNotNullOrDef("dcmUnit", (Object)metricsDescriptor.getUnit(), null);
                    gen.writeEnd();
                }
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/{name:.+}")
    public Response getMetrics(@PathParam(value="name") String name) {
        this.logRequest();
        if (!this.metricsService.exists(name)) {
            return this.errResponse("No metrics with given name found: " + name, Response.Status.NOT_FOUND);
        }
        try {
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                this.metricsService.forEach(name, this.parseInt(this.limit), this.parseInt(this.binSize), dss -> this.write(gen, (DoubleSummaryStatistics)dss));
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private MetricsDescriptor[] sortedMetricsDescriptors() {
        return (MetricsDescriptor[])((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getMetricsDescriptors().stream().sorted(Comparator.comparing(MetricsDescriptor::getMetricsName)).toArray(MetricsDescriptor[]::new);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private void write(JsonGenerator gen, DoubleSummaryStatistics dss) {
        gen.writeStartObject();
        if (dss != null) {
            gen.write("count", dss.getCount()).write("min", dss.getMin()).write("avg", dss.getAverage()).write("max", dss.getMax());
        }
        gen.writeEnd();
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

