/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.keyvalue.impl;

import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.dcm4chee.arc.entity.KeyValue;
import org.dcm4chee.arc.keyvalue.ContentTypeMismatchException;
import org.dcm4chee.arc.keyvalue.KeyValueService;
import org.dcm4chee.arc.keyvalue.UserMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class KeyValueServiceEJB
implements KeyValueService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueServiceEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    @Override
    public KeyValue getKeyValue(String key, String user) {
        try {
            return this.findByKeyAndUser(key, user);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public void setKeyValue(String key, String user, boolean share, String value, String contentType) throws UserMismatchException, ContentTypeMismatchException {
        try {
            KeyValue keyValue = this.findByKey(key);
            if (!keyValue.getContentType().equals(contentType)) {
                throw new ContentTypeMismatchException("There is already a Value set for the specified Key with a different content type.");
            }
            if (!share && keyValue.getUsername() != null && !keyValue.getUsername().equals(user)) {
                throw new UserMismatchException("There is already a Value set for the specified Key by a different user.");
            }
            this.updateKeyValue(keyValue, share ? null : user, value, contentType);
        }
        catch (NoResultException e) {
            this.createKeyValue(key, share ? null : user, value, contentType);
        }
    }

    @Override
    public KeyValue deleteKeyValue(String key, String user) throws UserMismatchException {
        try {
            KeyValue keyValue = this.findByKey(key);
            if (keyValue.getUsername() != null && !keyValue.getUsername().equals(user)) {
                throw new UserMismatchException("The Value for the specified Key was set by a different user.");
            }
            this.em.remove((Object)keyValue);
            return keyValue;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Long> keyValuePKs(Date before, int fetchSize) {
        return this.em.createNamedQuery("KeyValue.PkUpdatedBefore", Long.class).setParameter(1, (Object)before).setMaxResults(fetchSize).getResultList();
    }

    @Override
    public int deleteKeyValues(List<Long> pks) {
        return this.em.createNamedQuery("KeyValue.DeleteByPKs").setParameter(1, pks).executeUpdate();
    }

    private KeyValue findByKey(String key) {
        return (KeyValue)this.em.createNamedQuery("KeyValue.FindByKey", KeyValue.class).setParameter(1, (Object)key).getSingleResult();
    }

    private KeyValue findByKeyAndUser(String key, String user) {
        return (KeyValue)this.em.createNamedQuery("KeyValue.FindByKeyAndUser", KeyValue.class).setParameter(1, (Object)key).setParameter(2, (Object)user).getSingleResult();
    }

    private void updateKeyValue(KeyValue keyValue, String user, String value, String contentType) {
        keyValue.setKeyAsUser(keyValue.getKey(), user);
        keyValue.setValueWithContentType(value, contentType);
        LOG.info("Update {}", (Object)keyValue);
    }

    private void createKeyValue(String key, String user, String value, String contentType) {
        KeyValue kv = new KeyValue();
        kv.setKeyAsUser(key, user);
        kv.setValueWithContentType(value, contentType);
        this.em.persist((Object)kv);
        LOG.info("Create {}", (Object)kv);
    }
}

