/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.keycloak.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.WebApplication;
import org.dcm4chee.arc.keycloak.AccessTokenRequestor;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="token2/{webAppName}")
public class KeycloakRS2 {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakRS2.class);
    @Context
    private HttpServletRequest request;
    @Inject
    private AccessTokenRequestor accessTokenRequestor;
    @Inject
    private IWebApplicationCache iWebAppCache;
    @PathParam(value="webAppName")
    private String webAppName;

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getAccessToken() {
        this.logRequest();
        try {
            WebApplication webApplication = this.iWebAppCache.findWebApplication(this.webAppName);
            if (webApplication.getKeycloakClientID() == null) {
                return Response.noContent().build();
            }
            AccessTokenRequestor.AccessTokenWithExpiration accessToken = this.accessTokenRequestor.getAccessToken2(webApplication);
            return Response.status((Response.Status)Response.Status.OK).entity(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                JsonWriter writer = new JsonWriter(gen);
                gen.writeStartObject();
                writer.writeNotNullOrDef("token", (Object)accessToken.getToken(), null);
                writer.writeNotDef("expiration", (int)accessToken.getExpiration(), 0);
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

