/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.dcm4chee.arc.study.StudyMissingException;
import org.dcm4chee.arc.study.StudyService;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=UpdateStudyAccessMatchingRS.class)
public class UpdateStudyAccessMatchingRS {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateStudyAccessMatchingRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @PathParam(value="AETitle")
    private String aet;
    @Inject
    private Device device;
    @Inject
    private StudyService studyService;
    @Inject
    private QueryService queryService;
    @Inject
    private RunInTransaction runInTx;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @javax.ws.rs.QueryParam(value="incomplete")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String incomplete;
    @javax.ws.rs.QueryParam(value="retrievefailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String retrievefailed;
    @javax.ws.rs.QueryParam(value="storageVerificationFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationFailed;
    @javax.ws.rs.QueryParam(value="metadataUpdateFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String metadataUpdateFailed;
    @javax.ws.rs.QueryParam(value="compressionfailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String compressionfailed;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET")
    private String externalRetrieveAET;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET!")
    private String externalRetrieveAETNot;
    @javax.ws.rs.QueryParam(value="patientVerificationStatus")
    @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED")
    private @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED") String patientVerificationStatus;
    @javax.ws.rs.QueryParam(value="ExpirationDate")
    private String expirationDate;
    @javax.ws.rs.QueryParam(value="storageID")
    private String storageID;
    @javax.ws.rs.QueryParam(value="storageClustered")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageClustered;
    @javax.ws.rs.QueryParam(value="storageExported")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageExported;
    @javax.ws.rs.QueryParam(value="allOfModalitiesInStudy")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String allOfModalitiesInStudy;
    @javax.ws.rs.QueryParam(value="StudySizeInKB")
    @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}")
    private @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}") String studySizeInKB;
    @javax.ws.rs.QueryParam(value="ExpirationState")
    @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT")
    private @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT") String expirationState;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/studies/access/{accessControlID}")
    public Response updateStudyAccessControlID(@PathParam(value="accessControlID") String accessControlID) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            QueryContext qCtx = this.queryContext(ae);
            try (Query query = this.queryService.createQuery(qCtx);){
                int queryMaxNumberOfResults = qCtx.getArchiveAEExtension().queryMaxNumberOfResults();
                if (queryMaxNumberOfResults > 0 && !qCtx.containsUniqueKey() && query.fetchCount() > (long)queryMaxNumberOfResults) {
                    Response response = this.errResponse("Request entity too large", Response.Status.BAD_REQUEST);
                    return response;
                }
                UpdateStudyAccess updateStudyAccess = new UpdateStudyAccess(ae, query, accessControlID);
                this.runInTx.execute((Runnable)updateStudyAccess);
                int count = updateStudyAccess.getCount();
                return Response.ok((Object)("{\"count\":" + count + "}")).build();
            }
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException e) {
            return this.errResponse(e.getMessage(), Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private QueryContext queryContext(ApplicationEntity ae) {
        QueryContext ctx = this.queryService.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), "matchingStudyUpdateAccessControl", this.aet, ae, this.queryParam(ae));
        ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.STUDY);
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        Attributes keys = queryAttrs.getQueryKeys();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        ctx.setQueryKeys(keys);
        Attributes returnKeys = new Attributes(3);
        returnKeys.setNull(0x20000D, VR.UI);
        ctx.setReturnKeys(returnKeys);
        return ctx;
    }

    private QueryParam queryParam(ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setAllOfModalitiesInStudy(Boolean.parseBoolean(this.allOfModalitiesInStudy));
        queryParam.setIncomplete(Boolean.parseBoolean(this.incomplete));
        queryParam.setRetrieveFailed(Boolean.parseBoolean(this.retrievefailed));
        queryParam.setStorageVerificationFailed(Boolean.parseBoolean(this.storageVerificationFailed));
        queryParam.setMetadataUpdateFailed(Boolean.parseBoolean(this.metadataUpdateFailed));
        queryParam.setCompressionFailed(Boolean.parseBoolean(this.compressionfailed));
        queryParam.setExternalRetrieveAET(this.externalRetrieveAET);
        queryParam.setExternalRetrieveAETNot(this.externalRetrieveAETNot);
        queryParam.setExpirationDate(this.expirationDate);
        queryParam.setStudySizeRange(this.studySizeInKB);
        if (this.patientVerificationStatus != null) {
            queryParam.setPatientVerificationStatus(Patient.VerificationStatus.valueOf((String)this.patientVerificationStatus));
        }
        if (this.storageID != null) {
            queryParam.setStudyStorageIDs(((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getStudyStorageIDs(this.storageID, UpdateStudyAccessMatchingRS.parseBoolean(this.storageClustered), UpdateStudyAccessMatchingRS.parseBoolean(this.storageExported)));
        }
        if (this.expirationState != null) {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.valueOf((String)this.expirationState)});
        }
        return queryParam;
    }

    private static Boolean parseBoolean(String s) {
        return s != null ? Boolean.valueOf(s) : null;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    class UpdateStudyAccess
    implements Runnable {
        private int count;
        private final ApplicationEntity ae;
        private final Query query;
        private final String accessControlID;

        UpdateStudyAccess(ApplicationEntity ae, Query query, String accessControlID) {
            this.ae = ae;
            this.query = query;
            this.accessControlID = accessControlID;
        }

        int getCount() {
            return this.count;
        }

        @Override
        public void run() {
            try {
                this.query.executeQuery(((ArchiveDeviceExtension)UpdateStudyAccessMatchingRS.this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueryFetchSize());
                while (this.query.hasMoreMatches()) {
                    Attributes match = this.query.nextMatch();
                    if (match == null) continue;
                    StudyMgtContext ctx = UpdateStudyAccessMatchingRS.this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)UpdateStudyAccessMatchingRS.this.request), this.ae);
                    ctx.setStudyInstanceUID(match.getString(0x20000D));
                    ctx.setAccessControlID("null".equals(this.accessControlID) ? "*" : this.accessControlID);
                    ctx.setAttributes(match);
                    ctx.setEventActionCode("U");
                    UpdateStudyAccessMatchingRS.this.studyService.updateAccessControlID(ctx);
                    ++this.count;
                }
            }
            catch (StudyMissingException e) {
                throw new WebApplicationException(e.getMessage(), Response.Status.NOT_FOUND);
            }
            catch (DicomServiceException e) {
                throw new WebApplicationException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new WebApplicationException(UpdateStudyAccessMatchingRS.this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
    }
}

