/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.delete.RejectionService;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=RejectMatchingRS.class)
public class RejectMatchingRS {
    private static final Logger LOG = LoggerFactory.getLogger(RejectMatchingRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @PathParam(value="AETitle")
    private String aet;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private RejectionService rejectionService;
    @Inject
    private QueryService queryService;
    @Inject
    private RunInTransaction runInTx;
    @javax.ws.rs.QueryParam(value="batchID")
    private String batchID;
    @javax.ws.rs.QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @javax.ws.rs.QueryParam(value="incomplete")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String incomplete;
    @javax.ws.rs.QueryParam(value="retrievefailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String retrievefailed;
    @javax.ws.rs.QueryParam(value="ExpirationDate")
    private String expirationDate;
    @javax.ws.rs.QueryParam(value="storageVerificationFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationFailed;
    @javax.ws.rs.QueryParam(value="metadataUpdateFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String metadataUpdateFailed;
    @javax.ws.rs.QueryParam(value="compressionfailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String compressionfailed;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET")
    private String externalRetrieveAET;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET!")
    private String externalRetrieveAETNot;
    @javax.ws.rs.QueryParam(value="patientVerificationStatus")
    @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED")
    private @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED") String patientVerificationStatus;
    @javax.ws.rs.QueryParam(value="storageID")
    private String storageID;
    @javax.ws.rs.QueryParam(value="storageClustered")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageClustered;
    @javax.ws.rs.QueryParam(value="storageExported")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageExported;
    @javax.ws.rs.QueryParam(value="allOfModalitiesInStudy")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String allOfModalitiesInStudy;
    @javax.ws.rs.QueryParam(value="StudySizeInKB")
    @Pattern(regexp="\\d{1,6}(-\\d{0,6})?|-\\d{1,6}")
    private @Pattern(regexp="\\d{1,6}(-\\d{0,6})?|-\\d{1,6}") String studySizeInKB;
    @javax.ws.rs.QueryParam(value="ExpirationState")
    @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT")
    private @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT") String expirationState;
    @HeaderParam(value="Content-Type")
    private MediaType contentType;

    private static Boolean parseBoolean(String s) {
        return s != null ? Boolean.valueOf(s) : null;
    }

    private static String count(int count) {
        return "{\"count\":" + count + "}";
    }

    @POST
    @Path(value="/studies/reject/{codeValue}^{codingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectMatchingStudies(@PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator) {
        return this.rejectMatching(this.aet, codeValue, designator, "rejectMatchingStudies", QueryRetrieveLevel2.STUDY, null, null);
    }

    @POST
    @Path(value="/series/reject/{codeValue}^{codingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectMatchingSeries(@PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator) {
        return this.rejectMatching(this.aet, codeValue, designator, "rejectMatchingSeries", QueryRetrieveLevel2.SERIES, null, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/reject/{codeValue}^{codingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectMatchingSeriesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator) {
        return this.rejectMatching(this.aet, codeValue, designator, "rejectMatchingSeriesOfStudy", QueryRetrieveLevel2.SERIES, studyInstanceUID, null);
    }

    @POST
    @Path(value="/instances/reject/{codeValue}^{codingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectMatchingInstances(@PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator) {
        return this.rejectMatching(this.aet, codeValue, designator, "rejectMatchingInstances", QueryRetrieveLevel2.IMAGE, null, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/instances/reject/{codeValue}^{codingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectMatchingInstancesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator) {
        return this.rejectMatching(this.aet, codeValue, designator, "rejectMatchingInstancesOfStudy", QueryRetrieveLevel2.IMAGE, studyInstanceUID, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/reject/{codeValue}^{codingSchemeDesignator}")
    @Produces(value={"application/json"})
    public Response rejectMatchingInstancesOfSeries(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID, @PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator) {
        return this.rejectMatching(this.aet, codeValue, designator, "rejectMatchingInstancesOfSeries", QueryRetrieveLevel2.IMAGE, studyInstanceUID, seriesInstanceUID);
    }

    @POST
    @Path(value="/studies/csv:{studyUIDField}/reject/{codeValue}^{codingSchemeDesignator}")
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response rejectStudiesFromCSV(@PathParam(value="studyUIDField") int studyUIDField, @PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator, InputStream in) {
        return this.rejectFromCSV(this.aet, studyUIDField, null, codeValue, designator, in);
    }

    @POST
    @Path(value="/studies/csv:{studyUIDField}/series/csv:{seriesUIDField}/reject/{codeValue}^{codingSchemeDesignator}")
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response rejectSeriesFromCSV(@PathParam(value="studyUIDField") int studyUIDField, @PathParam(value="seriesUIDField") int seriesUIDField, @PathParam(value="codeValue") String codeValue, @PathParam(value="codingSchemeDesignator") String designator, InputStream in) {
        return this.rejectFromCSV(this.aet, studyUIDField, seriesUIDField, codeValue, designator, in);
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Response rejectMatching(String aet, String codeValue, String designator, String method, QueryRetrieveLevel2 qrlevel, String studyInstanceUID, String seriesInstanceUID) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            String warning;
            int count;
            Code rjNoteCode = this.validateRejectionNote(codeValue, designator);
            if (rjNoteCode == null) {
                return this.errResponse("No such Rejection Note : " + codeValue + "^" + designator, Response.Status.NOT_FOUND);
            }
            QueryContext ctx = this.queryContext(method, qrlevel, studyInstanceUID, seriesInstanceUID, ae);
            Response.Status status = Response.Status.ACCEPTED;
            try (Query query = this.queryService.createQuery(ctx);){
                int queryMaxNumberOfResults = ctx.getArchiveAEExtension().queryMaxNumberOfResults();
                if (queryMaxNumberOfResults > 0 && !ctx.containsUniqueKey() && query.fetchCount() > (long)queryMaxNumberOfResults) {
                    Response response = this.errResponse("Request entity too large", Response.Status.BAD_REQUEST);
                    return response;
                }
                RejectMatchingObjects rejectMatchingObjects = new RejectMatchingObjects(aet, rjNoteCode, qrlevel, query, status);
                this.runInTx.execute((Runnable)rejectMatchingObjects);
                count = rejectMatchingObjects.getCount();
                status = rejectMatchingObjects.getStatus();
                warning = rejectMatchingObjects.getWarning();
            }
            Response.ResponseBuilder builder = Response.status((Response.Status)status);
            if (warning == null) return builder.entity((Object)("{\"count\":" + count + "}")).build();
            LOG.warn("Response {} caused by {}", (Object)status, (Object)warning);
            builder.header("Warning", (Object)warning);
            return builder.entity((Object)("{\"count\":" + count + "}")).build();
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    Response rejectFromCSV(String aet, int studyUIDField, Integer seriesUIDField, String codeValue, String designator, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            Code rjNoteCode;
            Response.Status status = Response.Status.BAD_REQUEST;
            if (studyUIDField < 1) {
                return this.errResponse("CSV field for Study Instance UID should be greater than or equal to 1", status);
            }
            if (seriesUIDField != null) {
                if (studyUIDField == seriesUIDField) {
                    return this.errResponse("CSV fields for Study and Series Instance UIDs should be different", status);
                }
                if (seriesUIDField < 1) {
                    return this.errResponse("CSV field for Series Instance UID should be greater than or equal to 1", status);
                }
            }
            if ((rjNoteCode = this.validateRejectionNote(codeValue, designator)) == null) {
                return this.errResponse("No such Rejection Note : " + codeValue + "^" + designator, Response.Status.NOT_FOUND);
            }
            int count = 0;
            String warning = null;
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            int csvUploadChunkSize = arcDev.getCSVUploadChunkSize();
            ArrayList<StudySeriesInfo> studySeries = new ArrayList<StudySeriesInfo>();
            Date scheduledTime = this.scheduledTime();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                 CSVParser parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.builder().setDelimiter(this.csvDelimiter()).build());){
                boolean header = true;
                for (CSVRecord csvRecord : parser) {
                    if (csvRecord.size() == 0 || csvRecord.get(0).isEmpty()) continue;
                    String studyUID = csvRecord.get(studyUIDField - 1).replaceAll("\"", "");
                    if (header && studyUID.chars().allMatch(Character::isLetter)) {
                        header = false;
                        continue;
                    }
                    if (!arcDev.isValidateUID() || this.validateUID(studyUID)) {
                        StudySeriesInfo studySeriesInfo = new StudySeriesInfo(studyUID);
                        this.addSeriesUID(studySeriesInfo, csvRecord, seriesUIDField, arcDev);
                        studySeries.add(studySeriesInfo);
                    }
                    if (studySeries.size() != csvUploadChunkSize) continue;
                    count += this.scheduleStudyRejectTasks(aet, rjNoteCode, studySeries, scheduledTime);
                    studySeries.clear();
                }
                if (!studySeries.isEmpty()) {
                    count += this.scheduleStudyRejectTasks(aet, rjNoteCode, studySeries, scheduledTime);
                }
                if (count == 0) {
                    warning = "Empty file or Incorrect field position or Not a CSV file or Invalid UIDs.";
                    status = Response.Status.NO_CONTENT;
                }
            }
            catch (Exception e) {
                warning = e.getMessage();
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
            if (warning == null && count > 0) {
                return Response.accepted((Object)RejectMatchingRS.count(count)).build();
            }
            LOG.warn("Response {} caused by {}", (Object)status, (Object)warning);
            Response.ResponseBuilder builder = Response.status((Response.Status)status).header("Warning", (Object)warning);
            if (count > 0) {
                builder.entity((Object)RejectMatchingRS.count(count));
            }
            return builder.build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Code validateRejectionNote(String codeValue, String designator) {
        Code rjNoteCode;
        if (codeValue == null || (rjNoteCode = this.toRejectionNote(codeValue, designator).getRejectionNoteCode()) == null) {
            return null;
        }
        return rjNoteCode;
    }

    private char csvDelimiter() {
        return "semicolon".equals(this.contentType.getParameters().get("delimiter")) ? (char)';' : ',';
    }

    private boolean validateUID(String studyUID) {
        boolean valid = UIDUtils.isValid((String)studyUID);
        if (!valid) {
            LOG.warn("Invalid UID in CSV file: " + studyUID);
        }
        return valid;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private void addSeriesUID(StudySeriesInfo studySeriesInfo, CSVRecord csvRecord, Integer seriesUIDField, ArchiveDeviceExtension arcDev) {
        if (seriesUIDField == null) {
            return;
        }
        String seriesUID = csvRecord.get(seriesUIDField - 1).replaceAll("\"", "");
        if (arcDev.isValidateUID() && !this.validateUID(seriesUID)) {
            LOG.info("Invalid Series[uid={}] of valid Study[uid={}] present in CSV file", (Object)seriesUID, (Object)studySeriesInfo.getStudyUID());
            return;
        }
        studySeriesInfo.setSeriesUID(seriesUID);
    }

    private void rejectMatching(String aet, Code rjNoteCode, Attributes match, QueryRetrieveLevel2 qrlevel, HttpServletRequestInfo httpRequestInfo, Date scheduledTime) {
        this.rejectionService.createRejectionTask(aet, rjNoteCode, httpRequestInfo, this.batchID, scheduledTime, match.getString(0x20000D), qrlevel != QueryRetrieveLevel2.STUDY ? match.getString(0x20000E) : null, qrlevel == QueryRetrieveLevel2.IMAGE ? match.getString(524312) : null);
    }

    private int scheduleStudyRejectTasks(String aet, Code rjNoteCode, List<StudySeriesInfo> studySeriesInfos, Date scheduledTime) {
        studySeriesInfos.forEach(studySeriesInfo -> this.rejectionService.createRejectionTask(aet, rjNoteCode, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.batchID, scheduledTime, studySeriesInfo.getStudyUID(), studySeriesInfo.getSeriesUID(), null));
        return studySeriesInfos.size();
    }

    private Date scheduledTime() {
        if (this.scheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(this.scheduledTime);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return new Date();
    }

    private RejectionNote toRejectionNote(String codeValue, String designator) {
        return this.arcDev().getRejectionNote(new Code(codeValue, designator, null, ""));
    }

    private QueryContext queryContext(String method, QueryRetrieveLevel2 qrlevel, String studyInstanceUID, String seriesInstanceUID, ApplicationEntity ae) {
        QueryContext ctx = this.queryService.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), method, this.aet, ae, this.queryParam(ae));
        ctx.setQueryRetrieveLevel(qrlevel);
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        Attributes keys = queryAttrs.getQueryKeys();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        if (studyInstanceUID != null) {
            keys.setString(0x20000D, VR.UI, studyInstanceUID);
        }
        if (seriesInstanceUID != null) {
            keys.setString(0x20000E, VR.UI, seriesInstanceUID);
        }
        ctx.setQueryKeys(keys);
        Attributes returnKeys = new Attributes(3);
        returnKeys.setNull(0x20000D, VR.UI);
        switch (qrlevel) {
            case IMAGE: {
                returnKeys.setNull(524312, VR.UI);
            }
            case SERIES: {
                returnKeys.setNull(0x20000E, VR.UI);
            }
        }
        ctx.setReturnKeys(returnKeys);
        return ctx;
    }

    private QueryParam queryParam(ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setAllOfModalitiesInStudy(Boolean.parseBoolean(this.allOfModalitiesInStudy));
        queryParam.setIncomplete(Boolean.parseBoolean(this.incomplete));
        queryParam.setRetrieveFailed(Boolean.parseBoolean(this.retrievefailed));
        queryParam.setStorageVerificationFailed(Boolean.parseBoolean(this.storageVerificationFailed));
        queryParam.setMetadataUpdateFailed(Boolean.parseBoolean(this.metadataUpdateFailed));
        queryParam.setCompressionFailed(Boolean.parseBoolean(this.compressionfailed));
        queryParam.setExternalRetrieveAET(this.externalRetrieveAET);
        queryParam.setExternalRetrieveAETNot(this.externalRetrieveAETNot);
        queryParam.setExpirationDate(this.expirationDate);
        if (this.patientVerificationStatus != null) {
            queryParam.setPatientVerificationStatus(Patient.VerificationStatus.valueOf((String)this.patientVerificationStatus));
        }
        if (this.storageID != null) {
            queryParam.setStudyStorageIDs(this.arcDev().getStudyStorageIDs(this.storageID, RejectMatchingRS.parseBoolean(this.storageClustered), RejectMatchingRS.parseBoolean(this.storageExported)));
        }
        queryParam.setStudySizeRange(this.studySizeInKB);
        if (this.expirationState != null) {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.valueOf((String)this.expirationState)});
        }
        return queryParam;
    }

    private ArchiveDeviceExtension arcDev() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    class RejectMatchingObjects
    implements Runnable {
        private int count;
        private final String aet;
        private final Code rjNoteCode;
        private final QueryRetrieveLevel2 qrLevel;
        private final Date scheduledTime;
        private final Query query;
        private Response.Status status;
        private String warning;

        RejectMatchingObjects(String aet, Code rjNoteCode, QueryRetrieveLevel2 qrLevel, Query query, Response.Status status) {
            this.scheduledTime = RejectMatchingRS.this.scheduledTime();
            this.aet = aet;
            this.rjNoteCode = rjNoteCode;
            this.qrLevel = qrLevel;
            this.query = query;
            this.status = status;
        }

        int getCount() {
            return this.count;
        }

        Response.Status getStatus() {
            return this.status;
        }

        String getWarning() {
            return this.warning;
        }

        @Override
        public void run() {
            try {
                HttpServletRequestInfo httpRequestInfo = HttpServletRequestInfo.valueOf((HttpServletRequest)RejectMatchingRS.this.request);
                this.query.executeQuery(RejectMatchingRS.this.arcDev().getQueryFetchSize());
                while (this.query.hasMoreMatches()) {
                    Attributes match = this.query.nextMatch();
                    if (match == null) continue;
                    RejectMatchingRS.this.rejectMatching(this.aet, this.rjNoteCode, match, this.qrLevel, httpRequestInfo, this.scheduledTime);
                    ++this.count;
                }
            }
            catch (Exception e) {
                this.warning = e.getMessage();
                this.status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
    }

    static class StudySeriesInfo {
        private final String studyUID;
        private String seriesUID = "*";

        StudySeriesInfo(String studyUID) {
            this.studyUID = studyUID;
        }

        String getStudyUID() {
            return this.studyUID;
        }

        String getSeriesUID() {
            return this.seriesUID;
        }

        void setSeriesUID(String seriesUID) {
            this.seriesUID = seriesUID;
        }
    }
}

