/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.rs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
public class ExportCSVRS {
    private static final Logger LOG = LoggerFactory.getLogger(ExportCSVRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @PathParam(value="AETitle")
    private String aet;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private ExportManager exportManager;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @HeaderParam(value="Content-Type")
    private MediaType contentType;

    @POST
    @Path(value="/studies/csv:{studyUIDField}/export/{ExporterID}")
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response exportStudies(@PathParam(value="ExporterID") String exporterID, @PathParam(value="studyUIDField") int studyUIDField, InputStream in) {
        return this.exportFromCSV(this.aet, exporterID, studyUIDField, null, in);
    }

    @POST
    @Path(value="/studies/csv:{studyUIDField}/series/csv:{seriesUIDField}/export/{ExporterID}")
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response exportSeries(@PathParam(value="ExporterID") String exporterID, @PathParam(value="studyUIDField") int studyUIDField, @PathParam(value="seriesUIDField") int seriesUIDField, InputStream in) {
        return this.exportFromCSV(this.aet, exporterID, studyUIDField, seriesUIDField, in);
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    Response exportFromCSV(String aet, String exporterID, int studyUIDField, Integer seriesUIDField, InputStream in) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return ExportCSVRS.errResponse(Response.Status.NOT_FOUND, "No such Application Entity: " + aet);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        Response.Status status = Response.Status.BAD_REQUEST;
        try {
            ArchiveDeviceExtension arcDev;
            ExporterDescriptor exporter;
            if (studyUIDField < 1) {
                return ExportCSVRS.errResponse(status, "CSV field for Study Instance UID should be greater than or equal to 1");
            }
            if (seriesUIDField != null) {
                if (studyUIDField == seriesUIDField) {
                    return ExportCSVRS.errResponse(status, "CSV fields for Study and Series Instance UIDs should be different");
                }
                if (seriesUIDField < 1) {
                    return ExportCSVRS.errResponse(status, "CSV field for Series Instance UID should be greater than or equal to 1");
                }
            }
            if ((exporter = (arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getExporterDescriptor(exporterID)) == null) {
                return ExportCSVRS.errResponse(Response.Status.NOT_FOUND, "No such Exporter: " + exporterID);
            }
            int count = 0;
            String warning = null;
            int csvUploadChunkSize = arcDev.getCSVUploadChunkSize();
            ArrayList<StudySeriesInfo> studySeries = new ArrayList<StudySeriesInfo>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                 CSVParser parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.builder().setDelimiter(this.csvDelimiter()).build());){
                boolean header = true;
                for (CSVRecord csvRecord : parser) {
                    if (csvRecord.size() == 0 || csvRecord.get(0).isEmpty()) continue;
                    String studyUID = csvRecord.get(studyUIDField - 1).replaceAll("\"", "");
                    if (header && studyUID.chars().allMatch(Character::isLetter)) {
                        header = false;
                        continue;
                    }
                    if (!arcDev.isValidateUID() || this.validateUID(studyUID)) {
                        StudySeriesInfo studySeriesInfo = new StudySeriesInfo(studyUID);
                        this.addSeriesUID(studySeriesInfo, csvRecord, seriesUIDField, arcDev);
                        studySeries.add(studySeriesInfo);
                    }
                    if (studySeries.size() != csvUploadChunkSize) continue;
                    count += this.scheduleExportTasks(exporter, studySeries, this.scheduledTime());
                    studySeries.clear();
                }
                if (!studySeries.isEmpty()) {
                    count += this.scheduleExportTasks(exporter, studySeries, this.scheduledTime());
                }
                if (count == 0) {
                    warning = "Empty file or Incorrect field position or Not a CSV file or Invalid UIDs.";
                    status = Response.Status.NO_CONTENT;
                }
            }
            catch (Exception e) {
                warning = e.getMessage();
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
            if (warning == null && count > 0) {
                return Response.accepted((Object)ExportCSVRS.count(count)).build();
            }
            LOG.info("Response {} caused by {}", (Object)status, (Object)warning);
            Response.ResponseBuilder builder = Response.status((Response.Status)status).header("Warning", (Object)warning);
            if (count > 0) {
                builder.entity((Object)ExportCSVRS.count(count));
            }
            return builder.build();
        }
        catch (Exception e) {
            return ExportCSVRS.errResponseAsTextPlain(ExportCSVRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void addSeriesUID(StudySeriesInfo studySeriesInfo, CSVRecord csvRecord, Integer seriesUIDField, ArchiveDeviceExtension arcDev) {
        if (seriesUIDField == null) {
            return;
        }
        String seriesUID = csvRecord.get(seriesUIDField - 1).replaceAll("\"", "");
        if (arcDev.isValidateUID() && !this.validateUID(seriesUID)) {
            LOG.info("Invalid Series[uid={}] of valid Study[uid={}] present in CSV file", (Object)seriesUID, (Object)studySeriesInfo.getStudyUID());
            return;
        }
        studySeriesInfo.setSeriesUID(seriesUID);
    }

    private int scheduleExportTasks(ExporterDescriptor exporter, List<StudySeriesInfo> studySeriesInfos, Date scheduledTime) {
        for (StudySeriesInfo studySeriesInfo : studySeriesInfos) {
            this.exportManager.createExportTask(this.device.getDeviceName(), exporter, studySeriesInfo.getStudyUID(), studySeriesInfo.getSeriesUID(), "*", this.batchID, scheduledTime, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        }
        return studySeriesInfos.size();
    }

    private boolean validateUID(String uid) {
        boolean valid = UIDUtils.isValid((String)uid);
        if (!valid) {
            LOG.info("Invalid UID in CSV file: " + uid);
        }
        return valid;
    }

    private char csvDelimiter() {
        return "semicolon".equals(this.contentType.getParameters().get("delimiter")) ? (char)';' : ',';
    }

    private Date scheduledTime() {
        if (this.scheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(this.scheduledTime);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return new Date();
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private static String count(int count) {
        return "{\"count\":" + count + "}";
    }

    private static Response errResponse(Response.Status status, String msg) {
        return ExportCSVRS.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private static Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.info("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private static String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(ExportCSVRS.errResponse(Response.Status.NOT_FOUND, "No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet)));
    }

    static class StudySeriesInfo {
        private final String studyUID;
        private String seriesUID = "*";

        StudySeriesInfo(String studyUID) {
            this.studyUID = studyUID;
        }

        String getStudyUID() {
            return this.studyUID;
        }

        String getSeriesUID() {
            return this.seriesUID;
        }

        void setSeriesUID(String seriesUID) {
            this.seriesUID = seriesUID;
        }
    }
}

