/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.pr2ko;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.UID;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;

public class PR2KOExporter
extends AbstractExporter {
    private static final ElementDictionary dict = ElementDictionary.getStandardElementDictionary();
    private static final String KEY_OBJECT_DESCRIPTION = "KeyObjectDescription";
    private static final String DOCUMENT_TITLE = "DocumentTitle";
    private static final String LANGUAGE = "Language";
    private static final String[] DEF_PROPS = new String[]{"DocumentTitle", "(PR2KO, DCM4CHEE, \"Referenced by Presentation State\")", "Language", "(en, RFC5646, \"English\")", "KeyObjectDescription", "{00700080} - {00700081}", "KO.Manufacturer", "", "KO.SeriesDescription", "{0008103E}", "KO.SeriesNumber", "{00200011,offset,100}", "KO.InstanceNumber", "{00200013,offset,0}"};
    private final QueryService queryService;
    private final StoreService storeService;
    private final int[] patStudyTags;
    private final Device device;
    private final Map<String, String> properties = new HashMap<String, String>();

    PR2KOExporter(ExporterDescriptor descriptor, QueryService queryService, StoreService storeService, Device device) {
        super(descriptor);
        this.queryService = queryService;
        this.storeService = storeService;
        this.patStudyTags = PR2KOExporter.patStudyTags((ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class));
        this.device = device;
        for (int i = 1; i < DEF_PROPS.length; ++i) {
            this.properties.put(DEF_PROPS[i - 1], DEF_PROPS[i]);
            ++i;
        }
        descriptor.getProperties().forEach(this.properties::put);
    }

    private static int[] patStudyTags(ArchiveDeviceExtension arcdev) {
        int[] patTags = arcdev.getAttributeFilter(Entity.Patient).getSelection(false);
        int[] studyTags = arcdev.getAttributeFilter(Entity.Study).getSelection(false);
        int[] dst = new int[patTags.length + studyTags.length - 1];
        System.arraycopy(patTags, 0, dst, 0, patTags.length);
        System.arraycopy(studyTags, 1, dst, patTags.length, studyTags.length - 1);
        Arrays.sort(dst);
        return dst;
    }

    public Outcome export(ExportContext ctx) throws Exception {
        ApplicationEntity ae = this.device.getApplicationEntity(ctx.getAETitle(), true);
        ArrayList<Attributes> matches = new ArrayList<Attributes>();
        try (Query query = this.queryService.createInstanceQuery(this.queryContext(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), ae));){
            query.executeQuery(((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getQueryFetchSize());
            while (query.hasMoreMatches()) {
                Attributes match = query.nextMatch();
                if (match == null) continue;
                matches.add(match);
            }
        }
        if (matches.isEmpty()) {
            return new Outcome(Task.Status.COMPLETED, PR2KOExporter.noKeyObjectCreated(ctx));
        }
        try (StoreSession session = this.storeService.newStoreSession(ctx.getHttpServletRequestInfo(), ae, ctx.getAETitle(), this.properties.get("SourceAET"));){
            for (Attributes prAttrs : matches) {
                StoreContext storeCtx = this.storeService.newStoreContext(session);
                storeCtx.setReceiveTransferSyntax("1.2.840.10008.1.2.1");
                this.storeService.store(storeCtx, this.pr2ko(prAttrs));
            }
        }
        return new Outcome(Task.Status.COMPLETED, PR2KOExporter.toMessage(ctx, matches.size()));
    }

    private QueryContext queryContext(String studyIUID, String seriesIUID, String sopIUID, ApplicationEntity ae) {
        QueryContext ctx = this.queryService.newQueryContext(ae, new QueryParam(ae));
        ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.IMAGE);
        ctx.setQueryKeys(this.queryKeys(studyIUID, seriesIUID, sopIUID));
        return ctx;
    }

    private Attributes queryKeys(String studyInstanceUID, String seriesInstanceUID, String sopInstanceUID) {
        Attributes keys = new Attributes();
        keys.setString(0x20000D, VR.UI, studyInstanceUID);
        if (seriesInstanceUID != null) {
            keys.setString(0x20000E, VR.UI, seriesInstanceUID);
        }
        if (sopInstanceUID != null) {
            keys.setString(524312, VR.UI, sopInstanceUID);
        }
        keys.setString(524310, VR.UI, this.cuids());
        return keys;
    }

    private String[] cuids() {
        return (String[])Arrays.stream(StringUtils.split((String)this.descriptor.getExportURI().getSchemeSpecificPart(), (char)':')).map(PR2KOExporter::toUID).toArray(String[]::new);
    }

    private static String toUID(String uidOrName) {
        return uidOrName.startsWith("1") ? uidOrName : UID.forName((String)uidOrName);
    }

    private Attributes pr2ko(Attributes prAttrs) {
        Attributes koAttrs = new Attributes(prAttrs, this.patStudyTags);
        Date now = new Date();
        koAttrs.setDate(2251877123620883L, new Date[]{now});
        koAttrs.setDate(2251950138064947L, new Date[]{PR2KOExporter.contentDateAndTime(prAttrs, now)});
        koAttrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        koAttrs.setString(524312, VR.UI, UIDUtils.createNameBasedUID((byte[])prAttrs.getString(524312).getBytes()));
        koAttrs.setString(0x20000E, VR.UI, UIDUtils.createNameBasedUID((byte[])prAttrs.getString(0x20000E).getBytes()));
        koAttrs.setString(524384, VR.CS, "KO");
        koAttrs.setString(0x40A040, VR.CS, "CONTAINER");
        koAttrs.setString(4235344, VR.CS, "SEPARATE");
        koAttrs.setNull(528657, VR.SQ);
        this.properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("KO")).forEach(entry -> PR2KOExporter.setString(koAttrs, entry, prAttrs));
        koAttrs.newSequence(4235331, 1).add(new Code(this.properties.get(DOCUMENT_TITLE)).toItem());
        koAttrs.newSequence(4236548, 1).add(PR2KOExporter.templateIdentifier());
        this.addContentSeq(koAttrs, prAttrs);
        PR2KOExporter.addCurrentRequestedProcedureEvidenceSeq(koAttrs, prAttrs);
        return koAttrs;
    }

    private static Date contentDateAndTime(Attributes prAttrs, Date now) {
        Date date = prAttrs.getDate(31525755744682115L);
        if (date == null && (date = prAttrs.getDate(2251950138064947L)) == null) {
            date = now;
        }
        return date;
    }

    private static void setString(Attributes attrs, Map.Entry<String, String> entry, Attributes prAttrs) {
        int tag = TagUtils.forName((String)entry.getKey().substring(3));
        attrs.setString(tag, dict.vrOf(tag), new AttributesFormat(entry.getValue()).format((Object)prAttrs));
    }

    private static void addCurrentRequestedProcedureEvidenceSeq(Attributes attrs, Attributes prAttrs) {
        String studyIUID = prAttrs.getString(0x20000D);
        String seriesIUID = prAttrs.getString(0x20000E);
        String iuid = prAttrs.getString(524312);
        String cuid = prAttrs.getString(524310);
        Sequence evidenceSeq = attrs.newSequence(4236149, 2);
        PR2KOExporter.refSOPSeq(PR2KOExporter.refSeriesSeq(studyIUID, evidenceSeq), seriesIUID).add(PR2KOExporter.refSOP(cuid, iuid));
        PR2KOExporter.addPresentationStateRefSerSeq(prAttrs, evidenceSeq);
    }

    private static void addPresentationStateRefSerSeq(Attributes prAttrs, Sequence evidenceSeq) {
        Sequence presentationStateRefSerSeq = prAttrs.getSequence(528661);
        Sequence refSeriesSeq = PR2KOExporter.refSeriesSeq(prAttrs.getString(0x20000D), evidenceSeq);
        presentationStateRefSerSeq.forEach(presentationStateRefSer -> {
            String seriesIUID = presentationStateRefSer.getString(0x20000E);
            Sequence refSOPSeq = PR2KOExporter.refSOPSeq(refSeriesSeq, seriesIUID);
            presentationStateRefSer.getSequence(528704).forEach(prRefSop -> refSOPSeq.add(PR2KOExporter.refSOP(prRefSop.getString(528720), prRefSop.getString(528725))));
        });
    }

    private static Sequence refSeriesSeq(String studyIUID, Sequence evidenceSeq) {
        Attributes refStudy = new Attributes(2);
        Sequence refSeriesSeq = refStudy.newSequence(528661, 10);
        refStudy.setString(0x20000D, VR.UI, studyIUID);
        evidenceSeq.add(refStudy);
        return refSeriesSeq;
    }

    private static Sequence refSOPSeq(Sequence refSeriesSeq, String seriesIUID) {
        Attributes refSeries = new Attributes(5);
        Sequence refSOPSeq = refSeries.newSequence(528793, 100);
        refSeries.setString(0x20000E, VR.UI, seriesIUID);
        refSeriesSeq.add(refSeries);
        return refSOPSeq;
    }

    private static Attributes refSOP(String cuid, String iuid) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, cuid);
        item.setString(528725, VR.UI, iuid);
        return item;
    }

    private static Attributes templateIdentifier() {
        Attributes attrs = new Attributes(2);
        attrs.setString(524549, VR.CS, "DCMR");
        attrs.setString(4250368, VR.CS, "2010");
        return attrs;
    }

    private void addContentSeq(Attributes attrs, Attributes prAttrs) {
        Sequence contentSeq = attrs.newSequence(4237104, 2);
        contentSeq.add(new Code(this.properties.get(LANGUAGE)).toItem());
        contentSeq.add(this.keyObjectDescription(prAttrs));
        prAttrs.getSequence(528661).forEach(presentationStateRefSer -> presentationStateRefSer.getSequence(528704).forEach(prRefSop -> contentSeq.add(PR2KOExporter.imageRef(prRefSop, prAttrs))));
    }

    private Attributes keyObjectDescription(Attributes prAttrs) {
        Attributes item = new Attributes(4);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, "TEXT");
        item.newSequence(4235331, 1).add(PR2KOExporter.keyObjectDescriptionConceptName());
        item.setString(4235616, VR.UT, new AttributesFormat(this.properties.get(KEY_OBJECT_DESCRIPTION)).format((Object)prAttrs));
        return item;
    }

    private static Attributes keyObjectDescriptionConceptName() {
        Attributes codeItem = new Attributes(3);
        codeItem.setString(524544, VR.SH, "113012");
        codeItem.setString(524546, VR.SH, "DCM");
        codeItem.setString(524548, VR.LO, "Key Object Description");
        return codeItem;
    }

    private static String noKeyObjectCreated(ExportContext ctx) {
        return PR2KOExporter.appendEntity((ExportContext)ctx, (StringBuilder)new StringBuilder("No Key Object created for ")).toString();
    }

    private static String toMessage(ExportContext ctx, int numKOs) {
        return PR2KOExporter.appendEntity((ExportContext)ctx, (StringBuilder)new StringBuilder("Created ").append(numKOs).append(" Key Object(s) for ")).toString();
    }

    private static Attributes imageRef(Attributes prRefSop, Attributes prAttrs) {
        Attributes item = new Attributes(3);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, "IMAGE");
        Attributes refSOP = PR2KOExporter.refSOP(prRefSop.getString(528720), prRefSop.getString(528725));
        refSOP.newSequence(528793, 1).add(PR2KOExporter.refSOP(prAttrs.getString(524310), prAttrs.getString(524312)));
        item.newSequence(528793, 1).add(refSOP);
        return item;
    }
}

