/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.event;

import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.util.TagUtils;

public class RejectionNoteSent {
    private final HttpServletRequest request;
    private final ApplicationEntity localAE;
    private final ApplicationEntity remoteAE;
    private final Attributes rejectionNote;
    private final boolean studyDeleted;
    private final int status;
    private final String errorComment;

    public RejectionNoteSent(HttpServletRequest request, ApplicationEntity localAE, ApplicationEntity remoteAE, Attributes rejectionNote, boolean studyDeleted, int status, String errorComment) {
        this.request = request;
        this.localAE = localAE;
        this.remoteAE = remoteAE;
        this.rejectionNote = rejectionNote;
        this.studyDeleted = studyDeleted;
        this.status = status;
        this.errorComment = errorComment;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ApplicationEntity getLocalAE() {
        return this.localAE;
    }

    public ApplicationEntity getRemoteAE() {
        return this.remoteAE;
    }

    public Attributes getRejectionNote() {
        return this.rejectionNote;
    }

    public boolean isStudyDeleted() {
        return this.studyDeleted;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean success() {
        return this.status == 0;
    }

    public boolean warning() {
        return (this.status & 0xB000) == 45056;
    }

    public boolean failed() {
        return !this.success() && !this.warning();
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    public String toString() {
        return "RejectInstancesEvent[" + this.request.getRemoteUser() + "@" + this.request.getRemoteHost() + ", localAET=" + this.localAE.getAETitle() + ", remoteAET=" + this.remoteAE.getAETitle() + ", studyUID=" + this.rejectionNote.getString(0x20000D) + ", studyDeleted=" + this.studyDeleted + ", status=" + TagUtils.shortToHexString((int)this.status) + ", errorComment=" + this.errorComment + "]";
    }
}

