/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.DateUtils;
import org.dcm4chee.arc.entity.PersonName;

@Entity
@Table(name="verify_observer", indexes={@Index(columnList="verify_datetime")})
public class VerifyingObserver {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="verify_datetime")
    private String verificationDateTime;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="observer_name_fk")
    private PersonName verifyingObserverName;

    public VerifyingObserver() {
    }

    public VerifyingObserver(Attributes attrs, FuzzyStr fuzzyStr) {
        Date dt = attrs.getDate(4235312);
        this.verificationDateTime = dt != null ? DateUtils.formatDT(null, (Date)dt) : "*";
        this.verifyingObserverName = PersonName.valueOf(attrs.getString(4235381), fuzzyStr, null);
    }

    public long getPk() {
        return this.pk;
    }

    public String getVerificationDateTime() {
        return this.verificationDateTime;
    }

    public PersonName getVerifyingObserverName() {
        return this.verifyingObserverName;
    }
}

