/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="uidmap")
public class UIDMap {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="uidmap")
    private byte[] encodedMap;
    @Transient
    private Map<String, String> cachedMap;

    public UIDMap() {
    }

    public UIDMap(long pk, byte[] encodedMap) {
        this.pk = pk;
        this.encodedMap = encodedMap;
    }

    public String toString() {
        return "UIDMap[pk=" + this.pk + "]";
    }

    public long getPk() {
        return this.pk;
    }

    public Map<String, String> getUIDMap() {
        if (this.cachedMap == null) {
            this.cachedMap = UIDMap.decodeUIDMap(this.encodedMap);
        }
        return this.cachedMap;
    }

    public void setUIDMap(Map<String, String> uidmap) {
        this.cachedMap = uidmap;
        this.encodedMap = UIDMap.encodeUIDMap(this.cachedMap);
    }

    public byte[] getEncodedMap() {
        return this.encodedMap;
    }

    public static byte[] encodeUIDMap(Map<String, String> uidmap) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        try (PrintStream ps = new PrintStream(out);){
            for (Map.Entry<String, String> entry : uidmap.entrySet()) {
                ps.append(entry.getKey()).append('=').append(entry.getValue()).println();
            }
        }
        return out.toByteArray();
    }

    public static Map<String, String> decodeUIDMap(byte[] b) {
        HashMap<String, String> result = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(b)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int delimPos = line.indexOf(61);
                result.put(line.substring(0, delimPos), line.substring(delimPos + 1));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

