/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.entity.Study;

@NamedQueries(value={@NamedQuery(name="StudyQueryAttributes.findByViewIDAndStudyPk", query="select a from StudyQueryAttributes a where a.viewID = ?1 and a.study.pk = ?2"), @NamedQuery(name="StudyQueryAttributes.deleteForStudy", query="delete from StudyQueryAttributes a where a.study = ?1"), @NamedQuery(name="StudyQueryAttributes.viewIDsForStudyPk", query="select a.viewID from StudyQueryAttributes a where a.study.pk = ?1"), @NamedQuery(name="StudyQueryAttributes.updateAvailabilityOfStudy", query="update StudyQueryAttributes studyQueryAttrs set studyQueryAttrs.availability = ?2 where studyQueryAttrs.study = ?1"), @NamedQuery(name="StudyQueryAttributes.updateAvailabilityByStudyIUID", query="update StudyQueryAttributes studyQueryAttrs set studyQueryAttrs.availability = ?2 where studyQueryAttrs.study = (select study from Study study where study.studyInstanceUID = ?1)")})
@Entity
@Table(name="study_query_attrs", uniqueConstraints={@UniqueConstraint(columnNames={"view_id", "study_fk"})})
public class StudyQueryAttributes {
    public static final String FIND_BY_VIEW_ID_AND_STUDY_PK = "StudyQueryAttributes.findByViewIDAndStudyPk";
    public static final String DELETE_FOR_STUDY = "StudyQueryAttributes.deleteForStudy";
    public static final String VIEW_IDS_FOR_STUDY_PK = "StudyQueryAttributes.viewIDsForStudyPk";
    public static final String UPDATE_AVAILABILITY_OF_STUDY = "StudyQueryAttributes.updateAvailabilityOfStudy";
    public static final String UPDATE_AVAILABILITY_BY_STUDY_IUID = "StudyQueryAttributes.updateAvailabilityByStudyIUID";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Column(name="view_id")
    private String viewID;
    @Column(name="num_series")
    private int numberOfSeries;
    @Column(name="num_instances")
    private int numberOfInstances;
    @Column(name="mods_in_study")
    private String modalitiesInStudy;
    @Column(name="cuids_in_study", length=4000)
    private String sopClassesInStudy;
    @Column(name="retrieve_aets")
    private String retrieveAETs;
    @Column(name="availability")
    private Availability availability;
    @ManyToOne(optional=false)
    @JoinColumn(name="study_fk")
    private Study study;

    public long getPk() {
        return this.pk;
    }

    public String getViewID() {
        return this.viewID;
    }

    public void setViewID(String viewID) {
        this.viewID = viewID;
    }

    public int getNumberOfSeries() {
        return this.numberOfSeries;
    }

    public void setNumberOfSeries(int numberOfSeries) {
        this.numberOfSeries = numberOfSeries;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void setNumberOfInstances(int numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    public String getModalitiesInStudy() {
        return this.modalitiesInStudy;
    }

    public void setModalitiesInStudy(String modalitiesInStudy) {
        this.modalitiesInStudy = modalitiesInStudy;
    }

    public String getSOPClassesInStudy() {
        return this.sopClassesInStudy;
    }

    public void setSOPClassesInStudy(String sopClassesInStudy) {
        this.sopClassesInStudy = sopClassesInStudy;
    }

    public String getRetrieveAETs() {
        return this.retrieveAETs;
    }

    public void setRetrieveAETs(String retrieveAETs) {
        this.retrieveAETs = retrieveAETs;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }
}

