/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Arrays;
import java.util.HashSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.entity.Series;

@NamedQueries(value={@NamedQuery(name="SeriesQueryAttributes.findByViewIDAndSeriesPk", query="select a from SeriesQueryAttributes a where a.viewID = ?1 and a.series.pk = ?2"), @NamedQuery(name="SeriesQueryAttributes.deleteForSeries", query="delete from SeriesQueryAttributes a where a.series = ?1"), @NamedQuery(name="SeriesQueryAttributes.viewIDsForSeriesPk", query="select a.viewID from SeriesQueryAttributes a where a.series.pk = ?1"), @NamedQuery(name="SeriesQueryAttributes.updateAvailabilityByStudyPk", query="update SeriesQueryAttributes serQueryAttrs set serQueryAttrs.availability = ?2 where serQueryAttrs.series in (select ser from Series ser where ser.study = ?1)"), @NamedQuery(name="SeriesQueryAttributes.updateAvailabilityByStudyIUID", query="update SeriesQueryAttributes serQueryAttrs set serQueryAttrs.availability = ?2 where serQueryAttrs.series in (select ser from Series ser where ser.study.studyInstanceUID = ?1)"), @NamedQuery(name="SeriesQueryAttributes.updateAvailabilityBySeriesIUID", query="update SeriesQueryAttributes serQueryAttrs set serQueryAttrs.availability = ?2 where serQueryAttrs.series in (select ser from Series ser where ser.seriesInstanceUID = ?1)")})
@Entity
@Table(name="series_query_attrs", uniqueConstraints={@UniqueConstraint(columnNames={"view_id", "series_fk"})})
public class SeriesQueryAttributes {
    public static final String FIND_BY_VIEW_ID_AND_SERIES_PK = "SeriesQueryAttributes.findByViewIDAndSeriesPk";
    public static final String DELETE_FOR_SERIES = "SeriesQueryAttributes.deleteForSeries";
    public static final String VIEW_IDS_FOR_SERIES_PK = "SeriesQueryAttributes.viewIDsForSeriesPk";
    public static final String UPDATE_AVAILABILITY_BY_STUDY_PK = "SeriesQueryAttributes.updateAvailabilityByStudyPk";
    public static final String UPDATE_AVAILABILITY_BY_STUDY_IUID = "SeriesQueryAttributes.updateAvailabilityByStudyIUID";
    public static final String UPDATE_AVAILABILITY_BY_SERIES_IUID = "SeriesQueryAttributes.updateAvailabilityBySeriesIUID";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Column(name="view_id")
    private String viewID;
    @Column(name="num_instances")
    private int numberOfInstances;
    @Column(name="cuids_in_series")
    private String sopClassesInSeries;
    @Column(name="retrieve_aets")
    private String retrieveAETs;
    @Column(name="availability")
    private Availability availability;
    @ManyToOne(optional=false)
    @JoinColumn(name="series_fk")
    private Series series;

    public long getPk() {
        return this.pk;
    }

    public String getViewID() {
        return this.viewID;
    }

    public void setViewID(String viewID) {
        this.viewID = viewID;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void setNumberOfInstances(int numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    public String getSOPClassesInSeries() {
        return this.sopClassesInSeries;
    }

    public void setSOPClassesInSeries(String sopClassesInSeries) {
        this.sopClassesInSeries = sopClassesInSeries;
    }

    public void addSOPClassInSeries(String cuid) {
        if (cuid.equals(this.sopClassesInSeries)) {
            return;
        }
        if (this.sopClassesInSeries == null) {
            this.sopClassesInSeries = cuid;
        } else {
            for (String s : StringUtils.split((String)this.sopClassesInSeries, (char)'\\')) {
                if (!cuid.equals(s)) continue;
                return;
            }
            this.sopClassesInSeries = this.sopClassesInSeries + "\\" + cuid;
        }
    }

    public String getRetrieveAETs() {
        return this.retrieveAETs;
    }

    public void setRetrieveAETs(String retrieveAETs) {
        this.retrieveAETs = retrieveAETs;
    }

    public void retainRetrieveAETs(String[] retrieveAETs) {
        HashSet<String> set;
        String s = StringUtils.concat((String[])retrieveAETs, (char)'\\');
        if (this.retrieveAETs == null) {
            this.retrieveAETs = s;
        } else if (!s.equals(this.retrieveAETs) && (set = new HashSet<String>(Arrays.asList(StringUtils.split((String)this.retrieveAETs, (char)'\\')))).retainAll(Arrays.asList(retrieveAETs))) {
            this.retrieveAETs = StringUtils.concat((String[])set.toArray(StringUtils.EMPTY_STRING), (char)'\\');
        }
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public void floorAvailability(Availability availability) {
        if (this.availability == null || this.availability.compareTo((Enum)availability) > 0) {
            this.availability = availability;
        }
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.series = series;
    }
}

